/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.memory;

import java.lang.reflect.Array;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import meldexun.matrixutil.UnsafeUtil;
import meldexun.renderlib.util.memory.BufferFactory;
import meldexun.renderlib.util.memory.PrimitiveInfo;

public class MemoryUtil {
    public static long allocateMemory(long capacity) {
        return UnsafeUtil.UNSAFE.allocateMemory(capacity);
    }

    public static void freeMemory(long address) {
        UnsafeUtil.UNSAFE.freeMemory(address);
    }

    private static <T> T allocateAndMap(long capacity, LongFunction<T> f) {
        long address = 0L;
        try {
            address = MemoryUtil.allocateMemory(capacity);
            return f.apply(address);
        }
        catch (Throwable t) {
            MemoryUtil.freeMemory(address);
            throw t;
        }
    }

    static <T> T allocateBuffer(long capacity, PrimitiveInfo type, BufferFactory<T> bufferFactory) {
        return (T)MemoryUtil.allocateAndMap(type.toByte(capacity), address -> bufferFactory.create(address, capacity, type));
    }

    public static void copyMemory(long srcAddress, long destAddress, long bytes) {
        if (bytes <= 256L) {
            int i = 0;
            while ((long)i < (bytes & 0xFFFFFFFFFFFFFFF8L)) {
                UnsafeUtil.UNSAFE.putLong(destAddress + (long)i, UnsafeUtil.UNSAFE.getLong(srcAddress + (long)i));
                i += 8;
            }
            if ((long)i < (bytes & 0xFFFFFFFFFFFFFFFCL)) {
                UnsafeUtil.UNSAFE.putInt(destAddress + (long)i, UnsafeUtil.UNSAFE.getInt(srcAddress + (long)i));
                i += 4;
            }
            if ((long)i < (bytes & 0xFFFFFFFFFFFFFFFEL)) {
                UnsafeUtil.UNSAFE.putShort(destAddress + (long)i, UnsafeUtil.UNSAFE.getShort(srcAddress + (long)i));
                i += 2;
            }
            if ((long)i < bytes) {
                UnsafeUtil.UNSAFE.putByte(destAddress + (long)i, UnsafeUtil.UNSAFE.getByte(srcAddress + (long)i));
            }
        } else {
            UnsafeUtil.UNSAFE.copyMemory(srcAddress, destAddress, bytes);
        }
    }

    public static void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        if (bytes <= 256L) {
            int i = 0;
            while ((long)i < (bytes & 0xFFFFFFFFFFFFFFF8L)) {
                UnsafeUtil.UNSAFE.putLong(destBase, destOffset + (long)i, UnsafeUtil.UNSAFE.getLong(srcBase, srcOffset + (long)i));
                i += 8;
            }
            if ((long)i < (bytes & 0xFFFFFFFFFFFFFFFCL)) {
                UnsafeUtil.UNSAFE.putInt(destBase, destOffset + (long)i, UnsafeUtil.UNSAFE.getInt(srcBase, srcOffset + (long)i));
                i += 4;
            }
            if ((long)i < (bytes & 0xFFFFFFFFFFFFFFFEL)) {
                UnsafeUtil.UNSAFE.putShort(destBase, destOffset + (long)i, UnsafeUtil.UNSAFE.getShort(srcBase, srcOffset + (long)i));
                i += 2;
            }
            if ((long)i < bytes) {
                UnsafeUtil.UNSAFE.putByte(destBase, destOffset + (long)i, UnsafeUtil.UNSAFE.getByte(srcBase, srcOffset + (long)i));
            }
        } else {
            UnsafeUtil.UNSAFE.copyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
        }
    }

    public static void copyFromArray(byte[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.BYTE);
    }

    public static void copyFromArray(short[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.SHORT);
    }

    public static void copyFromArray(int[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.INT);
    }

    public static void copyFromArray(long[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.LONG);
    }

    public static void copyFromArray(float[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.FLOAT);
    }

    public static void copyFromArray(double[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.DOUBLE);
    }

    public static void copyFromArray(char[] array, int offset, Object destBase, long destOffset, int length) {
        MemoryUtil.copyFromArray(array, offset, destBase, destOffset, length, PrimitiveInfo.CHAR);
    }

    private static void copyFromArray(Object array, int offset, Object destBase, long destOffset, int length, PrimitiveInfo type) {
        MemoryUtil.copyMemory(array, type.arrayBaseOffset() + type.toByte(offset), destBase, destOffset, type.toByte(length));
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, byte[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.BYTE);
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, short[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.SHORT);
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, int[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.INT);
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, long[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.LONG);
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, float[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.FLOAT);
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, double[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.DOUBLE);
    }

    public static void copyIntoArray(Object srcBase, long srcOffset, char[] array, int offset, int length) {
        MemoryUtil.copyIntoArray(srcBase, srcOffset, array, offset, length, PrimitiveInfo.CHAR);
    }

    private static void copyIntoArray(Object srcBase, long srcOffset, Object array, int offset, int length, PrimitiveInfo type) {
        MemoryUtil.copyMemory(srcBase, srcOffset, array, type.arrayBaseOffset() + type.toByte(offset), type.toByte(length));
    }

    public static <T> T copyOfMemory(Object srcBase, long srcOffset, long bytes, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfMemory(srcBase, 0L, srcOffset, bytes, PrimitiveInfo.BYTE, bufferFactory);
    }

    static <T> T copyOfMemory(Object srcBase, long srcOffset, long offset, long length, PrimitiveInfo type, BufferFactory<T> bufferFactory) {
        return (T)MemoryUtil.allocateAndMap(type.toByte(length), address -> {
            MemoryUtil.copyMemory(srcBase, srcOffset + type.toByte(offset), null, address, type.toByte(length));
            return bufferFactory.create(address, length, type);
        });
    }

    public static <T> T copyOfArray(byte[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.BYTE, bufferFactory);
    }

    public static <T> T copyOfArray(short[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.SHORT, bufferFactory);
    }

    public static <T> T copyOfArray(int[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.INT, bufferFactory);
    }

    public static <T> T copyOfArray(long[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.LONG, bufferFactory);
    }

    public static <T> T copyOfArray(float[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.FLOAT, bufferFactory);
    }

    public static <T> T copyOfArray(double[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.DOUBLE, bufferFactory);
    }

    public static <T> T copyOfArray(char[] array, int offset, int length, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfArray(array, offset, length, PrimitiveInfo.CHAR, bufferFactory);
    }

    private static <T> T copyOfArray(Object array, int offset, int length, PrimitiveInfo type, BufferFactory<T> bufferFactory) {
        return MemoryUtil.copyOfMemory(array, type.arrayBaseOffset(), offset, length, type, bufferFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tempMemory(long capacity, LongConsumer consumer) {
        long address = 0L;
        try {
            address = MemoryUtil.allocateMemory(capacity);
            consumer.accept(address);
        }
        finally {
            MemoryUtil.freeMemory(address);
        }
    }

    static <T> void tempBuffer(long capacity, PrimitiveInfo type, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempMemory(type.toByte(capacity), address -> consumer.accept(bufferFactory.create(address, capacity, type)));
    }

    public static <T> void tempCopyOfArray(byte[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.BYTE, bufferFactory, consumer);
    }

    public static <T> void tempCopyOfArray(short[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.SHORT, bufferFactory, consumer);
    }

    public static <T> void tempCopyOfArray(int[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.INT, bufferFactory, consumer);
    }

    public static <T> void tempCopyOfArray(long[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.LONG, bufferFactory, consumer);
    }

    public static <T> void tempCopyOfArray(float[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.FLOAT, bufferFactory, consumer);
    }

    public static <T> void tempCopyOfArray(double[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.DOUBLE, bufferFactory, consumer);
    }

    public static <T> void tempCopyOfArray(char[] array, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        MemoryUtil.tempCopyOfArray(array, PrimitiveInfo.CHAR, bufferFactory, consumer);
    }

    private static <T> void tempCopyOfArray(Object array, PrimitiveInfo arrayType, BufferFactory<T> bufferFactory, Consumer<T> consumer) {
        long capacity = Array.getLength(array);
        MemoryUtil.tempMemory(arrayType.toByte(capacity), address -> {
            MemoryUtil.copyMemory(array, arrayType.arrayBaseOffset(), null, address, arrayType.toByte(capacity));
            consumer.accept(bufferFactory.create(address, capacity, arrayType));
        });
    }
}

