/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.memory;

import meldexun.matrixutil.UnsafeUtil;
import meldexun.renderlib.util.memory.MemoryUtil;

public interface MemoryAccess {
    public static MemoryAccess of(long address) {
        return () -> address;
    }

    public long getAddress();

    default public boolean getBoolean(long offset) {
        return UnsafeUtil.UNSAFE.getBoolean(null, this.getAddress() + offset);
    }

    default public void putBoolean(long offset, boolean data) {
        UnsafeUtil.UNSAFE.putBoolean(null, this.getAddress() + offset, data);
    }

    default public byte getByte(long offset) {
        return UnsafeUtil.UNSAFE.getByte(this.getAddress() + offset);
    }

    default public void putByte(long offset, byte data) {
        UnsafeUtil.UNSAFE.putByte(this.getAddress() + offset, data);
    }

    default public short getShort(long offset) {
        return UnsafeUtil.UNSAFE.getShort(this.getAddress() + offset);
    }

    default public void putShort(long offset, short data) {
        UnsafeUtil.UNSAFE.putShort(this.getAddress() + offset, data);
    }

    default public int getInt(long offset) {
        return UnsafeUtil.UNSAFE.getInt(this.getAddress() + offset);
    }

    default public void putInt(long offset, int data) {
        UnsafeUtil.UNSAFE.putInt(this.getAddress() + offset, data);
    }

    default public long getLong(long offset) {
        return UnsafeUtil.UNSAFE.getLong(this.getAddress() + offset);
    }

    default public void putLong(long offset, long data) {
        UnsafeUtil.UNSAFE.putLong(this.getAddress() + offset, data);
    }

    default public float getFloat(long offset) {
        return UnsafeUtil.UNSAFE.getFloat(this.getAddress() + offset);
    }

    default public void putFloat(long offset, float data) {
        UnsafeUtil.UNSAFE.putFloat(this.getAddress() + offset, data);
    }

    default public double getDouble(long offset) {
        return UnsafeUtil.UNSAFE.getDouble(this.getAddress() + offset);
    }

    default public void putDouble(long offset, double data) {
        UnsafeUtil.UNSAFE.putDouble(this.getAddress() + offset, data);
    }

    default public char getChar(long offset) {
        return UnsafeUtil.UNSAFE.getChar(this.getAddress() + offset);
    }

    default public void putChar(long offset, char data) {
        UnsafeUtil.UNSAFE.putChar(this.getAddress() + offset, data);
    }

    public static void copyMemory(Object srcBase, long srcOffset, MemoryAccess destBase, long destOffset, long bytes) {
        MemoryUtil.copyMemory(srcBase, srcOffset, null, destBase.getAddress() + destOffset, bytes);
    }

    public static void copyMemory(MemoryAccess srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        MemoryUtil.copyMemory(null, srcBase.getAddress() + srcOffset, destBase, destOffset, bytes);
    }

    public static void copyMemory(MemoryAccess srcBase, long srcOffset, MemoryAccess destBase, long destOffset, long bytes) {
        MemoryUtil.copyMemory(srcBase.getAddress() + srcOffset, destBase.getAddress() + destOffset, bytes);
    }
}

