/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.objectweb.asm.tree.ClassNode;

public interface ClassNodeTransformer {
    public boolean transform(ClassNode var1);

    public int writeFlags();

    public static ClassNodeTransformer create(int writeFlags, Consumer<ClassNode> transformer) {
        return ClassNodeTransformer.create(writeFlags, (ClassNode classNode) -> {
            transformer.accept((ClassNode)classNode);
            return true;
        });
    }

    public static ClassNodeTransformer create(final int writeFlags, final Predicate<ClassNode> transformer) {
        return new ClassNodeTransformer(){

            @Override
            public boolean transform(ClassNode classNode) {
                return transformer.test(classNode);
            }

            @Override
            public int writeFlags() {
                return writeFlags;
            }
        };
    }
}

