/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import meldexun.asmutil2.InsnFinder;
import meldexun.asmutil2.StringBuilderUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMUtil {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Class<? extends AbstractInsnNode>, Function<? extends AbstractInsnNode, String>> INSN_TO_STRING_SERIALIZERS = new HashMap<Class<? extends AbstractInsnNode>, Function<? extends AbstractInsnNode, String>>();

    private static <T extends AbstractInsnNode> void register(Class<T> type, Function<T, ?> insnToStringSerializer) {
        INSN_TO_STRING_SERIALIZERS.compute(type, (k, v) -> {
            if (v != null) {
                throw new IllegalArgumentException();
            }
            return insnToStringSerializer.andThen(Object::toString);
        });
    }

    private static <T extends AbstractInsnNode> Function<T, String> get(T insn) {
        return INSN_TO_STRING_SERIALIZERS.get(insn.getClass());
    }

    public static String classToString(ClassNode classNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(classNode.name);
        sb.append('\n');
        sb.append(classNode.methods.stream().map(ASMUtil::methodToString).collect(Collectors.joining("\n\n")));
        return sb.toString();
    }

    public static String methodToString(MethodNode methodNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodNode.name);
        sb.append(' ');
        sb.append(methodNode.desc);
        sb.append('\n');
        int i = 0;
        ListIterator iterator = methodNode.instructions.iterator();
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            StringBuilderUtil.append(sb, i, 3);
            sb.append(' ');
            sb.append(ASMUtil.instructionToString(insn));
            if (iterator.hasNext()) {
                sb.append('\n');
            }
            ++i;
        }
        return sb.toString();
    }

    public static <T extends AbstractInsnNode> String instructionToString(T insn) {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtil.append(sb, ASMUtil.opcodeName(insn), 15);
        sb.append(' ');
        StringBuilderUtil.append(sb, insn.getClass().getSimpleName(), 22);
        sb.append(' ');
        Function<T, String> insnToStringSerializer = ASMUtil.get(insn);
        if (insnToStringSerializer != null) {
            sb.append(insnToStringSerializer.apply(insn));
        }
        return sb.toString();
    }

    private static String opcodeName(AbstractInsnNode insn) {
        if (insn instanceof LabelNode) {
            return "";
        }
        if (insn instanceof LineNumberNode) {
            return "";
        }
        if (insn instanceof FrameNode) {
            return "";
        }
        return Arrays.stream(Opcodes.class.getFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType() == Integer.TYPE).filter(field -> !field.getName().startsWith("ASM")).filter(field -> !field.getName().startsWith("V")).filter(field -> !field.getName().startsWith("ACC_")).filter(field -> !field.getName().startsWith("T_")).filter(field -> !field.getName().startsWith("H_")).filter(field -> !field.getName().startsWith("F_")).filter(field -> {
            try {
                return field.getInt(null) == insn.getOpcode();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return false;
            }
        }).map(Field::getName).findFirst().orElse("UNKNOWN");
    }

    public static <T extends AbstractInsnNode> InsnFinder<T> first(MethodNode methodNode) {
        return InsnFinder.create().first(methodNode);
    }

    public static <T extends AbstractInsnNode> InsnFinder<T> last(MethodNode methodNode) {
        return InsnFinder.create().last(methodNode);
    }

    public static <T extends AbstractInsnNode> InsnFinder<T> nextExclusive(AbstractInsnNode startExclusive) {
        return InsnFinder.create().nextExclusive(startExclusive);
    }

    public static <T extends AbstractInsnNode> InsnFinder<T> prevExclusive(AbstractInsnNode startExclusive) {
        return InsnFinder.create().prevExclusive(startExclusive);
    }

    public static <T extends AbstractInsnNode> InsnFinder<T> next(AbstractInsnNode startInclusive) {
        return InsnFinder.create().next(startInclusive);
    }

    public static <T extends AbstractInsnNode> InsnFinder<T> prev(AbstractInsnNode startInclusive) {
        return InsnFinder.create().prev(startInclusive);
    }

    public static InsnList listOf(AbstractInsnNode insn0) {
        InsnList list = new InsnList();
        list.add(insn0);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1, AbstractInsnNode insn2) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        list.add(insn2);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1, AbstractInsnNode insn2, AbstractInsnNode insn3) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        list.add(insn2);
        list.add(insn3);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1, AbstractInsnNode insn2, AbstractInsnNode insn3, AbstractInsnNode insn4) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        list.add(insn2);
        list.add(insn3);
        list.add(insn4);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1, AbstractInsnNode insn2, AbstractInsnNode insn3, AbstractInsnNode insn4, AbstractInsnNode insn5) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        list.add(insn2);
        list.add(insn3);
        list.add(insn4);
        list.add(insn5);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1, AbstractInsnNode insn2, AbstractInsnNode insn3, AbstractInsnNode insn4, AbstractInsnNode insn5, AbstractInsnNode insn6) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        list.add(insn2);
        list.add(insn3);
        list.add(insn4);
        list.add(insn5);
        list.add(insn6);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode insn0, AbstractInsnNode insn1, AbstractInsnNode insn2, AbstractInsnNode insn3, AbstractInsnNode insn4, AbstractInsnNode insn5, AbstractInsnNode insn6, AbstractInsnNode insn7) {
        InsnList list = new InsnList();
        list.add(insn0);
        list.add(insn1);
        list.add(insn2);
        list.add(insn3);
        list.add(insn4);
        list.add(insn5);
        list.add(insn6);
        list.add(insn7);
        return list;
    }

    public static InsnList listOf(AbstractInsnNode ... insns) {
        InsnList list = new InsnList();
        for (AbstractInsnNode insn : insns) {
            list.add(insn);
        }
        return list;
    }

    static {
        ASMUtil.register(IntInsnNode.class, insn -> insn.operand);
        ASMUtil.register(VarInsnNode.class, insn -> insn.var);
        ASMUtil.register(TypeInsnNode.class, insn -> insn.desc);
        ASMUtil.register(FieldInsnNode.class, insn -> insn.owner + " " + insn.name + " " + insn.desc);
        ASMUtil.register(MethodInsnNode.class, insn -> insn.owner + " " + insn.name + " " + insn.desc);
        ASMUtil.register(JumpInsnNode.class, insn -> insn.label.getLabel());
        ASMUtil.register(LabelNode.class, insn -> insn.getLabel());
        ASMUtil.register(LdcInsnNode.class, insn -> insn.cst);
        ASMUtil.register(FrameNode.class, insn -> insn.local + " " + insn.stack);
        ASMUtil.register(LineNumberNode.class, insn -> insn.line);
    }
}

