/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import com.google.common.collect.Sets;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.Direction;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Ellipsoid
implements IShape {
    private Coord start;
    private Coord end;

    public Ellipsoid(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
    }

    @Override
    public Iterator<Coord> iterator() {
        return new EllipsoidIterator(this.start, this.end);
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> copy = new ArrayList<Coord>();
        for (Coord pos : this) {
            copy.add(pos);
        }
        return copy;
    }

    @Override
    public Set<Coord> getAnchors() {
        return Sets.newHashSet((Object[])new Coord[]{this.start, this.end});
    }

    private class EllipsoidIterator
    implements Iterator<Coord> {
        private Coord centre;
        private Coord diff;
        private Coord cursor;
        private Direction dir;
        private boolean top;

        public EllipsoidIterator(Coord centre, Coord end) {
            this.centre = centre.copy();
            Coord s = centre.copy();
            Coord e = end.copy();
            this.diff = e.translate(-s.getX(), -s.getY(), -s.getZ());
            this.diff = new Coord(Math.abs(this.diff.getX()), Math.abs(this.diff.getY()), Math.abs(this.diff.getZ()));
            this.cursor = new Coord(0, 0, 0);
            this.top = true;
            this.dir = Direction.NORTH;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() < this.diff.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.centre.copy();
            toReturn.translate(this.top ? Direction.UP : Direction.DOWN, this.cursor.getY());
            if (this.dir == Direction.NORTH || this.dir == Direction.SOUTH) {
                toReturn.translate(this.dir.antiClockwise(), this.cursor.getX());
                toReturn.translate(this.dir, this.cursor.getZ());
            } else {
                toReturn.translate(this.dir, this.cursor.getX());
                toReturn.translate(this.dir.antiClockwise(), this.cursor.getZ());
            }
            if (this.dir != Direction.NORTH || this.top) {
                if (this.dir == Direction.NORTH) {
                    this.top = false;
                }
                this.dir = this.dir.antiClockwise();
                return toReturn;
            }
            this.cursor.south();
            if (this.inRange(this.cursor)) {
                this.dir = this.dir.antiClockwise();
                this.top = true;
                return toReturn;
            }
            this.cursor = new Coord(this.cursor.getX(), this.cursor.getY(), 0);
            this.cursor.east();
            if (this.inRange(this.cursor)) {
                this.dir = this.dir.antiClockwise();
                this.top = true;
                return toReturn;
            }
            this.cursor = new Coord(0, this.cursor.getY(), this.cursor.getZ());
            this.cursor.up();
            this.dir = this.dir.antiClockwise();
            this.top = true;
            return toReturn;
        }

        private boolean inRange(Coord pos) {
            double x = pos.getX();
            double y = pos.getY();
            double z = pos.getZ();
            double rx = this.diff.getX() == 0 ? 1.0 : (double)this.diff.getX();
            double ry = this.diff.getY() == 0 ? 1.0 : (double)this.diff.getY();
            double rz = this.diff.getZ() == 0 ? 1.0 : (double)this.diff.getZ();
            return x / rx * (x / rx) + y / ry * (y / ry) + z / rz * (z / rz) <= 1.0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

