/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin.dungeon;

import com.github.fnar.minecraft.world.BiomeTag;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinBaseSettings;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.filter.Filter;

public class BuiltinMountainDungeonSettings
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "mountain");

    public BuiltinMountainDungeonSettings() {
        super(ID);
        this.setExclusive(true);
        this.getInherit().add(BuiltinBaseSettings.ID);
        this.getCriteria().addBiomeTags(BiomeTag.MOUNTAIN);
        this.setTowerSettings(new TowerSettings(TowerType.ENIKO, Theme.OAK));
        Theme[] themes = new Theme[]{Theme.ENIKO, Theme.ENIKO2, Theme.SEWER, Theme.MOSSY, Theme.NETHER};
        for (int level = 0; level < 5; ++level) {
            SecretsSetting secrets;
            RoomsSetting factory;
            LevelSettings levelSettings = this.getLevelSettings(level);
            levelSettings.setTheme(themes[level]);
            if (level == 0) {
                levelSettings.setScatter(16);
                levelSettings.setRange(60);
                levelSettings.setNumRooms(10);
                factory = new RoomsSetting();
                factory.add(RoomType.LIBRARY.newSingleRoomSetting());
                factory.add(RoomType.FIRE.newSingleRoomSetting());
                RoomType.ENIKO.newRandomRoomSetting(10);
                RoomType.CORNER.newRandomRoomSetting(3);
                levelSettings.setRooms(factory);
                secrets = new SecretsSetting();
                secrets.add(RoomType.BEDROOM.newSingleRoomSetting());
                secrets.add(RoomType.BEDROOM.newSingleRoomSetting());
                secrets.add(RoomType.SMITH.newSingleRoomSetting());
                levelSettings.setSecrets(secrets);
                SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
                segments.add(Segment.DOOR, 7);
                segments.add(Segment.ANKH, 2);
                segments.add(Segment.PLANT, 3);
                segments.add(Segment.LAMP, 1);
                segments.add(Segment.FLOWERS, 1);
                levelSettings.setSegments(segments);
            }
            if (level == 1) {
                levelSettings.setScatter(16);
                levelSettings.setRange(80);
                levelSettings.setNumRooms(20);
                factory = new RoomsSetting();
                factory.add(RoomType.FIRE.newSingleRoomSetting());
                factory.add(RoomType.MESS.newSingleRoomSetting());
                factory.add(RoomType.LIBRARY.newSingleRoomSetting());
                factory.add(RoomType.LAB.newSingleRoomSetting());
                factory.add(RoomType.ENIKO.newRandomRoomSetting(10));
                factory.add(RoomType.CORNER.newRandomRoomSetting(3));
                levelSettings.setRooms(factory);
                secrets = new SecretsSetting();
                secrets.add(RoomType.ENCHANT.newSingleRoomSetting());
                levelSettings.setSecrets(secrets);
            }
            if (level != 2) continue;
            levelSettings.setLevel(4);
            SegmentGenerator segments = new SegmentGenerator(Segment.SEWERARCH);
            segments.add(Segment.SEWER, 7);
            segments.add(Segment.SEWERDRAIN, 4);
            segments.add(Segment.SEWERDOOR, 2);
            levelSettings.setSegments(segments);
            RoomsSetting factory2 = new RoomsSetting();
            factory2.add(RoomType.BRICK.newRandomRoomSetting(4));
            factory2.add(RoomType.SLIME.newRandomRoomSetting(7));
            factory2.add(RoomType.CORNER.newRandomRoomSetting(3));
            factory2.add(RoomType.SPIDER.newRandomRoomSetting(2));
            factory2.add(RoomType.PIT.newRandomRoomSetting(2));
            factory2.add(RoomType.PRISON.newRandomRoomSetting(3));
            levelSettings.setRooms(factory2);
        }
        this.getLevelSettings().get(3).addFilter(Filter.VINE);
    }
}

