/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import com.github.fnar.forge.ModLoader;
import com.github.fnar.roguelike.settings.exception.SettingsNotFoundException;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.DungeonSettingsParser;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinBaseSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinLayoutSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinLootSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinRoomsSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinSecretsSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinSegmentsSettings;
import greymerk.roguelike.dungeon.settings.builtin.BuiltinThemeSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinDesertDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinForestDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinIceDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinJungleDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinMesaDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinMountainDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinPlainsDungeonSettings;
import greymerk.roguelike.dungeon.settings.builtin.dungeon.BuiltinSwampDungeonSettings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class SettingsContainer {
    public static final String DEFAULT_NAMESPACE = "default";
    public static final String BUILTIN_NAMESPACE = "builtin";
    private final Map<String, Map<String, DungeonSettings>> settingsByNamespace = new HashMap<String, Map<String, DungeonSettings>>();
    private final DungeonSettingsParser dungeonSettingsParser;

    public SettingsContainer(ModLoader modLoader) {
        this.put(new BuiltinRoomsSettings(), new BuiltinSecretsSettings(), new BuiltinSegmentsSettings(), new BuiltinLayoutSettings(), new BuiltinThemeSettings(), new BuiltinLootSettings(), new BuiltinBaseSettings(), new BuiltinDesertDungeonSettings(), new BuiltinPlainsDungeonSettings(), new BuiltinJungleDungeonSettings(), new BuiltinSwampDungeonSettings(), new BuiltinMountainDungeonSettings(), BuiltinForestDungeonSettings.create(), new BuiltinMesaDungeonSettings(), new BuiltinIceDungeonSettings());
        this.dungeonSettingsParser = new DungeonSettingsParser(modLoader);
    }

    public SettingsContainer loadFiles() {
        File settingsDirectoryFile = new File("config/roguelike_dungeons/settings");
        if (settingsDirectoryFile.exists() && !settingsDirectoryFile.isDirectory()) {
            throw new RuntimeException("Settings directory is a file");
        }
        if (!settingsDirectoryFile.exists()) {
            settingsDirectoryFile.mkdir();
        }
        Map<String, String> fileByName = this.collectSettingsFiles(settingsDirectoryFile);
        this.put(fileByName);
        return this;
    }

    private Map<String, String> collectSettingsFiles(File settingsDirectory) {
        List<File> files = SettingsContainer.listFilesRecursively(settingsDirectory);
        return SettingsContainer.mapContentByFilename(files);
    }

    private static List<File> listFilesRecursively(File settingsDirectory) {
        Object[] files = settingsDirectory.listFiles();
        return Optional.ofNullable(files).isPresent() ? Lists.newArrayList((Object[])files).stream().flatMap(file -> file.isDirectory() ? SettingsContainer.listFilesRecursively(file).stream() : Lists.newArrayList((Object[])new File[]{file}).stream()).filter(file -> FilenameUtils.getExtension((String)file.getName()).equals("json")).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static Map<String, String> mapContentByFilename(List<File> files) {
        return files.stream().collect(Collectors.toMap(File::getAbsolutePath, SettingsContainer::getFileContent));
    }

    private static String getFileContent(File file) {
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file : " + file.getName());
        }
    }

    public void put(Map<String, String> dungeonSettingsJsonByFileName) {
        for (Map.Entry<String, String> entry : dungeonSettingsJsonByFileName.entrySet()) {
            String filePath = entry.getKey();
            String setting = entry.getValue();
            try {
                this.put(setting);
            }
            catch (Exception e) {
                throw new RuntimeException("Error in: " + filePath + ": " + e.getMessage());
            }
        }
    }

    public void put(String dungeonSettingsJson) throws Exception {
        this.dungeonSettingsParser.parseJson(dungeonSettingsJson).ifPresent(this::put);
    }

    public void put(DungeonSettings ... dungeonSettings) {
        Arrays.stream(dungeonSettings).forEach(this::put);
    }

    public void put(List<DungeonSettings> dungeonSettings) {
        dungeonSettings.forEach(this::put);
    }

    private void put(DungeonSettings dungeonSettings) {
        String namespace = dungeonSettings.getNamespace();
        if (!this.containsNamespace(namespace)) {
            this.settingsByNamespace.put(namespace, new HashMap());
        }
        this.settingsByNamespace.get(namespace).put(dungeonSettings.getName(), dungeonSettings);
    }

    public Collection<DungeonSettings> getByNamespace(String namespace) {
        if (this.containsNamespace(namespace)) {
            return this.settingsByNamespace.get(namespace).values();
        }
        return new ArrayList<DungeonSettings>();
    }

    public Collection<DungeonSettings> getBuiltinSettings() {
        return this.settingsByNamespace.entrySet().stream().filter(this::isBuiltIn).map(Map.Entry::getValue).map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isBuiltIn(Map.Entry<String, Map<String, DungeonSettings>> entry) {
        return BUILTIN_NAMESPACE.equals(entry.getKey());
    }

    public Collection<DungeonSettings> getCustomSettings() {
        return this.settingsByNamespace.entrySet().stream().filter(((Predicate<Map.Entry>)this::isBuiltIn).negate()).map(Map.Entry::getValue).map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public DungeonSettings get(SettingIdentifier id) {
        if (!this.contains(id)) {
            throw new SettingsNotFoundException(id);
        }
        return this.getNamespace(id).get(id.getName());
    }

    private boolean contains(SettingIdentifier id) {
        return this.containsNamespace(id.getNamespace()) && this.getNamespace(id).containsKey(id.getName());
    }

    private boolean containsNamespace(String namespace) {
        return this.settingsByNamespace.containsKey(namespace);
    }

    private Map<String, DungeonSettings> getNamespace(SettingIdentifier id) {
        return this.settingsByNamespace.get(id.getNamespace());
    }

    public String toString() {
        return this.getAllSettingIdentifiers().stream().map(SettingIdentifier::toString).collect(Collectors.joining(" "));
    }

    public Set<SettingIdentifier> getAllSettingIdentifiers() {
        return this.settingsByNamespace.values().stream().map(Map::values).flatMap(Collection::stream).map(DungeonSettings::getId).collect(Collectors.toSet());
    }
}

