/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.loot.special.weapons;

import com.github.fnar.minecraft.item.Enchantment;
import com.github.fnar.minecraft.item.RldItem;
import com.github.fnar.minecraft.item.Weapon;
import com.github.fnar.minecraft.item.WeaponType;
import com.github.fnar.roguelike.loot.special.SpecialEquipment;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.util.TextFormat;
import java.util.Random;

public class SpecialSword
extends SpecialEquipment {
    private static Weapon getItem() {
        return WeaponType.SWORD.asItem();
    }

    @Override
    protected SpecialSword withQuality(Quality quality) {
        super.withQuality(quality);
        return this;
    }

    @Override
    protected SpecialSword withRldItem(RldItem rldItem) {
        super.withRldItem(rldItem);
        return this;
    }

    public static SpecialEquipment newSpecialSword(Random random, Quality quality) {
        return new SpecialSword().withQuality(quality).withRldItem(SpecialSword.getItem().withQuality(quality)).withSwordEnchantments(random).withCommonEnchantments(random).withName(quality.getDescriptor() + ".sword");
    }

    public SpecialSword withSwordEnchantments(Random random) {
        return this.withSharpness(random).withLooting(random).withFiery(random);
    }

    public SpecialSword withSharpness(Random random) {
        if (random.nextBoolean()) {
            return this;
        }
        int enchantmentLevel = random.nextInt(6);
        if (enchantmentLevel <= 0) {
            return this;
        }
        this.withEnchantment(Enchantment.Effect.SHARPNESS.atLevel(enchantmentLevel));
        return this;
    }

    public SpecialSword withLooting(Random random) {
        if (random.nextBoolean()) {
            return this;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return this;
        }
        this.withEnchantment(Enchantment.Effect.LOOTING.atLevel(enchantmentLevel));
        if (enchantmentLevel < 3) {
            this.withPrefix("loot2");
        } else {
            this.withPrefix("loot3");
            this.withLore("Once belonged to a king of hidden desert thieves.", TextFormat.DARKGREEN);
            this.withLocLore("lore.roguelike.looting3");
        }
        return this;
    }

    public SpecialSword withFiery(Random random) {
        if (random.nextBoolean()) {
            return this;
        }
        int enchantmentLevel = random.nextInt(4);
        if (enchantmentLevel <= 0) {
            return this;
        }
        this.withEnchantment(Enchantment.Effect.FIRE_ASPECT.atLevel(enchantmentLevel));
        if (enchantmentLevel == 1) {
            this.withPrefix("fire1");
            this.withLore("Warm to the touch", TextFormat.YELLOW);
            this.withLocLore("lore.roguelike.fire_aspect1");
            return this;
        }
        if (enchantmentLevel == 2) {
            this.withPrefix("fire2");
            this.withLore("Almost too hot to hold", TextFormat.RED);
            this.withLocLore("lore.roguelike.fire_aspect2");
            return this;
        }
        this.withSuffix("fire3");
        this.withLore("From the fiery depths", TextFormat.DARKRED);
        this.withLocLore("lore.roguelike.fire_aspect3");
        return this;
    }
}

