/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.command.commands;

import com.github.fnar.roguelike.command.CommandContext;
import com.github.fnar.roguelike.command.commands.BaseRoguelikeCommand;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.worldgen.Coord;
import java.util.Optional;

public class GenerateTowerCommand
extends BaseRoguelikeCommand {
    private final String towerName;

    public GenerateTowerCommand(CommandContext context, String towerName) {
        super(context);
        this.towerName = towerName;
    }

    @Override
    public boolean onRun() throws Exception {
        if (this.towerName == null) {
            this.context.sendInfo("notif.roguelike.usage_", "roguelike tower <tower name>");
            this.context.sendInfo("notif.roguelike.towertypes", String.join((CharSequence)" ", TowerType.getTowerList()));
            return false;
        }
        Optional<TowerType> towerType = TowerType.get(this.towerName);
        if (!towerType.isPresent()) {
            this.context.sendFailure("nosuchtower", this.towerName);
            return false;
        }
        towerType.map(this::instantiateTower).ifPresent(this::generateTower);
        return true;
    }

    private void generateTower(Tower tower) {
        tower.generate(this.getCoord());
    }

    private Tower instantiateTower(TowerType towerType) {
        return towerType.instantiate(this.context.createEditor());
    }

    private Coord getCoord() {
        return this.context.getSenderCoord().setY(50);
    }

    @Override
    public void onSuccess() {
        this.context.sendSuccess(this.towerName + "_generated", this.getCoord().toString());
    }
}

