/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.command;

import com.github.fnar.forge.ModLoader;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.roguelike.command.CommandSender;
import com.github.fnar.roguelike.command.ContextHolder;
import com.github.fnar.roguelike.command.message.ErrorMessage;
import com.github.fnar.roguelike.command.message.InfoMessage;
import com.github.fnar.roguelike.command.message.Message;
import com.github.fnar.roguelike.command.message.SpecialMessage;
import com.github.fnar.roguelike.command.message.SuccessMessage;
import com.github.fnar.roguelike.command.message.WarningMessage;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.Optional;

public class CommandContext {
    private final ContextHolder contextHolder;

    public CommandContext(ContextHolder contextHolder) {
        this.contextHolder = contextHolder;
    }

    private CommandSender getCommandSender() {
        return this.contextHolder.getCommandSender();
    }

    public void sendFailure(Exception e) {
        this.sendFailure("", e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage());
    }

    public void sendFailure(String message) {
        this.sendMessage(new ErrorMessage("notif.roguelike.failure_" + message));
    }

    public void sendFailure(String message, String details) {
        this.sendMessage(new ErrorMessage("notif.roguelike.failure_" + message).withDetails(details));
    }

    public void sendInfo(String message) {
        this.sendMessage(new InfoMessage(message));
    }

    public void sendInfo(String message, String details) {
        this.sendMessage(new InfoMessage(message).withDetails(details));
    }

    public void sendSpecial(String message) {
        this.sendMessage(new SpecialMessage(message));
    }

    public void sendSpecial(String message, String details) {
        this.sendMessage(new SpecialMessage(message).withDetails(details));
    }

    public void sendSuccess(String message) {
        this.sendMessage(new SuccessMessage("notif.roguelike.success_" + message));
    }

    public void sendSuccess(String message, String details) {
        this.sendMessage(new SuccessMessage("notif.roguelike.success_" + message).withDetails(details));
    }

    public void sendWarning(String message) {
        this.sendMessage(new WarningMessage(message));
    }

    public void sendWarning(String message, String details) {
        this.sendMessage(new WarningMessage(message).withDetails(details));
    }

    public void sendMessage(Message message) {
        this.getCommandSender().sendMessage(message);
    }

    public WorldEditor createEditor() {
        return this.getCommandSender().createWorldEditor();
    }

    public Coord getSenderCoord() {
        return this.getCommandSender().getCoord();
    }

    public void give(RldItemStack item) {
        this.getCommandSender().give(item);
    }

    public ModLoader getModLoader() {
        return this.createEditor().getModLoader();
    }

    public Optional<String> getArgument(int argumentIndex) {
        return this.contextHolder.getArgument(argumentIndex);
    }

    public Optional<String> getArgument(String argumentName) {
        return this.contextHolder.getArgument(argumentName);
    }

    public Optional<SettingIdentifier> getArgumentAsSettingIdentifier(String argumentName) {
        return this.contextHolder.getArgumentAsSettingIdentifier(argumentName);
    }

    public Optional<Coord> getArgumentAsCoord(int argumentIndex) {
        return this.contextHolder.getArgumentAsCoord(argumentIndex);
    }

    public Optional<Coord> getArgumentAsCoord(String position) {
        return this.contextHolder.getArgumentAsCoord(position);
    }
}

