/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.block.ColoredBlockMapper1_12;
import com.github.fnar.minecraft.item.Banner;
import com.github.fnar.minecraft.item.Design;
import com.github.fnar.minecraft.item.mapper.BaseItemMapper1_12;
import com.github.fnar.minecraft.item.mapper.DesignMapper1_12;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BannerMapper1_12
extends BaseItemMapper1_12<Banner> {
    private static NBTTagCompound ensureNbtTagCompound(ItemStack banner) {
        NBTTagCompound nbt = banner.func_77978_p();
        if (nbt != null) {
            return nbt;
        }
        banner.func_77982_d(new NBTTagCompound());
        return banner.func_77978_p();
    }

    private static NBTTagCompound ensureBlockEntityTag(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("BlockEntityTag")) {
            return nbtTagCompound.func_74775_l("BlockEntityTag");
        }
        NBTTagCompound tag = new NBTTagCompound();
        nbtTagCompound.func_74782_a("BlockEntityTag", (NBTBase)tag);
        return tag;
    }

    private static NBTTagList ensurePatternsTag(NBTTagCompound tag) {
        NBTTagList patterns;
        if (tag.func_74764_b("Patterns")) {
            patterns = tag.func_150295_c("Patterns", 10);
        } else {
            patterns = new NBTTagList();
            tag.func_74782_a("Patterns", (NBTBase)patterns);
        }
        return patterns;
    }

    @Override
    public Class<Banner> getClazz() {
        return Banner.class;
    }

    @Override
    public ItemStack map(Banner banner) {
        ItemStack bannerItemStack = this.addEnchantmentNbtTags(banner, Items.field_179564_cE);
        NBTTagCompound bannerNbtTagCompound = BannerMapper1_12.ensureNbtTagCompound(bannerItemStack);
        NBTTagCompound blockEntityTag = BannerMapper1_12.ensureBlockEntityTag(bannerNbtTagCompound);
        NBTTagList patternsTag = BannerMapper1_12.ensurePatternsTag(blockEntityTag);
        NBTTagCompound patternsAttributes = new NBTTagCompound();
        for (Design bannerDesign : banner.getDesigns()) {
            patternsAttributes.func_74768_a("Color", ColoredBlockMapper1_12.toEnumDyeColor(bannerDesign.getColor()).func_176767_b());
            patternsAttributes.func_74778_a("Pattern", new DesignMapper1_12().map(bannerDesign.getDesignPattern()).func_190993_b());
            patternsTag.func_74742_a((NBTBase)patternsAttributes);
        }
        return bannerItemStack;
    }
}

