/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.block;

import com.github.fnar.minecraft.block.AnvilBlockMapper1_12;
import com.github.fnar.minecraft.block.BedBlockMapper1_12;
import com.github.fnar.minecraft.block.BlockParser1_12;
import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.ColoredBlockMapper1_12;
import com.github.fnar.minecraft.block.ComparatorBlockMapper1_12;
import com.github.fnar.minecraft.block.CouldNotMapBlockException;
import com.github.fnar.minecraft.block.CropBlockMapper1_12;
import com.github.fnar.minecraft.block.DirectionMapper1_12;
import com.github.fnar.minecraft.block.DoorBlockMapper1_12;
import com.github.fnar.minecraft.block.InfestedBlockMapper1_12;
import com.github.fnar.minecraft.block.LeverMapper1_12;
import com.github.fnar.minecraft.block.PlantBlockMapper1_12;
import com.github.fnar.minecraft.block.PumpkinBlockMapper1_12;
import com.github.fnar.minecraft.block.QuartzBlockMapper1_12;
import com.github.fnar.minecraft.block.RepeaterBlockMapper1_12;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.block.SlabBlockMapper1_12;
import com.github.fnar.minecraft.block.StairsBlockMapper1_12;
import com.github.fnar.minecraft.block.TallGrassMapper1_12;
import com.github.fnar.minecraft.block.TorchBlockMapper1_12;
import com.github.fnar.minecraft.block.TrapdoorBlockMapper1_12;
import com.github.fnar.minecraft.block.UnmappedBlockException;
import com.github.fnar.minecraft.block.VineBlockMapper1_12;
import com.github.fnar.minecraft.block.WoodMapper1_12;
import com.github.fnar.minecraft.block.decorative.AnvilBlock;
import com.github.fnar.minecraft.block.decorative.BedBlock;
import com.github.fnar.minecraft.block.decorative.CropBlock;
import com.github.fnar.minecraft.block.decorative.PlantBlock;
import com.github.fnar.minecraft.block.decorative.PumpkinBlock;
import com.github.fnar.minecraft.block.decorative.TallPlantBlock;
import com.github.fnar.minecraft.block.decorative.TorchBlock;
import com.github.fnar.minecraft.block.normal.ColoredBlock;
import com.github.fnar.minecraft.block.normal.InfestedBlock;
import com.github.fnar.minecraft.block.normal.Quartz;
import com.github.fnar.minecraft.block.normal.SlabBlock;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.block.redstone.ComparatorBlock;
import com.github.fnar.minecraft.block.redstone.DoorBlock;
import com.github.fnar.minecraft.block.redstone.LeverBlock;
import com.github.fnar.minecraft.block.redstone.RepeaterBlock;
import com.github.fnar.minecraft.block.redstone.TrapdoorBlock;
import com.github.fnar.minecraft.block.redstone.TripwireHookBlock;
import com.github.fnar.minecraft.material.Wood;
import com.github.fnar.util.ReportThisIssueException;
import com.google.gson.JsonElement;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.worldgen.Direction;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;

public class BlockMapper1_12 {
    public static IBlockState map(SingleBlockBrush blockBrush) throws CouldNotMapBlockException {
        JsonElement json = blockBrush.getJson();
        BlockType blockType = blockBrush.getBlockType();
        if (json != null) {
            if (BlockType.OAK_STAIRS.equals((Object)blockType)) {
                return StairsBlockMapper1_12.map((StairsBlock)blockBrush);
            }
            if (BlockType.OAK_DOOR.equals((Object)blockType)) {
                return DoorBlockMapper1_12.map((DoorBlock)blockBrush);
            }
            return BlockParser1_12.parse(json);
        }
        Direction facing = blockBrush.getFacing();
        EnumFacing enumFacing = DirectionMapper1_12.map(facing);
        switch (blockType) {
            case ANVIL: {
                return AnvilBlockMapper1_12.map((AnvilBlock)blockBrush);
            }
            case ACACIA_LOG: {
                return WoodMapper1_12.mapLogs(Wood.ACACIA, facing);
            }
            case BIRCH_LOG: {
                return WoodMapper1_12.mapLogs(Wood.BIRCH, facing);
            }
            case DARK_OAK_LOG: {
                return WoodMapper1_12.mapLogs(Wood.DARK_OAK, facing);
            }
            case JUNGLE_LOG: {
                return WoodMapper1_12.mapLogs(Wood.JUNGLE, facing);
            }
            case OAK_LOG: {
                return WoodMapper1_12.mapLogs(Wood.OAK, facing);
            }
            case SPRUCE_LOG: {
                return WoodMapper1_12.mapLogs(Wood.SPRUCE, facing);
            }
            case ACACIA_FENCE: {
                return Blocks.field_180405_aT.func_176223_P();
            }
            case BIRCH_FENCE: {
                return Blocks.field_180404_aQ.func_176223_P();
            }
            case DARK_OAK_FENCE: {
                return Blocks.field_180406_aS.func_176223_P();
            }
            case JUNGLE_FENCE: {
                return Blocks.field_180403_aR.func_176223_P();
            }
            case OAK_FENCE: {
                return Blocks.field_180407_aO.func_176223_P();
            }
            case SPRUCE_FENCE: {
                return Blocks.field_180408_aP.func_176223_P();
            }
            case ACACIA_PLANK: {
                return WoodMapper1_12.mapPlanks(Wood.ACACIA);
            }
            case BIRCH_PLANK: {
                return WoodMapper1_12.mapPlanks(Wood.BIRCH);
            }
            case DARK_OAK_PLANK: {
                return WoodMapper1_12.mapPlanks(Wood.DARK_OAK);
            }
            case JUNGLE_PLANK: {
                return WoodMapper1_12.mapPlanks(Wood.JUNGLE);
            }
            case OAK_PLANK: {
                return WoodMapper1_12.mapPlanks(Wood.OAK);
            }
            case SPRUCE_PLANK: {
                return WoodMapper1_12.mapPlanks(Wood.SPRUCE);
            }
            case OAK_LEAVES: {
                return WoodMapper1_12.mapLeaves(Wood.OAK);
            }
            case SPRUCE_LEAVES: {
                return WoodMapper1_12.mapLeaves(Wood.SPRUCE);
            }
            case BIRCH_LEAVES: {
                return WoodMapper1_12.mapLeaves(Wood.BIRCH);
            }
            case JUNGLE_LEAVES: {
                return WoodMapper1_12.mapLeaves(Wood.JUNGLE);
            }
            case ACACIA_LEAVES2: {
                return WoodMapper1_12.mapLeaves(Wood.ACACIA);
            }
            case DARK_OAK_LEAVES: {
                return WoodMapper1_12.mapLeaves(Wood.DARK_OAK);
            }
            case CARPET: 
            case CONCRETE: 
            case CONCRETE_POWDER: 
            case STAINED_GLASS: 
            case STAINED_GLASS_PANE: 
            case STAINED_HARDENED_CLAY: 
            case TERRACOTTA: 
            case WOOL: {
                return ColoredBlockMapper1_12.getColoredBlock((ColoredBlock)blockBrush);
            }
            case ACACIA_STAIRS: 
            case BIRCH_STAIRS: 
            case BRICK_STAIRS: 
            case DARK_OAK_STAIRS: 
            case JUNGLE_STAIRS: 
            case NETHER_BRICK_STAIRS: 
            case OAK_STAIRS: 
            case PURPUR_STAIRS: 
            case QUARTZ_STAIRS: 
            case RED_SANDSTONE_STAIRS: 
            case SANDSTONE_STAIRS: 
            case SPRUCE_STAIRS: 
            case STONE_BRICK_STAIRS: 
            case STONE_STAIRS: {
                return StairsBlockMapper1_12.map((StairsBlock)blockBrush);
            }
            case ACACIA_SLAB: 
            case BIRCH_SLAB: 
            case BRICK_SLAB: 
            case COBBLESTONE_SLAB: 
            case DARK_OAK_SLAB: 
            case JUNGLE_SLAB: 
            case PETRIFIED_OAK_SLAB: 
            case NETHER_BRICK_SLAB: 
            case OAK_SLAB: 
            case QUARTZ_SLAB: 
            case RED_SANDSTONE_SLAB: 
            case SANDSTONE_SLAB: 
            case SMOOTH_RED_SANDSTONE_SLAB: 
            case SPRUCE_SLAB: 
            case STONE_BRICK_SLAB: 
            case STONE_SLAB: {
                return SlabBlockMapper1_12.map((SlabBlock)blockBrush);
            }
            case IRON_DOOR: 
            case OAK_DOOR: 
            case BIRCH_DOOR: 
            case SPRUCE_DOOR: 
            case JUNGLE_DOOR: 
            case ACACIA_DOOR: 
            case DARK_OAK_DOOR: 
            case WARPED_DOOR: 
            case CRIMSON_DOOR: {
                return DoorBlockMapper1_12.map((DoorBlock)blockBrush);
            }
            case CHISELED_QUARTZ: {
                return QuartzBlockMapper1_12.map(Quartz.CHISELED, facing);
            }
            case PILLAR_QUARTZ: {
                return QuartzBlockMapper1_12.map(Quartz.PILLAR, facing);
            }
            case WITHER_SKELETON_SKULL: {
                return Blocks.field_150465_bP.func_176223_P();
            }
            case SMOOTH_QUARTZ: {
                return QuartzBlockMapper1_12.map(Quartz.SMOOTH, facing);
            }
            case VINE: {
                return VineBlockMapper1_12.map(facing);
            }
            case CROP: {
                return CropBlockMapper1_12.map((CropBlock)blockBrush);
            }
            case PUMPKIN: {
                return blockBrush instanceof PumpkinBlock ? PumpkinBlockMapper1_12.map((PumpkinBlock)blockBrush) : Blocks.field_150423_aK.func_176223_P();
            }
            case FLOWER_POT: {
                return Blocks.field_150457_bL.func_176223_P();
            }
            case BROWN_MUSHROOM: {
                return Blocks.field_150338_P.func_176223_P();
            }
            case RED_MUSHROOM: {
                return Blocks.field_150337_Q.func_176223_P();
            }
            case PLANT: {
                return PlantBlockMapper1_12.map((PlantBlock)blockBrush);
            }
            case TALL_PLANT: {
                return TallGrassMapper1_12.map((TallPlantBlock)blockBrush);
            }
            case GRASS_PLANT: {
                return Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
            }
            case FERN: {
                return Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN);
            }
            case TRAPDOOR: {
                return TrapdoorBlockMapper1_12.map((TrapdoorBlock)blockBrush);
            }
            case LEVER: {
                return LeverMapper1_12.getLever((LeverBlock)blockBrush);
            }
            case TORCH: 
            case REDSTONE_TORCH: {
                return TorchBlockMapper1_12.map((TorchBlock)blockBrush);
            }
            case BED: {
                if (blockBrush instanceof BedBlock) {
                    return BedBlockMapper1_12.map((BedBlock)blockBrush);
                }
                return BlockMapper1_12.map(new BedBlock());
            }
            case FURNACE: {
                if (!RogueConfig.FURNITURE.getBoolean()) {
                    return Blocks.field_150347_e.func_176223_P();
                }
                return Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)enumFacing);
            }
            case DISPENSER: {
                return Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)enumFacing);
            }
            case DROPPER: {
                return Blocks.field_150409_cd.func_176223_P().func_177226_a((IProperty)BlockDropper.field_176441_a, (Comparable)enumFacing);
            }
            case HOPPER: {
                return Blocks.field_150438_bZ.func_176223_P().func_177226_a((IProperty)BlockHopper.field_176430_a, (Comparable)enumFacing);
            }
            case COCOA_BEANS: {
                return Blocks.field_150375_by.func_176223_P();
            }
            case COMPARATOR: {
                return ComparatorBlockMapper1_12.map((ComparatorBlock)blockBrush);
            }
            case REPEATER: {
                return RepeaterBlockMapper1_12.map((RepeaterBlock)blockBrush);
            }
            case PISTON: {
                return Blocks.field_150331_J.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)enumFacing);
            }
            case STICKY_PISTON: {
                return Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockPistonBase.field_176387_N, (Comparable)enumFacing);
            }
            case INFESTED_BLOCK: {
                return InfestedBlockMapper1_12.map((InfestedBlock)blockBrush);
            }
            case CHEST: {
                return Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)enumFacing);
            }
            case TRAPPED_CHEST: {
                return Blocks.field_150447_bR.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)enumFacing);
            }
            case NETHER_PORTAL: {
                return Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)enumFacing.func_176740_k());
            }
            case TRIPWIRE: {
                return Blocks.field_150473_bD.func_176223_P();
            }
            case TRIPWIRE_HOOK: {
                return Blocks.field_150479_bC.func_176223_P().func_177226_a((IProperty)BlockTripWire.field_176294_M, (Comparable)Boolean.valueOf(((TripwireHookBlock)blockBrush).isAttached())).func_177226_a((IProperty)BlockTripWireHook.field_176264_a, (Comparable)enumFacing);
            }
            case LADDER: {
                return Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)enumFacing);
            }
            case AIR: {
                return Blocks.field_150350_a.func_176223_P();
            }
            case WATER_STILL: {
                return Blocks.field_150355_j.func_176223_P();
            }
            case WATER_FLOWING: {
                return Blocks.field_150358_i.func_176223_P();
            }
            case LAVA_STILL: {
                return Blocks.field_150353_l.func_176223_P();
            }
            case LAVA_FLOWING: {
                return Blocks.field_150356_k.func_176223_P();
            }
            case FIRE: {
                return Blocks.field_150480_ab.func_176223_P();
            }
            case IRON_BAR: {
                return Blocks.field_150411_aY.func_176223_P();
            }
            case STONE_SMOOTH: {
                return Blocks.field_150348_b.func_176223_P();
            }
            case GRANITE: {
                return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
            }
            case GRANITE_POLISHED: {
                return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE_SMOOTH);
            }
            case DIORITE: {
                return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
            }
            case DIORITE_POLISHED: {
                return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH);
            }
            case ANDESITE: {
                return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
            }
            case ANDESITE_POLISHED: {
                return Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
            }
            case GRASS_BLOCK: {
                return Blocks.field_150349_c.func_176223_P();
            }
            case DIRT: {
                return Blocks.field_150346_d.func_176223_P();
            }
            case DIRT_COARSE: {
                return Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
            }
            case DIRT_PODZOL: {
                return Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
            }
            case COBBLESTONE: {
                return Blocks.field_150347_e.func_176223_P();
            }
            case COBBLESTONE_WALL: {
                return Blocks.field_150463_bK.func_176223_P();
            }
            case BEDROCK: {
                return Blocks.field_150357_h.func_176223_P();
            }
            case SAND: {
                return Blocks.field_150354_m.func_176223_P();
            }
            case SAND_RED: {
                return Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
            }
            case GRAVEL: {
                return Blocks.field_150351_n.func_176223_P();
            }
            case ORE_GOLD: {
                return Blocks.field_150352_o.func_176223_P();
            }
            case ORE_IRON: {
                return Blocks.field_150366_p.func_176223_P();
            }
            case ORE_COAL: {
                return Blocks.field_150402_ci.func_176223_P();
            }
            case GLASS: {
                return Blocks.field_150359_w.func_176223_P();
            }
            case GLASS_PANE: {
                return Blocks.field_150410_aZ.func_176223_P();
            }
            case ORE_LAPIS: {
                return Blocks.field_150369_x.func_176223_P();
            }
            case LAPIS_BLOCK: {
                return Blocks.field_150368_y.func_176223_P();
            }
            case ORE_EMERALD: {
                return Blocks.field_150412_bA.func_176223_P();
            }
            case SANDSTONE: {
                return Blocks.field_150322_A.func_176223_P();
            }
            case CHISELED_SANDSTONE: {
                return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.CHISELED);
            }
            case SANDSTONE_SMOOTH: {
                return Blocks.field_150322_A.func_176223_P().func_177226_a((IProperty)BlockSandStone.field_176297_a, (Comparable)BlockSandStone.EnumType.SMOOTH);
            }
            case GOLD_BLOCK: {
                return Blocks.field_150340_R.func_176223_P();
            }
            case IRON_BLOCK: {
                return Blocks.field_150339_S.func_176223_P();
            }
            case BRICK: {
                return Blocks.field_150336_V.func_176223_P();
            }
            case COBBLESTONE_MOSSY: {
                return Blocks.field_150341_Y.func_176223_P();
            }
            case OBSIDIAN: {
                return Blocks.field_150343_Z.func_176223_P();
            }
            case ORE_DIAMOND: {
                return Blocks.field_150482_ag.func_176223_P();
            }
            case DIAMOND_BLOCK: {
                return Blocks.field_150484_ah.func_176223_P();
            }
            case FARMLAND: {
                return Blocks.field_150458_ak.func_176223_P();
            }
            case ORE_REDSTONE: {
                return Blocks.field_150450_ax.func_176223_P();
            }
            case ICE: {
                return Blocks.field_150432_aD.func_176223_P();
            }
            case SNOW: {
                return Blocks.field_150433_aE.func_176223_P();
            }
            case CLAY: {
                return Blocks.field_150435_aG.func_176223_P();
            }
            case NETHERRACK: {
                return Blocks.field_150424_aL.func_176223_P();
            }
            case SOUL_SAND: {
                return Blocks.field_150425_aM.func_176223_P();
            }
            case GLOWSTONE: {
                return Blocks.field_150426_aN.func_176223_P();
            }
            case STONE_BRICKS: {
                return Blocks.field_150417_aV.func_176223_P();
            }
            case STONE_BRICK_MOSSY: {
                return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
            }
            case STONE_BRICK_CRACKED: {
                return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CRACKED);
            }
            case STONE_BRICK_CHISELED: {
                return Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.CHISELED);
            }
            case MYCELIUM: {
                return Blocks.field_150391_bh.func_176223_P();
            }
            case NETHERBRICK: {
                return Blocks.field_150385_bj.func_176223_P();
            }
            case END_PORTAL: {
                return Blocks.field_150384_bq.func_176223_P();
            }
            case END_PORTAL_FRAME: {
                return Blocks.field_150378_br.func_176223_P();
            }
            case END_STONE: {
                return Blocks.field_150377_bs.func_176223_P();
            }
            case EMERALD_BLOCK: {
                return Blocks.field_150475_bE.func_176223_P();
            }
            case ORE_QUARTZ: {
                return Blocks.field_150449_bY.func_176223_P();
            }
            case PRISMARINE: {
                return Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.ROUGH);
            }
            case PRISMARINE_BRICKS: {
                return Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.BRICKS);
            }
            case PRISMARINE_DARK: {
                return Blocks.field_180397_cI.func_176223_P().func_177226_a((IProperty)BlockPrismarine.field_176332_a, (Comparable)BlockPrismarine.EnumType.DARK);
            }
            case SEA_LANTERN: {
                return Blocks.field_180398_cJ.func_176223_P();
            }
            case COAL_BLOCK: {
                return Blocks.field_150402_ci.func_176223_P();
            }
            case ICE_PACKED: {
                return Blocks.field_150403_cj.func_176223_P();
            }
            case RED_SANDSTONE: {
                return Blocks.field_180395_cM.func_176223_P();
            }
            case CHISELED_RED_SANDSTONE: {
                return Blocks.field_180395_cM.func_176223_P().func_177226_a((IProperty)BlockRedSandstone.field_176336_a, (Comparable)BlockRedSandstone.EnumType.CHISELED);
            }
            case SMOOTH_RED_SANDSTONE: {
                return Blocks.field_180395_cM.func_176223_P().func_177226_a((IProperty)BlockRedSandstone.field_176336_a, (Comparable)BlockRedSandstone.EnumType.SMOOTH);
            }
            case QUARTZ: {
                return Blocks.field_150371_ca.func_176223_P();
            }
            case REDSTONE_BLOCK: {
                return Blocks.field_150451_bX.func_176223_P();
            }
            case PRESSURE_PLATE_STONE: {
                return Blocks.field_150456_au.func_176223_P();
            }
            case OAK_PRESSURE_PLATE: {
                return Blocks.field_150452_aw.func_176223_P();
            }
            case BOOKSHELF: {
                return Blocks.field_150342_X.func_176223_P();
            }
            case REDSTONE_WIRE: {
                return Blocks.field_150488_af.func_176223_P();
            }
            case SUGAR_CANE: {
                return Blocks.field_150436_aH.func_176223_P();
            }
            case CRAFTING_TABLE: {
                return !RogueConfig.FURNITURE.getBoolean() ? BlockMapper1_12.map(Wood.OAK.getPlanks()) : Blocks.field_150462_ai.func_176223_P();
            }
            case NOTEBLOCK: {
                return Blocks.field_150323_B.func_176223_P();
            }
            case REDSTONE_LAMP: {
                return Blocks.field_150379_bu.func_176223_P();
            }
            case REDSTONE_LAMP_LIT: {
                return Blocks.field_150374_bv.func_176223_P();
            }
            case JUKEBOX: {
                return Blocks.field_150421_aI.func_176223_P();
            }
            case TNT: {
                return Blocks.field_150335_W.func_176223_P();
            }
            case ENCHANTING_TABLE: {
                return Blocks.field_150381_bn.func_176223_P();
            }
            case FENCE_NETHER_BRICK: {
                return Blocks.field_150386_bk.func_176223_P();
            }
            case COBWEB: {
                return Blocks.field_150321_G.func_176223_P();
            }
            case PURPUR_BLOCK: {
                return Blocks.field_185767_cT.func_176223_P();
            }
            case PURPUR_PILLAR: {
                return Blocks.field_185768_cU.func_176223_P();
            }
            case PURPUR_STAIR: {
                return Blocks.field_185769_cV.func_176223_P();
            }
            case PURPUR_SLAB: {
                return Blocks.field_185771_cX.func_176223_P();
            }
            case END_STONE_BRICKS: {
                return Blocks.field_185772_cY.func_176223_P();
            }
            case MAGMA: {
                return Blocks.field_189877_df.func_176223_P();
            }
            case RED_NETHER_BRICKS: {
                return Blocks.field_189879_dh.func_176223_P();
            }
            case NETHER_WART_BLOCK: {
                return Blocks.field_189878_dg.func_176223_P();
            }
            case OAK_SAPLING: {
                return WoodMapper1_12.mapSapling(Wood.OAK);
            }
            case SPRUCE_SAPLING: {
                return WoodMapper1_12.mapSapling(Wood.SPRUCE);
            }
            case BIRCH_SAPLING: {
                return WoodMapper1_12.mapSapling(Wood.BIRCH);
            }
            case BONE_BLOCK: {
                return Blocks.field_189880_di.func_176223_P();
            }
            case BREWING_STAND: {
                return Blocks.field_150382_bo.func_176223_P();
            }
            case CACTUS: {
                return Blocks.field_150434_aF.func_176223_P();
            }
            case CAKE: {
                return Blocks.field_150414_aQ.func_176223_P();
            }
            case SPAWNER: {
                return Blocks.field_150474_ac.func_176223_P();
            }
            case ENDER_CHEST: {
                return Blocks.field_150477_bB.func_176223_P();
            }
            case POPPY: {
                return Blocks.field_150328_O.func_176223_P();
            }
            case SKELETONS_SKULL: {
                return Blocks.field_150465_bP.func_176223_P();
            }
            case DANDELION: {
                return Blocks.field_150327_N.func_176223_P();
            }
            case JUNGLE_SAPLING: {
                return WoodMapper1_12.mapSapling(Wood.JUNGLE);
            }
            case ACACIA_SAPLING: {
                return WoodMapper1_12.mapSapling(Wood.ACACIA);
            }
            case DARK_OAK_SAPLING: {
                return WoodMapper1_12.mapSapling(Wood.DARK_OAK);
            }
            case WHEAT: {
                return Blocks.field_150464_aj.func_176223_P();
            }
            case OAK_SIGN: {
                return Blocks.field_150472_an.func_176223_P();
            }
            case SPONGE: {
                return Blocks.field_150360_v.func_176223_P();
            }
        }
        throw new ReportThisIssueException(new UnmappedBlockException(blockType));
    }
}

