/*
 * Decompiled with CFR 0.152.
 */
package srpmultiplier.mixin.playerphases;

import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmultiplier.SRPMultiplier;
import srpmultiplier.handlers.PlayerPhases_AlertOnePlayer;
import srpmultiplier.handlers.SRPMultiplierConfigHandler;
import srpmultiplier.mixin.playerphases.SRPSaveDataAccessor;
import srpmultiplier.util.SRPSaveDataInterface;

@Mixin(value={SRPSaveData.class})
public abstract class SRPSaveDataMixin
implements SRPSaveDataInterface {
    @Unique
    private static String uuidtmp = "";
    @Unique
    private UUID playerUUID;

    @ModifyArg(method={"<init>()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/WorldSavedData;<init>(Ljava/lang/String;)V"), remap=false)
    private static String changeDataName(String name) {
        return name + uuidtmp;
    }

    @Inject(method={"createData"}, at={@At(value="HEAD")}, remap=false)
    private static void getServerWorldData(World world, MapStorage storage, CallbackInfoReturnable<SRPSaveData> cir) {
        if (!SRPMultiplierConfigHandler.server.debugMode) {
            return;
        }
        SRPMultiplier.LOGGER.info("Creating new SRPSaveData for dim{}", (Object)world.field_73011_w.getDimension());
        if (world.field_72995_K) {
            try {
                throw new Exception("This Method called me");
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    @Redirect(method={"get"}, at=@At(value="INVOKE", target="Ljava/io/PrintStream;println(Ljava/lang/String;)V"), remap=false)
    private static void disableSRPDebugMessage(PrintStream instance, String s) {
    }

    @Override
    public void setUUID(UUID uuid) {
        this.playerUUID = uuid;
    }

    @Unique
    private static SRPSaveData createForPlayer(World world, UUID playerUUID, MapStorage storage) {
        String[] configSplit;
        SRPMultiplier.LOGGER.info("Creating new SRPSaveData for dim{} and player{}", (Object)world.field_73011_w.getDimension(), (Object)playerUUID.toString());
        uuidtmp = playerUUID.toString();
        SRPSaveData instance = new SRPSaveData();
        uuidtmp = "";
        storage.func_75745_a("srparasites_global_data" + playerUUID, (WorldSavedData)instance);
        for (String line : SRPConfigSystems.evolutionParasiteLock) {
            if (line == null) continue;
            configSplit = line.split(";");
            int id = Integer.parseInt(configSplit[2]);
            instance.getLockedList().add(id);
        }
        for (String line : SRPConfigSystems.evolutionDimStart) {
            configSplit = line.split(";");
            int dim = Integer.parseInt(configSplit[0]);
            SRPSaveDataMixin.addDim(instance, dim);
            int phase = Integer.parseInt(configSplit[1]);
            int points = Integer.parseInt(configSplit[2]);
            instance.setEvolutionPhase(dim, (byte)phase, true, world, true);
            if (phase == -1) {
                instance.setTotalKills(dim, -points, false, world, true);
                continue;
            }
            if (phase == -2) {
                instance.setGaining(false, dim);
                instance.setLoss(true, dim);
                continue;
            }
            instance.setTotalKills(dim, points, false, world, true);
        }
        Iterator<Integer> iterator = ((SRPSaveDataAccessor)instance).getDimEPid().iterator();
        while (iterator.hasNext()) {
            boolean dimIsInList;
            int dim = (Integer)iterator.next();
            if (!SRPConfigSystems.evolutionDimGainInverted == (dimIsInList = Arrays.stream(SRPConfigSystems.evolutionDimGain).anyMatch(v -> v == dim))) {
                instance.setGaining(false, dim);
            }
            if (!SRPConfigSystems.evolutionDimLossInverted != (dimIsInList = Arrays.stream(SRPConfigSystems.evolutionDimLoss).anyMatch(v -> v == dim))) continue;
            instance.setLoss(true, dim);
        }
        return instance;
    }

    @Unique
    private static void addDim(SRPSaveData instance, int id) {
        if (((SRPSaveDataAccessor)instance).getDimEPid().contains(id)) {
            return;
        }
        ((SRPSaveDataAccessor)instance).getDimEPid().add(id);
        ((SRPSaveDataAccessor)instance).getDimEPcanGainPoints().add(true);
        ((SRPSaveDataAccessor)instance).getDimEPcanLossPoints().add(false);
        ((SRPSaveDataAccessor)instance).getDimEPevolution().add(SRPConfigSystems.defaultEvoPhase);
        ((SRPSaveDataAccessor)instance).getDimEPtimeEvolution().add(0);
        ((SRPSaveDataAccessor)instance).getDimEPtotalKills().add(SRPConfigSystems.defaultEvoPoints);
        instance.func_76185_a();
    }

    @Override
    public SRPSaveData getByPlayer(World world, UUID playerUUID) {
        if (playerUUID != null) {
            MapStorage storage = world.getPerWorldStorage();
            SRPSaveData instancePlayer = (SRPSaveData)storage.func_75742_a(SRPSaveData.class, "srparasites_global_data" + playerUUID);
            if (instancePlayer == null) {
                instancePlayer = SRPSaveDataMixin.createForPlayer(world, playerUUID, storage);
            }
            ((SRPSaveDataInterface)instancePlayer).setUUID(playerUUID);
            return instancePlayer;
        }
        if (SRPMultiplierConfigHandler.server.debugMode) {
            SRPMultiplier.LOGGER.info("SRPMultiplier Debug Mode: getByPlayer didnt find player");
        }
        return SRPSaveData.get((World)world);
    }

    @Override
    public SRPSaveData getByBlock(World world, BlockPos blockPos) {
        if (!world.field_73010_i.isEmpty()) {
            if (blockPos != null) {
                int z;
                int y;
                int x = blockPos.func_177958_n();
                EntityPlayer player = this.getClosestPlayer(world, x, y = blockPos.func_177956_o(), z = blockPos.func_177952_p(), 256.0);
                if (player != null) {
                    return this.getByPlayer(world, player.func_110124_au());
                }
                if (SRPMultiplierConfigHandler.server.debugMode) {
                    SRPMultiplier.LOGGER.info("SRPMultiplier Debug Mode: getByBlock didnt find player {}", (Object)blockPos);
                }
            } else if (SRPMultiplierConfigHandler.server.debugMode) {
                SRPMultiplier.LOGGER.info("SRPMultiplier Debug Mode: getByBlock didnt find blockpos");
            }
            if (SRPMultiplierConfigHandler.server.debugMode) {
                try {
                    throw new Exception("SRPMultiplier Debug Mode - Stack Trace");
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        return SRPSaveData.get((World)world);
    }

    @Unique
    public EntityPlayer getClosestPlayer(World world, double x, double y, double z, double maxDist) {
        double minDist = -1.0;
        EntityPlayer closestPlayer = null;
        for (EntityPlayer player : world.field_73010_i) {
            if (player.func_175149_v()) continue;
            double currDistXZ = this.distSq(player, x, z);
            double currDist = player.func_70092_e(x, y, z);
            if (!(maxDist < 0.0) && !(currDistXZ < maxDist * maxDist) || minDist != -1.0 && !(currDist < minDist)) continue;
            minDist = currDist;
            closestPlayer = player;
        }
        return closestPlayer;
    }

    @Unique
    private double distSq(EntityPlayer player, double x, double z) {
        double xD = Math.abs(player.field_70165_t - x);
        double zD = Math.abs(player.field_70161_v - z);
        return Math.max(xD, zD);
    }

    @Redirect(method={"checkKills"}, at=@At(value="INVOKE", target="Lcom/dhanantry/scapeandrunparasites/util/ParasiteEventEntity;alertAllPlayerDim(Lnet/minecraft/world/World;Ljava/lang/String;I)V"), remap=false)
    void sendWarningToOnePlayer(World worldIn, String message, int warning) {
        if (SRPMultiplierConfigHandler.server.playerPhases && this.playerUUID != null) {
            PlayerPhases_AlertOnePlayer.alertOnePlayer(worldIn, this.playerUUID, message, warning);
        } else {
            ParasiteEventEntity.alertAllPlayerDim((World)worldIn, (String)message, (int)warning);
        }
    }

    @Redirect(method={"checkForUnlock"}, at=@At(value="INVOKE", target="Lcom/dhanantry/scapeandrunparasites/util/ParasiteEventEntity;alertAllPlayerSer(Ljava/lang/String;Lnet/minecraft/world/World;)V"), remap=false)
    void sendParaUnlockMessageToOnePlayer(String message, World world) {
        if (SRPMultiplierConfigHandler.server.playerPhases) {
            EntityPlayer player = world.func_152378_a(this.playerUUID);
            if (player != null) {
                player.func_145747_a((ITextComponent)new TextComponentString(message));
            }
        } else {
            ParasiteEventEntity.alertAllPlayerSer((String)message, (World)world);
        }
    }
}

