/*
 * Decompiled with CFR 0.152.
 */
package srpmultiplier.mixin.lostcitytweaks.bloodmoon;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPWorldEntitySpawner;
import lumien.bloodmoon.network.PacketHandler;
import lumien.bloodmoon.network.messages.MessageBloodmoonStatus;
import lumien.bloodmoon.server.BloodmoonHandler;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import srpmultiplier.handlers.SRPMultiplierConfigHandler;

@Mixin(value={BloodmoonHandler.class})
public abstract class BloodmoonHandlerMixin {
    @Unique
    public int time = 0;
    @Shadow(remap=false)
    boolean bloodMoon;

    @Redirect(method={"endWorldTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldProvider;getDimension()I", ordinal=0), remap=false)
    private int allowLCdimensionMixin(WorldProvider instance) {
        if (SRPMultiplierConfigHandler.server.bloodmoonInLC && instance.getDimension() == 111) {
            return 0;
        }
        return instance.getDimension();
    }

    @Inject(method={"endWorldTick"}, at={@At(value="INVOKE", target="Llumien/bloodmoon/server/BloodmoonSpawner;findChunksForSpawning(Lnet/minecraft/world/WorldServer;ZZZ)I")}, remap=false)
    private void spawnParasitesMixin(TickEvent.WorldTickEvent event, CallbackInfo ci) {
        if (SRPMultiplierConfigHandler.server.bloodmoonInLC && !event.world.field_72995_K && SRPConfigSystems.useEvolution && SRPConfigSystems.phaseCustomSpawner) {
            WorldServer server;
            SRPWorldEntitySpawner.findChunksForSpawning((WorldServer)server, (boolean)true, (boolean)false, ((server = event.world.func_73046_m().func_71218_a(event.world.field_73011_w.getDimension())).func_72912_H().func_82573_f() % 400L == 0L ? 1 : 0) != 0);
        }
    }

    @Inject(method={"endWorldTick"}, at={@At(value="HEAD")}, remap=false)
    private void saveWorldTimeMixin(TickEvent.WorldTickEvent event, CallbackInfo ci) {
        if (SRPMultiplierConfigHandler.server.bloodmoonInLC) {
            this.time = (int)(event.world.func_72820_D() % 24000L);
        }
    }

    @Redirect(method={"endWorldTick"}, at=@At(value="INVOKE", target="Llumien/bloodmoon/server/BloodmoonHandler;isBloodmoonActive()Z"), remap=false)
    private boolean skipFirstBloodMoonTickInLCMixin(BloodmoonHandler instance) {
        if (SRPMultiplierConfigHandler.server.bloodmoonInLC && this.time == 12000) {
            return false;
        }
        return instance.isBloodmoonActive();
    }

    @Inject(method={"updateClients"}, at={@At(value="HEAD")}, remap=false)
    private void updateBloodmoonMixin(CallbackInfo ci) {
        if (SRPMultiplierConfigHandler.server.bloodmoonInLC) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBloodmoonStatus(this.bloodMoon), 111);
        }
    }

    @Inject(method={"setBloodmoon"}, at={@At(value="HEAD")}, remap=false)
    private void setBloodmoonMixin(boolean bloodMoon, CallbackInfo ci) {
        if (SRPMultiplierConfigHandler.server.bloodmoonInLC && this.bloodMoon != bloodMoon) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageBloodmoonStatus(bloodMoon), 111);
        }
    }
}

