/*
 * Decompiled with CFR 0.152.
 */
package srpmultiplier.mixin.features;

import com.dhanantry.scapeandrunparasites.world.SRPWorldEntitySpawner;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmultiplier.SRPMultiplier;
import srpmultiplier.handlers.SRPMultiplierConfigHandler;

@Mixin(value={SRPWorldEntitySpawner.class})
public abstract class BiomeSpawningBlacklist {
    @Inject(method={"getSpawnListEntryForTypeAt"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void blacklistDimensions(WorldServer worldServerIn, BlockPos pos, CallbackInfoReturnable<Biome.SpawnListEntry> cir) {
        boolean isInList;
        int dim = worldServerIn.field_73011_w.getDimension();
        ArrayList<String> biomeBlacklist = SRPMultiplier.biomeSpawningBlacklists.get(dim);
        if (biomeBlacklist == null) {
            return;
        }
        ResourceLocation biome = worldServerIn.func_180494_b(pos).getRegistryName();
        if (biome == null) {
            return;
        }
        String currBiome = biome.toString();
        String currBiomeMod = biome.func_110624_b();
        boolean bl = isInList = biomeBlacklist.contains(currBiome) || biomeBlacklist.contains(currBiomeMod) || biomeBlacklist.isEmpty();
        if (isInList != SRPMultiplierConfigHandler.server.biomeBlacklistIsWhitelist) {
            cir.setReturnValue(null);
        }
    }
}

