/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.tameable;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.ai.EntityAITargetItem;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityFishTameable;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityScarecrow;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWaterFlying;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRaven
extends EntityFishTameable
implements EntityFlying {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityRaven.class, (DataSerializer)DataSerializers.field_187192_b);
    private final Set<Item> TAME_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151070_bp, Items.field_151071_bq, FishItems.PARASITE_ITEM, FishItems.PARASITE_ITEM_COOKED});
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    private boolean partyParrot;
    private BlockPos jukeboxPosition;
    private int ridingCooldown;
    public int callTimer;
    private float TargetLocationX = -1.0f;
    private float TargetLocationY = -1.0f;
    private float TargetLocationZ = -1.0f;
    private EntityAITargetItem<EntityItem> AITargetItem;

    public EntityRaven(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.9f);
        this.ridingCooldown = 30;
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.func_98053_h(true);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.wander = new EntityAIWanderAvoidWaterFlying((EntityCreature)this, 1.0);
        this.follow = new EntityAIFollowOwnerFlying((EntityTameable)this, 1.0, 5.0f, 1.0f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMovetoTargetLocation());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 3.0f, 7.0f));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.AITargetItem = new EntityAITargetItem<EntityItem>((EntityCreature)this, EntityItem.class, true);
        this.field_70715_bh.func_75776_a(1, this.AITargetItem);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Raven_Health);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    private void SetDismount(Entity ridden) {
        this.func_184210_p();
        this.func_70107_b(ridden.field_70165_t, ridden.field_70163_u + (double)(ridden.field_70131_O / 2.0f) - (double)0.35f, ridden.field_70161_v);
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        if (ridden instanceof EntityPlayerMP && ((EntityPlayerMP)ridden).field_71135_a != null) {
            ((EntityPlayerMP)ridden).field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(ridden));
        }
        this.ridingCooldown = 30;
    }

    public void setTargetLocation(float X, float Y, float Z) {
        this.TargetLocationX = X;
        this.TargetLocationY = Y;
        this.TargetLocationZ = Z;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.callTimer > 0) {
            --this.callTimer;
        }
        if (this.jukeboxPosition == null || this.jukeboxPosition.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 12.0 || this.field_70170_p.func_180495_p(this.jukeboxPosition).func_177230_c() != Blocks.field_150421_aI) {
            this.partyParrot = false;
            this.jukeboxPosition = null;
        }
        if (!this.isFetching() && this.func_70909_n()) {
            if (this.ridingCooldown > 0) {
                --this.ridingCooldown;
            }
            if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
                this.func_70101_b(this.func_184187_bx().field_70177_z, 0.0f);
                if (Modconfig.Raven_Slowfall && !this.func_184187_bx().field_70122_E && this.func_184187_bx().field_70181_x < 0.0 && !this.func_184187_bx().func_189652_ae() && !((EntityPlayer)this.func_184187_bx()).func_184613_cA()) {
                    this.func_184187_bx().field_70181_x *= 0.5;
                }
                if (this.ridingCooldown == 0 && (this.func_184187_bx().func_70093_af() || this.func_184187_bx().func_70090_H())) {
                    this.SetDismount(this.func_184187_bx());
                }
            }
            if (!this.func_70906_o() && !this.func_184218_aH() && this.func_184614_ca().func_190926_b() && this.field_70173_aa % 200 == 0 && this.field_70146_Z.nextFloat() < 0.02f) {
                Map<ItemStack, Float> lootTable;
                ItemStack chosenDrop = null;
                switch (this.getSkin()) {
                    case 2: {
                        lootTable = LootTableHandler.LOOT_SEAGULL;
                        break;
                    }
                    case 3: {
                        lootTable = LootTableHandler.LOOT_SPECTRAL_RAVEN;
                        break;
                    }
                    default: {
                        lootTable = LootTableHandler.LOOT_RAVEN;
                    }
                }
                for (Map.Entry<ItemStack, Float> entry : lootTable.entrySet()) {
                    if (!(this.field_70146_Z.nextFloat() < entry.getValue().floatValue())) continue;
                    chosenDrop = entry.getKey();
                    break;
                }
                if (chosenDrop == null) {
                    switch (this.getSkin()) {
                        case 1: {
                            chosenDrop = new ItemStack(Items.field_191525_da, 1);
                            break;
                        }
                        case 2: {
                            chosenDrop = new ItemStack(Items.field_151115_aP, 1);
                            break;
                        }
                        case 3: {
                            chosenDrop = new ItemStack(FishItems.ECTOPLASM, 1);
                            break;
                        }
                        default: {
                            chosenDrop = new ItemStack(FishItems.FEATHER_BLACK, 1);
                        }
                    }
                }
                this.func_184611_a(this.func_184600_cs(), new ItemStack(chosenDrop.func_77973_b(), this.field_70146_Z.nextInt(chosenDrop.func_190916_E()) + 1, chosenDrop.func_77960_j()));
            }
        }
        if (this.func_98052_bS() && !this.func_184614_ca().func_190926_b()) {
            this.func_98053_h(false);
        } else if (!this.func_98052_bS() && this.func_184614_ca().func_190926_b()) {
            this.func_98053_h(true);
        }
        this.calculateFlapping();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_191987_a(BlockPos pos, boolean p_191987_2_) {
        this.jukeboxPosition = pos;
        this.partyParrot = p_191987_2_;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPartying() {
        return this.partyParrot;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.flap += this.flapping * 2.0f;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_152114_e((EntityLivingBase)player) && hand.equals((Object)EnumHand.MAIN_HAND)) {
            if (itemstack.func_190926_b() && !this.func_184614_ca().func_190926_b()) {
                player.field_70170_p.func_184133_a(player, this.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (!player.field_71071_by.func_70441_a(this.func_184614_ca().func_77946_l())) {
                    player.func_71019_a(this.func_184614_ca().func_77946_l(), false);
                }
                this.func_184614_ca().func_190918_g(this.func_184614_ca().func_190916_E());
                return true;
            }
            if (Modconfig.Raven_Perch && player.func_70093_af() && player.func_184188_bt().isEmpty()) {
                this.func_184220_m((Entity)player);
                this.ridingCooldown = 20;
                if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71135_a != null) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetPassengers((Entity)player));
                }
                return true;
            }
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                if (!this.func_174814_R()) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
                }
                this.func_70691_i(2.0f);
                return true;
            }
            if (itemstack.func_77973_b() == FishItems.GHOSTJELLY && this.getSkin() == 0) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.setSkin(3);
                this.func_184185_a(SoundEvents.field_192797_eu, 1.0f, 1.0f);
                this.func_184185_a(SoundEvents.field_187674_a, 1.0f, 1.0f);
                for (int i = 0; i < 16; ++i) {
                    double d0 = new Random().nextGaussian() * 0.02;
                    double d1 = new Random().nextGaussian() * 0.02;
                    double d2 = new Random().nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + (double)(new Random().nextFloat() * this.field_70131_O), this.field_70161_v + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return this.getSkin() == 2 ? stack.func_77973_b().equals(Items.field_151115_aP) : this.TAME_ITEMS.contains(stack.func_77973_b());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        Block block = this.field_70170_p.func_180495_p(blockpos.func_177977_b()).func_177230_c();
        if (SpawnUtil.isAllowedDimension(this.field_71093_bK)) {
            if (block instanceof BlockLeaves) return true;
        }
        if (block == Blocks.field_150349_c) return true;
        if (block instanceof BlockLog) return true;
        if (block != Blocks.field_150350_a) return false;
        if (this.field_70170_p.func_175699_k(blockpos) <= 8) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        if (!this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_189884_a((Entity)this)) return false;
        return true;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            return this.func_184187_bx().field_70131_O / 2.0f - 0.35f;
        }
        return super.func_70033_W();
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
    }

    @Nullable
    public SoundEvent func_184639_G() {
        if (this.getSkin() == 2) {
            return FishItems.ENTITY_SEAGULL_AMBIENT;
        }
        return FishItems.ENTITY_RAVEN_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (this.getSkin() == 2) {
            return FishItems.ENTITY_SEAGULL_HURT;
        }
        return FishItems.ENTITY_RAVEN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        if (this.getSkin() == 2) {
            return FishItems.ENTITY_SEAGULL_DEATH;
        }
        return FishItems.ENTITY_RAVEN_DEATH;
    }

    public void func_70642_aH() {
        super.func_70642_aH();
        this.callTimer = 10;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float p_191954_1_) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return p_191954_1_ + this.flapSpeed / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public EnumCreatureAttribute func_70668_bt() {
        if (this.getSkin() == 3) {
            return EnumCreatureAttribute.UNDEAD;
        }
        return EnumCreatureAttribute.UNDEFINED;
    }

    public boolean func_70104_M() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || this.getSkin() == 3) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184614_ca().func_190926_b()) {
            this.func_70099_a(this.func_184614_ca().func_77946_l(), 0.2f);
            this.func_184614_ca().func_190918_g(100);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184218_aH();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)(this.field_70146_Z.nextFloat() < 0.1f ? 1 : 0));
    }

    public String func_70005_c_() {
        if (this.getSkin() == 2) {
            if (this.func_145818_k_()) {
                return this.func_95999_t();
            }
            return new TextComponentTranslation("entity.mod_lavacow.raven.seagull", new Object[0]).func_150254_d();
        }
        return super.func_70005_c_();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData) {
        if (BiomeDictionary.hasType((Biome)this.func_130014_f_().func_180494_b(this.func_180425_c()), (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
            this.setSkin(2);
        }
        return super.func_180482_a(difficulty, entityLivingData);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    private boolean isFetching() {
        return this.TargetLocationX != -1.0f || this.TargetLocationY != -1.0f || this.TargetLocationZ != -1.0f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.func_70906_o() || !this.func_130014_f_().func_180495_p(this.func_180425_c().func_177977_b()).func_185914_p()) {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getSkin());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSkin(compound.func_74762_e("Variant"));
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        if (recentlyHit) {
            int chance = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + looting);
            for (int amount = 0; amount < chance; ++amount) {
                this.func_70099_a(new ItemStack(this.getSkin() == 2 ? Items.field_151008_G : FishItems.FEATHER_BLACK), 0.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.getSkin() == 3 ? 0xF000F0 : super.func_70070_b();
    }

    public float func_70013_c() {
        return this.getSkin() == 3 ? 1.0f : super.func_70013_c();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.getSkin() == 2 ? LootTableHandler.SEAGULL : LootTableHandler.RAVEN;
    }

    public boolean isFlying() {
        return !this.field_70122_E && !this.func_184218_aH() || this.func_184187_bx() != null && !this.func_184187_bx().field_70122_E && this.func_184187_bx().field_70181_x < 0.0;
    }

    @Override
    public boolean isPreventingPlayerRest(EntityPlayer playerIn) {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        if (!(this.func_70909_n() || this.field_70170_p.func_72935_r() || this.field_70146_Z.nextInt(100) >= Modconfig.pScarecrow_PlagueDoctor || this.func_130014_f_().field_72995_K)) {
            EntityScarecrow entityscarecrow = new EntityScarecrow(this.field_70170_p);
            entityscarecrow.func_70012_b(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 0.0f, 0.0f);
            entityscarecrow.setSkin(2);
            this.field_70170_p.func_72838_d((Entity)entityscarecrow);
            this.func_184185_a(SoundEvents.field_187674_a, 1.0f, 1.0f);
            for (int i = 0; i < 8; ++i) {
                double d3 = this.field_70165_t + this.field_70146_Z.nextDouble();
                double d4 = this.field_70163_u + this.field_70146_Z.nextDouble();
                double d5 = this.field_70161_v + this.field_70146_Z.nextDouble();
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d4, d5, 0.0, 0.0, 0.0, new int[0]);
            }
            entityscarecrow.func_70690_d(new PotionEffect(MobEffects.field_180152_w, 160, 2));
            entityscarecrow.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, 1));
            if (cause.func_76346_g() != null && cause.func_76346_g() instanceof EntityLivingBase) {
                entityscarecrow.func_70624_b((EntityLivingBase)cause.func_76346_g());
            }
        }
        super.func_70645_a(cause);
    }

    public class AIMovetoTargetLocation
    extends EntityAIBase {
        public AIMovetoTargetLocation() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntityRaven.this.isFetching();
        }

        public boolean func_75253_b() {
            return EntityRaven.this.func_70011_f(EntityRaven.this.TargetLocationX, EntityRaven.this.TargetLocationY, EntityRaven.this.TargetLocationZ) > 1.0;
        }

        public boolean func_75252_g() {
            return false;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityRaven.this.field_70699_by.func_75499_g();
            EntityRaven.this.field_70911_d.func_75270_a(false);
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityRaven.this.TargetLocationX = (EntityRaven.this.TargetLocationY = (EntityRaven.this.TargetLocationZ = -1.0f));
            EntityRaven.this.field_70699_by.func_75499_g();
            EntityRaven.this.field_70911_d.func_75270_a(true);
        }

        public void func_75246_d() {
            EntityRaven.this.func_70661_as().func_75492_a((double)EntityRaven.this.TargetLocationX, (double)EntityRaven.this.TargetLocationY, (double)EntityRaven.this.TargetLocationZ, 1.5);
        }
    }
}

