/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.tameable;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.EntityCactyrant;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityFishTameable;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCactoid
extends EntityFishTameable {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityCactoid.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GROWING_STAGE = EntityDataManager.func_187226_a(EntityCactoid.class, (DataSerializer)DataSerializers.field_187192_b);
    private EntityAIWatchClosest watch;
    private EntityAILookIdle look;

    public EntityCactoid(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.1f, 2.2f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(3));
        this.func_184212_Q().func_187214_a(GROWING_STAGE, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        this.watch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.look = new EntityAILookIdle((EntityLiving)this);
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.watch);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.look);
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Cactoid_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Cactoid_Attack);
    }

    @Override
    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return SpawnUtil.isAllowedDimension(this.field_71093_bK) && this.field_70170_p.func_175678_i(pos) && super.func_70601_bi();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (GROWING_STAGE.equals(key)) {
            // empty if block
        }
        super.func_184206_a(key);
    }

    public int getGrowingStage() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_STAGE);
    }

    public void setGrowingStage(int i) {
        this.field_70180_af.func_187227_b(GROWING_STAGE, (Object)i);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        if (!this.func_70909_n()) {
            IFluidHandlerItem fluidHandlerItem;
            FluidStack fluidStack;
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (fluidStack = (fluidHandlerItem = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).drain(1000, false)) != null) {
                if (this.getSkin() == 3 && fluidStack.getFluid() == FluidRegistry.LAVA) {
                    return true;
                }
                if (this.getSkin() != 3 && fluidStack.getFluid() == FluidRegistry.WATER) {
                    return true;
                }
            }
        } else {
            return stack.func_77969_a(new ItemStack(Items.field_151100_aR, 1, 15));
        }
        return false;
    }

    protected void func_82167_n(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityCactoid) && !(entity instanceof EntityCactyrant) && this.func_70638_az() == null && !this.func_70909_n() && entity.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        super.func_82167_n(entity);
    }

    protected boolean isInDaylight() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            float f = this.func_70013_c();
            BlockPos blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            return f > 0.5f && this.field_70170_p.func_175678_i(blockpos);
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n() && this.func_70638_az() == null) {
            if (this.isInDaylight()) {
                this.doSitCommand(null);
            } else if (this.state != EntityFishTameable.State.WANDERING) {
                this.doFollowCommand(null);
                this.doWanderCommand(null);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_175504_a < -12000) {
                if (this.getGrowingStage() != 0) {
                    this.setGrowingStage(0);
                }
            } else if (this.field_175504_a < 0) {
                if (this.getGrowingStage() != 1) {
                    this.setGrowingStage(1);
                    this.func_184185_a(FishItems.ENTITY_CACTYRANT_GROW, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                }
            } else if (this.field_175504_a == 0 && this.getGrowingStage() != 2) {
                this.setGrowingStage(2);
                this.func_184185_a(FishItems.ENTITY_CACTYRANT_GROW, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72960_a((Entity)this, (byte)14);
            }
        }
        super.func_70071_h_();
    }

    public void func_70030_z() {
        if (this.getSkin() == 3) {
            this.field_70178_ae = true;
        }
        super.func_70030_z();
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && this.func_70909_n() && this.getGrowingStage() == 2) {
            this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            this.func_70099_a(new ItemStack(FishItems.CACTUS_FRUIT), 0.0f);
            this.setGrowingStage(0);
            this.func_70873_a(-24000);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void doSitCommand(EntityPlayer player) {
        this.field_70714_bg.func_85156_a((EntityAIBase)this.watch);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.look);
        this.func_174810_b(true);
        super.doSitCommand(player);
    }

    @Override
    public void doFollowCommand(EntityPlayer player) {
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.watch);
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)this.look);
        this.func_174810_b(false);
        super.doFollowCommand(player);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        return flag;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        if (!source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 1.0f);
            }
        }
        if (source.func_76347_k()) {
            return super.func_70097_a(source, 2.0f * amount);
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Cactoid_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Cactoid_Attack);
        this.func_70606_j(this.func_110138_aP());
        this.func_70873_a(-24000);
        if (this.field_70170_p.field_73011_w.func_177500_n()) {
            this.setSkin(3);
            this.setFireImmunity();
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean setFireImmunity() {
        this.field_70178_ae = true;
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.34f;
    }

    public int func_70646_bf() {
        return this.func_174814_R() ? 0 : super.func_70646_bf();
    }

    public int func_184649_cE() {
        return this.func_174814_R() ? 0 : super.func_184649_cE();
    }

    @SideOnly(value=Side.CLIENT)
    protected void addParticlesAroundSelf(EnumParticleTypes type) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(type, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 14: {
                this.addParticlesAroundSelf(EnumParticleTypes.WATER_WAKE);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_LILSLUDGE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187546_ae;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_CACTYRANT_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.CACTOID;
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSkin(compound.func_74762_e("Variant"));
        this.setGrowingStage(compound.func_74762_e("GrowingStage"));
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getSkin());
        compound.func_74768_a("GrowingStage", this.getGrowingStage());
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getGrowingStage() == 2) {
            this.func_70099_a(new ItemStack(FishItems.CACTUS_FRUIT), 0.0f);
        }
    }

    public boolean func_146066_aG() {
        return this.func_70909_n() || !(this.func_70902_q() instanceof EntityPlayer);
    }
}

