/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.flying;

import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityFishTameable;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFlyingMob
extends EntityFishTameable {
    private int attackTimer;
    private int hoverTimer;
    private int landTimer;
    public static int heightLimit;

    public EntityFlyingMob(World worldIn, int heightLimit) {
        super(worldIn);
        EntityFlyingMob.heightLimit = heightLimit;
        this.field_70765_h = new FlyingMoveHelper(this);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_189654_d(true);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFlyingAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
    }

    @Override
    public boolean func_70601_bi() {
        return SpawnUtil.isAllowedDimension(this.field_71093_bK) && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v)) && super.func_70601_bi();
    }

    @Override
    protected void doSitCommand(EntityPlayer playerIn) {
        if (SpawnUtil.getHeight((Entity)this).func_177956_o() > 0 || this.func_70631_g_()) {
            this.func_189654_d(false);
        }
        super.doSitCommand(playerIn);
    }

    @Override
    protected void doFollowCommand(EntityPlayer playerIn) {
        if (!this.func_70631_g_()) {
            this.func_189654_d(true);
        }
        super.doFollowCommand(playerIn);
    }

    @Override
    protected void doWanderCommand(EntityPlayer playerIn) {
        if (!this.func_70631_g_()) {
            this.func_189654_d(true);
        }
        super.doWanderCommand(playerIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_()) {
            if (this.field_70122_E) {
                if (this.getLandTimer() < 20) {
                    this.setLandTimer(this.getLandTimer() + 1);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)40);
                }
                if (this.func_189652_ae()) {
                    this.func_189654_d(this.func_70638_az() != null);
                }
                if (!this.func_189652_ae() && !this.func_70906_o() && this.field_70146_Z.nextFloat() < 0.15f) {
                    this.func_189654_d(true);
                    this.field_70181_x += 0.25;
                }
            } else {
                if (this.getLandTimer() > 0) {
                    this.setLandTimer(this.getLandTimer() - 1);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)41);
                }
                if (!this.func_189652_ae()) {
                    this.func_189654_d(true);
                }
            }
            if (this.func_70906_o() && this.func_70638_az() == null && !this.field_70122_E && SpawnUtil.getHeight((Entity)this).func_177956_o() > 0) {
                this.field_70181_x += (double)-0.025f;
            }
        }
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 20;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return super.func_70652_k(entityIn);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int getHoverTimer() {
        return this.hoverTimer;
    }

    public void setHoverTimer(int i) {
        this.hoverTimer = i;
    }

    public int getLandTimer() {
        return this.landTimer;
    }

    public void setLandTimer(int i) {
        this.landTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 4: {
                this.attackTimer = 20;
                break;
            }
            case 40: {
                if (this.getLandTimer() >= 20) break;
                this.setLandTimer(this.getLandTimer() + 1);
                break;
            }
            case 41: {
                if (this.getLandTimer() <= 0) break;
                this.setLandTimer(this.getLandTimer() - 1);
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected PathNavigate func_175447_b(World world) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, world);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_192877_c(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public Entity getLowestPassenger() {
        Entity lowestPassenger = null;
        for (Entity passenger : this.func_184188_bt()) {
            if (lowestPassenger != null && !(passenger.func_174813_aQ().field_72338_b < lowestPassenger.func_174813_aQ().field_72338_b)) continue;
            lowestPassenger = passenger;
        }
        return lowestPassenger;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    protected double VehicleSpeedMod() {
        return 1.0;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        AxisAlignedBB passengerBounds;
        Entity lowestPassenger = this.getLowestPassenger();
        if (lowestPassenger != null && !(lowestPassenger instanceof EntityPlayer) && !lowestPassenger.field_70170_p.func_184144_a(lowestPassenger, passengerBounds = lowestPassenger.func_174813_aQ()).isEmpty()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + (double)lowestPassenger.field_70131_O, this.field_70161_v, 1.0);
        }
        if (!(this.func_189652_ae() || this.func_184207_aI() || this.func_184179_bs() instanceof EntityPlayer)) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70181_x = -0.15;
        }
        if (this.func_70638_az() != null) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 1.05;
            this.field_70181_x *= 1.05;
            this.field_70179_y *= 1.05;
        }
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            BlockPos ground = new BlockPos(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
            IBlockState underState = this.field_70170_p.func_180495_p(ground);
            float f = 0.91f;
            if (this.field_70122_E) {
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return this.func_70631_g_() ? super.func_70617_f_() : false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData) {
        this.field_70181_x += 0.5;
        return super.func_180482_a(difficulty, entityLivingData);
    }

    static class AIFlyingAttackMelee
    extends EntityAIAttackMelee {
        public AIFlyingAttackMelee(EntityCreature creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + attackTarget.field_70130_N * attackTarget.field_70130_N;
        }
    }

    static class FlyingMoveHelper
    extends EntityMoveHelper {
        private final EntityFlyingMob parentEntity;
        private int courseChangeCooldown;
        IAttributeInstance entityMoveSpeedAttribute;
        double entityMoveSpeed;

        public FlyingMoveHelper(EntityFlyingMob flyer) {
            super((EntityLiving)flyer);
            this.entityMoveSpeedAttribute = this.field_75648_a.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_193334_e);
            this.entityMoveSpeed = this.entityMoveSpeedAttribute != null ? this.entityMoveSpeedAttribute.func_111126_e() : 0.1;
            this.parentEntity = flyer;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - this.parentEntity.field_70163_u;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    if (this.isNotColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3)) && this.isNotPassengerColliding(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3)) {
                        this.parentEntity.field_70159_w += d0 / d3 * this.entityMoveSpeed;
                        this.parentEntity.field_70181_x += d1 / d3 * this.entityMoveSpeed;
                        this.parentEntity.field_70179_y += d2 / d3 * this.entityMoveSpeed;
                        float yaw = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                        this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, yaw, this.Movement2RotationAngle(this.entityMoveSpeed));
                    } else {
                        this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                }
                if (this.parentEntity.func_70906_o() && this.parentEntity.func_70638_az() == null) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            }
        }

        private float Movement2RotationAngle(double movement) {
            return (float)(movement * 1214.28564453125 - 31.428571701049805);
        }

        private boolean isNotPassengerColliding(double x, double y, double z, double distance) {
            if (this.parentEntity.func_184188_bt().isEmpty()) {
                return true;
            }
            double d0 = (x - this.parentEntity.field_70165_t) / distance;
            double d1 = (y - this.parentEntity.field_70163_u) / distance;
            double d2 = (z - this.parentEntity.field_70161_v) / distance;
            Entity lowestPassenger = this.parentEntity.getLowestPassenger();
            AxisAlignedBB axisalignedbb = lowestPassenger.func_174813_aQ();
            int i = 1;
            while ((double)i < distance) {
                if (!lowestPassenger.field_70170_p.func_184144_a(lowestPassenger, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean isNotColliding(double x, double y, double z, double distance) {
            double d0 = (x - this.parentEntity.field_70165_t) / distance;
            double d1 = (y - this.parentEntity.field_70163_u) / distance;
            double d2 = (z - this.parentEntity.field_70161_v) / distance;
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            int i = 1;
            while ((double)i < distance) {
                if (!this.parentEntity.field_70170_p.func_184144_a((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_72317_d(d0, d1, d2)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    static class AIRandomFly
    extends EntityAIBase {
        private final EntityFlyingMob parentEntity;

        public AIRandomFly(EntityFlyingMob entityFlyingMob) {
            this.parentEntity = entityFlyingMob;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.parentEntity.func_70605_aq();
            if (this.parentEntity.func_70661_as() instanceof PathNavigateGround) {
                return false;
            }
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            if (this.parentEntity.func_70638_az() != null) {
                return false;
            }
            double d0 = entitymovehelper.func_179917_d() - this.parentEntity.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.parentEntity.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.parentEntity.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            for (int i = 0; i < 3; ++i) {
                int groundHeight = SpawnUtil.getHeight((Entity)this.parentEntity).func_177956_o();
                BlockPos blockpos = new BlockPos((Entity)this.parentEntity).func_177982_a(this.parentEntity.field_70146_Z.nextInt(15) - 7, this.parentEntity.field_70146_Z.nextInt(11) - 5, this.parentEntity.field_70146_Z.nextInt(15) - 7);
                Random random = this.parentEntity.func_70681_au();
                double y = this.parentEntity.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                if (groundHeight > 0) {
                    if (this.parentEntity.func_70026_G()) {
                        y = Math.min((double)(SpawnUtil.getHeight((Entity)this.parentEntity).func_177956_o() + 3), y);
                    } else if (heightLimit != 0) {
                        y = Math.min((double)(SpawnUtil.getHeight((Entity)this.parentEntity).func_177956_o() + heightLimit), y);
                    }
                }
                this.parentEntity.field_70765_h.func_75642_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, 1.0);
            }
        }
    }

    class EntityAIWander
    extends EntityAIBase {
        public EntityAIWander(EntityFlyingMob entityFlyingMob) {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return EntityFlyingMob.this.field_70699_by.func_75500_f() && EntityFlyingMob.this.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }
    }
}

