/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities.flying;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.entities.flying.EntityFlyingMob;
import com.Fishmod.mod_LavaCow.entities.flying.EntityRideableFlyingMob;
import com.Fishmod.mod_LavaCow.entities.projectiles.EntityMothScales;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.init.ModMobEffects;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityEnigmoth
extends EntityRideableFlyingMob {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityEnigmoth.class, (DataSerializer)DataSerializers.field_187192_b);
    private int skinFixedTick;

    public EntityEnigmoth(World worldIn) {
        super(worldIn, Modconfig.Enigmoth_FlyingHeight_limit);
        this.func_70105_a(1.6f, 1.0f);
        this.field_70178_ae = true;
        this.field_70728_aV = 20;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.wander = this.wanderGoal();
        this.follow = this.followGoal();
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIUseSpell());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true).func_190882_b(160));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Enigmoth_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Enigmoth_Health);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.067);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.05);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)0);
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Enigmoth_Health * 2.0);
            this.func_70606_j(this.func_110143_aJ() * 2.0f);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Enigmoth_Health);
            this.func_70606_j(this.func_110143_aJ());
        }
    }

    @Override
    protected EntityAIBase wanderGoal() {
        return new EntityFlyingMob.AIRandomFly(this);
    }

    @Override
    protected EntityAIBase followGoal() {
        return new EntityAIFollowOwnerFlying((EntityTameable)this, 1.0, 10.0f, 4.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !this.func_70631_g_()) {
            if (item.equals(Items.field_151075_bm)) {
                this.skinFixedTick = 2400;
                this.field_70170_p.func_72960_a((Entity)this, (byte)39);
                this.setSkin(2);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (int i = 0; i < 16; ++i) {
                    double d0 = new Random().nextGaussian() * 0.02;
                    double d1 = new Random().nextGaussian() * 0.02;
                    double d2 = new Random().nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + (double)(new Random().nextFloat() * this.field_70130_N), this.field_70161_v + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
                return true;
            }
            if (item.equals(Items.field_151065_br)) {
                this.skinFixedTick = 2400;
                this.field_70170_p.func_72960_a((Entity)this, (byte)39);
                this.setSkin(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (int i = 0; i < 16; ++i) {
                    double d0 = new Random().nextGaussian() * 0.02;
                    double d1 = new Random().nextGaussian() * 0.02;
                    double d2 = new Random().nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + (double)(new Random().nextFloat() * this.field_70130_N), this.field_70161_v + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
                return true;
            }
            if (item.equals(Items.field_151079_bi)) {
                this.skinFixedTick = 2400;
                this.field_70170_p.func_72960_a((Entity)this, (byte)39);
                this.setSkin(0);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (int i = 0; i < 16; ++i) {
                    double d0 = new Random().nextGaussian() * 0.02;
                    double d1 = new Random().nextGaussian() * 0.02;
                    double d2 = new Random().nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, this.field_70163_u + (double)(new Random().nextFloat() * this.field_70130_N), this.field_70161_v + (double)(new Random().nextFloat() * this.field_70130_N) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return this.func_70909_n() && stack.func_77973_b().equals(Items.field_185161_cS) || stack.func_77973_b().equals(Items.field_185162_cT);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.45f;
    }

    @Override
    public int abilityCooldown() {
        return Modconfig.Enigmoth_Ability_Cooldown_Mount * 20;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        if (this.skinFixedTick > 0) {
            --this.skinFixedTick;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70122_E && !this.isSpellcasting() && this.field_70173_aa % 10 == 0) {
            this.func_184185_a(this.getFlyingSound(), 1.0f, 1.0f);
        }
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Enigmoth_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Enigmoth_Attack);
        this.func_70606_j(this.func_110138_aP());
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.getDimension() == 1) {
            return !Modconfig.Enigmoth_Middle_End_Island ? this.field_70165_t > 500.0 || this.field_70165_t < -500.0 || this.field_70161_v > 500.0 || this.field_70161_v < -500.0 : true;
        }
        return super.func_70601_bi();
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public int getSkinFixedTick() {
        return this.skinFixedTick;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 10: {
                this.spellTicks = 15;
                break;
            }
            case 39: {
                this.skinFixedTick = 2400;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSkin(nbt.func_74762_e("Variant"));
        this.skinFixedTick = nbt.func_74762_e("SkinFixedTick");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Variant", this.getSkin());
        nbt.func_74768_a("SkinFixedTick", this.skinFixedTick);
    }

    public int func_70627_aG() {
        return 1000;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_ENIGMOTH_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_ENIGHMOTH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_ENIGMOTH_DEATH;
    }

    public SoundEvent getSpellSound() {
        return SoundEvents.field_193784_dd;
    }

    protected SoundEvent getFlyingSound() {
        return FishItems.ENTITY_ENIGMOTH_FLYING;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.getLandTimer() > 10) {
            this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.ENIGMOTH;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() != ModMobEffects.CORRODED && effect.func_188419_a() != MobEffects.field_76436_u && super.func_70687_e(effect);
    }

    public class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntityEnigmoth.this.func_70638_az() == null) {
                return false;
            }
            if (EntityEnigmoth.this.isSpellcasting() || EntityEnigmoth.this.getAttackTimer() > 0 || EntityEnigmoth.this.func_70032_d((Entity)EntityEnigmoth.this.func_70638_az()) > 3.0f) {
                return false;
            }
            return EntityEnigmoth.this.field_70173_aa >= this.spellCooldown;
        }

        public boolean func_75253_b() {
            return EntityEnigmoth.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityEnigmoth.this.spellTicks = this.getCastingTime();
            this.spellCooldown = EntityEnigmoth.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            EntityEnigmoth.this.field_70170_p.func_72960_a((Entity)EntityEnigmoth.this, (byte)10);
            if (soundevent != null) {
                EntityEnigmoth.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                EntityEnigmoth.this.func_184185_a(EntityEnigmoth.this.getSpellSound(), 0.175f, 1.0f);
                this.castSpell();
            }
        }

        protected void castSpell() {
            for (int i = 0; i < 8; ++i) {
                Double d0 = new Random().nextDouble() * 8.0 - 4.0;
                Double d1 = new Random().nextDouble() * 8.0 - 4.0;
                EntityMothScales ammo = new EntityMothScales(EntityEnigmoth.this.field_70170_p, (EntityLivingBase)EntityEnigmoth.this, d0, -2.4, d1);
                ammo.func_70107_b(EntityEnigmoth.this.field_70165_t + d0 * 0.25, EntityEnigmoth.this.field_70163_u + (double)(EntityEnigmoth.this.field_70131_O / 3.0f) + 1.5, EntityEnigmoth.this.field_70161_v + d1 * 0.25);
                if (EntityEnigmoth.this.field_70170_p.field_72995_K) continue;
                EntityEnigmoth.this.field_70170_p.func_72838_d((Entity)ammo);
                ammo.setScaleType(EntityEnigmoth.this.getSkin());
            }
            if (EntityEnigmoth.this.getSkin() == 0 && EntityEnigmoth.this.func_70638_az() != null) {
                EntityEnigmoth.this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, Modconfig.Enigmoth_Ability_Cooldown * 20, 0));
            }
            if (EntityEnigmoth.this.getSkin() == 1 && EntityEnigmoth.this.func_70638_az() != null) {
                EntityEnigmoth.this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, Modconfig.Enigmoth_Ability_Cooldown * 20, 0));
            }
            if (EntityEnigmoth.this.getSkin() == 2 && EntityEnigmoth.this.func_70638_az() != null) {
                EntityEnigmoth.this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, Modconfig.Enigmoth_Ability_Cooldown * 20, 0));
            }
            if (EntityEnigmoth.this.getSkinFixedTick() == 0) {
                EntityEnigmoth.this.setSkin(EntityEnigmoth.this.field_70146_Z.nextInt(3));
            }
        }

        protected int getCastWarmupTime() {
            return 10;
        }

        protected int getCastingTime() {
            return 15;
        }

        protected int getCastingInterval() {
            return Modconfig.Enigmoth_Ability_Cooldown * 20;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_187744_z;
        }
    }
}

