/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.entities.ai.EntityAIPickupMeat;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.init.ModEnchantments;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityWendigo
extends EntityMob
implements IAggressive {
    private boolean isAggressive = false;
    private int attackTimer;
    private int jumpTimer;
    public byte AttackStance;

    public EntityWendigo(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.6f, 2.6f);
        this.field_70728_aV = 20;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (!Modconfig.SunScreen_Mode) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIWendigoLeapAtTarget((EntityLiving)this, 0.7f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.25, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new EntityAIPickupMeat<EntityItem>((EntityCreature)this, EntityItem.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        if (Modconfig.Wendigo_AnimalAttack) {
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityAgeable.class, 0, false, true, (Predicate)new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return !(p_apply_1_ instanceof EntityTameable);
                }
            }));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Wendigo_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Wendigo_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_70601_bi() {
        return SpawnUtil.isAllowedDimension(this.field_71093_bK) && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70636_d() {
        float f;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.jumpTimer > 0) {
            --this.jumpTimer;
        }
        if (!Modconfig.SunScreen_Mode && this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v))) {
            this.func_70015_d(40);
        }
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 4.0 && this.getAttackTimer() == 10 && this.field_70725_aQ <= 0) {
            boolean flag = false;
            if (this.AttackStance == 40) {
                flag = this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 1.5f);
                if (this.func_70638_az() instanceof EntityPlayer) {
                    ((EntityPlayer)this.func_70638_az()).func_190777_m(true);
                }
            } else {
                flag = this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
            if (flag) {
                float f2 = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
                if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f2 * 0.3f) {
                    this.func_70638_az().func_70015_d(2 * (int)f2);
                }
                if (this.func_70638_az() instanceof EntityLivingBase) {
                    float local_difficulty = this.field_70170_p.func_175649_E(new BlockPos((Entity)this)).func_180168_b();
                    this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_76438_s, 140 * (int)local_difficulty, 4));
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 20;
        this.AttackStance = (byte)(40 + this.field_70146_Z.nextInt(3));
        this.field_70170_p.func_72960_a((Entity)this, this.AttackStance);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76347_k()) {
            return super.func_70097_a(source, 2.0f * amount);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isAggressive() {
        return this.isAggressive;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAttackStance(byte byteIn) {
        this.AttackStance = byteIn;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getAttackStance() {
        return this.AttackStance;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 40 || id == 41 || id == 42) {
            this.attackTimer = 20;
            this.AttackStance = id;
        }
        if (id == 4) {
            this.attackTimer = 20;
        }
        if (id == 11) {
            this.isAggressive = true;
        } else if (id == 34) {
            this.isAggressive = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public float func_70047_e() {
        return 2.4f;
    }

    public void func_70642_aH() {
        if (this.field_70146_Z.nextDouble() < 0.25) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_WENDIGO_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_WENDIGO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_WENDIGO_DEATH;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)cause.func_76346_g(), (DamageSource)cause);
        if (this.func_146066_aG()) {
            LootTableHandler.dropRareLoot((Entity)this, FishItems.UNDYINGHEART, Modconfig.UndeadSwine_DropHeart, ModEnchantments.LIFESTEAL, 3, i);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.WENDIGO;
    }

    protected boolean func_146066_aG() {
        return !this.func_70027_ad() || this.field_70718_bc != 0;
    }

    static class AIWendigoLeapAtTarget
    extends EntityAIBase {
        private final EntityLiving leaper;
        private EntityLivingBase leapTarget;
        private final float leapMotionY;

        public AIWendigoLeapAtTarget(EntityLiving leapingEntity, float leapMotionYIn) {
            this.leaper = leapingEntity;
            this.leapMotionY = leapMotionYIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.leapTarget = this.leaper.func_70638_az();
            if (this.leapTarget == null || ((EntityWendigo)this.leaper).jumpTimer > 0) {
                return false;
            }
            double d0 = this.leaper.func_70032_d((Entity)this.leapTarget);
            if (!(d0 < 26.0) && !(d0 > 36.0)) {
                return this.leaper.field_70122_E;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.leaper.field_70122_E;
        }

        public void func_75246_d() {
        }

        public void func_75249_e() {
            double d0 = this.leapTarget.field_70165_t - this.leaper.field_70165_t;
            double d1 = this.leapTarget.field_70161_v - this.leaper.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.leaper.func_70625_a((Entity)this.leapTarget, 100.0f, 100.0f);
            this.leaper.func_184185_a(FishItems.ENTITY_WENDIGO_ATTACK, 4.0f, 1.0f);
            ((EntityWendigo)this.leaper).jumpTimer = 240;
            if ((double)f >= 1.0E-4) {
                this.leaper.field_70159_w += d0 / (double)f * 0.5 * (double)8.4f + this.leaper.field_70159_w * (double)8.4f;
                this.leaper.field_70179_y += d1 / (double)f * 0.5 * (double)8.4f + this.leaper.field_70179_y * (double)8.4f;
            }
            this.leaper.field_70181_x = this.leapMotionY;
        }

        public void func_75251_c() {
        }
    }
}

