/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.entities;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import com.Fishmod.mod_LavaCow.core.SpawnUtil;
import com.Fishmod.mod_LavaCow.entities.IAggressive;
import com.Fishmod.mod_LavaCow.entities.projectiles.EntityCactusThorn;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityCactoid;
import com.Fishmod.mod_LavaCow.init.FishItems;
import com.Fishmod.mod_LavaCow.util.LootTableHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCactyrant
extends EntityMob
implements IAggressive {
    private static final DataParameter<Boolean> DATA_IS_CAMOUFLAGING = EntityDataManager.func_187226_a(EntityCactyrant.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityCactyrant.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> GROWING_STAGE = EntityDataManager.func_187226_a(EntityCactyrant.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HUGGING_CD = EntityDataManager.func_187226_a(EntityCactyrant.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean isAggressive = false;
    private int attackTimer;
    protected int spellTicks;
    private EntityAIWanderAvoidWater move;
    private EntityAIWatchClosest watch;
    private EntityAILookIdle look;

    public EntityCactyrant(World world) {
        super(world);
        this.func_70105_a(1.3f, 2.8f);
        this.field_70728_aV = 12;
    }

    protected void func_184651_r() {
        this.move = new EntityAIWanderAvoidWater((EntityCreature)this, 1.0);
        this.watch = new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f);
        this.look = new EntityAILookIdle((EntityLiving)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIUseSpell());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.25, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.move);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.watch);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.look);
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true){

            public boolean func_75250_a() {
                super.func_75250_a();
                return !this.field_75299_d.func_174814_R();
            }
        });
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.19);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Cactyrant_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Cactyrant_Attack);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_IS_CAMOUFLAGING, (Object)false);
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(2));
        this.func_184212_Q().func_187214_a(GROWING_STAGE, (Object)0);
        this.func_184212_Q().func_187214_a(HUGGING_CD, (Object)0);
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return SpawnUtil.isAllowedDimension(this.field_71093_bK) && this.field_70170_p.func_175678_i(pos) && super.func_70601_bi();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (GROWING_STAGE.equals(key)) {
            // empty if block
        }
        super.func_184206_a(key);
    }

    public boolean isCamouflaging() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CAMOUFLAGING);
    }

    public void setCamouflaging(boolean i) {
        this.field_70180_af.func_187227_b(DATA_IS_CAMOUFLAGING, (Object)i);
    }

    public int getGrowingStage() {
        return (Integer)this.field_70180_af.func_187225_a(GROWING_STAGE);
    }

    public void setGrowingStage(int i) {
        this.field_70180_af.func_187227_b(GROWING_STAGE, (Object)i);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public int getHuggingCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(HUGGING_CD);
    }

    public void setHuggingCooldown(int i) {
        this.field_70180_af.func_187227_b(HUGGING_CD, (Object)i);
    }

    public boolean isSpellcasting() {
        return this.spellTicks > 0;
    }

    public int getSpellTicks() {
        return this.spellTicks;
    }

    protected void func_82167_n(Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityCactoid) && !(entity instanceof EntityCactyrant) && this.func_70638_az() == null && entity.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            entity.func_70097_a(DamageSource.field_76367_g, 2.0f);
        }
        super.func_82167_n(entity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityLivingBase target = this.func_70638_az();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.spellTicks > 0) {
            --this.spellTicks;
        }
        if (this.getHuggingCooldown() > 0) {
            this.setHuggingCooldown(this.getHuggingCooldown() - 1);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.func_72935_r() && this.func_70638_az() == null) {
                if (!this.isCamouflaging()) {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.move);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.watch);
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.look);
                    this.func_174810_b(true);
                    this.setCamouflaging(true);
                }
            } else if (this.isCamouflaging()) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.move);
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.watch);
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)this.look);
                this.func_174810_b(false);
                this.setCamouflaging(false);
            }
            if (this.getGrowingStage() != 2) {
                if (this.field_70173_aa > 24000) {
                    if (this.getGrowingStage() != 2) {
                        this.setGrowingStage(2);
                        this.func_184185_a(FishItems.ENTITY_CACTYRANT_GROW, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                    }
                } else if (this.field_70173_aa > 12000 && this.getGrowingStage() != 1) {
                    this.setGrowingStage(1);
                    this.func_184185_a(FishItems.ENTITY_CACTYRANT_GROW, 1.0f, 1.0f / (this.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                }
            }
        }
        if (target != null && this.func_70068_e((Entity)target) < 4.0 && this.getAttackTimer() == 5 && this.field_70725_aQ <= 0 && this.func_70685_l((Entity)target) && !this.func_70638_az().func_184585_cz()) {
            if (!this.func_184207_aI() && !this.func_70638_az().func_70093_af() && this.getHuggingCooldown() == 0) {
                this.func_70638_az().func_184205_a((Entity)this, true);
                this.setHuggingCooldown(120);
            } else if (!this.func_184207_aI()) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 1.0f);
            } else {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 0.25f);
            }
        }
    }

    public void func_70030_z() {
        if (this.getSkin() == 2) {
            this.field_70178_ae = true;
        }
        super.func_70030_z();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float r = 0.4f;
            float angle = (float)(Math.PI / 180 * (double)this.field_70761_aq);
            double offX = (double)r * Math.sin((float)(Math.PI + (double)angle));
            double offZ = (double)r * Math.cos(angle);
            passenger.func_70107_b(this.field_70165_t + offX, this.field_70163_u + (double)0.8f, this.field_70161_v + offZ);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 15;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        if (!source.func_82725_o() && source.func_76364_f() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)source.func_76364_f();
            if (!source.func_94541_c()) {
                entity.func_70097_a(DamageSource.func_92087_a((Entity)this), 2.0f);
            }
        }
        if (source.func_76347_k()) {
            return super.func_70097_a(source, 2.0f * amount);
        }
        return super.func_70097_a(source, amount);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.spellTicks = compound.func_74762_e("SpellTicks");
        this.setSkin(compound.func_74762_e("Variant"));
        this.setGrowingStage(compound.func_74762_e("GrowingStage"));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SpellTicks", this.spellTicks);
        compound.func_74768_a("Variant", this.getSkin());
        compound.func_74768_a("GrowingStage", this.getGrowingStage());
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(Modconfig.Cactyrant_Health);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(Modconfig.Cactyrant_Attack);
        this.func_70606_j(this.func_110138_aP());
        if (this.field_70170_p.field_73011_w.func_177500_n()) {
            this.setSkin(2);
            this.setFireImmunity();
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean setFireImmunity() {
        this.field_70178_ae = true;
        return true;
    }

    @Override
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    public void setAttackTimer(int i) {
        this.attackTimer = i;
    }

    @SideOnly(value=Side.CLIENT)
    protected void addParticlesAroundSelf(EnumParticleTypes type) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(type, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 10: {
                this.spellTicks = 20;
                break;
            }
            case 4: {
                this.attackTimer = 15;
                break;
            }
            case 14: {
                this.addParticlesAroundSelf(EnumParticleTypes.WATER_WAKE);
                break;
            }
            case 11: {
                this.isAggressive = true;
                break;
            }
            case 34: {
                this.isAggressive = false;
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public boolean func_184191_r(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof EntityCactyrant) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_CACTYRANT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187546_ae;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_CACTYRANT_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187579_bV, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.getSkin() == 2 ? LootTableHandler.CACTYRANT_NETHER : LootTableHandler.CACTYRANT;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        int looting = ForgeHooks.getLootingLevel((Entity)this, (Entity)cause.func_76346_g(), (DamageSource)cause);
        int chance = this.field_70146_Z.nextInt(5) + this.field_70146_Z.nextInt(1 + looting);
        if (!this.field_70170_p.field_72995_K && this.getGrowingStage() == 2) {
            for (int amount = 0; amount <= chance; ++amount) {
                this.func_70099_a(new ItemStack(FishItems.CACTUS_FRUIT), 0.0f);
            }
        }
    }

    public boolean func_146066_aG() {
        return this.func_70027_ad() || this.field_70717_bb != null;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            this.isAggressive = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)11);
        } else {
            this.isAggressive = false;
            this.field_70170_p.func_72960_a((Entity)this, (byte)34);
        }
    }

    @Override
    public boolean isAggressive() {
        return this.isAggressive;
    }

    public class AIUseSpell
    extends EntityAIBase {
        protected int spellWarmup;
        protected int spellCooldown;

        public boolean func_75250_a() {
            if (EntityCactyrant.this.func_70638_az() == null || EntityCactyrant.this.func_184207_aI()) {
                return false;
            }
            if (EntityCactyrant.this.isSpellcasting() || !EntityCactyrant.this.func_70685_l((Entity)EntityCactyrant.this.func_70638_az())) {
                return false;
            }
            return EntityCactyrant.this.field_70173_aa >= this.spellCooldown && (double)EntityCactyrant.this.func_70032_d((Entity)EntityCactyrant.this.func_70638_az()) > 2.0;
        }

        public boolean func_75253_b() {
            return EntityCactyrant.this.func_70638_az() != null && this.spellWarmup > 0;
        }

        public void func_75249_e() {
            this.spellWarmup = this.getCastWarmupTime();
            EntityCactyrant.this.spellTicks = this.getCastingTime();
            this.spellCooldown = EntityCactyrant.this.field_70173_aa + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            EntityCactyrant.this.field_70170_p.func_72960_a((Entity)EntityCactyrant.this, (byte)10);
            if (soundevent != null) {
                EntityCactyrant.this.func_184185_a(soundevent, 1.0f, 1.0f);
            }
        }

        public void func_75246_d() {
            --this.spellWarmup;
            if (this.spellWarmup == 0) {
                this.castSpell();
            }
        }

        protected void castSpell() {
            for (int i = 0; i < 6; ++i) {
                EntityCactusThorn abstractarrowentity = new EntityCactusThorn(EntityCactyrant.this.field_70170_p, (EntityLivingBase)EntityCactyrant.this);
                EntityLivingBase target = EntityCactyrant.this.func_70638_az();
                double d0 = target.field_70165_t - EntityCactyrant.this.field_70165_t;
                double d1 = target.field_70163_u + (double)EntityCactyrant.this.field_70131_O * 0.3333333333333333 - abstractarrowentity.field_70163_u;
                double d2 = target.field_70161_v - EntityCactyrant.this.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                double f = i == 3 ? 0.0 : (double)MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d3)) * 2.0;
                abstractarrowentity.func_70186_c(d0 + EntityCactyrant.this.field_70146_Z.nextGaussian() * f, d1 + d3 * 0.2, d2 + EntityCactyrant.this.field_70146_Z.nextGaussian() * f, 1.6f, 14 - EntityCactyrant.this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                EntityCactyrant.this.field_70170_p.func_72838_d((Entity)abstractarrowentity);
            }
            EntityCactyrant.this.func_184185_a(FishItems.RANDOM_THORN_SHOOT, 1.0f, 1.0f / (EntityCactyrant.this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }

        protected int getCastWarmupTime() {
            return 5;
        }

        protected int getCastingTime() {
            return 20;
        }

        protected int getCastingInterval() {
            return Modconfig.Cactyrant_Ability_Cooldown * 20;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.field_187730_dW;
        }
    }

    public class AICastingSpell
    extends EntityAIBase {
        public AICastingSpell() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return EntityCactyrant.this.getSpellTicks() > 0;
        }

        public void func_75249_e() {
            super.func_75249_e();
            EntityCactyrant.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            if (EntityCactyrant.this.func_70638_az() != null) {
                EntityCactyrant.this.func_70671_ap().func_75651_a((Entity)EntityCactyrant.this.func_70638_az(), (float)EntityCactyrant.this.func_184649_cE(), (float)EntityCactyrant.this.func_70646_bf());
            }
        }
    }
}

