/*
 * Decompiled with CFR 0.152.
 */
package com.Fishmod.mod_LavaCow.core;

import com.Fishmod.mod_LavaCow.client.Modconfig;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class SpawnUtil {
    public static boolean isDay(World worldIn) {
        return worldIn.func_72820_D() <= 12000L;
    }

    public static boolean isAllowedDimension(int dimensionIn) {
        for (int i : Modconfig.Spawn_AllowList) {
            if (i != dimensionIn) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllowedDimensionCemetery(int dimensionIn) {
        for (int i : Modconfig.Spawn_Cemetery_AllowList) {
            if (i != dimensionIn) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getHeight(Entity entityIn) {
        BlockPos blockpos1;
        IBlockState state;
        World worldIn = entityIn.func_130014_f_();
        BlockPos pos = entityIn.func_180425_c();
        Chunk chunk = worldIn.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && (!(state = chunk.func_177435_g(blockpos1 = blockpos.func_177977_b())).func_185904_a().func_76230_c() || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos1) || state.func_177230_c().isFoliage((IBlockAccess)worldIn, blockpos1))) {
            blockpos = blockpos1;
        }
        return pos;
    }

    public static boolean isInsideStructure(World worldIn, String structureName, BlockPos pos) {
        if (worldIn.func_72863_F() instanceof ChunkProviderServer) {
            return ((ChunkProviderServer)worldIn.func_72863_F()).func_193413_a(worldIn, structureName, pos);
        }
        return false;
    }

    public static EntityLivingBase getEntityByUniqueId(UUID uniqueId, World worldIn) {
        for (Entity E : worldIn.field_72996_f) {
            if (!(E instanceof EntityLivingBase) || !E.func_110124_au().equals(uniqueId)) continue;
            return (EntityLivingBase)E;
        }
        return null;
    }

    public static BlockPos isNearBlock(World worldIn, Block BlockIn, BlockPos pos, int r) {
        int dx = MathHelper.func_76141_d((float)pos.func_177958_n());
        int dy = MathHelper.func_76141_d((float)pos.func_177956_o());
        int dz = MathHelper.func_76141_d((float)pos.func_177952_p());
        for (int i = dx - r; i < dx + r; ++i) {
            for (int j = dy - r; j < dy + r; ++j) {
                for (int k = dz - r; k < dz + r; ++k) {
                    if (!worldIn.func_180495_p(new BlockPos(i, j, k)).func_177230_c().equals(BlockIn)) continue;
                    return new BlockPos(i, j, k);
                }
            }
        }
        return null;
    }

    public static TextComponentTranslation TimeupDeathMessage(Entity entityIn) {
        return new TextComponentTranslation("death.mod_lavacow.timeup", new Object[]{entityIn.func_145748_c_()});
    }
}

