/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.mixin;

import com.oblivioussp.spartanweaponry.item.IBlockingWeapon;
import com.oblivioussp.spartanweaponry.mixin.EntityMixin;
import com.oblivioussp.spartanweaponry.util.IDamageSourceArmorPiercing;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityLivingBase.class})
public class EntityLivingBaseMixin
extends EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"canBlockDamageSource(Lnet/minecraft/util/DamageSource;)Z"}, cancellable=true)
    private void canBlockDamageSource(DamageSource damageSourceIn, CallbackInfoReturnable<Boolean> callback) {
        EntityLivingBase thisLiving;
        Entity thisEntity = this.field_70170_p.func_73045_a(this.func_145782_y());
        if (thisEntity instanceof EntityLivingBase && (thisLiving = (EntityLivingBase)thisEntity).func_184607_cu().func_77973_b() instanceof IBlockingWeapon) {
            callback.setReturnValue(false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"applyArmorCalculations(Lnet/minecraft/util/DamageSource;F)F"}, cancellable=true)
    protected void applyArmorCalculations(DamageSource source, float damage, CallbackInfoReturnable<Float> callback) {
        if (source instanceof IDamageSourceArmorPiercing && !source.func_76363_c()) {
            this.func_70675_k(damage);
            float percentage = MathHelper.func_76131_a((float)((IDamageSourceArmorPiercing)source).getPercentage(), (float)0.0f, (float)1.0f);
            Log.debug("Found armor piercing damage source! Reducing armor value of target by " + percentage * 100.0f + "%");
            float oldDamage = CombatRules.func_189427_a((float)damage, (float)this.func_70658_aO(), (float)((float)this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
            float armorPiercingDamage = damage * percentage;
            float regularDamage = damage - armorPiercingDamage;
            float reducedDamage = CombatRules.func_189427_a((float)regularDamage, (float)this.func_70658_aO(), (float)((float)this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
            float resultDamage = armorPiercingDamage + reducedDamage;
            Log.debug("Full damage: " + damage + " Armor value: " + (float)this.func_70658_aO() + " Damage ignoring armor (" + percentage * 100.0f + "% damage): " + armorPiercingDamage + " Damage not ignoring armor: " + regularDamage + " Reduced Damage: " + reducedDamage + " Result Damage: " + resultDamage);
            callback.setReturnValue(Float.valueOf(resultDamage));
        }
    }

    @Shadow
    protected void func_70675_k(float damage) {
        throw new IllegalStateException("Mixin failed to shadow the \"EntityLivingBase.damageArmor(float)\" method!");
    }

    @Shadow
    public int func_70658_aO() {
        throw new IllegalStateException("Mixin failed to shadow the \"EntityLivingBase.getTotalArmorValue()\" method!");
    }

    @Shadow
    public IAttributeInstance func_110148_a(IAttribute attribute) {
        throw new IllegalStateException("Mixin failed to shadow the \"EntityLivingBase.getEntityAttribute(IAttribute)\" method!");
    }
}

