/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.api.IWeaponCallback;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityBolt;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.init.ItemRegistrySW;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import com.oblivioussp.spartanweaponry.item.IHudLoadState;
import com.oblivioussp.spartanweaponry.item.ItemBolt;
import com.oblivioussp.spartanweaponry.item.ItemSW;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.NBTHelper;
import com.oblivioussp.spartanweaponry.util.Quaternion;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemCrossbow
extends ItemSW
implements IHudLoadState {
    protected ToolMaterialEx material;
    protected String modId = null;
    protected String displayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected IWeaponCallback callback = null;
    public static final String NBT_IS_LOADED = "isLoaded";
    public static final String nbtAmmoStack = "ammoStack";

    public ItemCrossbow(String unlocName, ToolMaterialEx toolMaterial) {
        super(unlocName);
        this.material = toolMaterial;
        this.field_77777_bU = 1;
        this.func_77656_e((int)((float)toolMaterial.getMaxUses() * 1.5f));
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null && !(entityIn instanceof EntityPlayer)) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                if (NBTHelper.getBoolean(stack, ItemCrossbow.NBT_IS_LOADED)) {
                    return 1.0f;
                }
                if (itemstack != null && itemstack.func_77969_a(stack) && itemstack.func_77973_b() instanceof ItemCrossbow) {
                    return ItemCrossbow.this.getLoadProgress(stack, entityIn);
                }
                return 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ItemCrossbow(String unlocName, String externalModId, ToolMaterialEx material) {
        this(unlocName, material);
        this.modId = externalModId;
        this.displayName = "crossbow_custom";
    }

    public ItemCrossbow(String unlocName, String externalModId, ToolMaterialEx material, IWeaponCallback weaponCallback) {
        this(unlocName, externalModId, material);
        this.callback = weaponCallback;
    }

    @Override
    public String func_77658_a() {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return super.func_77658_a();
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return super.func_77658_a();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!ItemStack.func_77970_a((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    protected ItemStack findAmmo(EntityPlayer player) {
        if (this.isBolt(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isBolt(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isBolt(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isBolt(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemBolt;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!NBTHelper.getBoolean(stack, NBT_IS_LOADED) && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemStack bolt = this.findAmmo(player);
            if (bolt.func_190926_b()) {
                bolt = new ItemStack((Item)ItemRegistrySW.bolt);
            }
            boolean isCreativeOrArrowInfinite = player.field_71075_bZ.field_75098_d || bolt.func_77973_b() instanceof ItemBolt && ((ItemBolt)bolt.func_77973_b()).isInfinite(bolt, stack, player);
            int count = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.CROSSBOW_SPREADSHOT, (ItemStack)stack) > 0 ? 3 : 1;
            ItemStack boltToStore = bolt.func_77946_l();
            boltToStore.func_190920_e(count);
            NBTTagCompound nbtBolt = new NBTTagCompound();
            boltToStore.func_77955_b(nbtBolt);
            NBTHelper.setTagCompound(stack, nbtAmmoStack, nbtBolt);
            if (!isCreativeOrArrowInfinite) {
                bolt.func_190918_g(1);
                if (bolt.func_190926_b()) {
                    player.field_71071_by.func_184437_d(bolt);
                }
            }
            worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundRegistry.CROSSBOW_LOAD, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) * 0.5f);
            player.func_184811_cZ().func_185145_a((Item)this, ConfigHandler.crossbowTicksCooldown);
            NBTHelper.setBoolean(stack, NBT_IS_LOADED, true);
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            int i;
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean flag = entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = ItemStack.field_190927_a;
            NBTTagCompound tag = NBTHelper.getTagCompound(stack, nbtAmmoStack);
            if (tag != null) {
                itemstack = new ItemStack(tag);
            }
            if ((i = this.func_77626_a(stack) - timeLeft) < 0 || !NBTHelper.getBoolean(stack, NBT_IS_LOADED)) {
                return;
            }
            if (!itemstack.func_190926_b() || flag) {
                boolean flag1;
                if (itemstack.func_190926_b()) {
                    itemstack = new ItemStack((Item)ItemRegistrySW.bolt);
                }
                float vel = this.getBoltSpeed();
                boolean bl = flag1 = entityplayer.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ItemBolt && ((ItemBolt)itemstack.func_77973_b()).isInfinite(itemstack, stack, entityplayer);
                if (!worldIn.field_72995_K) {
                    ItemBolt itemBolt = itemstack.func_77973_b() instanceof ItemBolt ? itemstack.func_77973_b() : ItemRegistrySW.bolt;
                    int aimTicks = this.getAimTicks(stack);
                    int inaccuracy = aimTicks - i;
                    float inaccuracyModifier = 0.0f;
                    if (i >= aimTicks) {
                        inaccuracy = 0;
                    }
                    if (inaccuracy != 0) {
                        inaccuracyModifier = 10.0f * ((float)inaccuracy / (float)aimTicks);
                    }
                    this.spawnProjectile(stack, itemBolt, itemstack, worldIn, entityplayer, flag1, inaccuracyModifier, 0.0f);
                    if (itemstack.func_190916_E() > 1) {
                        this.spawnProjectile(stack, itemBolt, itemstack, worldIn, entityplayer, true, inaccuracyModifier, -10.0f);
                        this.spawnProjectile(stack, itemBolt, itemstack, worldIn, entityplayer, true, inaccuracyModifier, 10.0f);
                    }
                    int damage = itemstack.func_190916_E() > 1 ? 3 : 1;
                    stack.func_77972_a(damage, (EntityLivingBase)entityplayer);
                    NBTHelper.setBoolean(stack, NBT_IS_LOADED, false);
                    NBTHelper.setTagCompound(stack, nbtAmmoStack, new NBTTagCompound());
                }
                worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundRegistry.CROSSBOW_FIRE, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + vel * 0.5f);
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    public float getBoltSpeed() {
        return ConfigHandler.crossbowBaseBoltSpeed + (float)this.material.getHarvestLevel() * ConfigHandler.crossbowMaterialBoltSpeedModifier;
    }

    protected void spawnProjectile(ItemStack crossbow, ItemBolt boltItem, ItemStack boltStack, World world, EntityPlayer player, boolean noPickup, float inaccuracyModifier, float projectileAngle) {
        int k;
        EntityBolt bolt = boltItem.createBolt(world, boltStack, (EntityLivingBase)player);
        bolt.func_70243_d(true);
        Vec3d lookVec = player.func_70676_i(1.0f);
        Vec3d vector = new Vec3d(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
        if (projectileAngle != 0.0f) {
            Vec3d playerUpVec = this.calculateEntityViewVector(player.field_70125_A - 90.0f, player.field_70177_z);
            Quaternion quat = new Quaternion(playerUpVec, projectileAngle, true);
            vector = quat.transformVector(lookVec);
        }
        bolt.func_70186_c(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c, this.getBoltSpeed() * 3.0f, inaccuracyModifier);
        int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)crossbow);
        if (j > 0) {
            bolt.func_70239_b(bolt.func_70242_d() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)crossbow)) > 0) {
            bolt.func_70240_a(k);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)crossbow) > 0) {
            bolt.func_70015_d(100);
        }
        if (noPickup || projectileAngle != 0.0f) {
            bolt.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
        }
        world.func_72838_d((Entity)bolt);
    }

    private Vec3d calculateEntityViewVector(float pitch, float yaw) {
        float degToRad = (float)Math.PI / 180;
        float yawCos = MathHelper.func_76134_b((float)(-yaw * degToRad - (float)Math.PI));
        float yawSin = MathHelper.func_76126_a((float)(-yaw * degToRad - (float)Math.PI));
        float pitchCos = -MathHelper.func_76134_b((float)(-pitch * degToRad - (float)Math.PI));
        float pitchSin = MathHelper.func_76126_a((float)(-pitch * degToRad - (float)Math.PI));
        return new Vec3d((double)(yawSin * pitchCos), (double)pitchSin, (double)(yawCos * pitchCos));
    }

    public int func_77626_a(ItemStack stack) {
        if (!NBTHelper.getBoolean(stack, NBT_IS_LOADED)) {
            return this.getFullLoadTicks(stack);
        }
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (!NBTHelper.getBoolean(stack, NBT_IS_LOADED)) {
            return EnumAction.NONE;
        }
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean flag = false;
        boolean bl = flag = !this.findAmmo(playerIn).func_190926_b();
        if (playerIn.field_71075_bZ.field_75098_d || NBTHelper.getBoolean(stack, NBT_IS_LOADED) || flag || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return !flag ? new ActionResult(EnumActionResult.FAIL, (Object)stack) : new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        if (this.material == null) {
            return 1;
        }
        return this.material.getEnchantability();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (toRepair.func_190926_b() || repair.func_190926_b()) {
            return false;
        }
        if (this.material.doesOreDictMatch(repair)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public String func_77653_i(ItemStack stack) {
        if (this.displayName != null) {
            String name = I18n.func_74837_a((String)String.format("item.%s:%s.name", "spartanweaponry", this.displayName), (Object[])new Object[]{I18n.func_74838_a((String)this.material.getFullUnlocName())});
            return name;
        }
        return super.func_77653_i(stack);
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        if (this.modId != null) {
            return this.modId;
        }
        return super.getCreatorModId(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean isShiftPressed = GuiScreen.func_146272_n();
        if (this.doCraftCheck && worldIn != null) {
            NonNullList ores;
            if (this.material.getModId() == "spartanweaponry" && ((ores = OreDictionary.getOres((String)this.material.getOreDictForRepairMaterial(), (boolean)false)) == null || ores.isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        } else if (!ConfigHandler.forceDisableUncraftableTooltips && !this.canBeCrafted) {
            tooltip.add(TextFormatting.RED + StringHelper.translateFormattedString("cantCraftMissingMaterial", "tooltip", "spartanweaponry", StringHelper.translateString(this.material.getOreDictForRepairMaterial(), "material", this.material.getModId())));
        }
        ItemStack bolt = ItemStack.field_190927_a;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b(nbtAmmoStack)) {
            // empty if block
        }
        if ((bolt = new ItemStack(stack.func_77978_p().func_74775_l(nbtAmmoStack))) != null && !bolt.func_190926_b()) {
            tooltip.add(StringHelper.translateFormattedString("crossbow.loaded_bolt", "tooltip", "spartanweaponry", String.format("[%s x%d]", TextFormatting.AQUA.toString() + bolt.func_82833_r() + TextFormatting.WHITE.toString(), bolt.func_190916_E())));
            tooltip.add("");
        }
        if (this.callback != null) {
            this.callback.onTooltip(this.material, stack, worldIn, tooltip, flagIn);
            tooltip.add("");
        }
        tooltip.add(TextFormatting.GOLD + StringHelper.translateFormattedString("description", "tooltip", "spartanweaponry", isShiftPressed ? TextFormatting.DARK_GRAY + StringHelper.translateString("showingDescription", "tooltip", "spartanweaponry") : TextFormatting.DARK_GRAY + StringHelper.translateFormattedString("showDescription", "tooltip", "spartanweaponry", TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY)));
        if (GuiScreen.func_146272_n()) {
            tooltip.add(StringHelper.translateString("crossbow", "tooltip"));
            tooltip.add(StringHelper.translateString("crossbow.desc", "tooltip"));
            tooltip.add(StringHelper.translateString("crossbow.desc2", "tooltip"));
        }
        tooltip.add("");
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.ammo.type", "tooltip", "spartanweaponry", TextFormatting.GRAY + StringHelper.translateString("modifiers.ammo.bolt", "tooltip")));
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.crossbow.load_time", "tooltip", "spartanweaponry", TextFormatting.GRAY + "" + (float)this.getFullLoadTicks(stack) / 20.0f));
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.crossbow.aim_time", "tooltip", "spartanweaponry", TextFormatting.GRAY + "" + (float)this.getAimTicks(stack) / 20.0f));
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("modifiers.crossbow.speed_multiplier", "tooltip", "spartanweaponry", TextFormatting.GRAY + StringHelper.translateFormattedString("modifiers.crossbow.speed_multiplier.value", "tooltip", "spartanweaponry", Float.valueOf(this.getBoltSpeed()))));
        tooltip.add("");
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (this.callback != null) {
            this.callback.onCreateItem(this.material, stack);
        }
        super.func_77622_d(stack, worldIn, playerIn);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            if (this.callback != null) {
                this.callback.onCreateItem(this.material, stack);
            }
            items.add((Object)stack);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.callback != null && entityIn instanceof EntityLivingBase) {
            this.callback.onItemUpdate(this.material, stack, worldIn, (EntityLivingBase)entityIn, itemSlot, isSelected);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public String getHighlightTip(ItemStack item, String displayName) {
        ItemStack stack;
        if (!item.func_77942_o()) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (!(stack = new ItemStack(item.func_77978_p().func_74775_l(nbtAmmoStack))).func_190926_b()) {
            return String.format("%s (%s x%d)", displayName, stack.func_82833_r(), stack.func_190916_E());
        }
        return displayName;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ConfigHandler.enchantmentWhitelistCrossbow.contains(enchantment.getRegistryName()) || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean isLoaded(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return stack.func_77978_p().func_74767_n(NBT_IS_LOADED);
    }

    @Override
    public float getLoadProgress(ItemStack stack, EntityLivingBase entity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int fullLoadTicks = this.getFullLoadTicks(stack);
        return entity.func_184587_cr() && !stack.func_77978_p().func_74767_n(NBT_IS_LOADED) ? ((float)fullLoadTicks == 0.0f ? 1.0f : 1.0f - MathHelper.func_76131_a((float)((float)this.getLoadingTicks(stack, entity) / (float)fullLoadTicks), (float)0.0f, (float)1.0f)) : 0.0f;
    }

    protected int getFullLoadTicks(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.CROSSBOW_CHARGE, (ItemStack)stack);
        return Math.max(ConfigHandler.crossbowTicksToLoad - 4 * i + this.material.getHarvestLevel() * ConfigHandler.crossbowMaterialLoadModifier, 1);
    }

    protected int getLoadingTicks(ItemStack stack, EntityLivingBase entity) {
        return entity.func_184605_cv();
    }

    public int getAimTicks(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.CROSSBOW_SHARPSHOOTER, (ItemStack)stack);
        return Math.max(10 - 2 * i + this.material.getHarvestLevel() * ConfigHandler.crossbowMaterialAimModifier, 1);
    }
}

