/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.event;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.oblivioussp.spartanweaponry.ModSpartanWeaponry;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.client.KeyBinds;
import com.oblivioussp.spartanweaponry.client.gui.HudLoadState;
import com.oblivioussp.spartanweaponry.client.gui.HudQuiverAmmo;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.item.IHudLoadState;
import com.oblivioussp.spartanweaponry.item.ItemCrossbow;
import com.oblivioussp.spartanweaponry.item.ItemDagger;
import com.oblivioussp.spartanweaponry.item.ItemLongbow;
import com.oblivioussp.spartanweaponry.item.ItemThrowingWeapon;
import com.oblivioussp.spartanweaponry.network.NetworkHandler;
import com.oblivioussp.spartanweaponry.network.PacketKeyHandle;
import com.oblivioussp.spartanweaponry.network.PacketLongReachAttack;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.NBTHelper;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class EventHandlerClient {
    private static ItemStack activeQuiverStack = ItemStack.field_190927_a;
    protected static final ResourceLocation CROSSHAIR_TEXTURES = new ResourceLocation("spartanweaponry", "textures/gui/crosshairs.png");

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onKeyInputEvent(InputEvent.KeyInputEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player != null && !mc.func_147113_T() && mc.field_71415_G && KeyBinds.KEY_ACCESS_QUIVER.func_151468_f()) {
            NetworkHandler.sendPacketToServer(new PacketKeyHandle());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public static void onMouseEvent(MouseEvent ev) {
        if (ModSpartanWeaponry.isRLCombatLoaded) {
            return;
        }
        KeyBinding keyAttack = Minecraft.func_71410_x().field_71474_y.field_74312_F;
        if (keyAttack.func_151463_i() < 0 && ev.getButton() == keyAttack.func_151463_i() + 100 && ev.isButtonstate()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (player == null || player.func_184585_cz()) {
                return;
            }
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
            WeaponProperty reachProperty = null;
            if (!stack.func_190926_b()) {
                if (stack.func_77973_b() instanceof IWeaponPropertyContainer) {
                    IWeaponPropertyContainer container = (IWeaponPropertyContainer)stack.func_77973_b();
                    reachProperty = container.getFirstWeaponPropertyWithType("reach");
                }
                if (reachProperty != null) {
                    double initialReach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
                    float reach = reachProperty.getMagnitude() - 5.0f + (float)initialReach;
                    Log.debug("Initial reach value: " + initialReach + " - Extended reach value: " + reach);
                    if (mc.field_147125_j != null) {
                        return;
                    }
                    RayTraceResult result = EventHandlerClient.getMouseOverExtended(reach);
                    if (result != null && result.field_72308_g != null && result.field_72308_g.field_70172_ad == 0 && result.field_72308_g != player && result.field_72308_g != player.func_184187_bx()) {
                        float velocity = 0.0f;
                        if (player.func_184218_aH()) {
                            Entity riding = player.func_184187_bx();
                            Vec3d vec = new Vec3d(riding.field_70159_w, riding.field_70181_x, riding.field_70179_y);
                            velocity = (float)vec.func_72433_c();
                        }
                        NetworkHandler.sendPacketToServer(new PacketLongReachAttack(result.field_72308_g.func_145782_y(), velocity));
                    }
                }
            }
        }
    }

    protected static RayTraceResult getMouseOverExtended(float distance) {
        RayTraceResult result = null;
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderViewEntity = mc.func_175606_aa();
        if (renderViewEntity != null && mc.field_71441_e != null) {
            double d0 = distance;
            result = renderViewEntity.func_174822_a(d0, 0.0f);
            Vec3d eyePos = renderViewEntity.func_174824_e(0.0f);
            boolean flag = false;
            double d1 = d0;
            if (mc.field_71442_b.func_78749_i() && d1 < 6.0) {
                d0 = d1 = 6.0;
            } else if (d0 > (double)distance) {
                flag = true;
            }
            if (result != null) {
                d1 = result.field_72307_f.func_72438_d(eyePos);
            }
            Vec3d lookVec = renderViewEntity.func_70676_i(0.0f);
            Vec3d vec3d2 = eyePos.func_72441_c(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0);
            Entity pointedEntity = null;
            Vec3d vec3d3 = null;
            List list = mc.field_71441_e.func_175674_a(renderViewEntity, renderViewEntity.func_174813_aQ().func_72321_a(lookVec.field_72450_a * d0, lookVec.field_72448_b * d0, lookVec.field_72449_c * d0).func_72321_a(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

                public boolean apply(@Nullable Entity p_apply_1_) {
                    return p_apply_1_ != null && p_apply_1_.func_70067_L();
                }
            }));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult result0 = axisalignedbb.func_72327_a(eyePos, vec3d2);
                if (axisalignedbb.func_72318_a(eyePos)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = result0 == null ? eyePos : result0.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (result0 == null || !((d3 = eyePos.func_72438_d(result0.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == renderViewEntity.func_184208_bv() && !renderViewEntity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = result0.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = result0.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && eyePos.func_72438_d(vec3d3) > (double)distance) {
                pointedEntity = null;
                result = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
                Log.debug("Ray Trace for extended reach has missed!");
            }
            if (pointedEntity != null && (d2 < d1 || result == null)) {
                result = new RayTraceResult(pointedEntity, vec3d3);
                Log.debug("Ray Trace for extended reach has hit a " + pointedEntity.toString() + " d1 = " + d1 + " - d2 = " + d2);
                if (pointedEntity instanceof EntityLivingBase || pointedEntity instanceof EntityItemFrame) {
                    // empty if block
                }
            }
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFOVUpdate(FOVUpdateEvent ev) {
        if (ConfigHandler.disableFOVZoomIn) {
            return;
        }
        EntityPlayer player = ev.getEntity();
        ItemStack activeStack = player.func_184607_cu();
        if (activeStack.func_190926_b()) {
            return;
        }
        float currentFov = ev.getFov();
        float fovZoomIn = 0.05f;
        float newFov = currentFov;
        int ticksToZoomIn = 0;
        int currentTicks = activeStack.func_77988_m() - player.func_184605_cv();
        if (activeStack.func_77973_b() instanceof ItemLongbow) {
            ticksToZoomIn = ((ItemLongbow)activeStack.func_77973_b()).getDrawTicks();
        } else if (activeStack.func_77973_b() instanceof ItemCrossbow && NBTHelper.getBoolean(activeStack, "isLoaded")) {
            ticksToZoomIn = ((ItemCrossbow)activeStack.func_77973_b()).getAimTicks(activeStack);
        } else if (activeStack.func_77973_b() instanceof ItemDagger || activeStack.func_77973_b() instanceof ItemThrowingWeapon) {
            ticksToZoomIn = 5;
            fovZoomIn = 0.1f;
        }
        if (ticksToZoomIn > 0) {
            if (currentTicks >= ticksToZoomIn) {
                currentTicks = ticksToZoomIn;
            }
            newFov = currentFov - fovZoomIn * ((float)currentTicks / (float)ticksToZoomIn);
            ev.setNewfov(newFov);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent ev) {
        ItemStack stack = ev.getItemStack();
        if (stack.func_77973_b() instanceof ItemThrowingWeapon) {
            ItemThrowingWeapon weapon = (ItemThrowingWeapon)stack.func_77973_b();
            int j = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_DAMAGE, (ItemStack)stack);
            float throwDamage = (weapon.getDirectAttackDamage() + 1.0f) * weapon.getThrownDamageMultiplier() + (float)j * 0.5f;
            ev.getToolTip().add("");
            ev.getToolTip().add(StringHelper.translateString("modifiers.thrown", "tooltip"));
            ev.getToolTip().add(" " + StringHelper.translateFormattedString("attribute.damage", "tooltip", "spartanweaponry", ItemStack.field_111284_a.format(throwDamage)));
        }
        if (ModSpartanWeaponry.debugMode && stack.func_77942_o() && ev.getFlags().func_194127_a()) {
            ev.getToolTip().add(TextFormatting.DARK_PURPLE + "NBT: " + TextFormatting.DARK_GRAY + stack.func_77978_p().toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onSpecificHandRender(RenderSpecificHandEvent ev) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184600_cs() != ev.getHand()) {
            ItemStack activeStack = player.func_184607_cu();
            if (activeStack.func_77973_b() instanceof ItemLongbow) {
                ev.setCanceled(true);
            } else if (activeStack.func_77973_b() instanceof ItemCrossbow) {
                ev.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre ev) {
        if (ev.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            int x = ev.getResolution().func_78326_a() / 2;
            int y = ev.getResolution().func_78328_b() / 2;
            if (player.func_175149_v()) {
                return;
            }
            ItemStack equipStack = ItemStack.field_190927_a;
            ItemStack mainStack = player.func_184614_ca().func_190926_b() ? player.func_184592_cb() : player.func_184614_ca();
            ItemStack activeStack = player.func_184607_cu();
            ItemStack itemStack = equipStack = player.func_184587_cr() && activeStack.func_77973_b() instanceof ItemCrossbow ? activeStack : ItemStack.field_190927_a;
            if (!equipStack.func_190926_b()) {
                EventHandlerClient.renderCrossbowCrosshair(ev, mc, (EntityPlayer)player, equipStack, x, y);
                return;
            }
            ItemStack itemStack2 = player.func_184587_cr() && activeStack.func_77973_b() instanceof ItemThrowingWeapon ? activeStack : (equipStack = mainStack.func_77973_b() instanceof ItemThrowingWeapon ? mainStack : ItemStack.field_190927_a);
            if (!equipStack.func_190926_b()) {
                EventHandlerClient.renderThrowingWeaponCrosshair(ev, mc, (EntityPlayer)player, equipStack, x, y);
                return;
            }
            ItemStack itemStack3 = equipStack = mainStack.func_77973_b() instanceof ItemCrossbow ? mainStack : ItemStack.field_190927_a;
            if (!equipStack.func_190926_b()) {
                EventHandlerClient.renderCrossbowCrosshair(ev, mc, (EntityPlayer)player, equipStack, x, y);
                return;
            }
            ItemStack itemStack4 = equipStack = mainStack.func_77973_b() instanceof ItemThrowingWeapon ? mainStack : ItemStack.field_190927_a;
            if (!equipStack.func_190926_b()) {
                EventHandlerClient.renderThrowingWeaponCrosshair(ev, mc, (EntityPlayer)player, equipStack, x, y);
                return;
            }
        }
    }

    private static void renderCrossbowCrosshair(RenderGameOverlayEvent.Pre ev, Minecraft mc, EntityPlayer player, ItemStack equipStack, int x, int y) {
        GameSettings settings = mc.field_71474_y;
        if (!(ConfigHandler.disableNewCrosshairCrossbow && !ConfigHandler.forceCompatibilityCrosshairs || settings.field_74320_O != 0 || equipStack.func_190926_b())) {
            ItemStack crossbow = player.func_184607_cu();
            int offset = 80 / ev.getResolution().func_78325_e();
            if (player.func_184587_cr() && NBTHelper.getBoolean(equipStack, "isLoaded")) {
                int currentTicks = equipStack.func_77988_m() - player.func_184605_cv();
                if (!(crossbow.func_77973_b() instanceof ItemCrossbow)) {
                    return;
                }
                ItemCrossbow crossbowItem = (ItemCrossbow)crossbow.func_77973_b();
                int aimTicks = crossbowItem.getAimTicks(crossbow);
                float percentage = aimTicks == 0 ? 1.0f : MathHelper.func_76131_a((float)(((float)currentTicks + ev.getPartialTicks()) / (float)aimTicks), (float)0.0f, (float)1.0f);
                offset = (int)((float)offset * (1.0f - percentage));
            }
            if (settings.field_74330_P && !settings.field_74319_N && !mc.field_71439_g.func_175140_cp() && !settings.field_178879_v) {
                return;
            }
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179084_k();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(CROSSHAIR_TEXTURES);
            if (ModSpartanWeaponry.isRLCombatLoaded || ConfigHandler.forceCompatibilityCrosshairs) {
                offset = (int)Math.sqrt((double)(offset * offset) / 2.0);
                mc.field_71456_v.func_73729_b(x - 5 - offset, y - 5 - offset, 11, 12, 4, 4);
                mc.field_71456_v.func_73729_b(x + 2 + offset, y - 5 - offset, 18, 12, 4, 4);
                mc.field_71456_v.func_73729_b(x - 5 - offset, y + 2 + offset, 11, 19, 4, 4);
                mc.field_71456_v.func_73729_b(x + 2 + offset, y + 2 + offset, 18, 19, 4, 4);
            } else {
                mc.field_71456_v.func_73729_b(x - 1, y - 1, 4, 4, 3, 3);
                mc.field_71456_v.func_73729_b(x, y - 5 - offset, 5, 0, 1, 4);
                mc.field_71456_v.func_73729_b(x, y + 2 + offset, 5, 7, 1, 4);
                mc.field_71456_v.func_73729_b(x - 5 - offset, y, 0, 5, 4, 1);
                mc.field_71456_v.func_73729_b(x + 2 + offset, y, 7, 5, 4, 1);
                ev.setCanceled(true);
            }
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179084_k();
        }
    }

    private static void renderThrowingWeaponCrosshair(RenderGameOverlayEvent.Pre ev, Minecraft mc, EntityPlayer player, ItemStack equipStack, int x, int y) {
        GameSettings settings = mc.field_71474_y;
        if (!(ConfigHandler.disableNewCrosshairThrowingWeapon && !ConfigHandler.forceCompatibilityCrosshairs || settings.field_74320_O != 0 || equipStack.func_190926_b())) {
            int offset;
            ItemThrowingWeapon throwingWeapon = (ItemThrowingWeapon)equipStack.func_77973_b();
            int n = offset = ModSpartanWeaponry.isRLCombatLoaded ? 24 : 10;
            if (player.func_184587_cr()) {
                int currentTicks = equipStack.func_77988_m() - player.func_184605_cv();
                float percentage = MathHelper.func_76131_a((float)(((float)currentTicks + ev.getPartialTicks()) / (float)throwingWeapon.getMaxChargeTicks(equipStack)), (float)0.0f, (float)1.0f);
                offset = (int)((float)offset * (1.0f - percentage));
            }
            if (settings.field_74330_P && !settings.field_74319_N && !mc.field_71439_g.func_175140_cp() && !settings.field_178879_v) {
                return;
            }
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(CROSSHAIR_TEXTURES);
            if (ModSpartanWeaponry.isRLCombatLoaded || ConfigHandler.forceCompatibilityCrosshairs) {
                offset = (int)Math.sqrt((double)(offset * offset) / 2.0);
                mc.field_71456_v.func_73729_b(x - 5 - offset, y - 5 - offset, 11, 12, 4, 4);
                mc.field_71456_v.func_73729_b(x + 2 + offset, y - 5 - offset, 18, 12, 4, 4);
                mc.field_71456_v.func_73729_b(x - 5 - offset, y + 2 + offset, 11, 19, 4, 4);
                mc.field_71456_v.func_73729_b(x + 2 + offset, y + 2 + offset, 18, 19, 4, 4);
            } else {
                mc.field_71456_v.func_73729_b(x - 4, y - 4, 12, 1, 9, 5);
                mc.field_71456_v.func_73729_b(x - 4, y - 7 - offset, 12, 1, 9, 5);
                ev.setCanceled(true);
            }
            if (mc.field_71474_y.field_186716_M == 1 && !ModSpartanWeaponry.isRLCombatLoaded && !ConfigHandler.forceCompatibilityCrosshairs) {
                GuiIngame cfr_ignored_0 = mc.field_71456_v;
                mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
                GlStateManager.func_179141_d();
                float f = player.func_184825_o(0.0f);
                boolean flag = false;
                if (mc.field_147125_j != null && mc.field_147125_j instanceof EntityLivingBase && f >= 1.0f) {
                    flag = mc.field_71439_g.func_184818_cX() > 5.0f;
                    flag &= ((EntityLivingBase)mc.field_147125_j).func_70089_S();
                }
                int i = y - 7 + 16;
                int j = x - 8;
                if (flag) {
                    mc.field_71456_v.func_73729_b(j, i, 68, 94, 16, 16);
                } else if (f < 1.0f) {
                    int k = (int)(f * 17.0f);
                    mc.field_71456_v.func_73729_b(j, i, 36, 94, 16, 4);
                    mc.field_71456_v.func_73729_b(j, i, 52, 94, k, 4);
                }
                GlStateManager.func_179118_c();
            }
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179084_k();
            if (equipStack.func_77942_o() && equipStack.func_77978_p().func_74764_b("AmmoUsed")) {
                NBTTagCompound tag = equipStack.func_77978_p();
                int maxAmmo = throwingWeapon.getMaxAmmo(equipStack);
                int ammo = maxAmmo - tag.func_74762_e("AmmoUsed");
                String text = String.format("%d/%d", ammo, maxAmmo);
                mc.field_71466_p.func_175063_a(text, (float)(x - mc.field_71466_p.func_78256_a(text) / 2), (float)(y + 20), -1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post ev) {
        if (ev.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            int loadSlot = -1;
            ItemStack loadStack = ItemStack.field_190927_a;
            IHudLoadState loadItem = null;
            boolean isOffhand = false;
            if (player.func_184614_ca().func_77973_b() instanceof IHudLoadState) {
                loadStack = player.func_184614_ca();
                loadItem = (IHudLoadState)loadStack.func_77973_b();
            } else if (player.func_184592_cb().func_77973_b() instanceof IHudLoadState) {
                loadStack = player.func_184592_cb();
                loadItem = (IHudLoadState)loadStack.func_77973_b();
                isOffhand = true;
            }
            if (loadStack != null && loadItem != null && (!loadStack.func_190926_b() && player.func_184607_cu().func_77969_a(loadStack) || loadItem.isLoaded(loadStack))) {
                if (HudLoadState.hudActive == null) {
                    HudLoadState.hudActive = new HudLoadState();
                }
                HudLoadState.hudActive.setLoaded(loadItem.isLoaded(loadStack));
                HudLoadState.hudActive.setLoadProgress(loadItem.getLoadProgress(loadStack, (EntityLivingBase)player));
                HudLoadState.hudActive.setOffhand(isOffhand);
                if (!isOffhand) {
                    loadSlot = player.field_71071_by.field_70461_c;
                    HudLoadState.hudActive.setHighlightedSlot(loadSlot);
                }
                if (HudLoadState.hudActive != null) {
                    HudLoadState.hudActive.render();
                }
            } else if (HudLoadState.hudActive != null) {
                HudLoadState.hudActive = null;
            }
            ItemStack quiverStack = ItemStack.field_190927_a;
            for (QuiverHelper.IQuiverInfo info : QuiverHelper.info) {
                if (!info.isWeapon(player.func_184614_ca())) continue;
                quiverStack = QuiverHelper.findFirstOfType((EntityPlayer)player, info);
                break;
            }
            if (quiverStack.func_190926_b()) {
                quiverStack = QuiverHelper.findFirst((EntityPlayer)player);
            }
            if (quiverStack.func_190926_b()) {
                HudQuiverAmmo.hudActive = null;
                activeQuiverStack = ItemStack.field_190927_a;
            } else {
                activeQuiverStack = quiverStack;
                if (!ModSpartanWeaponry.isSpartanHudBaublesLoaded || !QuiverHelper.isInBaublesSlot((EntityPlayer)player, activeQuiverStack)) {
                    if (HudQuiverAmmo.hudActive == null) {
                        HudQuiverAmmo.hudActive = new HudQuiverAmmo(22, 22, activeQuiverStack);
                    } else {
                        HudQuiverAmmo.hudActive.setQuiver(activeQuiverStack);
                    }
                    HudQuiverAmmo.hudActive.render();
                }
            }
        }
    }

    public static ItemStack getActiveQuiverStack() {
        return activeQuiverStack;
    }
}

