/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.gui;

import com.oblivioussp.spartanweaponry.client.gui.AlignmentHelper;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class HudElement {
    protected int width;
    protected int height;

    public int getAlignedX(AlignmentHelper.Alignment align, int offset, ScaledResolution res) {
        switch (align) {
            case TOP_LEFT: 
            case CENTER_LEFT: 
            case BOTTOM_LEFT: {
                return offset;
            }
            case TOP_CENTER: 
            case CENTER: 
            case BOTTOM_CENTER: {
                return res.func_78326_a() / 2 - this.width / 2 + offset;
            }
            case TOP_RIGHT: 
            case CENTER_RIGHT: 
            case BOTTOM_RIGHT: {
                return res.func_78326_a() - this.width + offset;
            }
        }
        return 0;
    }

    public int getAlignedY(AlignmentHelper.Alignment align, int offset, ScaledResolution res) {
        switch (align) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                return offset;
            }
            case CENTER_LEFT: 
            case CENTER_RIGHT: {
                return res.func_78328_b() / 2 - this.height / 2 + offset;
            }
            case CENTER: {
                return res.func_78328_b() / 2 - this.height / 2 + 26 + offset;
            }
            case BOTTOM_CENTER: {
                return res.func_78328_b() - this.height - 65 + offset;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return res.func_78328_b() - this.height + offset;
            }
        }
        return 0;
    }

    public HudElement(int elementWidth, int elementHeight) {
        this.width = elementWidth;
        this.height = elementHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract void render();
}

