/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import surreal.contentcreator.util.IHaloItem;

public class RenderUtil {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final World WORLD = RenderUtil.MC.field_71441_e;
    private static final EntityPlayer PLAYER = RenderUtil.MC.field_71439_g;

    public static void renderBackground(ItemStack stack, int x, int y) {
        boolean renderHalo = false;
        int spread = 0;
        ResourceLocation halo = null;
        int haloColour = 0;
        Item item = stack.func_77973_b();
        if (item instanceof IHaloItem) {
            IHaloItem ihri = (IHaloItem)item;
            spread = ihri.getSpread(WORLD, PLAYER, stack);
            halo = ihri.getLocation(WORLD, PLAYER, stack);
            haloColour = ihri.getColor(WORLD, PLAYER, stack);
            renderHalo = halo != null;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        if (renderHalo) {
            float ca = (float)(haloColour >> 24 & 0xFF) / 255.0f;
            float cr = (float)(haloColour >> 16 & 0xFF) / 255.0f;
            float cg = (float)(haloColour >> 8 & 0xFF) / 255.0f;
            float cb = (float)(haloColour & 0xFF) / 255.0f;
            if (ca == 0.0f) {
                ca = 1.0f;
            }
            if (spread <= 0) {
                spread = 1;
            }
            GlStateManager.func_179131_c((float)cr, (float)cg, (float)cb, (float)ca);
            TextureAtlasSprite sprite = MC.func_147117_R().func_110572_b(halo.toString());
            MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            int xSize = sprite.func_94211_a() * spread;
            int ySize = sprite.func_94216_b() * spread;
            RenderUtil.drawTexturedModalRect(x - 7 * spread - sprite.func_94211_a() * (spread - 1) / 4 - 1, y - 7 * spread - sprite.func_94216_b() * (spread - 1) / 4 - 1, sprite, xSize, ySize);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static void setSize(ItemStack stack) {
        if (stack.func_77973_b() instanceof IHaloItem && ((IHaloItem)stack.func_77973_b()).shouldPulse(WORLD, PLAYER, stack) && Minecraft.func_71386_F() % 3L == 0L) {
            GlStateManager.func_179152_a((float)1.15f, (float)1.15f, (float)1.0f);
        }
    }

    private static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)xCoord, (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)yCoord, 1.0).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)xCoord, (double)yCoord, 1.0).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }
}

