/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.types;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.block.IMaterial;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import surreal.contentcreator.common.fluid.FluidBase;
import surreal.contentcreator.common.fluid.FluidMaterial;
import surreal.contentcreator.common.item.ItemMaterial;
import surreal.contentcreator.functions.item.IItemEffectHaloColor;
import surreal.contentcreator.functions.item.IItemEffectHaloSpread;
import surreal.contentcreator.functions.item.IItemEffectHaloTexture;
import surreal.contentcreator.functions.item.IItemEffectPulse;
import surreal.contentcreator.proxy.CommonProxy;
import surreal.contentcreator.types.parts.PartBlock;
import surreal.contentcreator.types.parts.PartItem;
import surreal.contentcreator.util.GeneralUtil;
import surreal.contentcreator.util.IHaloItem;

@ZenRegister
@ZenClass(value="contentcreator.material.Material")
public class CTMaterial {
    public static final Map<String, CTMaterial> MATERIALS = Maps.newHashMap();
    public static int ID = 0;
    public int id;
    public String name;
    public int color;
    public String[] ores;
    public String textureType = "default";
    public String rarity = "common";
    public List<String> tooltips;
    public Map<String, Object> properties;
    public Map<String, FluidBase> fluids = new HashMap<String, FluidBase>();
    public boolean enchantedEffect;
    public Material blockMaterial = null;
    public IItemEffectHaloTexture HALOTEXTURE = null;
    public IItemEffectHaloSpread HALOSPREAD = null;
    public IItemEffectHaloColor HALOCOLOR = null;
    public IItemEffectPulse EFFECTPULSE = null;

    private CTMaterial(int id, String name, int color) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.ores = new String[]{GeneralUtil.toUppercase(CaseFormat.LOWER_UNDERSCORE, CaseFormat.UPPER_CAMEL, name)};
        MATERIALS.put(name, this);
    }

    @ZenMethod
    public CTMaterial setColor(int color) {
        this.color = color;
        return this;
    }

    @ZenMethod
    public CTMaterial setTexture(String type) {
        this.textureType = type;
        return this;
    }

    @ZenMethod
    public CTMaterial setOres(String ... ores) {
        this.ores = ores;
        return this;
    }

    @ZenMethod
    public CTMaterial setRarity(String rarity) {
        this.rarity = rarity;
        return this;
    }

    @ZenMethod
    public CTMaterial addTooltip(String ... tooltips) {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<String>();
        }
        Collections.addAll(this.tooltips, tooltips);
        return this;
    }

    @ZenMethod
    public CTMaterial addItem(String type, @Optional String oreName) {
        PartItem part = PartItem.PARTS.containsKey(type) ? PartItem.PARTS.get(type) : new PartItem(type, oreName == null ? type : oreName);
        part.materials.add(this);
        return this;
    }

    @ZenMethod
    public CTMaterial addBlock(String type, @Optional String oreName) {
        PartBlock part = PartBlock.PARTS.containsKey(type) ? PartBlock.PARTS.get(type) : new PartBlock(type, oreName == null ? type : oreName);
        part.materials.add(this);
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, boolean prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, byte prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, short prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, int prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, long prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, float prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, Float.valueOf(prop));
        } else {
            this.properties.replace(name, Float.valueOf(prop));
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, double prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addProperty(String name, String prop) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, prop);
        } else {
            this.properties.replace(name, prop);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addItems(String ... type) {
        for (String str : type) {
            PartItem part = PartItem.PARTS.containsKey(str) ? PartItem.PARTS.get(str) : new PartItem(str, str);
            part.materials.add(this);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addBlocks(String ... type) {
        for (String str : type) {
            PartBlock part = PartBlock.PARTS.containsKey(str) ? PartBlock.PARTS.get(str) : new PartBlock(str, str);
            part.materials.add(this);
        }
        return this;
    }

    @ZenMethod
    public CTMaterial addFluid(String name, int temperature, @Optional int density, @Optional int viscosity, @Optional boolean block, @Optional String overlay) {
        FluidBase fluid = FluidMaterial.create(name, this, name + "_still", name + "_flow", overlay).setCol(this.color).setRare(this.rarity).addBucket();
        this.fluids.put(name, fluid);
        fluid.setDen(density).setVis(viscosity);
        if (block) {
            IMaterial material = temperature >= FluidRegistry.LAVA.getTemperature() ? CraftTweakerMC.getIMaterial((Material)Material.field_151587_i) : CraftTweakerMC.getIMaterial((Material)Material.field_151586_h);
            fluid.addBlock(material);
        }
        this.addProperty("temperature." + name, temperature);
        return this;
    }

    @ZenMethod
    public CTMaterial addPropertyInfo() {
        if (this.tooltips == null) {
            this.tooltips = new ArrayList<String>();
        }
        if (this.properties.size() > 0) {
            for (Map.Entry<String, Object> prop : this.properties.entrySet()) {
                this.tooltips.add(I18n.func_135052_a((String)prop.getKey(), (Object[])new Object[0]) + ": " + prop.getValue());
            }
        } else {
            CraftTweakerAPI.logWarning((String)"There's no property to add to info. Skipping!");
        }
        return this;
    }

    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return I18n.func_188566_a((String)("material." + this.name)) ? I18n.func_135052_a((String)("material." + this.name), (Object[])new Object[0]) : WordUtils.capitalizeFully((String)this.name, (char[])new char[]{'_'}).replace("_", " ");
    }

    @ZenGetter(value="name")
    public String getName() {
        return this.name;
    }

    @ZenGetter(value="color")
    public int getColor() {
        return this.color;
    }

    @ZenMethod
    public IItemStack getItem(String part) {
        ItemMaterial item = CommonProxy.MAT_ITEMS.get(part);
        if (item == null) {
            CraftTweakerAPI.logError((String)("The part " + part + " doesn't exist. Returning null!"));
            return null;
        }
        return new MCItemStack(new ItemStack((Item)item, 1, this.id));
    }

    @ZenMethod
    public IItemStack getBlock(String part) {
        Pair<Block, Integer> pair = CommonProxy.getBlockAndMetaFromMaterial(part, this);
        if (pair != null) {
            return CraftTweakerMC.getIItemStack((ItemStack)new ItemStack((Block)pair.getKey(), 1, ((Integer)pair.getValue()).intValue()));
        }
        return null;
    }

    @ZenMethod
    public IBlockState getBlockState(String part) {
        Pair<Block, Integer> pair = CommonProxy.getBlockAndMetaFromMaterial(part, this);
        if (pair != null) {
            return CraftTweakerMC.getBlockState((net.minecraft.block.state.IBlockState)((Block)pair.getKey()).func_176203_a(((Integer)pair.getValue()).intValue()));
        }
        return null;
    }

    @ZenMethod
    public ILiquidStack getFluid(String part) {
        Fluid fluid = this.fluids.get(part);
        if (fluid != null) {
            return CraftTweakerMC.getILiquidStack((FluidStack)new FluidStack(fluid, 1));
        }
        return null;
    }

    @ZenMethod
    public boolean getBool(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Boolean) {
            return (Boolean)this.properties.get(name);
        }
        return false;
    }

    @ZenMethod
    public byte getByte(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Byte) {
            return (Byte)this.properties.get(name);
        }
        return 0;
    }

    @ZenMethod
    public short getShort(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Short) {
            return (Short)this.properties.get(name);
        }
        return 0;
    }

    @ZenMethod
    public int getInt(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Integer) {
            return (Integer)this.properties.get(name);
        }
        return 0;
    }

    @ZenMethod
    public float getFloat(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Float) {
            return ((Float)this.properties.get(name)).floatValue();
        }
        return 0.0f;
    }

    @ZenMethod
    public double getDouble(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Double) {
            return (Double)this.properties.get(name);
        }
        return 0.0;
    }

    @ZenMethod
    public long getLong(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof Long) {
            return (Long)this.properties.get(name);
        }
        return 0L;
    }

    @ZenMethod
    public String getString(String name) {
        if (this.properties != null && this.properties.containsKey(name) && this.properties.get(name) instanceof String) {
            return (String)this.properties.get(name);
        }
        return null;
    }

    @ZenMethod
    public CTMaterial setBackgroundTexture(IItemEffectHaloTexture func) {
        this.HALOTEXTURE = func;
        return this;
    }

    @ZenMethod
    public CTMaterial setBackgroundTexture(String texture) {
        this.HALOTEXTURE = (world, player, stack) -> texture;
        return this;
    }

    @ZenMethod
    public CTMaterial setBackgroundTexture(int halo) {
        this.HALOTEXTURE = (world, player, stack) -> IHaloItem.getHaloTexture(halo);
        return this;
    }

    @ZenMethod
    public CTMaterial setBackgroundSize(IItemEffectHaloSpread func) {
        this.HALOSPREAD = func;
        return this;
    }

    @ZenMethod
    public CTMaterial setBackgroundSize(int size) {
        this.HALOSPREAD = (world, player, stack) -> size;
        return this;
    }

    @ZenMethod
    public CTMaterial setBackgroundColor(IItemEffectHaloColor func) {
        this.HALOCOLOR = func;
        return this;
    }

    @ZenMethod
    public CTMaterial setBackgroundColor(int color) {
        this.HALOCOLOR = (world, player, stack) -> color;
        return this;
    }

    @ZenMethod
    public CTMaterial setPulseEffect(IItemEffectPulse func) {
        this.EFFECTPULSE = func;
        return this;
    }

    @ZenMethod
    public CTMaterial setPulseEffect() {
        this.EFFECTPULSE = (world, player, stack) -> true;
        return this;
    }

    @ZenMethod
    public CTMaterial setEnchanted() {
        this.enchantedEffect = true;
        return this;
    }

    @ZenMethod
    public CTMaterial setMaterial(IMaterial material) {
        this.blockMaterial = CraftTweakerMC.getMaterial((IMaterial)material);
        return this;
    }

    @ZenMethod
    public static CTMaterial get(String name, @Optional int color) {
        CTMaterial material = MATERIALS.get(name);
        if (material == null) {
            material = new CTMaterial(ID, name, color == 0 ? 0xFFFFFF : color);
            ++ID;
        }
        return material;
    }

    @ZenMethod
    public static CTMaterial get(int id, String name, @Optional int color) {
        CTMaterial material = MATERIALS.get(name);
        if (material != null) {
            material.id = id;
        } else {
            material = new CTMaterial(id, name, color == 0 ? 0xFFFFFF : color);
        }
        return material;
    }
}

