/*
 * Decompiled with CFR 0.152.
 */
package surreal.contentcreator.core;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import surreal.contentcreator.core.CCLoadingPlugin;

public class CCClassTransformer
implements IClassTransformer {
    private static final Map<String, Consumer<ClassNode>> MAP = Maps.newHashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (MAP.containsKey(transformedName)) {
            CCLoadingPlugin.LOGGER.info("Manipulating " + transformedName);
            return this.transform(basicClass, MAP.get(transformedName));
        }
        return basicClass;
    }

    private byte[] transform(byte[] classBeingTransformed, Consumer<ClassNode> consumer) {
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBeingTransformed);
            classReader.accept((ClassVisitor)classNode, 0);
            consumer.accept(classNode);
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return classBeingTransformed;
        }
    }

    static {
        MAP.put("net.minecraft.client.renderer.RenderItem", clazz -> {
            for (MethodNode method : clazz.methods) {
                InsnList list;
                AbstractInsnNode node;
                if (method.name.equals(CCLoadingPlugin.DEOBF ? "renderItemModelIntoGUI" : "func_191962_a")) {
                    node = null;
                    for (AbstractInsnNode n : method.instructions.toArray()) {
                        if (!(n instanceof LineNumberNode) || ((LineNumberNode)n).line != 313) continue;
                        node = n.getNext();
                        break;
                    }
                    if (node != null) {
                        list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "surreal/contentcreator/util/RenderUtil", "setSize", "(Lnet/minecraft/item/ItemStack;)V", false));
                        method.instructions.insertBefore(node, list);
                        list.clear();
                        list.add((AbstractInsnNode)new InsnNode(12));
                        list.add((AbstractInsnNode)new InsnNode(12));
                        list.add((AbstractInsnNode)new InsnNode(12));
                        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/GlStateManager", CCLoadingPlugin.DEOBF ? "scale" : "func_179152_a", "(FFF)V", false));
                        method.instructions.insertBefore(node.getNext().getNext().getNext().getNext(), list);
                    }
                }
                if (!method.name.equals(CCLoadingPlugin.DEOBF ? "renderItemAndEffectIntoGUI" : "func_184391_a")) continue;
                node = null;
                for (AbstractInsnNode n : method.instructions.toArray()) {
                    if (n.getOpcode() != 181) continue;
                    node = n.getNext().getNext().getNext();
                    break;
                }
                if (node == null) continue;
                list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 2));
                list.add((AbstractInsnNode)new VarInsnNode(21, 3));
                list.add((AbstractInsnNode)new VarInsnNode(21, 4));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "surreal/contentcreator/util/RenderUtil", "renderBackground", "(Lnet/minecraft/item/ItemStack;II)V", false));
                method.instructions.insertBefore(node, list);
            }
        });
    }
}

