/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.tinkersconstruct.modifierlocks;

import codersafterdark.compatskills.CompatSkills;
import codersafterdark.compatskills.common.compats.tinkersconstruct.TinkersCompatHandler;
import codersafterdark.compatskills.common.compats.tinkersconstruct.modifierlocks.ModifierLockKey;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.RequirementHolder;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="tconstruct")
@ZenClass(value="mods.compatskills.ModifierLock")
@ZenRegister
public class ModifierLockTweaker {
    @ZenMethod
    public static void addModifierLock(String identifier, String ... requirements) {
        if (TinkersCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new AddModifierLock(identifier, requirements));
        }
    }

    private static class AddModifierLock
    implements IAction {
        private final String id;
        private final String[] requirements;

        private AddModifierLock(String id, String ... requirements) {
            this.id = id;
            this.requirements = requirements;
        }

        public void apply() {
            IModifier modifier;
            if (CheckMethods.checkModifier(this.id) && (modifier = TinkerRegistry.getModifier((String)this.id)) != null) {
                TinkersCompatHandler.addTinkersLock(new ModifierLockKey((IToolMod)modifier), RequirementHolder.fromStringList((String[])this.requirements));
            }
        }

        public String describe() {
            return "Added Modifier Lock for Modifier: " + this.id + " With Requirements: " + Utils.formatRequirements(this.requirements);
        }
    }
}

