/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.tinkersconstruct;

import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.LevelLockHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.TinkerCraftingEvent;

public class TinkerLockHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCraftingMaterial(TinkerCraftingEvent.ToolPartCraftingEvent event) {
        this.handleTinkerEvent((TinkerCraftingEvent)event, "compatskills.error.tconstruct.craft.part");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onModifierAttached(TinkerCraftingEvent.ToolModifyEvent event) {
        this.handleTinkerEvent((TinkerCraftingEvent)event, "compatskills.error.tconstruct.modify");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPartReplaced(TinkerCraftingEvent.ToolPartReplaceEvent event) {
        this.handleTinkerEvent((TinkerCraftingEvent)event, "compatskills.error.tconstruct.modify");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onToolCrafted(TinkerCraftingEvent.ToolCraftingEvent event) {
        if (event.getPlayer() == null) {
            event.setCanceled(true);
            return;
        }
        this.handleTinkerEvent((TinkerCraftingEvent)event, "compatskills.error.tconstruct.craft.tool");
    }

    private void handleTinkerEvent(TinkerCraftingEvent event, String translationKey) {
        EntityPlayer player = event.getPlayer();
        if (Utils.skipPlayer(player)) {
            return;
        }
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        if (data == null) {
            return;
        }
        RequirementHolder holder = LevelLockHandler.getSkillLock((ItemStack)event.getItemStack());
        if (holder.equals(LevelLockHandler.EMPTY_LOCK) || data.matchStats(holder)) {
            return;
        }
        StringBuilder reqs = new StringBuilder(new TextComponentTranslation(translationKey, new Object[0]).func_150261_e());
        reqs.append("\n\n").append(new TextComponentTranslation("compatskills.misc.requirements", new Object[0]).func_150261_e());
        holder.getRequirements().forEach(req -> reqs.append('\n').append(req.getToolTip(data)));
        event.setCanceled(reqs.toString());
    }
}

