/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.skillhiding;

import codersafterdark.compatskills.common.compats.reskillable.skillhiding.VisibilityLock;
import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.event.CacheInvalidatedEvent;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.base.LevelLockHandler;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class VisibilityLockHandler {
    @SubscribeEvent
    public void onPlayerJoinHide(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        Collection skills = ReskillableRegistries.SKILLS.getValuesCollection();
        for (Skill skill : skills) {
            RequirementHolder holder = LevelLockHandler.getLockByKey((LockKey)new VisibilityLock(skill));
            if (holder.equals(LevelLockHandler.EMPTY_LOCK) || data.matchStats(holder)) continue;
            skill.setHidden(true);
        }
    }

    @SubscribeEvent
    public void onCacheInvalidated(CacheInvalidatedEvent event) {
        EntityPlayer player = event.getPlayer();
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        Collection skills = ReskillableRegistries.SKILLS.getValuesCollection();
        for (Skill skill : skills) {
            RequirementHolder holder = LevelLockHandler.getLockByKey((LockKey)new VisibilityLock(skill));
            if (!holder.equals(LevelLockHandler.EMPTY_LOCK) && !data.matchStats(holder)) {
                skill.setHidden(true);
                continue;
            }
            skill.setHidden(false);
        }
    }
}

