/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.skillchange;

import codersafterdark.compatskills.common.compats.reskillable.skillchange.IChangeHandler;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.SkillChange;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.SkillLevel;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.UnlockableLock;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.UnlockableUnlock;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.changelisteners.LevelHandler;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.changelisteners.LockHandler;
import codersafterdark.compatskills.common.compats.reskillable.skillchange.changelisteners.UnlockHandler;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class SkillChangeHandler {
    private static Map<SkillChange, Consumer<EntityPlayer>> skillChangeMap = new HashMap<SkillChange, Consumer<EntityPlayer>>();
    private static boolean level;
    private static boolean unlock;
    private static boolean lock;

    public static void addSkillEvent(SkillChange change, String[] commands) {
        SkillChangeHandler.registerChange(change);
        skillChangeMap.put(change, player -> {
            MinecraftServer server = player.func_184102_h();
            if (server != null) {
                ICommandManager commandManager = server.func_71187_D();
                for (String command : commands) {
                    commandManager.func_71556_a((ICommandSender)server, command);
                }
            }
        });
    }

    public static void addSkillEvent(SkillChange change, IChangeHandler handler) {
        SkillChangeHandler.registerChange(change);
        skillChangeMap.put(change, player -> handler.handleChange(CraftTweakerMC.getIPlayer((EntityPlayer)player)));
    }

    private static void registerChange(SkillChange change) {
        if (change instanceof SkillLevel) {
            if (!level) {
                MinecraftForge.EVENT_BUS.register((Object)new LevelHandler());
                level = true;
            }
        } else if (change instanceof UnlockableUnlock) {
            if (!unlock) {
                MinecraftForge.EVENT_BUS.register((Object)new UnlockHandler());
                unlock = true;
            }
        } else if (change instanceof UnlockableLock && !lock) {
            MinecraftForge.EVENT_BUS.register((Object)new LockHandler());
            lock = true;
        }
    }

    public static void handleCommands(SkillChange change, EntityPlayer player) {
        if (player == null || player.field_70170_p.field_72995_K || player.func_184102_h() == null) {
            return;
        }
        Consumer<EntityPlayer> handler = skillChangeMap.get(change);
        if (handler != null) {
            handler.accept(player);
        }
    }
}

