/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.customcontent;

import codersafterdark.compatskills.common.compats.reskillable.ReskillableCompatHandler;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.skill.Skill;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.formatting.IFormattedText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.compatskills.SkillCreator")
@ZenRegister
public class CrTSkill
extends Skill {
    @ZenProperty
    public IFormattedText name;

    public CrTSkill(ResourceLocation name, ResourceLocation background) {
        super(name, background);
        ReskillableRegistries.SKILLS.register((IForgeRegistryEntry)this);
    }

    private static CrTSkill createSkill(ResourceLocation name, ResourceLocation background) {
        Skill value;
        CrTSkill customSkill = new CrTSkill(name, background);
        if (ReskillableRegistries.SKILLS.containsKey(name) && (value = (Skill)ReskillableRegistries.SKILLS.getValue(name)) instanceof CrTSkill) {
            customSkill = (CrTSkill)value;
            if (!background.equals((Object)customSkill.getBackground())) {
                customSkill.background = background;
                CraftTweakerAPI.logInfo((String)("Loaded Skill: " + name + " - Updated Background: " + background));
            } else {
                CraftTweakerAPI.logInfo((String)("Created or Loaded Skill: " + name + " - With Background: " + background));
            }
        }
        return customSkill;
    }

    @ZenMethod
    public static CrTSkill createSkill(String name, String backGroundLocation) {
        if (ReskillableCompatHandler.ENABLED & CheckMethods.checkString(name) & CheckMethods.checkString(backGroundLocation)) {
            return CrTSkill.createSkill(new ResourceLocation("compatskills", name), new ResourceLocation(backGroundLocation));
        }
        return null;
    }

    @ZenMethod
    public static CrTSkill createNewSkill(String nameLocation, String backGroundLocation) {
        if (ReskillableCompatHandler.ENABLED & CheckMethods.checkString(nameLocation) & CheckMethods.checkString(backGroundLocation)) {
            return CrTSkill.createSkill(new ResourceLocation(nameLocation), new ResourceLocation(backGroundLocation));
        }
        return null;
    }

    @ZenGetter(value="levelCap")
    @ZenMethod
    public int getLevelCap() {
        return this.getCap();
    }

    @ZenSetter(value="levelCap")
    @ZenMethod
    public void setLevelCap(int cap) {
        this.skillConfig.setLevelCap(cap);
    }

    @ZenGetter(value="enabled")
    @ZenMethod
    public boolean getEnabled() {
        return this.isEnabled();
    }

    @ZenSetter(value="enabled")
    @ZenMethod
    public void setEnabled(boolean enabled) {
        this.skillConfig.setEnabled(enabled);
    }

    @ZenGetter(value="levelStaggering")
    @ZenMethod
    public String[] getLevelStaggering() {
        ArrayList stagger = new ArrayList();
        this.skillConfig.getLevelStaggering().forEach((key, value) -> stagger.add(key + "|" + value));
        return stagger.toArray(new String[0]);
    }

    @ZenSetter(value="levelStaggering")
    @ZenMethod
    public void setLevelStaggering(String[] stagger) {
        Map<Integer, Integer> configLevelStaggering = Arrays.stream(stagger).map(string -> string.split("\\|")).filter(array -> ((String[])array).length == 2).map(array -> Pair.of((Object)array[0], (Object)array[1])).map(pair -> Pair.of((Object)Integer.parseInt((String)pair.getKey()), (Object)Integer.parseInt((String)pair.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        HashMap<Integer, Integer> levelStaggering = new HashMap<Integer, Integer>();
        int lastLevel = this.skillConfig.getBaseLevelCost();
        for (int i = 1; i < this.skillConfig.getLevelCap(); ++i) {
            if (configLevelStaggering.containsKey(i)) {
                lastLevel = configLevelStaggering.get(i);
            }
            levelStaggering.put(i, lastLevel);
        }
        this.skillConfig.setLevelStaggering(levelStaggering);
    }

    @ZenSetter(value="skillPointInterval")
    @ZenMethod
    public void setSkillPointInterval(int amount) {
        this.skillConfig.setSkillPointInterval(amount);
    }

    @ZenGetter(value="baseLevelCost")
    @ZenMethod
    public int getBaseLevelCost() {
        return this.skillConfig.getBaseLevelCost();
    }

    @ZenSetter(value="baseLevelCost")
    @ZenMethod
    public void setBaseLevelCost(int cost) {
        this.skillConfig.setBaseLevelCost(cost);
    }

    @ZenGetter(value="hidden")
    @ZenMethod
    public boolean isHidden() {
        return super.isHidden();
    }

    @ZenSetter(value="hidden")
    @ZenMethod
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
    }

    @ZenGetter(value="levelButton")
    @ZenMethod
    public boolean hasLevelButton() {
        return super.hasLevelButton();
    }

    @ZenSetter(value="levelButton")
    @ZenMethod
    public void setLevelButton(boolean button) {
        this.skillConfig.setLevelButton(button);
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name.getText();
    }

    @ZenMethod
    public void setRankIcon(int rank, String resourceLocation) {
        if (CheckMethods.checkResourceLocation(resourceLocation)) {
            this.setCustomSprite(rank, new ResourceLocation(resourceLocation));
        }
    }

    @ZenMethod
    public void removeRankIcon(int rank) {
        this.removeCustomSprite(rank);
    }
}

