/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable;

import codersafterdark.compatskills.CompatSkills;
import codersafterdark.compatskills.common.compats.reskillable.ReskillableCompatHandler;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.LevelLockHandler;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="crafttweaker")
@ZenClass(value="mods.compatskills.Requirement")
@ZenRegister
public class RequirementTweaker {
    @ZenMethod
    public static void addRequirement(IItemStack item, String ... locked) {
        if (ReskillableCompatHandler.ENABLED) {
            CompatSkills.LATE_ADDITIONS.add(new Add(item, locked));
        }
    }

    private static class Add
    implements IAction {
        private final IItemStack stack;
        private final String[] requirements;

        private Add(IItemStack stack, String ... requirements) {
            this.stack = stack;
            this.requirements = requirements;
        }

        public void apply() {
            if (CheckMethods.checkIItemstack(this.stack) & CheckMethods.checkStringArray(this.requirements)) {
                RequirementHolder h = RequirementHolder.fromStringList((String[])this.requirements);
                LevelLockHandler.addLock((ItemStack)CraftTweakerMC.getItemStack((IItemStack)this.stack), (RequirementHolder)h);
            }
        }

        public String describe() {
            return "Setting the requirement of: " + (this.stack == null ? "null" : this.stack.getDisplayName()) + " to Requirements: " + Utils.formatRequirements(this.requirements);
        }
    }
}

