/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class SimpleLayerGen
implements ITerrainGenerator {
    public static final String ID = "basicLayer";
    final IBlockState block;
    final int minY;
    final int maxY;
    final int extB;
    final int extT;

    @Override
    public String getRegistryName() {
        return ID;
    }

    public SimpleLayerGen(IBlockState block, int minY, int maxY, int extB, int extT) {
        this.block = block;
        this.minY = minY;
        this.maxY = maxY - 1;
        this.extB = extB;
        this.extT = extT;
    }

    public SimpleLayerGen(NBTTagCompound nbt) {
        this.block = BlockPredicate.parse(nbt.func_74779_i("block"));
        this.minY = nbt.func_74771_c("minY") & 0xFF;
        this.maxY = nbt.func_74771_c("maxY") & 0xFF;
        this.extB = nbt.func_74771_c("extB") & 0xFF;
        this.extT = nbt.func_74771_c("extT") & 0xFF;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("block", BlockPredicate.serialize(this.block));
        nbt.func_74774_a("minY", (byte)this.minY);
        nbt.func_74774_a("maxY", (byte)this.maxY);
        nbt.func_74774_a("extB", (byte)this.extB);
        nbt.func_74774_a("extT", (byte)this.extT);
        return nbt;
    }

    @Override
    public void generate(World world, ChunkPrimer cp, int cx, int cz, TerrainGeneration cfg) {
        Random rand = cfg.rand;
        int eb = this.extB + 1;
        int et = this.extT + 1;
        int y0 = this.minY;
        int y1 = this.maxY;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                for (int y2 = y0; y2 <= y1; ++y2) {
                    cp.func_177855_a(x, y2, z, this.block);
                }
                int d = 1;
                for (y = y0 - 1; d < eb && y >= 0; ++d, --y) {
                    if (d > rand.nextInt(eb)) continue;
                    cp.func_177855_a(x, y, z, this.block);
                }
                d = 1;
                for (y = y1 + 1; d < et && y < 256; ++d, ++y) {
                    if (d > rand.nextInt(et)) continue;
                    cp.func_177855_a(x, y, z, this.block);
                }
            }
        }
    }
}

