/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.client.gui;

import cd4017be.dimstack.Main;
import cd4017be.dimstack.client.gui.GuiEditDim;
import cd4017be.dimstack.client.gui.GuiList;
import cd4017be.dimstack.client.gui.GuiMenuBase;
import cd4017be.dimstack.client.gui.IDrawableEntry;
import cd4017be.dimstack.core.Dimensionstack;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.FileBrowser;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.util.FileUtil;
import cd4017be.lib.util.TooltipUtil;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.lwjgl.input.Mouse;

public class GuiDimStack
extends GuiMenuBase {
    private GuiList<Dim> dimList;
    private GuiList<Dim> dimStack;
    private GuiButton b_edit;
    private GuiButton b_sel;
    private GuiButton b_add;
    private GuiButton b_rem;
    private GuiButton b_cut;
    private PortalConfiguration selStack;
    private File file;
    private final GuiFrame frame = new GuiFrame((ModularGui)null, 0, 0, 1);

    public GuiDimStack(GuiScreen parent) {
        super(parent);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.frame.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
        this.title = TooltipUtil.translate((String)"gui.dimstack.cfg");
        int bw = 70;
        int w = (this.field_146294_l - 32 - bw) / 2;
        if (w > 200 && (bw = this.field_146294_l - 2 * (w = 200) - 32) > 100) {
            bw = 100;
        }
        int left = (this.field_146294_l - bw - 16) / 2 - w;
        int right = (this.field_146294_l + bw + 16) / 2 + w;
        this.dimList = (GuiList)this.func_189646_b(new GuiList(1, (this.field_146294_l - bw - 16) / 2 - w, 36, w, this.field_146295_m - 72, TooltipUtil.translate((String)"gui.dimstack.ldim")));
        IntOpenHashSet ids = new IntOpenHashSet();
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            ids.add(i2);
        }
        ids.addAll((IntCollection)PortalConfiguration.getDefinedIds());
        List list = this.dimList.list;
        int[] IDs = ids.toIntArray();
        Arrays.sort(IDs);
        for (int id : IDs) {
            list.add(new Dim(id));
        }
        this.dimStack = (GuiList)this.func_189646_b(new GuiList(2, (this.field_146294_l + bw + 16) / 2, 36, w, this.field_146295_m - 72, TooltipUtil.translate((String)"gui.dimstack.lstack")));
        int y = (this.field_146295_m - 112 + 8) / 2;
        int x = (this.field_146294_l - bw) / 2;
        this.b_sel = this.func_189646_b((GuiButton)new GuiButtonExt(3, x, y, bw, 20, TooltipUtil.translate((String)"gui.dimstack.sel")));
        this.b_add = this.func_189646_b((GuiButton)new GuiButtonExt(4, x, y += 28, bw, 20, TooltipUtil.translate((String)"gui.dimstack.add")));
        this.b_rem = this.func_189646_b((GuiButton)new GuiButtonExt(5, x, y += 28, bw, 20, TooltipUtil.translate((String)"gui.dimstack.rem")));
        this.b_cut = this.func_189646_b((GuiButton)new GuiButtonExt(9, x, y += 28, bw, 20, TooltipUtil.translate((String)"gui.dimstack.cut")));
        bw = Math.min(150, (this.field_146294_l - 32) / 3);
        this.b_edit = this.func_189646_b((GuiButton)new GuiButtonExt(6, right - bw, this.field_146295_m - 28, bw, 20, TooltipUtil.translate((String)"gui.dimstack.edit")));
        this.setSelDimstack(this.selStack);
        this.textFields.add(new GuiTextField(7, this.field_146289_q, left, this.field_146295_m - 28, 40, 20));
        this.func_189646_b((GuiButton)new GuiButtonExt(8, left + 40, this.field_146295_m - 28, bw - 40, 20, TooltipUtil.translate((String)"gui.dimstack.search")));
        if (bw < 150) {
            this.b_close.func_175211_a(bw);
            this.b_close.field_146128_h += (150 - bw) / 2;
        }
        this.func_189646_b((GuiButton)new GuiButtonExt(10, left, 8, bw, 20, TooltipUtil.translate((String)"gui.dimstack.import")));
        this.func_189646_b((GuiButton)new GuiButtonExt(11, right - bw, 8, bw, 20, TooltipUtil.translate((String)"gui.dimstack.export")));
    }

    private void setSelDimstack(PortalConfiguration dim) {
        this.selStack = dim;
        if (dim == null) {
            this.dimStack.list.clear();
            this.dimStack.setSel(-1);
            this.updateButtons();
            return;
        }
        List list = this.dimStack.list;
        list.clear();
        PortalConfiguration d = dim;
        PortalConfiguration d1 = d.top();
        if (d1 == null) {
            d1 = d;
        }
        d = d1;
        list.add(new Dim(d.dimId));
        this.dimStack.sel = 0;
        for (d = d.down(); d != null && d != d1; d = d.down()) {
            if (d == dim) {
                this.dimStack.sel = list.size();
            }
            list.add(new Dim(d.dimId));
        }
        this.dimStack.setSel(this.dimStack.sel);
        this.updateButtons();
    }

    private void updateButtons() {
        boolean bs = this.selStack != null;
        boolean bx = !this.dimStack.list.isEmpty();
        boolean bl = this.dimList.getSelEl() != null;
        this.b_edit.field_146124_l = bs;
        this.b_rem.field_146124_l = bs;
        this.b_cut.field_146124_l = bs && this.selStack.down() != null;
        this.b_add.field_146124_l = bl && bx;
        this.b_sel.field_146124_l = bl;
    }

    @Override
    protected void func_146284_a(GuiButton b) throws IOException {
        switch (b.field_146127_k) {
            case 1: {
                this.updateButtons();
                break;
            }
            case 2: {
                Dim sd = this.dimStack.getSelEl();
                this.selStack = sd == null ? null : sd.getDim();
                this.updateButtons();
                break;
            }
            case 3: {
                Dim sd = this.dimList.getSelEl();
                this.setSelDimstack(sd != null ? sd.getDim() : null);
                break;
            }
            case 4: {
                Dim sd = this.dimList.getSelEl();
                if (sd == null) break;
                PortalConfiguration d1 = sd.getDim();
                if (this.dimStack.list.isEmpty()) break;
                if (this.selStack == null) {
                    ((Dim)this.dimStack.list.get(0)).getDim().insertTop(d1);
                } else {
                    this.selStack.insertBottom(d1);
                }
                this.setSelDimstack(d1);
                break;
            }
            case 5: {
                if (this.selStack == null) break;
                PortalConfiguration d = this.selStack;
                PortalConfiguration d1 = d.up();
                if (d1 == null) {
                    d1 = d.down();
                }
                d.unlink();
                for (int i = this.dimList.list.size() - 1; i >= 0; --i) {
                    if (((Dim)this.dimList.list.get((int)i)).id != d.dimId) continue;
                    this.dimList.setSel(i);
                    break;
                }
                this.setSelDimstack(d1);
                break;
            }
            case 6: {
                if (this.selStack == null) break;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiEditDim(this, this.selStack));
                break;
            }
            case 8: {
                try {
                    int s;
                    int i;
                    String text = ((GuiTextField)this.textFields.get(0)).func_146179_b();
                    if (text.isEmpty()) {
                        IntSet ids = PortalConfiguration.getDefinedIds();
                        i = 0;
                        while (ids.contains(i)) {
                            ++i;
                        }
                    } else {
                        i = Integer.parseInt(text);
                    }
                    List list = this.dimList.list;
                    int l = list.size();
                    for (s = 0; s < l; ++s) {
                        int id = ((Dim)list.get((int)s)).id;
                        if (id == i) {
                            this.dimList.setSel(s);
                            this.updateButtons();
                            return;
                        }
                        if (id > i) break;
                    }
                    list.add(s, new Dim(i));
                    this.dimList.setSel(s);
                    this.updateButtons();
                }
                catch (NumberFormatException text) {
                    // empty catch block
                }
                ((GuiTextField)this.textFields.get(0)).func_146180_a("");
                break;
            }
            case 9: {
                if (this.selStack == null) break;
                this.selStack.splitBottom();
                this.setSelDimstack(this.selStack);
                break;
            }
            case 10: {
                GuiFrame f = new FileBrowser(this.frame, this::load, null).setFile(new File(FMLCommonHandler.instance().getSavesDirectory().getAbsolutePath(), "dimensionstack.dat").getAbsoluteFile()).title("gui.dimstack.import", 0.5f);
                f.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
                f.position(8, 8);
                break;
            }
            case 11: {
                GuiFrame f = new FileBrowser(this.frame, fb -> {
                    fb.close();
                    this.file = fb.getFile();
                    File dir = this.file.getParentFile();
                    if (dir != null && new File(dir, "level.dat").exists()) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, TooltipUtil.translate((String)"gui.dimstack.warnsave1"), TooltipUtil.translate((String)"gui.dimstack.warnsave2"), 11));
                    } else {
                        this.save();
                    }
                }, null).setFile(new File(this.file != null ? this.file.getParentFile() : FileUtil.configDir, "dimensionstack.dat").getAbsoluteFile()).title("gui.dimstack.export", 0.5f);
                f.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
                f.position(8, 8);
                break;
            }
            default: {
                super.func_146284_a(b);
            }
        }
    }

    private void load(FileBrowser fb) {
        fb.close();
        this.file = fb.getFile();
        if (this.file == null || !this.file.exists() || !this.file.getName().endsWith(".dat")) {
            Main.LOG.info("import cancled: invalid file supplied!");
            return;
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)this.file);
            if (nbt.func_74771_c("version") < 4) {
                Main.LOG.warn("importing from file with outdated version!");
            }
            Dimensionstack.load(nbt);
            Main.LOG.info("Dimension stack configuration sucessfully imported from {}", (Object)this.file);
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
        catch (IOException e) {
            Main.LOG.error("Importing dimension stack configuration failed: ", (Throwable)e);
        }
    }

    private void save() {
        if (this.file == null || !this.file.getName().endsWith(".dat")) {
            Main.LOG.info("export cancled: invalid file supplied!");
            return;
        }
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            Dimensionstack.save(nbt, false);
            this.file.createNewFile();
            CompressedStreamTools.func_74795_b((NBTTagCompound)nbt, (File)this.file);
            Main.LOG.info("Dimension stack configuration sucessfully exported to {}", (Object)this.file);
        }
        catch (IOException e) {
            Main.LOG.error("Exporting dimension stack configuration failed: ", (Throwable)e);
        }
    }

    public void func_73878_a(boolean result, int id) {
        if (id == 11) {
            if (result && this.file != null) {
                this.save();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        } else {
            super.func_73878_a(result, id);
        }
    }

    @Override
    protected void func_73869_a(char c, int k) throws IOException {
        if (!this.frame.keyIn(c, k, (byte)0)) {
            super.func_73869_a(c, k);
        }
    }

    @Override
    protected void func_73864_a(int mx, int my, int mb) throws IOException {
        if (!this.frame.mouseIn(mx, my, mb, (byte)0)) {
            super.func_73864_a(mx, my, mb);
        }
    }

    protected void func_146286_b(int mx, int my, int mb) {
        if (!this.frame.mouseIn(mx, my, mb, (byte)2)) {
            super.func_146286_b(mx, my, mb);
        }
    }

    protected void func_146273_a(int mx, int my, int mb, long t) {
        if (!this.frame.mouseIn(mx, my, mb, (byte)1)) {
            super.func_146273_a(mx, my, mb, t);
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        int z = Mouse.getEventDWheel();
        if (z != 0) {
            if (z > 1) {
                z = 1;
            } else if (z < -1) {
                z = -1;
            }
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.frame.mouseIn(x, y, z, (byte)3);
        }
        super.func_146274_d();
    }

    @Override
    public void func_73863_a(int mx, int my, float t) {
        super.func_73863_a(mx, my, t);
        this.frame.drawBackground(mx, my, t);
        this.frame.drawOverlay(mx, my);
    }

    static class Dim
    implements IDrawableEntry {
        final int id;

        public Dim(int id) {
            this.id = id;
        }

        @Override
        public void draw(Minecraft mc, int x, int y, int w, int h, float t) {
            boolean d;
            PortalConfiguration pc = PortalConfiguration.get(this.id);
            mc.field_71466_p.func_78276_b(pc.toString(), x + 2, y + (h - mc.field_71466_p.field_78288_b) / 2, 0xFFFF80);
            int y0 = y + h / 2 - 1;
            int y1 = y0 + 1;
            boolean u = pc.up() != null;
            boolean bl = d = pc.down() != null;
            if (!u || !d) {
                Gui.func_73734_a((int)(x + w - 8), (int)y0, (int)(x + w - 3), (int)y1, (int)-16711936);
            }
            if (u) {
                y0 = y + 1;
            }
            if (d) {
                y1 = y + h - 2;
            }
            Gui.func_73734_a((int)(x + w - 6), (int)y0, (int)(x + w - 5), (int)y1, (int)-16711936);
        }

        PortalConfiguration getDim() {
            return PortalConfiguration.get(this.id);
        }
    }
}

