/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.client.gui;

import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.client.RenderUtil;
import cd4017be.dimstack.client.gui.AutoCompletions;
import cd4017be.dimstack.client.gui.BlockStateCompletion;
import cd4017be.dimstack.client.gui.GuiBlockSel;
import cd4017be.dimstack.client.gui.GuiList;
import cd4017be.dimstack.client.gui.GuiMenuBase;
import cd4017be.dimstack.client.gui.IDrawableEntry;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiBlockLayers
extends GuiMenuBase
implements GuiPageButtonList.GuiResponder {
    private final TerrainGeneration cfg;
    private BlockStateCompletion complete;
    private GuiBlockSel block;
    private GuiTextField topY;
    private GuiTextField botY;
    private GuiSlider topE;
    private GuiSlider botE;
    private GuiList<Layer> list;
    private GuiButton rem;

    public GuiBlockLayers(GuiScreen parent, IDimension dim) {
        super(parent);
        this.cfg = dim.getSettings(TerrainGeneration.class, true);
    }

    @Override
    public void func_73866_w_() {
        List layers;
        super.func_73866_w_();
        this.complete = AutoCompletions.blockstates();
        this.title = TooltipUtil.translate((String)"gui.dimstack.layer");
        int h = 104;
        int x = (this.field_146294_l - 308) / 2;
        int y = (this.field_146295_m - h) / 2;
        if (this.list != null) {
            layers = this.list.list;
        } else {
            layers = new ArrayList();
            for (ITerrainGenerator gen : this.cfg.entries) {
                NBTTagCompound nbt = gen.writeNBT();
                nbt.func_74778_a("id", gen.getRegistryName());
                layers.add(new Layer(nbt));
            }
        }
        this.list = (GuiList)this.func_189646_b(new GuiList(1, x, y, 150, h - 22, 16, TooltipUtil.translate((String)"gui.dimstack.layer.list"), layers));
        this.func_189646_b((GuiButton)new GuiButtonExt(2, x, y + h - 20, 74, 20, TooltipUtil.translate((String)"gui.dimstack.new")));
        this.rem = this.func_189646_b((GuiButton)new GuiButtonExt(3, x + 76, y + h - 20, 74, 20, TooltipUtil.translate((String)"gui.dimstack.rem")));
        this.block = new GuiBlockSel(4, this.field_146289_q, this.complete, x += 158, y, 150, 20);
        this.block.func_175207_a(this);
        this.textFields.add(this.block);
        GuiLabel l = new GuiLabel(this.field_146289_q, 0, x, y += 28, 45, 20, 0xFFFFFF).func_175203_a();
        this.field_146293_o.add(l);
        for (String s : TooltipUtil.translate((String)"gui.dimstack.layer.bot").split("\n", 2)) {
            l.func_175202_a(s);
        }
        this.botY = new GuiTextField(5, this.field_146289_q, x + 75 - 30, y, 30, 20);
        this.textFields.add(this.botY);
        this.botY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        l = new GuiLabel(this.field_146289_q, 1, x + 75, y, 45, 20, 0xFFFFFF).func_175203_a();
        this.field_146293_o.add(l);
        for (String s : TooltipUtil.translate((String)"gui.dimstack.layer.top").split("\n", 2)) {
            l.func_175202_a(s);
        }
        this.topY = new GuiTextField(6, this.field_146289_q, x + 150 - 30, y, 30, 20);
        this.textFields.add(this.topY);
        this.topY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.topE = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 8, x, y += 28, TooltipUtil.translate((String)"gui.dimstack.layer.fadeUp"), 0.0f, 64.0f, 0.0f, (id, name, val) -> String.format("%s: %.0f", name, Float.valueOf(val))));
        this.topE.func_175211_a(150);
        this.botE = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 7, x, y += 28, TooltipUtil.translate((String)"gui.dimstack.layer.fadeDown"), 0.0f, 64.0f, 0.0f, (id, name, val) -> String.format("%s: %.0f", name, Float.valueOf(val))));
        this.botE.func_175211_a(150);
        this.select(-1);
    }

    private void select(int i) {
        boolean enable;
        this.list.sel = i;
        NBTTagCompound nbt = this.getSel();
        boolean bl = enable = nbt != null && nbt.func_74779_i("id") == "basicLayer";
        if (enable) {
            this.block.func_146180_a(nbt.func_74779_i("block"));
            this.botY.func_146180_a(Integer.toString(nbt.func_74771_c("minY") & 0xFF));
            this.topY.func_146180_a(Integer.toString((nbt.func_74771_c("maxY") & 0xFF) + 1));
            this.botE.func_175218_a((float)(nbt.func_74771_c("extB") & 0xFF), false);
            this.topE.func_175218_a((float)(nbt.func_74771_c("extT") & 0xFF), false);
        } else {
            this.block.func_146180_a(nbt == null ? "" : "editor not yet implem.");
            this.topY.func_146180_a("");
            this.botY.func_146180_a("");
        }
        this.block.func_146184_c(enable);
        this.botY.func_146184_c(enable);
        this.topY.func_146184_c(enable);
        this.botE.field_146124_l = enable;
        this.topE.field_146124_l = enable;
        this.rem.field_146124_l = nbt != null;
    }

    private NBTTagCompound getSel() {
        return this.list.sel >= 0 && this.list.sel < this.list.list.size() ? ((Layer)this.list.list.get((int)this.list.sel)).nbt : null;
    }

    @Override
    public void func_73863_a(int mx, int my, float t) {
        super.func_73863_a(mx, my, t);
        this.block.drawOverlay();
    }

    @Override
    protected void func_146284_a(GuiButton b) throws IOException {
        int s = this.list.sel;
        switch (b.field_146127_k) {
            case 1: {
                this.select(this.list.sel);
                break;
            }
            case 2: {
                if (++s < 0 || s > this.list.list.size()) {
                    s = this.list.list.size();
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("id", "basicLayer");
                this.list.list.add(s, new Layer(nbt));
                this.select(s);
                break;
            }
            case 3: {
                if (s < 0 || s >= this.list.list.size()) break;
                this.list.list.remove(s);
                this.select(-1);
                break;
            }
            default: {
                super.func_146284_a(b);
            }
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
        NBTTagCompound nbt = this.getSel();
        if (nbt == null) {
            return;
        }
        switch (id) {
            case 7: {
                nbt.func_74774_a("extB", (byte)Math.round(value));
                break;
            }
            case 8: {
                nbt.func_74774_a("extT", (byte)Math.round(value));
            }
        }
    }

    public void func_175319_a(int id, String value) {
        NBTTagCompound nbt = this.getSel();
        if (nbt == null) {
            return;
        }
        switch (id) {
            case 4: {
                nbt.func_74778_a("block", value);
                break;
            }
            case 5: {
                try {
                    nbt.func_74774_a("minY", (byte)Integer.parseInt(value));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 6: {
                try {
                    nbt.func_74774_a("maxY", (byte)(Integer.parseInt(value) - 1));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public void func_146281_b() {
        NBTTagList tl = new NBTTagList();
        for (Layer l : this.list.list) {
            tl.func_74742_a((NBTBase)l.nbt);
        }
        this.cfg.deserializeNBT((NBTBase)tl);
        super.func_146281_b();
    }

    static class Layer
    implements IDrawableEntry {
        final NBTTagCompound nbt;

        Layer(NBTTagCompound nbt) {
            this.nbt = nbt;
        }

        @Override
        public void draw(Minecraft mc, int x, int y, int w, int h, float t) {
            int min = (this.nbt.func_74771_c("minY") & 0xFF) - (this.nbt.func_74771_c("extB") & 0xFF);
            int max = (this.nbt.func_74771_c("maxY") & 0xFF) + (this.nbt.func_74771_c("extT") & 0xFF) + 1;
            mc.field_71466_p.func_78276_b(TooltipUtil.format((String)("dimstack.gen." + this.nbt.func_74779_i("id")), (Object[])new Object[]{min, max}), x + h + 2, y + (h - mc.field_71466_p.field_78288_b) / 2, -256);
            String block = this.nbt.func_74779_i("block");
            RenderUtil.drawPortrait(BlockPredicate.parse(block), x + 1, y, 0.0f, h);
        }
    }
}

