/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.servercreatorbanner.data.api;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class JarGroupData
implements Comparable<JarGroupData> {
    public final String name;
    public final ResourceLocation iconId;
    public final BufferedImage iconImage;
    public final Map<String, JarData> premiumJars = new HashMap<String, JarData>();
    public final Map<String, JarData> budgetJars = new HashMap<String, JarData>();
    public final boolean ignore;

    public JarGroupData(String name, ResourceLocation iconId, BufferedImage iconImage, List<JarData> jars, boolean ignore) {
        this.name = name;
        this.iconId = iconId;
        this.iconImage = iconImage;
        jars.forEach(jar -> {
            this.premiumJars.put(jar.premiumJarId, (JarData)jar);
            this.budgetJars.put(jar.budgetJarId, (JarData)jar);
        });
        this.ignore = ignore;
    }

    public static JarGroupData fromJson(String groupName, JsonObject json) {
        ArrayList<JarData> jars = new ArrayList<JarData>();
        json.entrySet().forEach(entry -> {
            String ids = (String)entry.getKey();
            String name = ((JsonElement)entry.getValue()).getAsString();
            jars.add(JarData.fromString(name, ids));
        });
        Pair<ResourceLocation, BufferedImage> icon = JarGroupData.getIcon(groupName);
        return new JarGroupData(groupName, (ResourceLocation)icon.getLeft(), (BufferedImage)icon.getRight(), jars, false);
    }

    public static JarGroupData fromString(String ids, String name) {
        return new JarGroupData(name, null, null, Collections.singletonList(JarData.fromString(name, ids)), true);
    }

    public static Pair<ResourceLocation, BufferedImage> getIcon(String group) {
        try {
            String groupName = group.replaceAll("[^a-zA-Z]+", "");
            ResourceLocation icon = ModRef.res("icons/" + groupName.toLowerCase(Locale.ROOT));
            String iconUrl = "https://www.bisecthosting.com/images/modpackicons/" + groupName + ".png";
            URLConnection urlConnection = new URL(iconUrl).openConnection();
            urlConnection.setRequestProperty("User-Agent", "BisectHosting Overwolf App");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Cache-Control", "no-cache");
            urlConnection.setRequestProperty("Pragma", "no-cache");
            return Pair.of((Object)icon, (Object)ImageIO.read(urlConnection.getInputStream()));
        }
        catch (IOException e) {
            ModRef.LOGGER.warn("Failed to download icon for " + group);
            return Pair.of(null, null);
        }
        catch (Exception e) {
            ModRef.LOGGER.warn("Failed to load icon for " + group, (Throwable)e);
            return Pair.of(null, null);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JarGroupData{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", premiumJars=").append(this.premiumJars);
        sb.append(", budgetJars=").append(this.budgetJars);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(JarGroupData o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public static class JarData
    implements Comparable<JarData> {
        public final String name;
        public final String premiumJarId;
        public final String budgetJarId;

        public JarData(String name, String premiumJarId, String budgetJarId) {
            this.name = name;
            this.premiumJarId = premiumJarId;
            this.budgetJarId = budgetJarId;
        }

        public static JarData fromString(String name, String ids) {
            String[] split = ids.split(",");
            return new JarData(name, split[0], split[1]);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("JarData{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", premiumJarId=").append(this.premiumJarId);
            sb.append(", budgetJarId=").append(this.budgetJarId);
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int compareTo(JarData o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }
}

