/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.bloodmoon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import lumien.bloodmoon.config.BloodmoonConfig;
import lumien.bloodmoon.server.BloodmoonSpawner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BloodmoonSpawner.class})
public abstract class BloodmoonSpawnerMixin {
    @Shadow(remap=false)
    @Final
    private Set<ChunkPos> eligibleChunksForSpawning;
    @Shadow(remap=false)
    @Final
    private static int MOB_COUNT_DIV;

    @Shadow(remap=false)
    protected static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        return null;
    }

    @Shadow(remap=false)
    public static boolean canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType spawnPlacementTypeIn, World worldIn, BlockPos pos) {
        return false;
    }

    @Overwrite(remap=false)
    public int findChunksForSpawning(WorldServer worldServerIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        int i = 0;
        for (EntityPlayer entityplayer : worldServerIn.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int l = 8;
            for (int i1 = -l; i1 <= l; ++i1) {
                for (int j1 = -l; j1 <= l; ++j1) {
                    PlayerChunkMapEntry playermanager$playerinstance;
                    boolean flag = i1 == -l || i1 == l || j1 == -l || j1 == l;
                    ChunkPos chunkpos = new ChunkPos(i1 + j, j1 + k);
                    if (this.eligibleChunksForSpawning.contains(chunkpos)) continue;
                    ++i;
                    if (flag || !worldServerIn.func_175723_af().func_177730_a(chunkpos) || (playermanager$playerinstance = worldServerIn.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playermanager$playerinstance.func_187274_e() || !worldServerIn.func_72863_F().func_73149_a(chunkpos.field_77276_a, chunkpos.field_77275_b)) continue;
                    this.eligibleChunksForSpawning.add(chunkpos);
                }
            }
        }
        int j4 = 0;
        BlockPos blockpos1 = worldServerIn.func_175694_M();
        for (EnumCreatureType enumcreaturetype : EnumCreatureType.values()) {
            if (enumcreaturetype.func_75599_d() && !spawnPeacefulMobs || !enumcreaturetype.func_75599_d() && !spawnHostileMobs || enumcreaturetype.func_82705_e() && !spawnOnSetTickRate) continue;
            int k4 = worldServerIn.countEntities(enumcreaturetype, true);
            int spawnLimit = enumcreaturetype.func_75601_b() * i / MOB_COUNT_DIV;
            if (k4 > (spawnLimit *= BloodmoonConfig.SPAWNING.SPAWN_LIMIT_MULT)) continue;
            ArrayList shuffled = Lists.newArrayList(this.eligibleChunksForSpawning);
            Collections.shuffle(shuffled);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            block6: for (ChunkPos chunkcoordintpair1 : shuffled) {
                BlockPos blockpos = BloodmoonSpawnerMixin.getRandomChunkPosition((World)worldServerIn, chunkcoordintpair1.field_77276_a, chunkcoordintpair1.field_77275_b);
                int k1 = blockpos.func_177958_n();
                int l1 = blockpos.func_177956_o();
                int i2 = blockpos.func_177952_p();
                IBlockState iblockstate = worldServerIn.func_180495_p(blockpos);
                if (iblockstate.func_185915_l()) continue;
                int j2 = 0;
                block7: for (int k2 = 0; k2 < 3; ++k2) {
                    int l2 = k1;
                    int i3 = l1;
                    int j3 = i2;
                    int k3 = 6;
                    Biome.SpawnListEntry biomegenbase$spawnlistentry = null;
                    IEntityLivingData ientitylivingdata = null;
                    int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                    for (int i4 = 0; i4 < l3; ++i4) {
                        EntityLiving entityliving;
                        blockpos$mutableblockpos.func_181079_c(l2 += worldServerIn.field_73012_v.nextInt(k3) - worldServerIn.field_73012_v.nextInt(k3), i3 += worldServerIn.field_73012_v.nextInt(1) - worldServerIn.field_73012_v.nextInt(1), j3 += worldServerIn.field_73012_v.nextInt(k3) - worldServerIn.field_73012_v.nextInt(k3));
                        float f = (float)l2 + 0.5f;
                        float f1 = (float)j3 + 0.5f;
                        if (!(blockpos1.func_177954_c((double)f, (double)i3, (double)f1) >= (double)(BloodmoonConfig.SPAWNING.SPAWN_DISTANCE * BloodmoonConfig.SPAWNING.SPAWN_DISTANCE)) || worldServerIn.func_175636_b((double)f, (double)i3, (double)f1, (double)BloodmoonConfig.SPAWNING.SPAWN_RANGE) || !worldServerIn.func_175710_j((BlockPos)blockpos$mutableblockpos)) continue;
                        if (!(biomegenbase$spawnlistentry != null || (biomegenbase$spawnlistentry = worldServerIn.func_175734_a(enumcreaturetype, (BlockPos)blockpos$mutableblockpos)) != null && BloodmoonConfig.canSpawn((Class)biomegenbase$spawnlistentry.field_76300_b))) {
                            biomegenbase$spawnlistentry = null;
                            continue block7;
                        }
                        if (!worldServerIn.func_175732_a(enumcreaturetype, biomegenbase$spawnlistentry, (BlockPos)blockpos$mutableblockpos) || !BloodmoonSpawnerMixin.canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.func_180109_a((Class)biomegenbase$spawnlistentry.field_76300_b), (World)worldServerIn, (BlockPos)blockpos$mutableblockpos)) continue;
                        try {
                            entityliving = biomegenbase$spawnlistentry.newInstance((World)worldServerIn);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return j4;
                        }
                        entityliving.func_70012_b((double)f, (double)i3, (double)f1, worldServerIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)i3, (float)f1, (boolean)false);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi() && entityliving.func_70058_J()) {
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)l3, (float)f1)) {
                                ientitylivingdata = entityliving.func_180482_a(worldServerIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata);
                            }
                            if (entityliving.func_70058_J()) {
                                ++j2;
                                entityliving.getEntityData().func_74757_a("bloodmoonSpawned", true);
                                worldServerIn.func_72838_d((Entity)entityliving);
                            } else {
                                entityliving.func_70106_y();
                            }
                            if (i2 >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving)) continue block6;
                        }
                        j4 += j2;
                    }
                }
            }
        }
        return j4;
    }
}

