/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.handlers;

import com.google.common.collect.BiMap;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;
import rlmixins.RLMixins;

@Config(modid="rlmixins")
public class ForgeConfigHandler {
    private static List<String> netherBaneMobs = null;
    private static List<String> netherBaneWeapons = null;
    private static List<String> particleCollisionClasses = null;
    private static HashSet<String> mineshaftBiomeNames = null;
    private static HashSet<BiomeDictionary.Type> mineshaftBiomeTypes = null;
    private static HashSet<Block> dramaticTreeNonSolidList = null;
    private static HashSet<Block> dramaticTreeNonSolidBreakableList = null;
    private static HashSet<Block> dramaticTreeSolidBreakableList = null;
    private static HashSet<ResourceLocation> dregoraArrowAllowedEntities = null;
    private static List<PotionType> dregoraArrowAllowedPotionTypes = null;
    private static Map<Integer, IBlockState> dimensionBlockFillerMap = null;
    private static HashSet<Block> caveRavineCarverSet = null;
    @Config.Comment(value={"Additional Server-Side Options"})
    @Config.Name(value="Server Options")
    public static final ServerConfig server = new ServerConfig();
    @Config.Comment(value={"Additional Client-Side Options"})
    @Config.Name(value="Client Options")
    public static final ClientConfig client = new ClientConfig();
    @Config.Comment(value={"Enable/Disable Tweaks and Patches"})
    @Config.Name(value="Toggle Mixins")
    public static final MixinConfig mixinConfig = new MixinConfig();
    private static File configFile = null;
    private static String configBooleanString = "";

    public static List<String> getNetherBaneMobs() {
        if (netherBaneMobs == null) {
            netherBaneMobs = Arrays.asList(ForgeConfigHandler.server.netherBaneMobs);
        }
        return netherBaneMobs;
    }

    public static List<String> getNetherBaneWeapons() {
        if (netherBaneWeapons == null) {
            netherBaneWeapons = Arrays.asList(ForgeConfigHandler.server.netherBaneWeapons);
        }
        return netherBaneWeapons;
    }

    public static List<String> getParticleCollisionClasses() {
        if (particleCollisionClasses == null) {
            particleCollisionClasses = Arrays.asList(ForgeConfigHandler.client.particleCollisionArray);
        }
        return particleCollisionClasses;
    }

    public static HashSet<String> getMineshaftBiomeNameBlacklist() {
        if (mineshaftBiomeNames == null) {
            mineshaftBiomeNames = new HashSet<String>(Arrays.asList(ForgeConfigHandler.server.mineshaftBiomeNameBlacklist));
        }
        return mineshaftBiomeNames;
    }

    public static HashSet<BiomeDictionary.Type> getMineshaftBiomeTypesBlacklist() {
        if (mineshaftBiomeTypes == null) {
            mineshaftBiomeTypes = new HashSet();
            for (String string : ForgeConfigHandler.server.mineshaftBiomeTypeBlacklist) {
                mineshaftBiomeTypes.add(BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
            }
        }
        return mineshaftBiomeTypes;
    }

    public static HashSet<Block> getDramaticTreeNonSolidList() {
        if (dramaticTreeNonSolidList == null) {
            dramaticTreeNonSolidList = new HashSet();
            for (String string : ForgeConfigHandler.server.dramaticTreesNonSolidBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
                if (block == null || block == Blocks.field_150350_a) {
                    RLMixins.LOGGER.log(Level.WARN, "RLMixins DramaticTree Non-Solid list invalid block: " + string + ", ignoring.");
                    continue;
                }
                dramaticTreeNonSolidList.add(block);
            }
        }
        return dramaticTreeNonSolidList;
    }

    public static HashSet<Block> getDramaticTreeNonSolidBreakableList() {
        if (dramaticTreeNonSolidBreakableList == null) {
            dramaticTreeNonSolidBreakableList = new HashSet();
            for (String string : ForgeConfigHandler.server.dramaticTreesNonSolidBreakableBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
                if (block == null || block == Blocks.field_150350_a) {
                    RLMixins.LOGGER.log(Level.WARN, "RLMixins DramaticTree Non-Solid Breakable list invalid block: " + string + ", ignoring.");
                    continue;
                }
                dramaticTreeNonSolidBreakableList.add(block);
            }
        }
        return dramaticTreeNonSolidBreakableList;
    }

    public static HashSet<Block> getDramaticTreeSolidBreakableList() {
        if (dramaticTreeSolidBreakableList == null) {
            dramaticTreeSolidBreakableList = new HashSet();
            for (String string : ForgeConfigHandler.server.dramaticTreesSolidBreakableBlocks) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(string));
                if (block == null || block == Blocks.field_150350_a) {
                    RLMixins.LOGGER.log(Level.WARN, "RLMixins DramaticTree Solid Breakable list invalid block: " + string + ", ignoring.");
                    continue;
                }
                dramaticTreeSolidBreakableList.add(block);
            }
        }
        return dramaticTreeSolidBreakableList;
    }

    public static HashSet<ResourceLocation> getDregoraArrowAllowedEntities() {
        if (dregoraArrowAllowedEntities == null) {
            HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
            for (String entity : ForgeConfigHandler.server.dregoraTippedArrowEntities) {
                set.add(new ResourceLocation(entity));
            }
            dregoraArrowAllowedEntities = set;
        }
        return dregoraArrowAllowedEntities;
    }

    public static List<PotionType> getDregoraArrowAllowedPotionTypes() {
        if (dregoraArrowAllowedPotionTypes == null) {
            ArrayList<PotionType> list = new ArrayList<PotionType>();
            for (String string : ForgeConfigHandler.server.dregoraTippedArrowPotionTypes) {
                PotionType type = PotionType.func_185168_a((String)string);
                if (type == null) {
                    RLMixins.LOGGER.log(Level.WARN, "RLMixins Dregora Arrow PotionTypes invalid PotionType: " + string + ", ignoring.");
                    continue;
                }
                list.add(type);
            }
            dregoraArrowAllowedPotionTypes = list;
        }
        return dregoraArrowAllowedPotionTypes;
    }

    public static IBlockState getDimensionFillerBlock(int dimension) {
        if (dimensionBlockFillerMap == null) {
            dimensionBlockFillerMap = new HashMap<Integer, IBlockState>();
            for (String entry : ForgeConfigHandler.server.dimensionFillerBlockList) {
                try {
                    ResourceLocation loc;
                    Block block;
                    String[] arr;
                    if (entry.isEmpty() || (arr = entry.split(",")).length != 2) continue;
                    int id = Integer.parseInt(arr[0].trim());
                    String name = arr[1].trim();
                    if (name.isEmpty() || (block = (Block)ForgeRegistries.BLOCKS.getValue(loc = new ResourceLocation(name))) == null) continue;
                    dimensionBlockFillerMap.put(id, block.func_176223_P());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return dimensionBlockFillerMap.get(dimension);
    }

    public static boolean isBlockCarvable(Block blockIn) {
        if (caveRavineCarverSet == null) {
            caveRavineCarverSet = new HashSet();
            for (String entry : ForgeConfigHandler.server.caveRavineCarverList) {
                try {
                    ResourceLocation loc;
                    Block block;
                    String name;
                    if (entry.isEmpty() || (name = entry.trim()).isEmpty() || (block = (Block)ForgeRegistries.BLOCKS.getValue(loc = new ResourceLocation(name))) == null) continue;
                    caveRavineCarverSet.add(block);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return caveRavineCarverSet.contains(blockIn);
    }

    public static boolean getBoolean(String name) {
        if (configFile == null && (configFile = new File("config", "rlmixins.cfg")).exists() && configFile.isFile()) {
            try (Stream<String> stream = Files.lines(configFile.toPath());){
                configBooleanString = stream.filter(s -> s.trim().startsWith("B:")).collect(Collectors.joining());
            }
            catch (Exception ex) {
                RLMixins.LOGGER.log(Level.ERROR, "Failed to parse RLMixins config: " + ex);
            }
        }
        return configBooleanString.contains("B:\"" + name + "\"=true");
    }

    @Mod.EventBusSubscriber(modid="rlmixins")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("rlmixins")) {
                netherBaneMobs = null;
                netherBaneWeapons = null;
                particleCollisionClasses = null;
                mineshaftBiomeNames = null;
                mineshaftBiomeTypes = null;
                dramaticTreeNonSolidList = null;
                dramaticTreeNonSolidBreakableList = null;
                dramaticTreeSolidBreakableList = null;
                dregoraArrowAllowedEntities = null;
                ConfigManager.sync((String)"rlmixins", (Config.Type)Config.Type.INSTANCE);
                EventHandler.refreshValues();
            }
        }

        private static void refreshValues() {
            if (ForgeConfigHandler.mixinConfig.allowModifyGamma) {
                RLMixins.PROXY.setGamma(ForgeConfigHandler.client.minGamma, ForgeConfigHandler.client.maxGamma);
            }
            if (ForgeConfigHandler.server.allowEntityViewDistanceOverride) {
                try {
                    Field regField = EntityRegistry.instance().getClass().getDeclaredField("entityClassRegistrations");
                    regField.setAccessible(true);
                    BiMap reg = (BiMap)regField.get(EntityRegistry.instance());
                    for (EntityRegistry.EntityRegistration entity : reg.values()) {
                        Optional<Integer> boost = EventHandler.getRenderBoost(entity.getRegistryName());
                        if (!boost.isPresent()) continue;
                        Field rangeField = entity.getClass().getDeclaredField("trackingRange");
                        rangeField.setAccessible(true);
                        rangeField.set(entity, boost.get());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static Optional<Integer> getRenderBoost(ResourceLocation id) {
            if (id == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(ForgeConfigHandler.server.entityViewDistanceList.get(id.toString()));
        }
    }

    public static class ClientConfig {
        @Config.Comment(value={"Minimum Gamma value for brightness"})
        @Config.Name(value="Minimum Gamma Value")
        public float minGamma = 0.0f;
        @Config.Comment(value={"Maximum Gamma value for brightness"})
        @Config.Name(value="Maximum Gamma Value")
        public float maxGamma = 1.0f;
        @Config.Comment(value={"List of particle classes to keep collision enabled for"})
        @Config.Name(value="Particle Collision Classes")
        public String[] particleCollisionArray = new String[]{""};
    }

    public static class ServerConfig {
        @Config.Comment(value={"Item Blacklist for the Hungry Farmer trait."})
        @Config.Name(value="Hungry Farmer Blacklist")
        public String[] hungryFarmerBlacklist = new String[]{""};
        @Config.Comment(value={"Potion Blacklist for Tipped Arrows."})
        @Config.Name(value="Tipped Arrow Blacklist")
        public String[] tippedArrowBlacklist = new String[]{""};
        @Config.Comment(value={"How many blocks to reduce fall distance by per tick in water"})
        @Config.Name(value="Fall Distance Reduction in Water")
        @Config.RangeDouble(min=1.0, max=100.0)
        public double fallDistanceReduction = 4.0;
        @Config.Comment(value={"Register the Encumbered potion effect (Requires PotionCore)"})
        @Config.Name(value="Register Encumbered")
        @Config.RequiresMcRestart
        public boolean registerEncumbered = false;
        @Config.Comment(value={"Add and register Steel armor with custom models"})
        @Config.Name(value="Register Steel Armor")
        @Config.RequiresMcRestart
        public boolean registerSteelArmor = false;
        @Config.Comment(value={"Add and register Scarlite armor with custom models"})
        @Config.Name(value="Register Scarlite Armor")
        @Config.RequiresMcRestart
        public boolean registerScarliteArmor = false;
        @Config.Comment(value={"Add and register Antimagic Talisman, and a recipe for crafting it with enchanted items"})
        @Config.Name(value="Register Antimagic Talisman")
        @Config.RequiresMcRestart
        public boolean registerAntimagicTalisman = false;
        @Config.Comment(value={"Add and register Cleansing Talisman, a recipe for crafting a Curse Break book, and the Curse Break potion"})
        @Config.Name(value="Register Cleansing Talisman (Charm)")
        @Config.RequiresMcRestart
        public boolean registerCleansingTalisman = false;
        @Config.Comment(value={"Register the Lesser Fire Resistance potion effect"})
        @Config.Name(value="Register Lesser Fire Resistance")
        @Config.RequiresMcRestart
        public boolean registerLesserFireResistance = false;
        @Config.Comment(value={"Enables the Nether Bane weapon effect to deal bonus damage to nether mobs"})
        @Config.Name(value="Enable Nether Bane (Requires RLCombat)")
        @Config.RequiresMcRestart
        public boolean enableNetherBane = false;
        @Config.Comment(value={"List of mobs to be classed as nether-mobs for the Nether Bane effect"})
        @Config.Name(value="Nether Bane Mob List")
        public String[] netherBaneMobs = new String[]{"minecraft:wither_skeleton", "minecraft:zombie_pigman", "minecraft:blaze", "minecraft:magma_cube", "minecraft:wither"};
        @Config.Comment(value={"List of weapons to have the Nether Bane effect"})
        @Config.Name(value="Nether Bane Weapon List")
        public String[] netherBaneWeapons = new String[]{""};
        @Config.Comment(value={"If true, Nether Bane effect will multiply damage, if false, additive"})
        @Config.Name(value="Nether Bane Multiply/Add")
        public boolean netherBaneMultiply = false;
        @Config.Comment(value={"Value to either multiply damage by or add to damage for the Nether Bane effect"})
        @Config.Name(value="Nether Bane Damage Value")
        public double netherBaneValue = 4.0;
        @Config.Comment(value={"If true, Cobalt Shield will cancel knockback events, instead of only applying an attribute"})
        @Config.Name(value="Cobalt Shield Cancels Knockback (Bountiful Bauble)")
        @Config.RequiresMcRestart
        public boolean cobaltShieldCancelsKnockback = false;
        @Config.Comment(value={"Fixes squid and cow milking cooldowns"})
        @Config.Name(value="Milking Cooldown Fix (Inspirations)")
        @Config.RequiresMcRestart
        public boolean milkingFix = false;
        @Config.Comment(value={"Registers the Cow Potion effect"})
        @Config.Name(value="Register Cow Potion")
        @Config.RequiresMcRestart
        public boolean registerCowPotion = false;
        @Config.Comment(value={"Maximum Modifier for Nunchaku (Damage * (1+this))"})
        @Config.Name(value="Nunchaku Combo Max Modifier")
        public float nunchakuComboMaxModifier = 1.0f;
        @Config.Comment(value={"Makes the Ice/Fire blood recipes retain enchantments and repair cost, optional compatibility for BetterSurvival (Except for Spear) and SpartanFire (You will still need to remove the original recipes with CraftTweaker.)"})
        @Config.Name(value="Register Enchantment Sensitive Flame/Ice Weapon Recipes (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean registerEnchantmentSensitiveFlameIceWeapon = false;
        @Config.Comment(value={"Makes Advanced Mending incompatible with Infinity (Requires SME Overhaul Mixin)"})
        @Config.Name(value="Advanced Mending Infinity Restriction")
        @Config.RequiresMcRestart
        public boolean advMendingInfinityRestrict = true;
        @Config.Comment(value={"Makes Advanced Mending prioritize damaged items first (Requires SME Overhaul Mixin)"})
        @Config.Name(value="Advanced Mending Damaged Priority")
        @Config.RequiresMcRestart
        public boolean advMendingDamagedPriority = true;
        @Config.Comment(value={"Effect given by Scarlite Sword when hitting an entity."})
        @Config.Name(value="Scarlite Sword Effect")
        public String scarliteSwordEffect = "lycanitesmobs:leech";
        @Config.Comment(value={"Duration of effect given by Scarlite Sword when hitting an entity"})
        @Config.Name(value="Scarlite Sword Effect Duration")
        @Config.RangeInt(min=1, max=1200)
        public int scarliteSwordDuration = 20;
        @Config.Comment(value={"Amplifier of effect given by Scarlite Sword when hitting an entity"})
        @Config.Name(value="Scarlite Sword Effect Amplifier")
        @Config.RangeInt(min=0, max=10)
        public int scarliteSwordAmplifier = 1;
        @Config.Comment(value={"Effect given by Parasite Cleaver when hitting an entity."})
        @Config.Name(value="Parasite Cleaver Effect")
        public String parasiteCleaverEffect = "potioncore:vulnerable";
        @Config.Comment(value={"Amplifier given by Living Cleaver when hitting an entity."})
        @Config.Name(value="Living Cleaver Amplifier")
        @Config.RangeInt(min=0, max=10)
        public int livingCleaverAmplifier = 0;
        @Config.Comment(value={"Amplifier given by Sentient Cleaver when hitting an entity."})
        @Config.Name(value="Sentient Cleaver Amplifier")
        @Config.RangeInt(min=0, max=10)
        public int sentientCleaverAmplifier = 1;
        @Config.Comment(value={"Makes Parasite armor cure/lower the effect of Fear"})
        @Config.Name(value="Parasite Armor Fear Curing")
        @Config.RequiresMcRestart
        public boolean parasiteArmorFearCuring = false;
        @Config.Comment(value={"Makes Parasite armor cure/lower the effect of Viral"})
        @Config.Name(value="Parasite Armor Viral Curing")
        @Config.RequiresMcRestart
        public boolean parasiteArmorViralCuring = false;
        @Config.Comment(value={"Maximum amplifier of Fear while wearing Parasite armor (-1 = cures it)"})
        @Config.Name(value="Parasite Armor Fear Max Amplifier")
        @Config.RangeInt(min=-1, max=10)
        public int parasiteArmorFearMax = 1;
        @Config.Comment(value={"Maximum amplifier of Viral while wearing Parasite armor (-1 = cures it)"})
        @Config.Name(value="Parasite Armor Viral Max Amplifier")
        @Config.RangeInt(min=-1, max=10)
        public int parasiteArmorViralMax = 2;
        @Config.Comment(value={"Whether or not Atomic Deconstructor should attempt to replicate /kill damage (More effective, but may cause bugs)"})
        @Config.Name(value="Atomic Deconstructor /kill")
        public boolean atomicDeconstructorMaxDamage = false;
        @Config.Comment(value={"Whether or not Atomic Deconstructor should work on bosses (May cause bugs)"})
        @Config.Name(value="Atomic Deconstructor Works on Bosses")
        public boolean atomicDeconstructorBosses = false;
        @Config.Comment(value={"Every x ticks Spriggans attempt growing crops around them"})
        @Config.Name(value="Spriggan Farming Rate")
        public int sprigganFarmingRate = 20;
        @Config.Comment(value={"How many attempts will random respawning try to find a good spawn point. WARNING: Higher values will cause more lag on respawns"})
        @Config.Name(value="Random Respawn Protection Attempts")
        public int randomRespawnProt = 0;
        @Config.Comment(value={"If random respawning should attempt to avoid ocean biome spawns"})
        @Config.Name(value="Random Respawn Avoid Oceans")
        public boolean randomRespawnAvoidOcean = false;
        @Config.Comment(value={"Disallows all IMobs from entering carts/boats/astikor carts (Requires Boss Cart/Boat Cheese or Boss AstikorCart Cheese mixin enabled.)"})
        @Config.Name(value="All Mob Cart Cheese")
        public boolean mobCartCheese = false;
        @Config.Comment(value={"Makes lightning not destroy items"})
        @Config.Name(value="Stop Lightning Destroying Items")
        @Config.RequiresMcRestart
        public boolean lightningItemDestroyFix = false;
        @Config.Comment(value={"Allows for overriding entity view distances with alternate values"})
        @Config.Name(value="Allow Entity View Distance Override (Vanilla)")
        public boolean allowEntityViewDistanceOverride = false;
        @Config.Comment(value={"List of entities and the value of their view distance to override with in the format entityid=distance"})
        @Config.Name(value="Entity View Distance Override List")
        public Map<String, Integer> entityViewDistanceList = new HashMap<String, Integer>(){
            {
                this.put("battletowers:golem", 64);
            }
        };
        @Config.Comment(value={"Radius of spawn chunks to keep loaded in memory (-1 to load none, requires Spawn Chunk Radius Patch)"})
        @Config.Name(value="Spawn Chunk Radius")
        @Config.RangeInt(min=-1, max=8)
        public int spawnChunkRadius = 0;
        @Config.Comment(value={"Biome name blacklist to prevent Mineshafts from spawning"})
        @Config.Name(value="Mineshaft Biome Name Blacklist")
        public String[] mineshaftBiomeNameBlacklist = new String[]{""};
        @Config.Comment(value={"Biome type blacklist to prevent Mineshafts from spawning"})
        @Config.Name(value="Mineshaft Biome Type Blacklist")
        public String[] mineshaftBiomeTypeBlacklist = new String[]{""};
        @Config.Comment(value={"If the class names of blocks that are collided with that are considered solid should be printed to console"})
        @Config.Name(value="DramaticTrees Debug Collision Names")
        public boolean dramaticTreesCollisionNameDebug = false;
        @Config.Comment(value={"List of blocks for DramaticTrees to treat as non-solid when falling"})
        @Config.Name(value="DramaticTrees Non-Solid Blocks")
        public String[] dramaticTreesNonSolidBlocks = new String[]{"dynamictrees:leaves0", "minecraft:leaves", "minecraft:vine", "minecraft:double_plant", "minecraft:tallgrass", "notreepunching:loose_rock/stone", "notreepunching:loose_rock/sandstone"};
        @Config.Comment(value={"List of blocks from the non-solid list for DramaticTrees to break while falling"})
        @Config.Name(value="DramaticTrees Non-Solid Breakable Blocks")
        public String[] dramaticTreesNonSolidBreakableBlocks = new String[]{"dynamictrees:leaves0", "minecraft:leaves", "minecraft:vine", "minecraft:double_plant", "minecraft:tallgrass"};
        @Config.Comment(value={"List of blocks for DramaticTrees to treat as solid but still break while falling"})
        @Config.Name(value="DramaticTrees Solid Breakable Blocks")
        public String[] dramaticTreesSolidBreakableBlocks = new String[0];
        @Config.Comment(value={"If Rework Waystone Used Name Check is enabled, allows for removing Biome names from village waystones"})
        @Config.Name(value="Village Waystones Remove Biome Name")
        public boolean villageWaystoneRemoveBiome = false;
        @Config.Comment(value={"If Rework Waystone Used Name Check is enabled, allows for ignoring already used names, may further improve performance on large maps but results in repeated names"})
        @Config.Name(value="Waystones Ignore Used Names")
        public boolean waystonesIgnoreUsedNames = false;
        @Config.Comment(value={"Distance difference in a single tick that will cause Astikor Carts to become unpulled"})
        @Config.Name(value="Cart Distance Limit")
        public double cartDistanceLimit = 32.0;
        @Config.Comment(value={"If Stop Sleeping Resetting Weather MC-63340 is true, makes sleeping still reset the weather if it is actively raining/thundering"})
        @Config.Name(value="Fix Weather Reset on Sleep Conditionally")
        public boolean fixWeatherResetConditionally = false;
        @Config.Comment(value={"If Weather Timing is enabled, sets the range of how many ticks thunder will last, added to minimum"})
        @Config.Name(value="Thunder Duration Range Ticks")
        @Config.RangeInt(min=1200)
        public int thunderActiveRange = 12000;
        @Config.Comment(value={"If Weather Timing is enabled, sets the minimum amount of ticks thunder will last"})
        @Config.Name(value="Thunder Duration Minimum Ticks")
        @Config.RangeInt(min=1200)
        public int thunderActiveMinimum = 3600;
        @Config.Comment(value={"If Weather Timing is enabled, sets the range of how many ticks it will take for thunder to start, added to minimum"})
        @Config.Name(value="Thunder Time Until Start Range Ticks")
        @Config.RangeInt(min=1200)
        public int thunderInactiveRange = 168000;
        @Config.Comment(value={"If Weather Timing is enabled, sets the minimum amount of ticks it will take for thunder to start"})
        @Config.Name(value="Thunder Time Until Start Minimum Ticks")
        @Config.RangeInt(min=1200)
        public int thunderInactiveMinimum = 12000;
        @Config.Comment(value={"If Weather Timing is enabled, sets the range of how many ticks rain will last, added to minimum"})
        @Config.Name(value="Rain Duration Range Ticks")
        @Config.RangeInt(min=1200)
        public int rainActiveRange = 12000;
        @Config.Comment(value={"If Weather Timing is enabled, sets the minimum amount of ticks rain will last"})
        @Config.Name(value="Rain Duration Minimum Ticks")
        @Config.RangeInt(min=1200)
        public int rainActiveMinimum = 12000;
        @Config.Comment(value={"If Weather Timing is enabled, sets the range of how many ticks it will take for rain to start, added to minimum"})
        @Config.Name(value="Rain Time Until Start Range Ticks")
        @Config.RangeInt(min=1200)
        public int rainInactiveRange = 168000;
        @Config.Comment(value={"If Weather Timing is enabled, sets the minimum amount of ticks it will take for rain to start"})
        @Config.Name(value="Rain Time Until Start Minimum Ticks")
        @Config.RangeInt(min=1200)
        public int rainInactiveMinimum = 12000;
        @Config.Comment(value={"If enabled, handles certain scripts from Dregora through RLMixins instead, for improved performance"})
        @Config.Name(value="Handle Dregora Scripts")
        public boolean dregoraScriptHandling = false;
        @Config.Comment(value={"Chance for an entity to have its arrow replaced with a tipped arrow"})
        @Config.Name(value="Dregora Tipped Arrow Replacement Chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public float dregoraTippedArrowReplacementChance = 0.05f;
        @Config.Comment(value={"List of entities to allow randomly adding tipped arrows"})
        @Config.Name(value="Dregora Tipped Arrow Replacement Allowed Entities")
        public String[] dregoraTippedArrowEntities = new String[]{"minecraft:skeleton", "minecraft:wither_skeleton"};
        @Config.Comment(value={"List of potion types to be used for tipped arrows randomly added to entities"})
        @Config.Name(value="Dregora Tipped Arrow Replacement Allowed PotionTypes")
        public String[] dregoraTippedArrowPotionTypes = new String[]{"potioncore:strong_broken_armor", "potioncore:broken_armor", "potioncore:long_klutz", "potioncore:strong_klutz", "potioncore:klutz", "potioncore:dispel", "potioncore:strong_launch", "potioncore:launch", "potioncore:long_weight", "potioncore:long_broken_armor", "potioncore:spin", "potioncore:strong_spin", "potioncore:long_spin", "potioncore:curse", "potioncore:strong_curse", "quark:mining_fatigue", "quark:long_mining_fatigue", "quark:strong_mining_fatigue", "potioncore:disorganization", "srparasites:foster", "srparasites:coth", "srparasites:fear", "srparasites:res", "srparasites:corro", "srparasites:vira", "srparasites:rage", "srparasites:debar", "potioncore:magic_inhibition", "potioncore:weight", "potioncore:lightning", "potioncore:strong_explode", "potioncore:long_magic_inhibition", "potioncore:teleport", "potioncore:strong_teleport", "potioncore:teleport_surface", "potioncore:drown", "potioncore:long_drown", "potioncore:teleport_spawn", "potioncore:long_vulnerable", "potioncore:strong_vulnerable", "potioncore:vulnerable", "potioncore:long_rust", "potioncore:strong_rust", "potioncore:rust", "potioncore:long_perplexity", "potioncore:perplexity", "minecraft:long_slowness", "minecraft:slowness", "mujmajnkraftsbettersurvival:milk", "mujmajnkraftsbettersurvival:long_antiwarp", "mujmajnkraftsbettersurvival:antiwarp", "mujmajnkraftsbettersurvival:strong_decay", "mujmajnkraftsbettersurvival:long_decay", "mujmajnkraftsbettersurvival:decay", "mujmajnkraftsbettersurvival:long_blindness", "potioncore:long_blindness", "potioncore:nausea", "potioncore:long_nausea", "potioncore:levitation", "potioncore:strong_levitation", "potioncore:long_levitation", "potioncore:unluck", "potioncore:long_hunger", "potioncore:strong_hunger", "potioncore:hunger", "potioncore:long_wither", "potioncore:strong_wither", "potioncore:wither", "elenaidodge:long_sluggish", "elenaidodge:sluggish", "elenaidodge:strong_feeble", "minecraft:harming", "minecraft:strong_harming", "minecraft:poison", "minecraft:long_poison", "minecraft:strong_poison", "minecraft:long_weakness", "mujmajnkraftsbettersurvival:blindness", "elenaidodge:feeble", "elenaidodge:long_feeble", "potioncore:strong_magic_inhibition", "potioncore:strong_weight", "potioncore:fire", "potioncore:invert", "potioncore:long_broken_magic_shield", "potioncore:broken_magic_shield", "potioncore:strong_broken_magic_shield", "potioncore:strong_blindness", "potioncore:blindness", "potioncore:explode", "xat:extended_goblin", "xat:goblin"};
        @Config.Comment(value={"Changes the weight of Lucky Horseshoe in dungeon loot tables"})
        @Config.Name(value="Lucky Horseshoe Dungeon Weight")
        @Config.RangeInt(min=1)
        public int luckyHorseshoeWeight = 10;
        @Config.Comment(value={"Effect that drinking Ale should give"})
        @Config.Name(value="Ale Effect")
        public String aleEffect = "lycanitesmobs:immunization";
        @Config.Comment(value={"Maximum duration of the positive effect given by ale at quality 1.0"})
        @Config.Name(value="Ale Maximum Duration Positive")
        public float aleMaxDurationPositive = 12000.0f;
        @Config.Comment(value={"Maximum duration of the hunger effect given by ale below quality 0.5"})
        @Config.Name(value="Ale Maximum Duration Hunger")
        public float aleMaxDurationHunger = 6000.0f;
        @Config.Comment(value={"Maximum duration of the nausea effect given by ale below quality 0.5"})
        @Config.Name(value="Ale Maximum Duration Nausea")
        public float aleMaxDurationNausea = 6000.0f;
        @Config.Comment(value={"Inebriation chance when drinking ale"})
        @Config.Name(value="Ale Inebriation Chance")
        public float aleInebriationChance = 0.5f;
        @Config.Comment(value={"Effect that drinking Cider should give"})
        @Config.Name(value="Cider Effect")
        public String ciderEffect = "potioncore:magic_shield";
        @Config.Comment(value={"Maximum duration of the positive effect given by cider at quality 1.0"})
        @Config.Name(value="Cider Maximum Duration Positive")
        public float ciderMaxDurationPositive = 12000.0f;
        @Config.Comment(value={"Maximum duration of the poison effect given by cider below quality 0.5"})
        @Config.Name(value="Cider Maximum Duration Poison")
        public float ciderMaxDurationPoison = 1200.0f;
        @Config.Comment(value={"Maximum duration of the nausea effect given by cider below quality 0.5"})
        @Config.Name(value="Cider Maximum Duration Nausea")
        public float ciderMaxDurationNausea = 6000.0f;
        @Config.Comment(value={"Inebriation chance when drinking cider"})
        @Config.Name(value="Cider Inebriation Chance")
        public float ciderInebriationChance = 0.5f;
        @Config.Comment(value={"Maximum absorption given by iron wine at quality 1.0"})
        @Config.Name(value="Iron Wine Maximum Absorption")
        public float ironWineMaxAbsorption = 10.0f;
        @Config.Comment(value={"Maximum duration of the nausea effect given by iron wine below quality 0.5"})
        @Config.Name(value="Iron Wine Maximum Duration Nausea")
        public float ironWineMaxDurationNausea = 6000.0f;
        @Config.Comment(value={"Maximum damage given by iron wine below quality 0.5 (Plus 1)"})
        @Config.Name(value="Iron Wine Maximum Damage")
        public float ironWineMaxDamage = 5.0f;
        @Config.Comment(value={"Inebriation chance when drinking iron wine"})
        @Config.Name(value="Iron Wine Inebriation Chance")
        public float ironWineInebriationChance = 0.5f;
        @Config.Comment(value={"Effect that drinking Mead should give"})
        @Config.Name(value="Mead Effect")
        public String meadEffect = "lycanitesmobs:rejuvenation";
        @Config.Comment(value={"Maximum duration of the positive effect given by mead at quality 1.0"})
        @Config.Name(value="Mead Maximum Duration Positive")
        public float meadMaxDurationPositive = 6000.0f;
        @Config.Comment(value={"Maximum duration of the wither effect given by mead below quality 0.5"})
        @Config.Name(value="Mead Maximum Duration Wither")
        public float meadMaxDurationWither = 800.0f;
        @Config.Comment(value={"Maximum duration of the nausea effect given by mead below quality 0.5"})
        @Config.Name(value="Mead Maximum Duration Nausea")
        public float meadMaxDurationNausea = 6000.0f;
        @Config.Comment(value={"Inebriation chance when drinking mead"})
        @Config.Name(value="Mead Inebriation Chance")
        public float meadInebriationChance = 0.5f;
        @Config.Comment(value={"Maximum amplifier of the positive effect increased by wildberry wine above quality 0.5"})
        @Config.Name(value="Wildberry Wine Maximum Amplifier")
        public int wildberryWineMaxAmplifier = 2;
        @Config.Comment(value={"Maximum amplifier increase of the positive effect increased by wildberry wine above quality 0.5"})
        @Config.Name(value="Wildberry Wine Maximum Amplifier Increase")
        public int wildberryWineMaxAmplifierIncrease = 1;
        @Config.Comment(value={"Amplifier decrease of positive effects by wildberry wine below quality 0.5"})
        @Config.Name(value="Wildberry Wine Amplifier Decrease")
        public int wildberryWineAmplifierDecrease = 1;
        @Config.Comment(value={"Maximum duration of the nausea effect given by wildberry wine below quality 0.5"})
        @Config.Name(value="Wildberry Wine Maximum Duration Nausea")
        public float wildberryWineMaxDurationNausea = 6000.0f;
        @Config.Comment(value={"Inebriation chance when drinking wildberry wine"})
        @Config.Name(value="Wildberry Wine Inebriation Chance")
        public float wildberryWineInebriationChance = 0.5f;
        @Config.Comment(value={"Maximum duration increase of the positive effect increased by wine above quality 0.5"})
        @Config.Name(value="Wine Maximum Duration Increase")
        public float wineMaximumDurationIncrease = 2400.0f;
        @Config.Comment(value={"Maximum duration of the positive effect increased by wine above quality 0.5"})
        @Config.Name(value="Wine Maximum Duration")
        public float wineMaximumDuration = 12000.0f;
        @Config.Comment(value={"Maximum duration decrease of the positive effect decreased by wine below quality 0.5"})
        @Config.Name(value="Wine Maximum Duration Decrease")
        public float wineMaximumDurationDecrease = 2400.0f;
        @Config.Comment(value={"Maximum duration of the nausea effect given by wine below quality 0.5"})
        @Config.Name(value="Wine Maximum Duration Nausea")
        public float wineMaxDurationNausea = 6000.0f;
        @Config.Comment(value={"Inebriation chance when drinking wine"})
        @Config.Name(value="Wine Inebriation Chance")
        public float wineInebriationChance = 0.5f;
        @Config.Comment(value={"Chance per random tick for a corrupted block to attempt spreading, default mod chance is 1.0"})
        @Config.Name(value="Defiled Corruption Chance")
        public float defiledCorruptionChance = 0.5f;
        @Config.Comment(value={"Health multiplier for the Dregora Script Dragon"})
        @Config.Name(value="Dregora Script Dragon Health Multiplier")
        public float dregoraScriptDragonHealth = 0.5f;
        @Config.Comment(value={"Maximum amount of enchantment levels that bookwyrms can digest"})
        @Config.Name(value="BookWyrm Maximum Level")
        public int bookWyrmMaxLevel = 30;
        @Config.Comment(value={"Librarians will not be able to sell enchantments in this list"})
        @Config.Name(value="Librarian Enchant Trade Blacklist")
        public String[] blacklistedLibrarianEnchants = new String[0];
        @Config.Comment(value={"Librarian Enchant Trade Blacklist will be treated as a Whitelist"})
        @Config.Name(value="Librarian Enchant Trade Whitelist Toggle")
        public boolean blacklistedLibrarianEnchantsIsWhitelist = false;
        @Config.Comment(value={"Registers additional useful loot functions for json loot tables"})
        @Config.Name(value="Register Additional Loot Functions")
        @Config.RequiresMcRestart
        public boolean registerAdditionalLootFunctions = true;
        @Config.Comment(value={"Amount of seconds OTG's populate should wait to try to lock (Do not modify this if you do not know what you are doing.)"})
        @Config.Name(value="OTG Populate Lock Time")
        public int otgPopulateLockTime = 10;
        @Config.Comment(value={"Amount of seconds OTG's saveToDisk should wait to try to lock (Do not modify this if you do not know what you are doing.)"})
        @Config.Name(value="OTG SaveToDisk Lock Time")
        public int otgSaveToDiskLockTime = 10;
        @Config.Comment(value={"Items in this list will not be allowed to be worn as cosmetic armor"})
        @Config.Name(value="Cosmetic Armor Item Blacklist")
        public String[] cosmeticArmorItemBlacklist = new String[0];
        @Config.Comment(value={"Cosmetic Armor Item Blacklist will be treated as a Whitelist"})
        @Config.Name(value="Cosmetic Armor Item Whitelist Toggle")
        public boolean cosmeticArmorItemBlacklistIsWhitelist = false;
        @Config.Comment(value={"List of dimension ids and the block (Format: id,blockid) to override as the default filler block"})
        @Config.Name(value="Dimension Filler Block Override List")
        public String[] dimensionFillerBlockList = new String[0];
        @Config.Comment(value={"List of blocks to additionally allow caves and ravines to carve"})
        @Config.Name(value="Cave and Ravine Carver Block List")
        public String[] caveRavineCarverList = new String[0];
        @Config.Comment(value={"Upper limit for bedrock to attempt to generate"})
        @Config.Name(value="Bedrock Max Range")
        @Config.RangeInt(min=1)
        public int bedrockMaxRange = 5;
        @Config.Comment(value={"Random enchanting (loot and enchanting table) will not be able to generate enchantments in this list"})
        @Config.Name(value="Random Enchant Blacklist")
        public String[] blacklistedRandomEnchants = new String[0];
        @Config.Comment(value={"Random enchanting Blacklist will be treated as a Whitelist"})
        @Config.Name(value="Random Enchant Whitelist Toggle")
        public boolean blacklistedRandomEnchantsIsWhitelist = false;
    }

    public static class MixinConfig {
        @Config.Comment(value={"MC-119971 patch, created by EigenCraft Unofficial Patch"})
        @Config.Name(value="Outdated Chunk Data (Vanilla)")
        @Config.RequiresMcRestart
        public boolean outdatedChunkData = false;
        @Config.Comment(value={"Disallow Infernal/Blight/Champion mobs from entering Minecarts and Boats (Does not require all mods to be loaded.)"})
        @Config.Name(value="Boss Cart/Boat Cheese (Vanilla/InfernalMobs/ScalingHealth/Champions)")
        @Config.RequiresMcRestart
        public boolean bossCartCheesePatch = false;
        @Config.Comment(value={"Disallow Infernal/Blight/Champion mobs from entering Astikor Carts (Does not require all mods to be loaded except Astikor.)"})
        @Config.Name(value="Boss AstikorCart Cheese (Vanilla/AstikorCarts/InfernalMobs/ScalingHealth/Champions)")
        @Config.RequiresMcRestart
        public boolean astikorCartCheesePatch = false;
        @Config.Comment(value={"Force EntityLivingBase#attemptTeleport to cancel under the effects of AntiWarp"})
        @Config.Name(value="AntiWarp Handling (Vanilla/BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean antiwarpImprovement = false;
        @Config.Comment(value={"Makes fall distance reduction per tick in water configurable"})
        @Config.Name(value="Configurable Fall (Vanilla)")
        @Config.RequiresMcRestart
        public boolean configurableFallDistance = false;
        @Config.Comment(value={"Lower the player's eye height while crouching to be more like newer versions"})
        @Config.Name(value="Lowered Crouch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean lowerEyeHeight = false;
        @Config.Comment(value={"Patches issues with player health attributes being lowered between packets causing desynced death"})
        @Config.Name(value="Health Desync Patch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean healthAttributePatch = false;
        @Config.Comment(value={"Smooth eye height when crouching, created by RandomPatches"})
        @Config.Name(value="Smoothed Crouching (Vanilla)")
        @Config.RequiresMcRestart
        public boolean smoothCrouch = false;
        @Config.Comment(value={"Force Mending to prioritize damaged items first, instead of randomly picking"})
        @Config.Name(value="Mending Priorities (Vanilla)")
        @Config.RequiresMcRestart
        public boolean mendingPriorities = false;
        @Config.Comment(value={"Makes Chunk Animator stop animating around the player temporarily when using F3+A or changing render distance, to stop easy xray"})
        @Config.Name(value="ChunkAnimator XRay (Vanilla/ChunkAnimator)")
        @Config.RequiresMcRestart
        public boolean chunkAnimatorXRay = false;
        @Config.Comment(value={"Stops Anvils from displaying \"Too Expensive\" for compatibility with AnvilPatchLawful"})
        @Config.Name(value="Anvil Too Expensive (Vanilla/AnvilPatch)")
        @Config.RequiresMcRestart
        public boolean anvilTooExpensiveFix = false;
        @Config.Comment(value={"Directly modify Item attributes for certain SoManyEnchantments Enchantments"})
        @Config.Name(value="Enchantment Item Attributes (Vanilla/SME)")
        @Config.RequiresMcRestart
        public boolean enchantmentsModifyItemAttributes = false;
        @Config.Comment(value={"Directly modify ItemStack damage for certain SoManyEnchantments Enchantments"})
        @Config.Name(value="Enchantment ItemStack Damage (Vanilla/SME)")
        @Config.RequiresMcRestart
        public boolean enchantmentsModifyItemStackDamage = false;
        @Config.Comment(value={"Directly replaces getCanSpawn for Giant Zombies - allowing them to spawn"})
        @Config.Name(value="Giant Zombie Spawn Fix (Vanilla)")
        @Config.RequiresMcRestart
        public boolean giantZombieSpawnFix = false;
        @Config.Comment(value={"MC-92916 patch, created by EigenCraft Unofficial Patch"})
        @Config.Name(value="Entity Tracker Desync (Vanilla)")
        @Config.RequiresMcRestart
        public boolean entityTrackerDesyncPatch = false;
        @Config.Comment(value={"Fixes certain particles sent to the client from serverside never actually rendering, created by RandomPatches"})
        @Config.Name(value="Missing Particle Rendering (Vanilla)")
        @Config.RequiresMcRestart
        public boolean particleRenderPatch = false;
        @Config.Comment(value={"MC-108469 patch, created by EigenCraft Unofficial Patch"})
        @Config.Name(value="Chunk Entity List (Vanilla)")
        @Config.RequiresMcRestart
        public boolean chunkEntityListUpdate = false;
        @Config.Comment(value={"Overhaul a bunch of SoManyEnchantments Enchantment handlers to fix lag/bugs/offhand issues"})
        @Config.Name(value="Overhaul SME (Vanilla/SME/RLCombat)")
        @Config.RequiresMcRestart
        public boolean overhaulEnchants = false;
        @Config.Comment(value={"Force gathering rain into a canteen to give purified water instead of dirty water"})
        @Config.Name(value="Purified Rain Water (SimpleDifficulty)")
        @Config.RequiresMcRestart
        public boolean purifyRainWater = false;
        @Config.Comment(value={"Makes Coffee from Charm reduce the effects of Inebriation from Rustic instead of water"})
        @Config.Name(value="Coffee Cures Hangover (Rustic/Charm)")
        @Config.RequiresMcRestart
        public boolean coffeeInebriation = false;
        @Config.Comment(value={"Replace the effects of Ale, Cider, and Mead with config-defined effects"})
        @Config.Name(value="Config Alcohol Effects (Rustic)")
        @Config.RequiresMcRestart
        public boolean alcoholConfig = false;
        @Config.Comment(value={"Fixes Reskillable losing track of the player when returning from the end, causing baubles with level requirements to be lost"})
        @Config.Name(value="Player Tracking Patch (Reskillable)")
        @Config.RequiresMcRestart
        public boolean playerTrackingPatch = false;
        @Config.Comment(value={"Allows SeedFood to bypass being locked by Reskillable (Allows eating Potatos/Carrots but not planting them)"})
        @Config.Name(value="SeedFood Bypass Lock (Reskillable)")
        @Config.RequiresMcRestart
        public boolean seedFoodBypass = false;
        @Config.Comment(value={"Makes Golden Osmosis perk also repair Golden Book Wyrm armor"})
        @Config.Name(value="Wyrm Osmosis (Reskillable/DefiledLands)")
        @Config.RequiresMcRestart
        public boolean goldenBookWyrmOsmosis = false;
        @Config.Comment(value={"Adds a config defined blacklist for the Hungry Farmer perk"})
        @Config.Name(value="HungryFarmer Blacklist (Reskillable)")
        @Config.RequiresMcRestart
        public boolean hungryFarmerBlacklistAbility = false;
        @Config.Comment(value={"Reworks Undershirt perk to work properly with FirstAid"})
        @Config.Name(value="Undershirt Rework (Reskillable/FirstAid)")
        @Config.RequiresMcRestart
        public boolean undershirtRework = false;
        @Config.Comment(value={"Patches Dupe bug with Stonelings"})
        @Config.Name(value="Stoneling Dupe Patch (Quark)")
        @Config.RequiresMcRestart
        public boolean stonelingPatch = false;
        @Config.Comment(value={"Replaces Launch potion's effect from PotionCore with Delayed Launch, for compatibility with knockback effects"})
        @Config.Name(value="Delayed Launch (PotionCore)")
        @Config.RequiresMcRestart
        public boolean delayedLaunch = false;
        @Config.Comment(value={"Halves the effect of Reach potion"})
        @Config.Name(value="Half Reach (PotionCore)")
        @Config.RequiresMcRestart
        public boolean halfReach = false;
        @Config.Comment(value={"Modify the render bounding boxes of some Lycanite mobs to fix under/oversized render boxes"})
        @Config.Name(value="Lycanite Render Box (LycanitesMobs)")
        @Config.RequiresMcRestart
        public boolean lycaniteRenderBoxResize = false;
        @Config.Comment(value={"Stops Lycanite mobs from attempting to target mobs that are stone statues, or tagged with NoAI"})
        @Config.Name(value="Lycanite Targetting (LycanitesMobs/IceAndFire)")
        @Config.RequiresMcRestart
        public boolean lycaniteTargettingPatch = false;
        @Config.Comment(value={"Makes ItemPhysics use the player's reach attribute instead of a hardcoded value"})
        @Config.Name(value="Item Reach Attribute (ItemPhysics)")
        @Config.RequiresMcRestart
        public boolean itemReachAttribute = false;
        @Config.Comment(value={"Makes incorrectly mixing potions in an Inspirations cauldron turn into Mundane instead of Thick potion"})
        @Config.Name(value="Cauldron Failure Mundane (Inspirations)")
        @Config.RequiresMcRestart
        public boolean inspirationsMundaneCauldron = false;
        @Config.Comment(value={"Prevents Champion mobs from turning into Infernals as well"})
        @Config.Name(value="No Infernal Champions (Champions/InfernalMobs)")
        @Config.RequiresMcRestart
        public boolean preventChampionInfernals = false;
        @Config.Comment(value={"Stops Infernal Mobs from spamming particles while the game is paused"})
        @Config.Name(value="Infernal Particle Spam (InfernalMobs)")
        @Config.RequiresMcRestart
        public boolean infernalParticleSpam = false;
        @Config.Comment(value={"Adds the ability to define Dynamic Surroundings entity chat messages in a config file"})
        @Config.Name(value="Chat Bubble Config (DSurroundings)")
        @Config.RequiresMcRestart
        public boolean entityChatBubbleConfig = false;
        @Config.Comment(value={"Tags mobs spawned from Infested Champions as summoned, allowing for Trinkets and Baubles to cancel their xp/item drops"})
        @Config.Name(value="Infested Summon Tag (Champions/TrinketsAndBaubles)")
        @Config.RequiresMcRestart
        public boolean infestedSummonTags = false;
        @Config.Comment(value={"Increases the time that Jailer Champions apply the Jailed effect for, since the original mixes up seconds and ticks"})
        @Config.Name(value="Jailer Champion Time (Champions)")
        @Config.RequiresMcRestart
        public boolean jailerTimeFix = false;
        @Config.Comment(value={"Replace and rework the flare gun entity and handling"})
        @Config.Name(value="Flare Gun Rework (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean flareGunRework = false;
        @Config.Comment(value={"Rework the Broken Heart trinket to work with FirstAid"})
        @Config.Name(value="Broken Heart Rework (BountifulBaubles/FirstAid)")
        @Config.RequiresMcRestart
        public boolean brokenHeartRework = false;
        @Config.Comment(value={"Prevents trumpets from triggering the Gluttony amulet effect"})
        @Config.Name(value="Trumpet Gluttony (BountifulBaubles/TrumpetSkeleton)")
        @Config.RequiresMcRestart
        public boolean trumpetGluttonFix = false;
        @Config.Comment(value={"Rework Obsidian Skull/Shield fire resistance handling to be less buggy"})
        @Config.Name(value="Obsidian Skull/Shield Rework (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean obsidianResistanceRework = false;
        @Config.Comment(value={"Prevents the player from removing armor cursed with Binding in the reforging station"})
        @Config.Name(value="Reforging Binding Fix (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean reforgingBindingFix = false;
        @Config.Comment(value={"Replaces SRParasites Living and Sentient armor models with custom models"})
        @Config.Name(value="Replace Parasite Armor Models (SRParasites)")
        @Config.RequiresMcRestart
        public boolean replaceParasiteArmorModel = false;
        @Config.Comment(value={"Makes SRParasites Strange Bones stack to 16"})
        @Config.Name(value="Strange Bones stack to 16 (SRParasites)")
        @Config.RequiresMcRestart
        public boolean increaseStrangeBoneStackSize = false;
        @Config.Comment(value={"Ignore SRParasites spawning logic for Mob Spawners when using Evolution Phase Custom Spawner"})
        @Config.Name(value="Parasite Mob Spawner Fix (SRParasites)")
        @Config.RequiresMcRestart
        public boolean enableSRPSpawners = false;
        @Config.Comment(value={"Attempts to stop the ability to cheese dragons on the edge of render distance"})
        @Config.Name(value="Enable AntiDragon Cheese (IceAndFire)")
        @Config.RequiresMcRestart
        public boolean enableInFDragonCheese = false;
        @Config.Comment(value={"Cancels SRParasites manually packet handling for reach bonuses"})
        @Config.Name(value="Cancel Parasite Reach Packet (SRParasites)")
        @Config.RequiresMcRestart
        public boolean cancelParasiteReachPacket = false;
        @Config.Comment(value={"Makes Champions death messages use the Champion's name"})
        @Config.Name(value="Champion Death Message Tweak (Champions)")
        @Config.RequiresMcRestart
        public boolean championDeathMessage = false;
        @Config.Comment(value={"Makes Champions with potions use invisible particles"})
        @Config.Name(value="Champion Potion Invis (Champions)")
        @Config.RequiresMcRestart
        public boolean championPotionInvis = false;
        @Config.Comment(value={"Blacklists PotionCore Revival/1UP potion from affecting non-players, to prevent duping."})
        @Config.Name(value="Prevent Revival Potion on Non-Players (PotionCore)")
        @Config.RequiresMcRestart
        public boolean revivalPotionPlayerOnly = false;
        @Config.Comment(value={"Prevents Charm Crates from being inserted into Shulker Boxes, manually and by hopper."})
        @Config.Name(value="Prevent Shulker Crate Insertion (Vanilla/Charm)")
        @Config.RequiresMcRestart
        public boolean shulkerCrateInsertion = false;
        @Config.Comment(value={"Cancels Parasites attempting to run a custom spawn tick check. (Seems to help performance/spawning)"})
        @Config.Name(value="Parasite Spawn Fix (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteSpawnFix = false;
        @Config.Comment(value={"Makes parasite spawning ignore all light level if the ignore sunlight option is true."})
        @Config.Name(value="Parasite Light Level (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteLightLevel = false;
        @Config.Comment(value={"Makes nether portals not spawn zombie pigmen, to prevent farming."})
        @Config.Name(value="Stop Pigmen Portal Spawning (Vanilla)")
        @Config.RequiresMcRestart
        public boolean stopPigmenPortalSpawning = false;
        @Config.Comment(value={"Prevents hive blocks from being pushed by pistons, which could be exploited to mass produce Nether Wasps."})
        @Config.Name(value="Prevent Nether Wasp Farming (Vanilla/BOP)")
        @Config.RequiresMcRestart
        public boolean preventNetherWaspFarming = false;
        @Config.Comment(value={"Fixes BetterNether's food bowls from deleting whole stacks when eaten."})
        @Config.Name(value="Stalagnate Bowl Fix (BetterNether)")
        @Config.RequiresMcRestart
        public boolean stalagnateBowlFix = false;
        @Config.Comment(value={"Adds a blacklist to prevent certain potion effects from working on tipped arrows."})
        @Config.Name(value="Tipped Arrow Blacklist (Vanilla)")
        @Config.RequiresMcRestart
        public boolean tippedArrowBlacklist = false;
        @Config.Comment(value={"Modifies the Bountiful Baubles Cobalt Shield Knockback Resistance Attribute from 10 -> 1000."})
        @Config.Name(value="Cobalt Shield Increased Resistance (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean cobaltShieldIncreasedResistance = false;
        @Config.Comment(value={"Skips checking oversized AABB for collisions when teleporting long distances, causing extreme lag."})
        @Config.Name(value="EXPERIMENTAL: Teleporting Lag Patch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean teleportCollisionPatch = false;
        @Config.Comment(value={"Makes feathers not passively drop from chickens if they're stoned"})
        @Config.Name(value="Stoned Chicken Feather Fix (Quark/IceAndFire)")
        @Config.RequiresMcRestart
        public boolean chickenStonedFix = false;
        @Config.Comment(value={"Tweaks the values of the Education enchant."})
        @Config.Name(value="Education Tweak (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean educationTweak = false;
        @Config.Comment(value={"Removes the ability to add protection enchant to shields"})
        @Config.Name(value="Remove Shield Protection Enchant (Inspirations)")
        @Config.RequiresMcRestart
        public boolean inspirationsShieldEnchantRemove = false;
        @Config.Comment(value={"Attempts to fix a desync caused by ScalingHealth when a mob dies in the same tick it is spawned"})
        @Config.Name(value="ScalingHealth Death Desync (ScalingHealth)")
        @Config.RequiresMcRestart
        public boolean scalingHealthDesync = false;
        @Config.Comment(value={"Forces Quark's Right-Click sign edit to sync the config value from server to client to prevent desyncs (Thanks to Venom)"})
        @Config.Name(value="Sync Sign Edit Config (Quark)")
        @Config.RequiresMcRestart
        public boolean fixRightClickSignEdit = false;
        @Config.Comment(value={"Rehandles the Sentient Scythe's AOE effect to make it less ridiculous and more compatible with other effects"})
        @Config.Name(value="Rehandle Sentient Scythe Effect (SRParasites/RLCombat)")
        @Config.RequiresMcRestart
        public boolean rehandleSentientScythe = false;
        @Config.Comment(value={"Makes Strays and Husks ignore whether or not they can see the sky when spawning"})
        @Config.Name(value="Stray/Husk Sky Spawning Fix (Vanilla)")
        @Config.RequiresMcRestart
        public boolean strayHuskSpawningFix = false;
        @Config.Comment(value={"Makes curing Zombie Villagers and pig lightning conversion count as a kill for Mob Spawner Control spawners"})
        @Config.Name(value="Zombie Curing Ticks Spawners (Vanilla/MobSpawnerControl)")
        @Config.RequiresMcRestart
        public boolean curingTicksSpawners = false;
        @Config.Comment(value={"Fixes Dragonbone Bow duping arrows with the BetterSurvival Multishot enchant"})
        @Config.Name(value="InF Bow Multishot patch (IceAndFire/BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean dragonboneBowMultishot = false;
        @Config.Comment(value={"Allows for modifying the combo multiplier of Nunchaku"})
        @Config.Name(value="Changeable Nunchaku Combo (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean nunchakuComboModifier = false;
        @Config.Comment(value={"Fixes Vampirism from Better Survival healing the player when hitting non-living entities"})
        @Config.Name(value="Vampirism Cheese Patch (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean vampirismCheese = false;
        @Config.Comment(value={"Fixes Quark boat chests duping"})
        @Config.Name(value="Quark Chest Boat Dupe (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkChestBoatDupe = false;
        @Config.Comment(value={"Fixes dupe issues with the Locks keyring"})
        @Config.Name(value="Locks Keyring GUI Dupe Patch (Locks)")
        @Config.RequiresMcRestart
        public boolean locksGuiDupe = false;
        @Config.Comment(value={"Fixes dupe issues with the ToolBelt belt"})
        @Config.Name(value="ToolBelt Belt GUI Dupe Patch (ToolBelt)")
        @Config.RequiresMcRestart
        public boolean toolbeltGuiDupe = false;
        @Config.Comment(value={"Fixes not being able to use Iron Canteen and Dragon Canteen on Rain Collectors"})
        @Config.Name(value="Rain Collector Canteen Fix (SimpleDifficulty)")
        @Config.RequiresMcRestart
        public boolean canteenFix = false;
        @Config.Comment(value={"Fixes the clay tool from NTP being abusable for guaranteed unbreaking enchantments"})
        @Config.Name(value="Clay Tool Enchant Patch (NoTreePunching)")
        @Config.RequiresMcRestart
        public boolean clayToolPatch = false;
        @Config.Comment(value={"Fixes the mattock from NTP not breaking when tilling ground"})
        @Config.Name(value="Mattock Breaking Patch (NoTreePunching)")
        @Config.RequiresMcRestart
        public boolean mattockPatch = false;
        @Config.Comment(value={"Fixes the quivers from Switchbow not closing when the quiver is dropped"})
        @Config.Name(value="Switchbow Quiver Patch (Switchbow)")
        @Config.RequiresMcRestart
        public boolean switchbowQuiverPatch = false;
        @Config.Comment(value={"Fix ForgottenItems vein pickaxe mining tile entities and bypassing protection"})
        @Config.Name(value="Vein Pickaxe Patch (ForgottenItems)")
        @Config.RequiresMcRestart
        public boolean veinPickaxePatch = false;
        @Config.Comment(value={"Fix Reskillable cancelling indirect self damage"})
        @Config.Name(value="Reskillable Indirect Self Damage Patch (Reskillable)")
        @Config.RequiresMcRestart
        public boolean reskillableIndirectSelfDamage = false;
        @Config.Comment(value={"Replace the effect from the Scarlite Sword with a config-able effect"})
        @Config.Name(value="Scarlite Sword Config Effect (DefiledLands)")
        @Config.RequiresMcRestart
        public boolean scarliteSwordConfigEffect = false;
        @Config.Comment(value={"Fixes Disenchanting table crashing when broken while someone is still in the GUI"})
        @Config.Name(value="Disenchanting Table Crash Patch (Disenchanter)")
        @Config.RequiresMcRestart
        public boolean disenchantingCrash = false;
        @Config.Comment(value={"Fixes crashes caused by Quark's chat linking when items with large nbt are linked"})
        @Config.Name(value="Quark Chat Link NBT Crash (Quark)")
        @Config.RequiresMcRestart
        public boolean chatLinkCrash = false;
        @Config.Comment(value={"Makes potion effects actually display their values above amplifier 3 in the inventory"})
        @Config.Name(value="Potion Amplifier Visibility (Vanilla)")
        @Config.RequiresMcRestart
        public boolean potionAmplifierVisibility = false;
        @Config.Comment(value={"Makes potion effects actually display their values above amplifier 3 in dshud's display"})
        @Config.Name(value="Potion Amplifier Visibility (DSHuds)")
        @Config.RequiresMcRestart
        public boolean potionAmplifierVisibilityDSHud = false;
        @Config.Comment(value={"Replaces the Parasite Cleaver effect with a config defined effect"})
        @Config.Name(value="Parasite Cleaver Effect Config (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteCleaverCustomEffect = false;
        @Config.Comment(value={"Updates the adaption for indirect attacks to ignore the true damage source"})
        @Config.Name(value="Parasite Indirect Damage Adaption Fix (SRParasites)")
        @Config.RequiresMcRestart
        public boolean parasiteIndirectDamageAdaptionFix = false;
        @Config.Comment(value={"Stops Better Foliage's enable toggle from Chunk Animator XRaying"})
        @Config.Name(value="Better Foliage Chunk XRay (BetterFoliage/ChunkAnimator)")
        @Config.RequiresMcRestart
        public boolean betterFoliageChunkXRay = false;
        @Config.Comment(value={"Stops CarryOn from being able to pickup chests that have not had their loot generated"})
        @Config.Name(value="CarryOn Ungenerated Chest Patch (CarryOn)")
        @Config.RequiresMcRestart
        public boolean carryOnUngeneratedChest = false;
        @Config.Comment(value={"Stops CarryOn from being able to pickup pigs that still have saddles equipped, cows and squids with cooldown, or dead entities"})
        @Config.Name(value="CarryOn Pig Saddle Patch (CarryOn)")
        @Config.RequiresMcRestart
        public boolean carryOnPigSaddlePatch = false;
        @Config.Comment(value={"Fixes CorpseComplex improperly using ExperienceTotal for calculating XP returns and restoring player XP on death when it shouldnt"})
        @Config.Name(value="CorpseComplex XP Death Fix (CorpseComplex)")
        @Config.RequiresMcRestart
        public boolean corpseComplexXPDeathFix = false;
        @Config.Comment(value={"Fixes Charms Magnetic enchant being janky, possible memory leaks, and also duping on SpongeForge"})
        @Config.Name(value="Magnetic Dupe Patch (Charm)")
        @Config.RequiresMcRestart
        public boolean magneticDupePatch = false;
        @Config.Comment(value={"Modifies BetterSurvivals Penetration enchant to use SpartanWeaponrys penetration"})
        @Config.Name(value="Penetration Fix (BetterSurvival/SpartanWeaponry/RLCombat)")
        @Config.RequiresMcRestart
        public boolean penetrationFix = false;
        @Config.Comment(value={"Fixes Flowering Oak Leaves not working properly on Dynamic Trees"})
        @Config.Name(value="Flowering Oak DT Fix (DynamicTrees/BOP/DTBOP)")
        @Config.RequiresMcRestart
        public boolean floweringOakDTFix = false;
        @Config.Comment(value={"Modifies the world creation process to limit users to creating only the preset world type"})
        @Config.Name(value="OTG Create World Simplify Fix (OTG)")
        @Config.RequiresMcRestart
        public boolean otgCreateWorldFix = false;
        @Config.Comment(value={"Modifies Spriggans to properly allow changing the farming growth rate"})
        @Config.Name(value="Spriggan Growth Rate Override (LycanitesMobs)")
        @Config.RequiresMcRestart
        public boolean sprigganGrowthPatch = false;
        @Config.Comment(value={"Stops sleeping from resetting weather and weather timers, causing weather to be less common"})
        @Config.Name(value="Stop Sleeping Resetting Weather MC-63340 (Vanilla)")
        @Config.RequiresMcRestart
        public boolean stopSleepResetWeather = false;
        @Config.Comment(value={"Fixes Blast Protection knockback flooring the reduction making it not effective"})
        @Config.Name(value="Blast Protection Knockback Patch MC-198809 (Vanilla)")
        @Config.RequiresMcRestart
        public boolean blastProtKnockback = false;
        @Config.Comment(value={"Modifies BetterSurvival to fix a crash with TickDynamic, and improve performance"})
        @Config.Name(value="BetterSurvival TickDynamic Crash (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean bsTickDynamic = false;
        @Config.Comment(value={"Modifies SoManyEnchantments to fix a crash with TickDynamic, and improve performance"})
        @Config.Name(value="SoManyEnchantments TickDynamic Crash (SoManyEnchantments)")
        @Config.RequiresMcRestart
        public boolean smeTickDynamic = false;
        @Config.Comment(value={"Limits QualityTools to applying modifiers to only Players and tamed Horses for performance"})
        @Config.Name(value="QualityTools Limit Modifiers (QualtiyTools)")
        @Config.RequiresMcRestart
        public boolean qualityToolsLimitModifiers = false;
        @Config.Comment(value={"Stops LycanitesMobs from calling String::toLowerCase for every ObjectManager.getEffect() call"})
        @Config.Name(value="LycanitesMobs Lowercase Performance Patch (LycanitesMobs)")
        @Config.RequiresMcRestart
        public boolean lycaniteLowercasePatch = false;
        @Config.Comment(value={"Optimizes performance of BetterSurvival LivingUpdateHandler by caching and skipping agility enchant for non-players"})
        @Config.Name(value="BetterSurvival LivingUpdateHandler Optimization (BetterSurvival)")
        @Config.RequiresMcRestart
        public boolean bsLivingUpdatePerf = false;
        @Config.Comment(value={"Disables XaTs magic handler from running for non players for performance"})
        @Config.Name(value="XaT Magic Handler Players Only (Trinkets and Baubles)")
        @Config.RequiresMcRestart
        public boolean xatMagicHandlerPerf = false;
        @Config.Comment(value={"Caches System.currentTimeMillis per tick for use by WorldBorder::getDiameter for performance"})
        @Config.Name(value="Cache WorldBorder currentTime (Vanilla)")
        @Config.RequiresMcRestart
        public boolean cacheWorldBorder = false;
        @Config.Comment(value={"Suppresses DynamicTrees falling tree missing branch errors (Not needed with DramaticTrees)"})
        @Config.Name(value="Supress DT Branch Errors (DynamicTrees)")
        @Config.RequiresMcRestart
        public boolean suppressDTError = false;
        @Config.Comment(value={"Makes DT Leaves spawning on worldgen ignore light level for performance"})
        @Config.Name(value="DT Leaves Ignore Light on WorldGen (DynamicTrees)")
        @Config.RequiresMcRestart
        public boolean dtLeavesLightIgnore = false;
        @Config.Comment(value={"Disables water from forced updates on chunk gen"})
        @Config.Name(value="Remove Water Chunk Gen Ticking (Vanilla)")
        @Config.RequiresMcRestart
        public boolean waterChunkGenPerf = false;
        @Config.Comment(value={"Patches Quarks EnderWatcher to greatly improve performance"})
        @Config.Name(value="EnderWatcher Performance Patch (Quark)")
        @Config.RequiresMcRestart
        public boolean enderWatcherPerf = false;
        @Config.Comment(value={"Fixes a memory leak in BetterNether when going from singleplayer to multiplayer (Thanks to Meldexun)"})
        @Config.Name(value="BetterNether Memory Leak Fix (BetterNether)")
        @Config.RequiresMcRestart
        public boolean betterNetherMemLeak = false;
        @Config.Comment(value={"Fixes a memory leak in BetterQuesting when going from singleplayer to multiplayer or logging out in another dimension (Thanks to Meldexun)"})
        @Config.Name(value="BetterQuesting Memory Leak Fix (BetterQuesting Standard Expansion)")
        @Config.RequiresMcRestart
        public boolean betterQuestingMemLeak = false;
        @Config.Comment(value={"BetterQuesting Memory Leak Fix but for BetterQuesting Unofficial"})
        @Config.Name(value="BetterQuesting Unofficial Memory Leak Fix (BetterQuesting Unofficial)")
        @Config.RequiresMcRestart
        public boolean betterQuestingUnofficialMemLeak = false;
        @Config.Comment(value={"Fixes multiple memory leaks in MoBends (Thanks to Meldexun)"})
        @Config.Name(value="MoBends Memory Leak Fix (MoBends)")
        @Config.RequiresMcRestart
        public boolean mobendsMemLeak = false;
        @Config.Comment(value={"Suppresses JEI outputting too many input errors related to Varied Commodities"})
        @Config.Name(value="JEI Suppress Varied Commodities Errors (JEI)")
        @Config.RequiresMcRestart
        public boolean jeiSuppressVC = false;
        @Config.Comment(value={"Suppresses Forge's potentially dangerous prefix errors"})
        @Config.Name(value="Forge Suppress Dangerous Prefix Errors (Forge)")
        @Config.RequiresMcRestart
        public boolean forgeDangerousPrefix = false;
        @Config.Comment(value={"Suppresses Forge's broken ore dictionary errors"})
        @Config.Name(value="Forge Suppress Broken Ore Dictionary Errors (Forge)")
        @Config.RequiresMcRestart
        public boolean forgeBrokenOreDict = false;
        @Config.Comment(value={"Rewrites Elenai Dodge's TickEventListener for better performance when ability caps and cooldowns are set to 0"})
        @Config.Name(value="Elenai Dodge Better Tick Performance (Elenai Dodge)")
        @Config.RequiresMcRestart
        public boolean elenaiDodgePerformance = false;
        @Config.Comment(value={"Forcibly disable Quarks Springy Slime check for performance"})
        @Config.Name(value="Quark Springy Slime Force Disable (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkSpringySlimeDisable = false;
        @Config.Comment(value={"Caches reflection in SereneSeasons BiomeHook to fix severe wasted performance"})
        @Config.Name(value="SereneSeasons Reflection Caching Patch (SereneSeasons)")
        @Config.RequiresMcRestart
        public boolean sereneSeasonsReflection = false;
        @Config.Comment(value={"Forcibly disable Quarks Emotes for performance"})
        @Config.Name(value="Quark Emotes Force Disable (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkEmoteForceDisable = false;
        @Config.Comment(value={"Caches XaTs config attributes for better performance and mem usage"})
        @Config.Name(value="XaT Cache Config Attributes (Trinkets and Baubles)")
        @Config.RequiresMcRestart
        public boolean xatCacheConfig = false;
        @Config.Comment(value={"Force disables Quarks Potion Colorizer from running and wasting performance and networking"})
        @Config.Name(value="Quark Force Disable Potion Colorizer (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkColorizer = false;
        @Config.Comment(value={"Slows how often item entities update their position to improve performance. WARNING: It is not recommended you use this feature unless you absolutely need to, it may cause issues with certain item mechanics"})
        @Config.Name(value="Slowed Item Entity Movement (Vanilla)")
        @Config.RequiresMcRestart
        public boolean slowItemMovement = false;
        @Config.Comment(value={"Reduces the frequency of Quark attempting to replace villager AI to open double doors for performance"})
        @Config.Name(value="Quark Reduced Villager Double Door AI Checks (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkDoubleDoor = false;
        @Config.Comment(value={"Disallows respawning in the Lost Cities"})
        @Config.Name(value="Lost Cities No Respawn (Lost Cities)")
        @Config.RequiresMcRestart
        public boolean lostCityRespawn = false;
        @Config.Comment(value={"Enables setting a number of retries in the server config to attempt to get a better random respawn location"})
        @Config.Name(value="Random Respawn Attempt Safety (Vanilla)")
        @Config.RequiresMcRestart
        public boolean randomRespawnMixin = false;
        @Config.Comment(value={"Forces OTG to use Vanilla spawn checks instead of its modified respawn method"})
        @Config.Name(value="Force OTG No Set Spawn (OTG)")
        @Config.RequiresMcRestart
        public boolean forceOTGNoSetSpawn = false;
        @Config.Comment(value={"Disables Mo'Bends online checks that can cause the game to freeze on loading"})
        @Config.Name(value="Disable MoBends Online Checks (MoBends)")
        @Config.RequiresMcRestart
        public boolean moBendsOnlineCheck = false;
        @Config.Comment(value={"Forces Stonelings to assume minimum entity eyeheight to prevent infinite loops"})
        @Config.Name(value="Stoneling Eyeheight Stall Patch (Quark)")
        @Config.RequiresMcRestart
        public boolean stonelingLoopPatch = false;
        @Config.Comment(value={"Allows for setting different minimum and maximum Gamma values"})
        @Config.Name(value="Modify Gamma Max And Min (Vanilla)")
        @Config.RequiresMcRestart
        public boolean allowModifyGamma = false;
        @Config.Comment(value={"Makes the Dummy display values in damage not hearts"})
        @Config.Name(value="Dummy Damage Value Patch (MmmMmmMmmMmm)")
        @Config.RequiresMcRestart
        public boolean patchDummyDamage = false;
        @Config.Comment(value={"Silences broken advancement error messages"})
        @Config.Name(value="Broken Advancement Log Spam Silence (Vanilla/Forge)")
        @Config.RequiresMcRestart
        public boolean silenceBrokenAdvancement = false;
        @Config.Comment(value={"Fixes Quark's armor rune enchantment glint not working when Optifine is installed"})
        @Config.Name(value="Quark Rune Optifine Fix (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkRuneOptifineFix = false;
        @Config.Comment(value={"Modifies EnhancedVisual's death messages to be translatable"})
        @Config.Name(value="EV Death Message Translation (EnhancedVisuals)")
        @Config.RequiresMcRestart
        public boolean evDeathMessage = false;
        @Config.Comment(value={"Modifies Neat's rendering to make it (slightly) more compatible with shaders"})
        @Config.Name(value="Neat Shaders Patch (Neat)")
        @Config.RequiresMcRestart
        public boolean neatShadersPatch = false;
        @Config.Comment(value={"Modifies DSurround's chat bubble rendering to make it (slightly) more compatible with shaders"})
        @Config.Name(value="DSurround Chat Bubble Shaders Patch (DSurround)")
        @Config.RequiresMcRestart
        public boolean dsurroundShadersPatch = false;
        @Config.Comment(value={"Reverts the behavior of JEI moving bookmarks out of the config folder"})
        @Config.Name(value="JEI Revert Bookmark Location Changes (JEI)")
        @Config.RequiresMcRestart
        public boolean jeiRevertBookmark = false;
        @Config.Comment(value={"Nukes the Advancement system from loading"})
        @Config.Name(value="Nuke Advancements (Vanilla)")
        @Config.RequiresMcRestart
        public boolean nukeAdvancements = false;
        @Config.Comment(value={"Makes JEI ignore anvil enchantment recipes to save on memory"})
        @Config.Name(value="JEI Ignore Anvil Recipes (JEI)")
        @Config.RequiresMcRestart
        public boolean jeiAnvil = false;
        @Config.Comment(value={"Fixes the BattleTower Golem never clearing its attack target, even if its target died and respawned"})
        @Config.Name(value="Battletower Golem Attack Target Patch (Battletowers)")
        @Config.RequiresMcRestart
        public boolean battletowerGolemTarget = false;
        @Config.Comment(value={"Modifies the radius of spawn chunks to keep loaded even when a player is not near"})
        @Config.Name(value="Spawn Chunk Radius Patch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean spawnChunkRadiusPatch = false;
        @Config.Comment(value={"Adds a progress bar during DregoraRL first time setup file creation"})
        @Config.Name(value="DregoraRL First Time Setup Progress (DregoraRL)")
        @Config.RequiresMcRestart
        public boolean dregoraRLProgress = false;
        @Config.Comment(value={"Removes BQU's hardcoded handling of the backspace key to allow BQUTweaker to handle it instead"})
        @Config.Name(value="BQU Remove Hardcoded Backspace (BetterQuesting Unofficial)")
        @Config.RequiresMcRestart
        public boolean bquBackspace = false;
        @Config.Comment(value={"Patches Bloodmoon's red light rendering to work when Optifine is installed"})
        @Config.Name(value="Bloodmoon Optifine Patch (Bloodmoon)")
        @Config.RequiresMcRestart
        public boolean bloodmoonOptifine = false;
        @Config.Comment(value={"Cache DynamicTree leaf and branch AABBs to save on memory allocation usage"})
        @Config.Name(value="DynamicTrees AABB Cache (DynamicTrees)")
        @Config.RequiresMcRestart
        public boolean dynamicTreeCache = false;
        @Config.Comment(value={"Cache player chunk position to not refresh visible chunk list every tick to save on memory allocation"})
        @Config.Name(value="Cache Player Chunk Visibility (Vanilla)")
        @Config.RequiresMcRestart
        public boolean cachePlayerChunkVisibility = false;
        @Config.Comment(value={"Sets world flammable checks to use an existing mutable blockpos instead of creating a new one during flammable checks, for memory usage"})
        @Config.Name(value="World Flammable BlockPos Replacement (Vanilla)")
        @Config.RequiresMcRestart
        public boolean worldFlammableBlockpos = false;
        @Config.Comment(value={"Caches the results of BetterFoliage Class whitelist/blacklist checks for performance and memory usage"})
        @Config.Name(value="BetterFoliage Whitelist/Blacklist Cache (BetterFoliage)")
        @Config.RequiresMcRestart
        public boolean betterFoliageListCache = false;
        @Config.Comment(value={"Modifies BetterFoliage geometry checks to not create a new BlockPos if offset is 0"})
        @Config.Name(value="BetterFoliage Geometry Offset (BetterFoliage)")
        @Config.RequiresMcRestart
        public boolean betterFoliageGeometry = false;
        @Config.Comment(value={"Sets particles by default to not do collision checks, unless defined in the relevant config setting"})
        @Config.Name(value="Particle Collision Defaults (Vanilla)")
        @Config.RequiresMcRestart
        public boolean particleCollision = false;
        @Config.Comment(value={"Fixes issues with rune id handling resulting in missing runes from creative and invalid runes in loot"})
        @Config.Name(value="ForgottenItems Rune Fix (ForgottenItems)")
        @Config.RequiresMcRestart
        public boolean forgottenItemsRune = false;
        @Config.Comment(value={"Fixes Rusting curse allowing items to get negative durability"})
        @Config.Name(value="Rusting Curse Negative Durability Patch (Charm)")
        @Config.RequiresMcRestart
        public boolean rustingCurseNegative = false;
        @Config.Comment(value={"Makes Quark's enchanted book tooltip rendering wrap lines and fixed item lighting rendering"})
        @Config.Name(value="Quark Enchanted Book Tooltip Rendering Patch (Quark)")
        @Config.RequiresMcRestart
        public boolean quarkEnchantedTooltip = false;
        @Config.Comment(value={"Fixes Mo'Bends arrow trail animation not clearing entries properly"})
        @Config.Name(value="MoBends Arrow Trail Patch (MoBends)")
        @Config.RequiresMcRestart
        public boolean mobendArrowTrail = false;
        @Config.Comment(value={"Fixes arrows in ground rendering particles like tipped arrows when a world is reloaded"})
        @Config.Name(value="Untipped Arrow Particles Fix (Vanilla)")
        @Config.RequiresMcRestart
        public boolean untippedArrowParticle = false;
        @Config.Comment(value={"Fixes ScalingHealth's bandaged effect not having an icon"})
        @Config.Name(value="ScalingHealth Bandaged Icon Fix (ScalingHealth)")
        @Config.RequiresMcRestart
        public boolean scalingHealthBandaged = false;
        @Config.Comment(value={"Allows for blacklisting biomes to prevent spawning of Mineshafts"})
        @Config.Name(value="Mineshaft Biome Blacklist Patch (Vanilla)")
        @Config.RequiresMcRestart
        public boolean mineshaftBlacklistPatch = false;
        @Config.Comment(value={"Fix Food Expansion dropping horse meat from llamas"})
        @Config.Name(value="Horse Meat From Llamas Fix (FoodExpansion)")
        @Config.RequiresMcRestart
        public boolean horseMeatLlamaFix = false;
        @Config.Comment(value={"Remove SME from applying capabilities and NBT tags to all entities that are only used for Mortalitas and Rune Resurrection"})
        @Config.Name(value="Remove SME Mortalitas Resurrection Capability (SoManyEnchantments)")
        @Config.RequiresMcRestart
        public boolean smeCapabilityRemoval = false;
        @Config.Comment(value={"Allows for placing LycanitesMobs charges in item frames"})
        @Config.Name(value="Fix LycanitesMobs Charges in Item Frames (LycanitesMobs)")
        @Config.RequiresMcRestart
        public boolean lycaniteChargeItemFrame = false;
        @Config.Comment(value={"Fixes the player's model shaking when in the death screen"})
        @Config.Name(value="Fix Player Model Death Shake (Vanilla)")
        @Config.RequiresMcRestart
        public boolean playerModelDeathShake = false;
        @Config.Comment(value={"Fixes JSONPaintings crashing when trying to place a random painting in an invalid location"})
        @Config.Name(value="JSONPaintings Placement Crash Fix (JSONPaintings)")
        @Config.RequiresMcRestart
        public boolean jsonPaintingsCrash = false;
        @Config.Comment(value={"Overhauls and fixes some issues with DramaticTrees such as making sound volume dependant on speed/size and allowing for passing through or breaking additional blocks"})
        @Config.Name(value="DramaticTrees Falling Overhaul (DramaticTrees)")
        @Config.RequiresMcRestart
        public boolean dramaticTreesFallingOverhaul = false;
        @Config.Comment(value={"Allows for displaying the Y level in DSHuds when holding the Barometer from Inspirations (Also displays light level from photometer)"})
        @Config.Name(value="DSHuds Barometer Patch (DSHuds/Inspirations)")
        @Config.RequiresMcRestart
        public boolean dsHudBarometerPatch = false;
        @Config.Comment(value={"Fixes BountifulBaubles shields not properly overriding isShield method"})
        @Config.Name(value="BountifulBaubles isShield Fix (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean bountifulBaublesShieldFix = false;
        @Config.Comment(value={"Reworks Waystones used name system to use less memory and be more performant"})
        @Config.Name(value="Rework Waystone Used Name Check (Waystones)")
        @Config.RequiresMcRestart
        public boolean waystonesUsedNameRework = false;
        @Config.Comment(value={"Forces carts to be unpulled when the distance between the cart and the puller in a single tick is too high"})
        @Config.Name(value="Force Cart Unpull Over Distance (AstikorCarts)")
        @Config.RequiresMcRestart
        public boolean astikorCartUnpull = false;
        @Config.Comment(value={"Fixes ForgottenItems bound tools NBT being reset when the tool is bound"})
        @Config.Name(value="ForgottenItems Fix Binding NBT (ForgottenItems)")
        @Config.RequiresMcRestart
        public boolean forgottenItemsBoundNBT = false;
        @Config.Comment(value={"Fixes BetterNether double slabs not dropping items when broken"})
        @Config.Name(value="BetterNether Double Slab Drop Fix (BetterNether)")
        @Config.RequiresMcRestart
        public boolean betterNetherDoubleSlabFix = false;
        @Config.Comment(value={"Fixes mobs spawned from Bloodmoon being able to pick up loot (And then despawn with the loot)"})
        @Config.Name(value="Bloodmoon Loot Pickup Fix (Vanilla/Bloodmoon)")
        @Config.RequiresMcRestart
        public boolean bloodmoonLootPickupFix = false;
        @Config.Comment(value={"Fixes BetterNether doors being duped when broken"})
        @Config.Name(value="BetterNether Door Dupe Fix (BetterNether)")
        @Config.RequiresMcRestart
        public boolean betterNetherDoorDupe = false;
        @Config.Comment(value={"Allows for hoes to be repaired with their repair material like normal tools"})
        @Config.Name(value="Allow Hoe Repairing (Vanilla)")
        @Config.RequiresMcRestart
        public boolean hoeRepair = false;
        @Config.Comment(value={"Allows for setting timings of weather events with config values"})
        @Config.Name(value="Weather Timing Config (Vanilla)")
        @Config.RequiresMcRestart
        public boolean weatherTiming = false;
        @Config.Comment(value={"Fixes the Skeleton King not dropping loot if it is set to not drop loot inside a chest"})
        @Config.Name(value="Skeleton King Loot Drop Fix (FishsUndeadRising)")
        @Config.RequiresMcRestart
        public boolean skeletonKingLootFix = false;
        @Config.Comment(value={"Allows for changing the dungeon weight of the Lucky Horseshoe"})
        @Config.Name(value="Allow Changing Lucky Horseshoe Weight (BountifulBaubles)")
        @Config.RequiresMcRestart
        public boolean luckyHorseShoeWeightTweak = false;
        @Config.Comment(value={"Fixes passengers and riders being killed when an entity is picked up"})
        @Config.Name(value="CarryOn Passenger Rider Death Fix (CarryOn)")
        @Config.RequiresMcRestart
        public boolean carryOnPositionFix = false;
        @Config.Comment(value={"Fixes being able to throw CarryOn entities/tiles by holding Q"})
        @Config.Name(value="ItemPhysics Q CarryOn Fix (CarryOn/ItemPhysics)")
        @Config.RequiresMcRestart
        public boolean carryOnItemPhysicsFix = false;
        @Config.Comment(value={"Fixes possible rare crash when an item with invalid particle texture is placed in a bookshelf"})
        @Config.Name(value="Inspirations Bookshelf Color Crash Fix (Inspirations)")
        @Config.RequiresMcRestart
        public boolean inspirationsColorShelfFix = false;
        @Config.Comment(value={"Fixes a vanilla/forge bug limiting the xp result of smelting to 1 - 2 xp per item"})
        @Config.Name(value="Furnace XP Limit Fix (Vanilla)")
        @Config.RequiresMcRestart
        public boolean furnaceXPFix = false;
        @Config.Comment(value={"Fixes aqua mobs from Fish's Undead Rising not being able to spawn from spawners underwater"})
        @Config.Name(value="Aquatic Mob Underwater Spawning (FishsUndeadRising)")
        @Config.RequiresMcRestart
        public boolean aquaSpawningFix = false;
        @Config.Comment(value={"Adds checks to SRParasite Bush generation to hopefully prevent chunk loading/generation of unloaded chunks"})
        @Config.Name(value="SRP Bush Generation Loaded Checks (SRParasites)")
        @Config.RequiresMcRestart
        public boolean srpBushGen = false;
        @Config.Comment(value={"Improves the Defiled corruption checks and adds the ability to lower the chance of corruption"})
        @Config.Name(value="Defiled Corruption Improvements (DefiledLands)")
        @Config.RequiresMcRestart
        public boolean defiledCorruptionImprovement = false;
        @Config.Comment(value={"Fixes the healing salve from RoughTweaks not giving back empty bowls after the first salve is used"})
        @Config.Name(value="Healing Salve Bowl Return Fix (RoughTweaks)")
        @Config.RequiresMcRestart
        public boolean roughTweaksBowlFix = false;
        @Config.Comment(value={"Fixes FancyMenu crashing when loaded serverside"})
        @Config.Name(value="FancyMenu Server Crash (FancyMenu)")
        @Config.RequiresMcRestart
        public boolean fancyMenuServerCrash = false;
        @Config.Comment(value={"Replaces the advancements tab button in the escape menu with a button for BetterQuesting's quest menu"})
        @Config.Name(value="Advancement Tab Quest Replacement (Vanilla/BetterQuesting)")
        @Config.RequiresMcRestart
        public boolean advancementQuestingReplacement = false;
        @Config.Comment(value={"Suppress removed entity warnings from EntityTracker"})
        @Config.Name(value="Suppress EntityTracker Removed Entity Warnings (Vanilla)")
        @Config.RequiresMcRestart
        public boolean suppressEntityTracker = false;
        @Config.Comment(value={"Allows for modifying the max amount of levels that bookwyrms can digest"})
        @Config.Name(value="Modify BookWyrm Max Level (DefiledLands)")
        @Config.RequiresMcRestart
        public boolean bookWyrmMaxLevelModify = false;
        @Config.Comment(value={"At low render distance (<9) mobs can spawn in lazy loaded chunks, creating an automatic mob switch. Set to true to prevent that."})
        @Config.Name(value="Prevent Mob spawns in lazy loaded chunks (Vanilla)")
        @Config.RequiresMcRestart
        public boolean preventLazySpawns = false;
        @Config.Comment(value={"Suppresses the Received passengers for unknown entity log warnings"})
        @Config.Name(value="Suppress Unknown Passengers Warnings (Vanilla)")
        @Config.RequiresMcRestart
        public boolean suppressUnknownPassenger = false;
        @Config.Comment(value={"Allows for defining a blacklist of enchantments that will not be allowed in Librarian trades"})
        @Config.Name(value="Limit enchants on Librarian trades (Vanilla)")
        @Config.RequiresMcRestart
        public boolean limitLibrarianEnchants = false;
        @Config.Comment(value={"Makes zombie villagers keep their trades during infection and conversion"})
        @Config.Name(value="Zombified Villagers keep trades (Vanilla/SME)")
        @Config.RequiresMcRestart
        public boolean zombieVillagersKeepTrades = false;
        @Config.Comment(value={"Changes the lang key for rubies to avoid overlap with BoP"})
        @Config.Name(value="VC Ruby Name Change (VariedCommodities)")
        @Config.RequiresMcRestart
        public boolean vcRubyNameChange = false;
        @Config.Comment(value={"Fixes grenades not being consumed if it is the last one"})
        @Config.Name(value="Fishs Undead Grenade Consuming (Fish's Undead Rising)")
        @Config.RequiresMcRestart
        public boolean fishsGrenadeDupe = false;
        @Config.Comment(value={"Improves some checks in Bloodmoon spawning for performance"})
        @Config.Name(value="Bloodmoon Spawning Performance (Bloodmoon)")
        @Config.RequiresMcRestart
        public boolean bloodMoonPerformance = false;
        @Config.Comment(value={"Adds additional checks to attempt to help prevent OTG's SaveToDIsk from crashing during pregeneration"})
        @Config.Name(value="OTG Save To Disk Crash Checks (OTG)")
        @Config.RequiresMcRestart
        public boolean otgSaveToDiskCrash = false;
        @Config.Comment(value={"Adds additional checks to attempt to help prevent OTG from crashing during world-gen"})
        @Config.Name(value="OTG World-Gen Crash Checks (OTG)")
        @Config.RequiresMcRestart
        public boolean otgWorldGenCrash = false;
        @Config.Comment(value={"Disable the digging AI for digging mobs that are not carrying a pickaxe"})
        @Config.Name(value="Digging AI (Epic Siege Mod)")
        @Config.RequiresMcRestart
        public boolean epicSiegeModDiggingAI = false;
        @Config.Comment(value={"Improves world load speed on large maps such as pregenerated servers when using OTG"})
        @Config.Name(value="OTG CustomStructureCache Improve Load Speed (OTG)")
        @Config.RequiresMcRestart
        public boolean otgImproveLoadSpeed = false;
        @Config.Comment(value={"Fixes exiting a hardcore world without spectating first not properly unloading the world"})
        @Config.Name(value="Fix Hardcore World Not Unloading (Vanilla)")
        @Config.RequiresMcRestart
        public boolean hardcoreWorldUnload = false;
        @Config.Comment(value={"Fixes a crash when something runs pickBlock on a ClassyHat hat stand and passes in a null player"})
        @Config.Name(value="Fix ClassyHats Hat Container Null Player Crash (ClassyHats)")
        @Config.RequiresMcRestart
        public boolean classyHatNullPlayerCrash = false;
        @Config.Comment(value={"Fixes Fish's Undead Rising Ghost Stew crashing/kicking players when eaten on a server"})
        @Config.Name(value="Fix Fish's Undead Rising Ghost Stew Crash (Fish's Undead Rising)")
        @Config.RequiresMcRestart
        public boolean fishsUndeadRisingGhostStew = false;
        @Config.Comment(value={"Fixes errors from processing packets received after the player has already left a world"})
        @Config.Name(value="Fix Delayed Packet Errors (Vanilla)")
        @Config.RequiresMcRestart
        public boolean fixDelayedPacketErrors = false;
        @Config.Comment(value={"Fixes a crash where mob spawner mob ids will overlap with existing ids causing a MoBends crash"})
        @Config.Name(value="Fix Duplicate MoBends Render ID Crash (Vanilla/MoBends)")
        @Config.RequiresMcRestart
        public boolean moBendsDuplicateIDCrash = false;
        @Config.Comment(value={"Fixes chunk generation errors when a doomlike dungeon attempts to generate in an area with no theme"})
        @Config.Name(value="Doomlike Dungeon No Theme Error (DoomlikeDungeons)")
        @Config.RequiresMcRestart
        public boolean doomlikeNoThemeError = false;
        @Config.Comment(value={"Fixes a memory leak with Fish's Undead Rising Skeleton King Crown"})
        @Config.Name(value="Fishs Undead Rising Skeleton King Crown Mem Leak (Fishs Undead Rising)")
        @Config.RequiresMcRestart
        public boolean fishsSkeletonKingCrown = false;
        @Config.Comment(value={"Fixes some Fishs Undead Rising mobs applying potion effects on the client side"})
        @Config.Name(value="Fishs Undead Rising Client Side Effects (Fishs Undead Rising)")
        @Config.RequiresMcRestart
        public boolean fishsClientSideEffects = false;
        @Config.Comment(value={"Forcibly disables OTG's pregenerator from running its tick operations which wastes performance as it runs when it isn't active"})
        @Config.Name(value="Force Disable OTG Pregenerator Ticking (OTG)")
        @Config.RequiresMcRestart
        public boolean otgForceDisablePregenerator = false;
        @Config.Comment(value={"Allows for defining a blacklist/whitelist of allowed armors to be worn as cosmetics"})
        @Config.Name(value="Cosmetic Armor Blacklist (CosmeticArmorReworked)")
        @Config.RequiresMcRestart
        public boolean cosmeticArmorReworkedBlacklist = false;
        @Config.Comment(value={"Blocks BlockConcretePowder from running onBlockAdded during worldgen for performance"})
        @Config.Name(value="Chunk OnBlockAdded ConcretePowder Disable (Vanilla)")
        @Config.RequiresMcRestart
        public boolean chunkOnBlockAddedConcretePowderDisable = false;
        @Config.Comment(value={"Disables non-SRP armor models from rendering in SRPLayerBipedArmor to avoid crashes"})
        @Config.Name(value="SRParasites Layer Biped Armor Crash Fix (SRParasites)")
        @Config.RequiresMcRestart
        public boolean srpDisableLayerBipedArmorRender = false;
        @Config.Comment(value={"Allows for replacing the world generation filler block by dimension id (Warning: this will occur a slight performance cost, and may cause issues with world generation that expects blocks to be stone)"})
        @Config.Name(value="Dimension Custom Filler Block (Vanilla)")
        @Config.RequiresMcRestart
        public boolean dimensionCustomFillerBlock = false;
        @Config.Comment(value={"Allows for setting the maximum range of bedrock generation"})
        @Config.Name(value="Maximum Bedrock Generation Range (Vanilla)")
        @Config.RequiresMcRestart
        public boolean maxBedrockGenerationRange = false;
        @Config.Comment(value={"Allows for setting additional blocks to allow to be carved by caves and ravines"})
        @Config.Name(value="Additional Caves and Ravines Carver Blocks (Vanilla)")
        @Config.RequiresMcRestart
        public boolean additionalCaveRavineBlocks = false;
        @Config.Comment(value={"Patches CodeChickenLib's Chunk Unwatch event to not run due to it causing severe world generation lag during dimension changing (Warning: If you use a mod that depends on this event, it may cause issues, you should only use this if you know you don't need it)"})
        @Config.Name(value="CodeChickenLib Chunk Unwatch Lag (CodeChickenLib)")
        @Config.RequiresMcRestart
        public boolean codeChickenLibChunkLag = false;
        @Config.Comment(value={"Disables old SME compatibility checks of BetterSurvival and SpartanWeaponry"})
        @Config.Name(value="Disable old SME compat of BS and Spartan (BS/Spartan)")
        @Config.RequiresMcRestart
        public boolean disableSMEcompat = false;
        @Config.Comment(value={"Keeps Quark Usage Ticker rendered permanently"})
        @Config.Name(value="Usage Ticker stays visible (Quark)")
        @Config.RequiresMcRestart
        public boolean usageTickerStaysActive = false;
        @Config.Comment(value={"Allows for defining a blacklist of enchantments that will not be allowed on random enchanting (loot+enchanting table). Use this to fake-disable enchants, so that predefined loot can still have and use those enchants"})
        @Config.Name(value="Limit enchants on random enchanting (Vanilla)")
        @Config.RequiresMcRestart
        public boolean limitRandomEnchants = false;
    }
}

