/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.worldsave;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.worldsave.BiomeIdData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;

public class DimensionData {
    public int dimensionOrder;
    public int dimensionId;
    public String dimensionName;
    public boolean keepLoaded;
    public long seed = 0L;

    public static void saveDimensionData(File worldSaveDirectory, ArrayList<DimensionData> dimensionData) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DimensionData dimData : dimensionData) {
            stringBuilder.append((stringBuilder.length() == 0 ? "" : ",") + dimData.dimensionId + "," + dimData.dimensionName + "," + dimData.keepLoaded + "," + dimData.seed + "," + dimData.dimensionOrder);
        }
        DimensionData.saveDimensionData(worldSaveDirectory, stringBuilder);
    }

    public static void saveDimensionData(File worldSaveDirectory, StringBuilder stringBuilder) {
        File dimensionDataFile = new File(worldSaveDirectory + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataFileName);
        File dimensionDataBackupFile = new File(worldSaveDirectory + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataBackupFileName);
        BufferedWriter writer = null;
        try {
            if (!dimensionDataFile.exists()) {
                dimensionDataFile.getParentFile().mkdirs();
            } else {
                Files.move(dimensionDataFile.toPath(), dimensionDataBackupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            writer = new BufferedWriter(new FileWriter(dimensionDataFile));
            writer.write(stringBuilder.toString());
            OTG.log(LogMarker.DEBUG, "Custom dimension data saved", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("OTG encountered a critical error writing " + dimensionDataFile.getAbsolutePath() + ", exiting. OTG automatically backs up files before writing and will try to use the backup when loading. If your world's " + WorldStandardValues.DimensionsDataFileName + " and its backup have been corrupted, you can replace it with a backup or create a new world with the same dimensions and copy its " + WorldStandardValues.DimensionsDataFileName + ".");
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                String string = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<DimensionData> loadDimensionData(File worldSaveDir) {
        String line;
        BufferedReader reader;
        StringBuilder stringbuilder;
        boolean bSuccess;
        String[] dimensionDataFileValues;
        File dimensionDataFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataFileName);
        File dimensionDataBackupFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataBackupFileName);
        if (!dimensionDataFile.exists() && !dimensionDataBackupFile.exists()) {
            return null;
        }
        if (dimensionDataFile.exists()) {
            dimensionDataFileValues = new String[]{};
            bSuccess = false;
            try {
                stringbuilder = new StringBuilder();
                reader = new BufferedReader(new FileReader(dimensionDataFile));
                try {
                    line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        dimensionDataFileValues = stringbuilder.toString().split(",");
                    }
                    bSuccess = true;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                OTG.log(LogMarker.WARN, "Failed to load " + dimensionDataFile.getAbsolutePath() + ", trying to load backup.", new Object[0]);
            }
            if (bSuccess) {
                try {
                    return DimensionData.parseDimensionDataValues(dimensionDataFileValues);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    OTG.log(LogMarker.WARN, "Failed to load " + dimensionDataFile.getAbsolutePath() + ", trying to load backup.", new Object[0]);
                }
            }
        }
        if (dimensionDataBackupFile.exists()) {
            dimensionDataFileValues = new String[]{};
            bSuccess = false;
            try {
                stringbuilder = new StringBuilder();
                reader = new BufferedReader(new FileReader(dimensionDataBackupFile));
                try {
                    line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        dimensionDataFileValues = stringbuilder.toString().split(",");
                    }
                    bSuccess = true;
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (bSuccess) {
                try {
                    return DimensionData.parseDimensionDataValues(dimensionDataFileValues);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        throw new RuntimeException("OTG encountered a critical error loading " + dimensionDataFile.getAbsolutePath() + " and could not load a backup, exiting. OTG automatically backs up files before writing and will try to use the backup when loading. If your world's " + WorldStandardValues.DimensionsDataFileName + " and its backup have been corrupted, you can replace it with a backup or create a new world with the same dimensions and copy its " + WorldStandardValues.DimensionsDataFileName + ".");
    }

    private static ArrayList<DimensionData> parseDimensionDataValues(String[] dimensionDataFileValues) {
        ArrayList<DimensionData> dimensionData = new ArrayList<DimensionData>();
        if (dimensionDataFileValues.length > 0) {
            for (int i = 0; i < dimensionDataFileValues.length; i += 5) {
                DimensionData dimData = new DimensionData();
                dimData.dimensionId = Integer.parseInt(dimensionDataFileValues[i]);
                dimData.dimensionName = dimensionDataFileValues[i + 1];
                dimData.keepLoaded = Boolean.parseBoolean(dimensionDataFileValues[i + 2]);
                dimData.seed = Long.parseLong(dimensionDataFileValues[i + 3]);
                dimData.dimensionOrder = Integer.parseInt(dimensionDataFileValues[i + 4]);
                dimensionData.add(dimData);
            }
            OTG.log(LogMarker.DEBUG, "Custom dimension data loaded", new Object[0]);
        }
        return dimensionData;
    }

    public static void deleteDimSavedData(Path worldSaveDir, DimensionConfig dimConfig) {
        Path dimensionSaveDir = Paths.get(worldSaveDir + File.separator + "DIM" + dimConfig.DimensionId, new String[0]);
        if (Files.exists(dimensionSaveDir, new LinkOption[0]) && Files.isDirectory(dimensionSaveDir, new LinkOption[0])) {
            OTG.log(LogMarker.INFO, "Deleting MC world save data for dimension " + dimConfig.DimensionId, new Object[0]);
            try {
                Files.walk(dimensionSaveDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                if (Files.exists(dimensionSaveDir, new LinkOption[0])) {
                    OTG.log(LogMarker.ERROR, "Could not delete directory: " + dimensionSaveDir.toString(), new Object[0]);
                }
            }
            catch (IOException e) {
                OTG.log(LogMarker.ERROR, "Could not delete directory " + dimensionSaveDir.toString() + ". Error: " + e.toString(), new Object[0]);
                e.printStackTrace();
            }
        }
        if (Files.exists(dimensionSaveDir = Paths.get(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + "DIM-" + dimConfig.DimensionId, new String[0]), new LinkOption[0]) && Files.isDirectory(dimensionSaveDir, new LinkOption[0])) {
            OTG.log(LogMarker.INFO, "Deleting OTG world save data for dimension " + dimConfig.DimensionId, new Object[0]);
            try {
                Files.walk(dimensionSaveDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                if (Files.exists(dimensionSaveDir, new LinkOption[0])) {
                    OTG.log(LogMarker.ERROR, "Could not delete directory: " + dimensionSaveDir.toString(), new Object[0]);
                }
            }
            catch (IOException e) {
                OTG.log(LogMarker.ERROR, "Could not delete directory " + dimensionSaveDir.toString() + ". Error: " + e.toString(), new Object[0]);
                e.printStackTrace();
            }
            ArrayList<BiomeIdData> biomeIds = BiomeIdData.loadBiomeIdData(worldSaveDir.toFile());
            ArrayList<BiomeIdData> newBiomeIds = new ArrayList<BiomeIdData>();
            for (BiomeIdData biomeIdData : biomeIds) {
                if (biomeIdData.biomeName.startsWith(dimConfig.PresetName + "_")) continue;
                newBiomeIds.add(biomeIdData);
            }
            BiomeIdData.saveBiomeIdData(worldSaveDir.toFile(), newBiomeIds);
            ArrayList<DimensionData> dimensionData = DimensionData.loadDimensionData(worldSaveDir.toFile());
            ArrayList<DimensionData> newDimensionData = new ArrayList<DimensionData>();
            int removedIndex = -1;
            for (DimensionData dimData : dimensionData) {
                if (dimData.dimensionId != dimConfig.DimensionId) {
                    newDimensionData.add(dimData);
                    continue;
                }
                removedIndex = dimData.dimensionOrder;
            }
            if (removedIndex > -1) {
                for (DimensionData dimData : newDimensionData) {
                    if (dimData.dimensionOrder <= removedIndex) continue;
                    --dimData.dimensionOrder;
                }
            }
            DimensionData.saveDimensionData(worldSaveDir.toFile(), newDimensionData);
        }
    }
}

