/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.minecraft.defaults;

import com.pg85.otg.exception.InvalidConfigException;
import java.util.HashMap;
import java.util.Map;

public enum DefaultStructurePart {
    ENDCITY_BASE_FLOOR("endcity/base_floor"),
    ENDCITY_BASE_ROOF("endcity/base_roof"),
    ENDCITY_BRIDGE_END("endcity/bridge_end"),
    ENDCITY_BRIDGE_GENTLE_STAIRS("endcity/bridge_gentle_stairs"),
    ENDCITY_BRIDGE_PIECE("endcity/bridge_piece"),
    ENDCITY_BRIDGE_STEEP_STAIRS("endcity/bridge_steep_stairs"),
    ENDCITY_FAT_TOWER_BASE("endcity/fat_tower_base"),
    ENDCITY_FAT_TOWER_MIDDLE("endcity/fat_tower_middle"),
    ENDCITY_FAT_TOWER_TOP("endcity/fat_tower_top"),
    ENDCITY_SECOND_FLOOR("endcity/second_floor"),
    ENDCITY_SECOND_FLOOR_2("endcity/second_floor_2"),
    ENDCITY_SECOND_ROOF("endcity/second_roof"),
    ENDCITY_SHIP("endcity/ship"),
    ENDCITY_THIRD_FLOOR("endcity/third_floor"),
    ENDCITY_THIRD_FLOOR_B("endcity/third_floor_b"),
    ENDCITY_THIRD_FLOOR_C("endcity/third_floor_c"),
    ENDCITY_THIRD_ROOF("endcity/third_roof"),
    ENDCITY_TOWER_BASE("endcity/tower_base"),
    ENDCITY_TOWER_FLOOR("endcity/tower_floor"),
    ENDCITY_TOWER_PIECE("endcity/tower_piece"),
    ENDCITY_TOWER_TOP("endcity/tower_top"),
    FOSSIL_SKULL_01("minecraft:fossils/fossil_skull_01"),
    FOSSIL_SKULL_01_COAL("minecraft:fossils/fossil_skull_01_coal"),
    FOSSIL_SKULL_02("minecraft:fossils/fossil_skull_02"),
    FOSSIL_SKULL_02_COAL("minecraft:fossils/fossil_skull_02_coal"),
    FOSSIL_SKULL_03("minecraft:fossils/fossil_skull_03"),
    FOSSIL_SKULL_03_COAL("minecraft:fossils/fossil_skull_03_coal"),
    FOSSIL_SKULL_04("minecraft:fossils/fossil_skull_04"),
    FOSSIL_SKULL_04_COAL("minecraft:fossils/fossil_skull_04_coal"),
    FOSSIL_SPINE_01("minecraft:fossils/fossil_spine_01"),
    FOSSIL_SPINE_01_COAL("minecraft:fossils/fossil_spine_01_coal"),
    FOSSIL_SPINE_02("minecraft:fossils/fossil_spine_02"),
    FOSSIL_SPINE_02_COAL("minecraft:fossils/fossil_spine_02_coal"),
    FOSSIL_SPINE_03("minecraft:fossils/fossil_spine_03"),
    FOSSIL_SPINE_03_COAL("minecraft:fossils/fossil_spine_03_coal"),
    FOSSIL_SPINE_04("minecraft:fossils/fossil_spine_04"),
    FOSSIL_SPINE_04_COAL("minecraft:fossils/fossil_spine_04_coal"),
    IGLOO_TOP("minecraft:igloo/igloo_top"),
    IGLOO_MIDDLE("minecraft:igloo/igloo_middle"),
    IGLOO_BOTTOM("minecraft:igloo/igloo_bottom");

    private static final Map<String, DefaultStructurePart> ByPath;
    private final String path;

    public static DefaultStructurePart getDefaultStructurePart(String name) throws InvalidConfigException {
        DefaultStructurePart result;
        String lookupName = name;
        if (!lookupName.startsWith("minecraft:")) {
            lookupName = "minecraft:" + lookupName;
        }
        if ((result = ByPath.get(lookupName = lookupName.toLowerCase())) == null) {
            throw new InvalidConfigException("OpenTerrainGenerator doesn't know about a structure part called " + name);
        }
        return result;
    }

    private DefaultStructurePart(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getPath();
    }

    static {
        ByPath = new HashMap<String, DefaultStructurePart>();
        for (DefaultStructurePart defaultStructurePart : DefaultStructurePart.values()) {
            ByPath.put(defaultStructurePart.path, defaultStructurePart);
        }
    }
}

