/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import java.util.HashMap;
import java.util.Map;

public enum SaplingType {
    All,
    Oak,
    Redwood,
    Birch,
    SmallJungle,
    BigJungle,
    RedMushroom,
    BrownMushroom,
    Acacia,
    DarkOak,
    HugeRedwood,
    Custom;

    private static Map<String, SaplingType> BY_NAME;

    public boolean growsTree() {
        return this != RedMushroom && this != BrownMushroom;
    }

    public boolean requiresFourSaplings() {
        return this == BigJungle || this == DarkOak || this == HugeRedwood;
    }

    static SaplingType get(String name) {
        return BY_NAME.get(name.toLowerCase());
    }

    static {
        BY_NAME = new HashMap<String, SaplingType>();
        for (SaplingType type : SaplingType.values()) {
            BY_NAME.put(type.name().toLowerCase(), type);
        }
    }
}

