/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeGroup;
import com.pg85.otg.configuration.biome.BiomeGroupManager;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.layers.Layer;
import java.util.Map;
import java.util.SortedMap;

public class LayerBiome
extends Layer {
    private BiomeGroupManager manager;
    private int depth;
    private double freezeTemp;

    LayerBiome(long seed, int defaultOceanId, Layer childLayer, BiomeGroupManager groupManager, int depth, double freezeTemp) {
        super(seed, defaultOceanId);
        this.child = childLayer;
        this.manager = groupManager;
        this.depth = depth;
        this.freezeTemp = freezeTemp;
    }

    @Override
    public int[] getInts(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(world, cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int i = 0; i < zSize; ++i) {
            for (int j = 0; j < xSize; ++j) {
                BiomeGroup group;
                SortedMap<Integer, LocalBiome> possibleBiomes;
                this.initChunkSeed(j + x, i + z);
                int currentPiece = childInts[j + i * xSize];
                if (!((currentPiece & 0x1FC000) == 0 || (currentPiece & 0x800000) != 0 && (currentPiece & 0x7FF) != this.defaultOceanId || (possibleBiomes = (group = this.manager.getGroupById((currentPiece & 0x1FC000) >> 14)).getDepthMapOrHigher(this.depth)).isEmpty())) {
                    int newBiomeRarity = this.nextInt(BiomeGroupManager.getMaxRarityFromPossibles(possibleBiomes));
                    for (Map.Entry<Integer, LocalBiome> biome : possibleBiomes.entrySet()) {
                        if (newBiomeRarity >= biome.getKey()) continue;
                        if (biome.getValue() == null || biome.getValue().getBiomeConfig().biomeSize != this.depth) break;
                        currentPiece |= biome.getValue().getIds().getOTGBiomeId() | ((double)biome.getValue().getBiomeConfig().biomeTemperature <= this.freezeTemp ? 8192 : 0) | 0x800000;
                        break;
                    }
                }
                thisInts[j + i * xSize] = currentPiece;
            }
        }
        return thisInts;
    }
}

