/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.biome.BeforeGroupsBiomeGenerator;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.CachedBiomeGenerator;
import com.pg85.otg.generator.biome.FromImageBiomeGenerator;
import com.pg85.otg.generator.biome.NormalBiomeGenerator;
import com.pg85.otg.logging.LogMarker;
import java.util.HashMap;
import java.util.Map;

public class BiomeModeManager {
    private Map<String, Class<? extends BiomeGenerator>> registered = new HashMap<String, Class<? extends BiomeGenerator>>();
    public final Class<NormalBiomeGenerator> NORMAL = this.register("Normal", NormalBiomeGenerator.class);
    public final Class<FromImageBiomeGenerator> FROM_IMAGE = this.register("FromImage", FromImageBiomeGenerator.class);
    public final Class<BeforeGroupsBiomeGenerator> BEFORE_GROUPS = this.register("BeforeGroups", BeforeGroupsBiomeGenerator.class);

    public <T extends BiomeGenerator> Class<T> register(String name, Class<T> clazz) {
        this.registered.put(name, clazz);
        return clazz;
    }

    public Class<? extends BiomeGenerator> getBiomeManager(String name) {
        for (String key : this.registered.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            return this.registered.get(key);
        }
        OTG.log(LogMarker.WARN, "{} is not a valid biome mode, falling back on Normal.", name);
        return this.NORMAL;
    }

    private <T extends BiomeGenerator> BiomeGenerator create(Class<T> clazz, LocalWorld world) {
        try {
            return (BiomeGenerator)clazz.getConstructor(LocalWorld.class).newInstance(world);
        }
        catch (Exception e) {
            OTG.log(LogMarker.FATAL, "Cannot properly reflect biome manager, falling back on BiomeMode:Normal", new Object[0]);
            OTG.printStackTrace(LogMarker.FATAL, e);
            return new NormalBiomeGenerator(world);
        }
    }

    public BiomeGenerator createCached(Class<? extends BiomeGenerator> biomeModeClass, LocalWorld world) {
        return CachedBiomeGenerator.makeCached(this.create(biomeModeClass, world));
    }

    public String getName(Class<? extends BiomeGenerator> clazz) {
        for (Map.Entry<String, Class<? extends BiomeGenerator>> entry : this.registered.entrySet()) {
            if (!entry.getValue().equals(clazz)) continue;
            return entry.getKey();
        }
        return null;
    }
}

