/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.world;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.common.WorldSession;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.settings.ReplacedBlocksMatrix;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.SpawnableObject;
import com.pg85.otg.customobjects.bofunctions.EntityFunction;
import com.pg85.otg.customobjects.structures.CustomStructureCache;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.biomes.ForgeBiomeRegistryManager;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.forge.generator.OTGChunkGenerator;
import com.pg85.otg.forge.generator.structure.MojangStructurePart;
import com.pg85.otg.forge.generator.structure.OTGMineshaftGen;
import com.pg85.otg.forge.generator.structure.OTGNetherFortressGen;
import com.pg85.otg.forge.generator.structure.OTGOceanMonumentGen;
import com.pg85.otg.forge.generator.structure.OTGRareBuildingGen;
import com.pg85.otg.forge.generator.structure.OTGStrongholdGen;
import com.pg85.otg.forge.generator.structure.OTGVillageGen;
import com.pg85.otg.forge.generator.structure.OTGWoodLandMansionGen;
import com.pg85.otg.forge.materials.ForgeMaterialData;
import com.pg85.otg.forge.util.IOHelper;
import com.pg85.otg.forge.util.NBTHelper;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.forge.world.WorldHelper;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ClientConfigProvider;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.network.ServerConfigProvider;
import com.pg85.otg.util.BiomeIds;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import com.pg85.otg.util.minecraft.defaults.TreeType;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomUtils;

public class ForgeWorld
implements LocalWorld {
    public static final int MAX_BIOMES_COUNT = 4096;
    public static final int MAX_SAVED_BIOMES_COUNT = 256;
    public static final int STANDARD_WORLD_HEIGHT = 128;
    private ForgeWorldSession worldSession;
    public boolean isLoadedOnServer;
    public int clientDimensionId = 0;
    private OTGChunkGenerator generator;
    public World world;
    private ConfigProvider settings;
    private CustomStructureCache structureCache;
    private String name;
    private long seed;
    private BiomeGenerator biomeGenerator;
    public HashMap<String, LocalBiome> biomeNames = new HashMap();
    private MapGenStructure strongholdGen;
    public MapGenStructure villageGen;
    private MapGenStructure mineshaftGen;
    private MapGenStructure rareBuildingGen;
    private MapGenBase cavesGen;
    private OTGNetherFortressGen netherFortressGen;
    private MapGenStructure oceanMonumentGen;
    private MapGenStructure woodLandMansionGen;
    private WorldGenDungeons dungeonGen;
    private WorldGenFossils fossilGen;
    private WorldGenTrees tree;
    private WorldGenSavannaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenBirchTree birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenCanopyTree darkOakTree;
    private WorldGenShrub groundBush;
    private WorldGenBigMushroom hugeRedMushroom;
    private WorldGenBigMushroom hugeBrownMushroom;
    private WorldGenMegaPineTree hugeTaigaTree1;
    private WorldGenMegaPineTree hugeTaigaTree2;
    private WorldGenMegaJungle jungleTree;
    private WorldGenBirchTree longBirchTree;
    private WorldGenSwamp swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;
    private LocalBiome[][] cachedBiomes;
    private boolean cacheIsValid;
    private static boolean inited = false;
    private static Method canSpawnStructureAtCoordsMethodObf = null;
    private static Method canSpawnStructureAtCoordsMethodDeObf = null;
    private boolean isOTGPlusLoaded = false;
    private boolean isOTGPlus = false;

    public ForgeWorld(String _name) {
        OTG.log(LogMarker.INFO, "Creating world \"" + _name + "\"", new Object[0]);
        this.name = _name;
    }

    public void provideWorldInstance(WorldServer world) {
        ServerConfigProvider configs = (ServerConfigProvider)this.settings;
        DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(WorldHelper.getName((World)world));
        this.world = world;
        OTGDimensionManager.ApplyGameRulesToWorld((World)world, dimConfig);
        this.seed = world.func_72912_H().func_76063_b();
        world.func_181544_b(configs.getWorldConfig().waterLevelMax);
        this.dungeonGen = new WorldGenDungeons();
        this.fossilGen = new WorldGenFossils();
        this.netherFortressGen = new OTGNetherFortressGen(this);
        this.cavesGen = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGStrongholdGen(configs, world), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGVillageGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGMineshaftGen(this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.rareBuildingGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGRareBuildingGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.oceanMonumentGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGOceanMonumentGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.woodLandMansionGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGWoodLandMansionGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.WOODLAND_MANSION);
        IBlockState jungleLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.tree = new WorldGenTrees(false);
        this.acaciaTree = new WorldGenSavannaTree(false);
        this.cocoaTree = new WorldGenTrees(false, 5, jungleLog, jungleLeaves, true);
        this.bigTree = new WorldGenBigTree(false);
        this.birchTree = new WorldGenBirchTree(false, false);
        this.darkOakTree = new WorldGenCanopyTree(false);
        this.longBirchTree = new WorldGenBirchTree(false, true);
        this.swampTree = new WorldGenSwamp();
        this.taigaTree1 = new WorldGenTaiga1();
        this.taigaTree2 = new WorldGenTaiga2(false);
        this.hugeRedMushroom = new WorldGenBigMushroom(Blocks.field_150419_aX);
        this.hugeBrownMushroom = new WorldGenBigMushroom(Blocks.field_150420_aW);
        this.hugeTaigaTree1 = new WorldGenMegaPineTree(false, false);
        this.hugeTaigaTree2 = new WorldGenMegaPineTree(false, true);
        this.jungleTree = new WorldGenMegaJungle(false, 10, 20, jungleLog, jungleLeaves);
        this.groundBush = new WorldGenShrub(jungleLog, jungleLeaves);
        this.generator = new OTGChunkGenerator(this);
        this.worldSession = new ForgeWorldSession(this);
        this.structureCache = new CustomStructureCache(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigsBukkit(WorldClient world, ClientConfigProvider config) {
        this.settings = config;
        this.world = world;
        this.seed = world.func_72905_C();
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigs(ClientConfigProvider config) {
        this.settings = config;
        this.worldSession = new ForgeWorldSession(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientWorld(World world) {
        this.world = world;
        this.seed = world.func_72905_C();
    }

    public void provideConfigs(ServerConfigProvider configs) {
        this.settings = configs;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getWorldSettingsName() {
        return this.getWorld().func_72912_H().func_76065_j();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int getHeightCap() {
        return this.settings.getWorldConfig().worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.getWorldConfig().worldHeightScale;
    }

    public OTGChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    public void setBiomeGenerator(BiomeGenerator generator) {
        this.biomeGenerator = generator;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public CustomStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public ObjectSpawner getObjectSpawner() {
        return this.generator.spawner;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public File getWorldSaveDir() {
        return this.getWorld().func_72860_G().func_75765_b();
    }

    @Override
    public int getDimensionId() {
        return this.getWorld().field_73011_w.getDimension();
    }

    @Override
    public void updateSpawnPointY() {
        DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(this.getName());
        if (!dimConfig.Settings.SpawnPointSet) {
            LocalMaterialData highestBlockMaterial;
            BlockPos spawnPos = this.getSpawnPoint();
            int highestY = this.getHighestBlockYAt(spawnPos.func_177958_n(), spawnPos.func_177952_p(), true, true, false, true, true, null);
            if (highestY == -1) {
                highestY = this.getHighestBlockYAt(spawnPos.func_177958_n(), spawnPos.func_177952_p(), true, true, false, true, false, null);
            }
            if ((highestBlockMaterial = this.getMaterial(spawnPos.func_177958_n(), highestY, spawnPos.func_177952_p(), null)).isMaterial(DefaultMaterial.WATER) || highestBlockMaterial.isMaterial(DefaultMaterial.STATIONARY_WATER)) {
                this.setBlock(spawnPos.func_177958_n(), highestY, spawnPos.func_177952_p(), MaterialHelper.ICE, null, null, false);
            } else if (highestBlockMaterial.isMaterial(DefaultMaterial.LAVA) || highestBlockMaterial.isMaterial(DefaultMaterial.STATIONARY_LAVA)) {
                this.setBlock(spawnPos.func_177958_n(), highestY, spawnPos.func_177952_p(), MaterialHelper.MAGMA, null, null, false);
            }
            this.world.func_72912_H().func_176143_a(new BlockPos(spawnPos.func_177958_n(), highestY + 1, spawnPos.func_177952_p()));
            dimConfig.Settings.SpawnPointSet = true;
            dimConfig.Settings.SpawnPointX = spawnPos.func_177958_n();
            dimConfig.Settings.SpawnPointY = highestY;
            dimConfig.Settings.SpawnPointZ = spawnPos.func_177952_p();
            OTG.getDimensionsConfig().save();
        }
    }

    public BlockPos getSpawnPoint() {
        return this.world.field_73011_w.getSpawnPoint();
    }

    @Override
    public WorldSession getWorldSession() {
        return this.worldSession;
    }

    @Override
    public void deleteWorldSessionData() {
        if (this.getWorld() != null) {
            int dimensionId = this.getWorld().field_73011_w.getDimension();
            File worldDataDir = new File(this.getWorld().func_72860_G().func_75765_b() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : ""));
            if (worldDataDir.exists()) {
                IOHelper.deleteRecursive(worldDataDir);
            }
        }
    }

    public Biome getBiomeFromChunk(int blockX, int blockZ) {
        Chunk chunk;
        if (this.getWorld() != null && this.getWorld().func_175667_e(new BlockPos(blockX, 255, blockZ)) && (chunk = this.getWorld().func_175726_f(new BlockPos(blockX, 0, blockZ))) != null && !(chunk instanceof EmptyChunk)) {
            byte[] blockBiomeArray = chunk.func_76605_m();
            int i = blockX & 0xF;
            int j = blockZ & 0xF;
            int biomeId = blockBiomeArray[j << 4 | i] & 0xFF;
            return Biome.func_150568_d((int)biomeId);
        }
        return null;
    }

    @Override
    public LocalBiome getCalculatedBiome(int x, int z) {
        return this.getBiomeByOTGIdOrNull(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public LocalBiome getBiomeForPopulation(int worldX, int worldZ, ChunkCoordinate chunkBeingPopulated) {
        return !this.cacheIsValid ? this.getBiome(worldZ, worldX) : this.cachedBiomes[worldX - chunkBeingPopulated.getBlockX()][worldZ - chunkBeingPopulated.getBlockZ()];
    }

    @Override
    public void cacheBiomesForPopulation(ChunkCoordinate chunkCoord) {
        this.cachedBiomes = new LocalBiome[32][32];
        int areaSize = 32;
        for (int x = 0; x < areaSize; ++x) {
            for (int z = 0; z < areaSize; ++z) {
                this.cachedBiomes[x][z] = this.getBiome(chunkCoord.getBlockX() + x, chunkCoord.getBlockZ() + z);
            }
        }
        this.cacheIsValid = true;
    }

    @Override
    public void invalidatePopulationBiomeCache() {
        this.cacheIsValid = false;
    }

    @Override
    public String getSavedBiomeName(int x, int z) {
        BiomeConfig biomeConfig = this.getBiome(x, z).getBiomeConfig();
        if (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() == 0) {
            return biomeConfig.getName();
        }
        return biomeConfig.replaceToBiomeName;
    }

    @Override
    public ArrayList<LocalBiome> getAllBiomes() {
        ArrayList<LocalBiome> biomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : this.settings.getBiomeArrayByOTGId()) {
            if (biome == null) continue;
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public LocalBiome getFirstBiomeOrNull() {
        return this.biomeNames.size() > 0 ? (LocalBiome)this.biomeNames.values().toArray()[0] : null;
    }

    @Override
    public ForgeBiome getBiomeByOTGIdOrNull(int id) {
        return (ForgeBiome)this.settings.getBiomeByOTGIdOrNull(id);
    }

    @Override
    public LocalBiome getBiomeByNameOrNull(String name) {
        return this.biomeNames.get(name);
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, ConfigProvider configProvider, boolean isReload) {
        ForgeBiome forgeBiome = ForgeBiomeRegistryManager.getOrCreateBiome(biomeConfig, biomeIds, this.getName(), configProvider);
        this.biomeNames.put(forgeBiome.getName(), forgeBiome);
        return forgeBiome;
    }

    @Override
    public int getRegisteredBiomeId(String resourceLocationString) {
        return ForgeBiomeRegistryManager.getRegisteredBiomeId(resourceLocationString, this.getName());
    }

    public void unRegisterBiomes() {
        ForgeBiomeRegistryManager.unregisterBiomes(this.biomeNames, this);
    }

    @Override
    public int getMaxBiomesCount() {
        return 4096;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 256;
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        BlockPos spawnPos = this.getSpawnPoint();
        return ChunkCoordinate.fromBlockCoords(spawnPos.func_177958_n(), spawnPos.func_177952_p());
    }

    @Override
    public boolean isInsidePregeneratedRegion(ChunkCoordinate chunk) {
        return this.getWorldSession().isInsidePregeneratedRegion(chunk);
    }

    @Override
    public int getLightLevel(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        if (y < 0 || y >= 256) {
            return -1;
        }
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated) || chunkBeingPopulated == null && this.world.func_175667_e(new BlockPos(x, 255, z))) {
            return this.world.func_175699_k(new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public int getBlockAboveLiquidHeight(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int highestY = this.getHighestBlockYAt(x, z, false, true, false, false, false, chunkBeingPopulated);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getBlockAboveSolidHeight(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int highestY = this.getHighestBlockYAt(x, z, true, false, true, true, false, chunkBeingPopulated);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getHighestBlockAboveYAt(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        return this.getHighestBlockYAt(x, z, true, true, false, false, false, chunkBeingPopulated) + 1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow, boolean ignoreLeaves, ChunkCoordinate chunkBeingPopulated) {
        int heightMapy;
        Chunk chunk = null;
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null && chunkBeingPopulated == null) {
            if (this.world.func_175667_e(new BlockPos(x, 255, z))) {
                chunk = this.getChunkGenerator().getChunk(x, z);
            } else {
                return this.generator.getHighestBlockYInUnloadedChunk(x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
            }
        }
        if (chunk == null) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        boolean incorrectHeightMap = false;
        for (heightMapy = chunk.func_76611_b(internalX, internalZ); heightMapy < this.getHeightCap() && chunk.func_186032_a(internalX, heightMapy, internalZ).func_185904_a().func_76228_b(); ++heightMapy) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.func_175664_x(new BlockPos(x, heightMapy, z));
        }
        for (int i = heightMapy; i >= 0; --i) {
            boolean isSolid;
            IBlockState blockState = chunk.func_186032_a(internalX, i, internalZ);
            Block block = blockState.func_177230_c();
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() && (!ignoreLeaves || block != Blocks.field_150364_r && block != Blocks.field_150363_s) || !ignoreLeaves && (block == Blocks.field_150362_t || block == Blocks.field_150361_u) || !ignoreSnow && block == Blocks.field_150431_aC;
            if (ignoreLiquid && isLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return i;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public int getHeightMapHeight(int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int heightMapy;
        Chunk chunk = null;
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null && chunkBeingPopulated == null && this.world.func_175667_e(new BlockPos(x, 255, z))) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null) {
            return -1;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        boolean incorrectHeightMap = false;
        for (heightMapy = chunk.func_76611_b(internalX, internalZ); heightMapy < this.getHeightCap() && chunk.func_186032_a(internalX, heightMapy, internalZ).func_185904_a().func_76228_b(); ++heightMapy) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.func_175664_x(new BlockPos(x, heightMapy, z));
        }
        return heightMapy;
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z, ChunkCoordinate chunkBeingPopulated) {
        if (y >= 256 || y < 0) {
            return null;
        }
        Chunk chunk = null;
        if (chunkBeingPopulated != null && OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            chunk = this.getChunkGenerator().getChunk(x, z);
        }
        if (chunk == null && chunkBeingPopulated == null) {
            if (this.world.func_175667_e(new BlockPos(x, 255, z))) {
                chunk = this.getChunkGenerator().getChunk(x, z);
            } else {
                return this.generator.getMaterialInUnloadedChunk(x, y, z);
            }
        }
        if (chunk == null) {
            return null;
        }
        int internalX = x & 0xF;
        int internalZ = z & 0xF;
        return ForgeMaterialData.ofMinecraftBlockState(chunk.func_186032_a(internalX, y, internalZ));
    }

    @Override
    public LocalMaterialData[] getBlockColumnInUnloadedChunk(int x, int z) {
        return this.generator.getBlockColumnInUnloadedChunk(x, z);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, ChunkCoordinate chunkBeingPopulated, boolean replaceBlocks) {
        this.setBlock(x, y, z, material, metaDataTag, chunkBeingPopulated, null, replaceBlocks);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, ChunkCoordinate chunkBeingPopulated, BiomeConfig biomeConfig, boolean replaceBlocks) {
        if (y < 0 || y >= 256) {
            return;
        }
        if (material.isEmpty()) {
            return;
        }
        if (chunkBeingPopulated == null || OTG.IsInAreaBeingPopulated(x, z, chunkBeingPopulated)) {
            if (replaceBlocks) {
                if (biomeConfig == null) {
                    biomeConfig = chunkBeingPopulated == null ? this.getBiome(x, z).getBiomeConfig() : this.getBiomeForPopulation(x, z, chunkBeingPopulated).getBiomeConfig();
                }
                material = material.parseWithBiomeAndHeight(this, biomeConfig, y);
            }
            this.getChunkGenerator().setBlock(x, y, z, material, metaDataTag);
        }
    }

    @Override
    public boolean placeDungeon(Random rand, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        return this.dungeonGen.func_180709_b(this.world, rand, new BlockPos(x, y, z));
    }

    @Override
    public boolean placeFossil(Random rand, ChunkCoordinate chunkCoord) {
        return this.fossilGen.func_180709_b(this.world, rand, new BlockPos(chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ()));
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return false;
        }
        BlockPos blockPos = new BlockPos(x, y, z);
        try {
            switch (type) {
                case Tree: {
                    return this.tree.func_180709_b(this.world, rand, blockPos);
                }
                case BigTree: {
                    return this.bigTree.func_180709_b(this.world, rand, blockPos);
                }
                case Forest: 
                case Birch: {
                    return this.birchTree.func_180709_b(this.world, rand, blockPos);
                }
                case TallBirch: {
                    return this.longBirchTree.func_180709_b(this.world, rand, blockPos);
                }
                case HugeMushroom: {
                    if (rand.nextBoolean()) {
                        return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
                    }
                    return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
                }
                case HugeRedMushroom: {
                    return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
                }
                case HugeBrownMushroom: {
                    return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
                }
                case SwampTree: {
                    return this.swampTree.func_180709_b(this.world, rand, blockPos);
                }
                case Taiga1: {
                    return this.taigaTree1.func_180709_b(this.world, rand, blockPos);
                }
                case Taiga2: {
                    return this.taigaTree2.func_180709_b(this.world, rand, blockPos);
                }
                case JungleTree: {
                    return this.jungleTree.func_180709_b(this.world, rand, blockPos);
                }
                case GroundBush: {
                    return this.groundBush.func_180709_b(this.world, rand, blockPos);
                }
                case CocoaTree: {
                    return this.cocoaTree.func_180709_b(this.world, rand, blockPos);
                }
                case Acacia: {
                    return this.acaciaTree.func_180709_b(this.world, rand, blockPos);
                }
                case DarkOak: {
                    return this.darkOakTree.func_180709_b(this.world, rand, blockPos);
                }
                case HugeTaiga1: {
                    return this.hugeTaigaTree1.func_180709_b(this.world, rand, blockPos);
                }
                case HugeTaiga2: {
                    return this.hugeTaigaTree2.func_180709_b(this.world, rand, blockPos);
                }
            }
            throw new RuntimeException("Failed to handle tree of type " + type.toString());
        }
        catch (NullPointerException ex) {
            OTG.log(LogMarker.WARN, "Treegen caused a non-fatal exception, likely due to cascading chunkgen: ", new Object[0]);
            ex.printStackTrace();
            return true;
        }
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled && dry) {
            this.villageGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public boolean placeDefaultStructures(Random rand, ChunkCoordinate chunkCoord) {
        ChunkPos chunkCoordIntPair = new ChunkPos(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        WorldConfig worldConfig = this.settings.getWorldConfig();
        boolean isVillagePlaced = false;
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.villagesEnabled) {
            isVillagePlaced = this.villageGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        return isVillagePlaced;
    }

    public void recreateStructures(Chunk chunkIn, int chunkX, int chunkZ) {
        WorldConfig worldConfig = this.getConfigs().getWorldConfig();
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled) {
            this.villageGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
    }

    @Override
    public SpawnableObject getMojangStructurePart(String name) {
        ResourceLocation resourceLocation = new ResourceLocation(name);
        TemplateManager mojangStructureParts = this.world.func_72860_G().func_186340_h();
        Template mojangStructurePart = mojangStructureParts.func_186237_a(this.world.func_73046_m(), resourceLocation);
        if (mojangStructurePart == null) {
            return null;
        }
        return new MojangStructurePart(name, mojangStructurePart);
    }

    @Override
    public boolean chunkHasDefaultStructure(Random rand, ChunkCoordinate chunkCoord) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        return worldConfig.villagesEnabled && this.isStructureInRadius(chunkCoord, this.villageGen, 4) || worldConfig.rareBuildingsEnabled && this.isStructureInRadius(chunkCoord, this.rareBuildingGen, 4) || worldConfig.netherFortressesEnabled && this.isStructureInRadius(chunkCoord, this.netherFortressGen, 4) || worldConfig.oceanMonumentsEnabled && this.isStructureInRadius(chunkCoord, this.oceanMonumentGen, 4) || worldConfig.woodLandMansionsEnabled && this.isStructureInRadius(chunkCoord, this.woodLandMansionGen, 4);
    }

    public boolean isStructureInRadius(ChunkCoordinate startChunk, MapGenStructure structure, int radiusInChunks) {
        if (!inited) {
            inited = true;
            try {
                canSpawnStructureAtCoordsMethodObf = ObfuscationReflectionHelper.findMethod(MapGenStructure.class, (String)"func_75047_a", Boolean.TYPE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            }
            catch (ReflectionHelper.UnableToFindMethodException unableToFindMethodException) {
                // empty catch block
            }
            try {
                canSpawnStructureAtCoordsMethodDeObf = ObfuscationReflectionHelper.findMethod(MapGenStructure.class, (String)"canSpawnStructureAtCoords", Boolean.TYPE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            }
            catch (ReflectionHelper.UnableToFindMethodException unableToFindMethodException) {
                // empty catch block
            }
            if (canSpawnStructureAtCoordsMethodObf == null && canSpawnStructureAtCoordsMethodDeObf == null) {
                OTG.log(LogMarker.ERROR, "Error, could not reflect MapGenStructure.canSpawnStructureAtCoords, BO4's may not be able to detect default/modded structures. OTG may not fully support your Forge version or modded structures.", new Object[0]);
                return false;
            }
        }
        if (canSpawnStructureAtCoordsMethodObf == null && canSpawnStructureAtCoordsMethodDeObf == null) {
            return false;
        }
        int chunkX = startChunk.getChunkX();
        int chunkZ = startChunk.getChunkZ();
        for (int cycle = 0; cycle <= radiusInChunks; ++cycle) {
            for (int xRadius = -cycle; xRadius <= cycle; ++xRadius) {
                for (int zRadius = -cycle; zRadius <= cycle; ++zRadius) {
                    int distance = (int)Math.floor(Math.sqrt(Math.pow(xRadius, 2.0) + Math.pow(zRadius, 2.0)));
                    if (distance != cycle) continue;
                    boolean canSpawnStructureAtCoords = false;
                    try {
                        if (canSpawnStructureAtCoordsMethodObf != null) {
                            canSpawnStructureAtCoords = (Boolean)canSpawnStructureAtCoordsMethodObf.invoke((Object)structure, chunkX + xRadius, chunkZ + zRadius);
                            if (!canSpawnStructureAtCoords) continue;
                            return true;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                    try {
                        if (canSpawnStructureAtCoordsMethodDeObf == null || !(canSpawnStructureAtCoords = ((Boolean)canSpawnStructureAtCoordsMethodDeObf.invoke((Object)structure, chunkX + xRadius, chunkZ + zRadius)).booleanValue())) continue;
                        return true;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        OTG.log(LogMarker.ERROR, "Error, could not reflect MapGenStructure.canSpawnStructureAtCoords, BO4's may not be able to detect default/modded structures. OTG may not fully support your Forge version or modded structures.", new Object[0]);
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public boolean isInsideStructure(String structureName, BlockPos pos) {
        if ("Stronghold".equals(structureName) && this.strongholdGen != null) {
            return this.strongholdGen.func_175795_b(pos);
        }
        if ("Mansion".equals(structureName) && this.woodLandMansionGen != null) {
            return this.woodLandMansionGen.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGen != null) {
            return this.oceanMonumentGen.func_175795_b(pos);
        }
        if (("OTGVillage".equals(structureName) || "Village".equals(structureName)) && this.villageGen != null) {
            return this.villageGen.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGen != null) {
            return this.mineshaftGen.func_175795_b(pos);
        }
        if (("OTGTemple".equals(structureName) || "Temple".equals(structureName)) && this.rareBuildingGen != null) {
            return this.rareBuildingGen.func_175795_b(pos);
        }
        if (("Fortress".equals(structureName) || "Fortress".equals(structureName)) && this.netherFortressGen != null) {
            return this.netherFortressGen.func_175795_b(pos);
        }
        return false;
    }

    public BlockPos getNearestStructurePos(String structureName, BlockPos blockPos, boolean p_180513_4_) {
        if ("Stronghold".equals(structureName) && this.strongholdGen != null) {
            return this.strongholdGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if ("Mansion".equals(structureName) && this.woodLandMansionGen != null) {
            return this.woodLandMansionGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGen != null) {
            return this.oceanMonumentGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if (("OTGVillage".equals(structureName) || "Village".equals(structureName)) && this.villageGen != null) {
            return this.villageGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGen != null) {
            return this.mineshaftGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if (("OTGTemple".equals(structureName) || "Temple".equals(structureName)) && this.rareBuildingGen != null) {
            return this.rareBuildingGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if (("Fortress".equals(structureName) || "Fortress".equals(structureName)) && this.netherFortressGen != null) {
            return this.netherFortressGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        return null;
    }

    @Override
    public double getBiomeBlocksNoiseValue(int xInWorld, int zInWorld) {
        return this.getChunkGenerator().getBiomeBlocksNoiseValue(xInWorld, zInWorld);
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
    }

    private void replaceBlocks(Chunk rawChunk) {
        int worldStartX = rawChunk.field_76635_g * 16;
        int worldStartZ = rawChunk.field_76647_h * 16;
        ExtendedBlockStorage[] sectionsArray = rawChunk.func_76587_i();
        int blockId = 0;
        ReplacedBlocksMatrix.ReplacedBlocksInstruction[][][] replaceInstructionsCache = new ReplacedBlocksMatrix.ReplacedBlocksInstruction[16][16][];
        for (ExtendedBlockStorage section : sectionsArray) {
            if (section == null) continue;
            for (int sectionX = 0; sectionX < 16; ++sectionX) {
                for (int sectionZ = 0; sectionZ < 16; ++sectionZ) {
                    ReplacedBlocksMatrix.ReplacedBlocksInstruction[] replaceArray = replaceInstructionsCache[sectionX][sectionZ];
                    if (replaceArray == null) {
                        LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                        if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) {
                            replaceArray = new ReplacedBlocksMatrix.ReplacedBlocksInstruction[]{};
                        } else {
                            biome.getBiomeConfig().replacedBlocks.parseForWorld(this);
                            replaceArray = new ReplacedBlocksMatrix.ReplacedBlocksInstruction[biome.getBiomeConfig().replacedBlocks.getInstructions().size()];
                            replaceArray = biome.getBiomeConfig().replacedBlocks.getInstructions().toArray(replaceArray);
                        }
                        replaceInstructionsCache[sectionX][sectionZ] = replaceArray;
                    }
                    if (replaceArray == null || replaceArray.length <= 0) continue;
                    int minHeight = 256;
                    int maxHeight = 0;
                    for (ReplacedBlocksMatrix.ReplacedBlocksInstruction instruction : replaceArray) {
                        if (instruction.getFrom() == null || instruction.getTo() == null) continue;
                        if (instruction.getMinHeight() < minHeight) {
                            minHeight = instruction.getMinHeight();
                        }
                        if (instruction.getMaxHeight() <= maxHeight) continue;
                        maxHeight = instruction.getMaxHeight();
                    }
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        IBlockState block = null;
                        int y = section.func_76662_d() + sectionY;
                        if (y < minHeight || y > maxHeight) continue;
                        for (ReplacedBlocksMatrix.ReplacedBlocksInstruction instruction : replaceArray) {
                            if (instruction.getFrom() == null || instruction.getTo() == null || y < instruction.getMinHeight() || y > instruction.getMaxHeight()) continue;
                            if (block == null) {
                                block = section.func_186049_g().func_186016_a(sectionX, sectionY, sectionZ);
                                blockId = Block.func_149682_b((Block)block.func_177230_c());
                            }
                            if (instruction.getFrom().getBlockId() != blockId) continue;
                            section.func_177484_a(sectionX, sectionY, sectionZ, ((ForgeMaterialData)instruction.getTo()).internalBlock());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        if (TerrainGen.populate((IChunkGenerator)this.getChunkGenerator(), (World)this.world, (Random)random, (int)chunkCoord.getChunkX(), (int)chunkCoord.getChunkZ(), (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.getWorld(), (Biome)((ForgeBiome)biome).getHandle(), (int)chunkCoord.getBlockXCenter(), (int)chunkCoord.getBlockZCenter(), (int)16, (int)16, (Random)random);
        }
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType paramaca, BlockPos blockPos) {
        WorldConfig worldConfig = this.getConfigs().getWorldConfig();
        Biome biomeBaseOTG = ((ForgeBiome)this.getBiome((int)blockPos.func_177958_n(), (int)blockPos.func_177952_p())).biomeBase;
        if (worldConfig.rareBuildingsEnabled && paramaca == EnumCreatureType.MONSTER && (this.rareBuildingGen instanceof OTGRareBuildingGen && ((OTGRareBuildingGen)this.rareBuildingGen).isSwampHutAtLocation(blockPos) || !(this.rareBuildingGen instanceof OTGRareBuildingGen) && ((MapGenScatteredFeature)this.rareBuildingGen).func_175798_a(blockPos))) {
            return this.rareBuildingGen instanceof OTGRareBuildingGen ? ((OTGRareBuildingGen)this.rareBuildingGen).getMonsterSpawnList() : ((MapGenScatteredFeature)this.rareBuildingGen).func_82667_a();
        }
        if (worldConfig.oceanMonumentsEnabled && paramaca == EnumCreatureType.MONSTER && this.oceanMonumentGen.func_175796_a(this.getWorld(), blockPos)) {
            return this.oceanMonumentGen instanceof OTGOceanMonumentGen ? ((OTGOceanMonumentGen)this.oceanMonumentGen).getMonsterSpawnList() : ((StructureOceanMonument)this.oceanMonumentGen).func_175799_b();
        }
        return biomeBaseOTG.func_76747_a(paramaca);
    }

    @Override
    public void spawnEntity(EntityFunction<?> entityData, ChunkCoordinate chunkBeingPopulated) {
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.DEBUG, "Attempting to spawn BO3 Entity() " + entityData.groupSize + " x " + entityData.name + " at " + entityData.x + " " + entityData.y + " " + entityData.z, new Object[0]);
        }
        if (chunkBeingPopulated != null && !OTG.IsInAreaBeingPopulated((int)Math.floor(entityData.x), (int)Math.floor(entityData.z), chunkBeingPopulated)) {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.DEBUG, "Tried to spawn entity " + entityData.resourceLocation + "outside population bounds, aborting", new Object[0]);
            }
            return;
        }
        if (entityData.y < 0 || entityData.y >= 256) {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.ERROR, "Failed to spawn mob " + entityData.name + ", spawn position out of bounds", new Object[0]);
            }
            return;
        }
        String nameTag = entityData.nameTagOrNBTFileName;
        Entity entity = this.createEntityFromData(entityData);
        if (entity == null) {
            return;
        }
        if (this.world.func_175677_d(new BlockPos(entityData.x, entityData.y, entityData.z), false) || (entity.isCreatureType(EnumCreatureType.WATER_CREATURE, false) || entity instanceof EntityGuardian) && this.world.func_180495_p(new BlockPos(entityData.x, entityData.y, entityData.z)).func_185904_a() != Material.field_151586_h) {
            this.world.func_72900_e(entity);
            return;
        }
        if (entity instanceof EntityLiving) {
            for (int r = 0; r < entityData.groupSize; ++r) {
                if (r != 0 && (entity = this.createEntityFromData(entityData)) == null) continue;
                if (nameTag != null && !nameTag.toLowerCase().trim().endsWith(".txt") && !nameTag.toLowerCase().trim().endsWith(".nbt")) {
                    entity.func_96094_a(nameTag);
                }
                ((EntityLiving)entity).func_110163_bv();
            }
        } else {
            for (int r = 0; r < entityData.groupSize; ++r) {
                if (r != 0 && (entity = this.createEntityFromData(entityData)) == null || !(entity instanceof EntityItemFrame) || ((EntityItemFrame)entity).field_174860_b != null) continue;
                ((EntityItemFrame)entity).field_174860_b = EnumFacing.SOUTH;
            }
        }
    }

    private Entity createEntityFromData(EntityFunction<?> entityData) {
        Entity entity;
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
            try {
                if (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt")) {
                    nbttagcompound = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                    nbttagcompound.func_74778_a("id", entityData.resourceLocation);
                } else if (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt")) {
                    nbttagcompound = NBTHelper.getNMSFromNBTTagCompound(entityData.namedBinaryTag);
                }
            }
            catch (NBTException nbtexception) {
                if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                }
                return null;
            }
            if (nbttagcompound.func_74764_b("Facing")) {
                byte face = nbttagcompound.func_74771_c("Facing");
                nbttagcompound.func_74774_a("Facing", (byte)((face + (6 - entityData.rotation)) % 4));
            }
            if (nbttagcompound.func_74764_b("Rotation")) {
                NBTTagList list = nbttagcompound.func_150295_c("Rotation", 5);
                float f = list.func_150308_e(0);
                if (f == 1.0f) {
                    f += (float)RandomUtils.nextInt((int)0, (int)350);
                }
                list.func_150304_a(0, (NBTBase)new NBTTagFloat((f + (float)((2 - entityData.rotation) % 4 * 90)) % 360.0f));
            }
            if ((entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)this.world, (double)((double)entityData.x + 0.5), (double)entityData.y, (double)((double)entityData.z + 0.5), (boolean)true)) == null) {
                return null;
            }
        } else {
            nbttagcompound.func_74778_a("id", entityData.resourceLocation);
            entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)this.world, (double)((double)entityData.x + 0.5), (double)entityData.y, (double)((double)entityData.z + 0.5), (boolean)true);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(this.world.func_175649_E(new BlockPos(entityData.x, entityData.y, entityData.z)), (IEntityLivingData)null);
            }
            if (entity == null) {
                return null;
            }
        }
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.DEBUG, "Spawned OK", new Object[0]);
        }
        return entity;
    }

    @Override
    public boolean generateModdedCaveGen(int x, int z, ChunkBuffer chunkBuffer) {
        if (this.cavesGen == null || this.cavesGen.getClass() == MapGenCaves.class) {
            return false;
        }
        ChunkPrimer primer = ((ForgeChunkBuffer)chunkBuffer).getChunkPrimer();
        this.cavesGen.func_186125_a(this.world, x, z, primer);
        return true;
    }

    @Override
    public boolean isInsideWorldBorder(ChunkCoordinate chunkCoordinate) {
        return this.world.func_175723_af().func_177746_a(new BlockPos(chunkCoordinate.getBlockXCenter(), 0, chunkCoordinate.getBlockZCenter()));
    }

    @Override
    public boolean isBo4Enabled() {
        if (!this.isOTGPlusLoaded) {
            this.isOTGPlusLoaded = true;
            DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(this.getName());
            if (dimConfig != null && dimConfig.Settings.IsOTGPlus) {
                this.isOTGPlus = true;
            }
        }
        return this.isOTGPlus;
    }
}

