/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.blocks.portal.PortalColors;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.gui.GuiHandler;
import com.pg85.otg.forge.gui.OTGGuiEnterWorldName;
import com.pg85.otg.forge.gui.dimensions.OTGGuiDimensionSettingsList;
import com.pg85.otg.forge.gui.dimensions.base.OTGGuiSlotDimensionList;
import com.pg85.otg.forge.gui.dimensions.base.SettingEntry;
import com.pg85.otg.forge.gui.presets.OTGGuiPresetList;
import com.pg85.otg.forge.network.client.ClientPacketManager;
import com.pg85.otg.forge.pregenerator.Pregenerator;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.logging.LogMarker;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import org.lwjgl.input.Mouse;
import scala.Int;

public class OTGGuiDimensionList
extends GuiScreen
implements GuiYesNoCallback {
    private static boolean ShowingOpenLinkDialogue;
    public SettingEntry<?> buttonId;
    public OTGGuiDimensionSettingsList dimensionSettingsList;
    public OTGGuiPresetList selectPresetForDimensionMenu = new OTGGuiPresetList(this);
    public boolean selectingPresetForDimension = false;
    private boolean creatingNewDimension = false;
    public OTGGuiPresetList previousMenu;
    private OTGGuiSlotDimensionList dimensionsList;
    public int selectedDimensionIndex = -1;
    public String worldName;
    public String modPackConfigName;
    public int modPackConfigVersion;
    public final ArrayList<DimensionConfig> dimensions;
    private final ArrayList<DimensionConfig> originalDimensions;
    public DimensionConfig selectedDimension;
    public int listWidth = 100;
    public int topMargin = 37;
    public int bottomMargin = 73;
    private int btnBottomMargin = 63;
    public int leftMargin = 10;
    private int rightMargin = 10;
    public int slotHeight = 16;
    private int margin = 20;
    private GuiButton btnContinue;
    public GuiButton btnCancel;
    private GuiButton btnDelete;
    private final int iContinueButton = 0;
    private final int iCancelButton = 1;
    private final int iNewButton = 2;
    private final int iDeleteButton = 3;
    private boolean restoreSelection = false;
    private boolean previouslySelectedMainMenu = false;
    private boolean previouslySelectedGameRulesMenu = false;
    private boolean previouslySelectedAdvancedSettingsMenu = false;
    private float lastScrollPos = 0.0f;
    private boolean settingsChanged = false;
    private int wikiBtnLeft;
    private int wikiBtnTop;
    private int wikiBtnWidth;
    private int wikiBtnHeight;
    private int wikiBtnRight;
    private int wikiBtnBottom;
    private long lastPregeneratorCheckTime = System.currentTimeMillis();

    public OTGGuiDimensionList(OTGGuiPresetList previousMenu) {
        ShowingOpenLinkDialogue = false;
        this.previousMenu = previousMenu;
        this.dimensions = new ArrayList();
        if (!GuiHandler.IsInMainMenu) {
            if (Minecraft.func_71410_x().func_71356_B()) {
                this.modPackConfigName = OTG.getDimensionsConfig().ModPackConfigName;
                this.modPackConfigVersion = OTG.getDimensionsConfig().ModPackConfigVersion;
                this.dimensions.add(OTG.getDimensionsConfig().Overworld);
                for (DimensionConfig dimensionConfig : OTG.getDimensionsConfig().Dimensions) {
                    this.dimensions.add(dimensionConfig);
                }
            } else {
                this.dimensions.add(OTG.getDimensionsConfig().Overworld.clone());
                for (DimensionConfig dimensionConfig : OTG.getDimensionsConfig().Dimensions) {
                    this.dimensions.add(dimensionConfig.clone());
                }
            }
        } else {
            DimensionsConfig defaultConfig = null;
            defaultConfig = OTG.getEngine().getModPackConfigManager().getModPackConfig((String)previousMenu.selectedPreset.func_76341_a());
            if (defaultConfig != null) {
                this.modPackConfigName = defaultConfig.ModPackConfigName;
                this.modPackConfigVersion = defaultConfig.ModPackConfigVersion;
                this.dimensions.add(defaultConfig.Overworld.clone());
                for (DimensionConfig dimConfig : defaultConfig.Dimensions) {
                    DimensionConfig newConfig = dimConfig.clone();
                    PortalColors.correctPortalColor(newConfig, this.dimensions);
                    this.dimensions.add(newConfig);
                }
            }
            if (defaultConfig == null) {
                this.dimensions.add(new DimensionConfig((DimensionConfigGui)previousMenu.selectedPreset.func_76340_b()));
                block3: for (String dimName : ((DimensionConfigGui)previousMenu.selectedPreset.func_76340_b()).dimensions) {
                    for (Map.Entry<String, DimensionConfigGui> preset : GuiHandler.GuiPresets.entrySet()) {
                        if (!dimName.equals(preset.getKey())) continue;
                        DimensionConfig dimConfig = new DimensionConfig(preset.getValue());
                        PortalColors.correctPortalColor(dimConfig, this.dimensions);
                        this.dimensions.add(dimConfig);
                        continue block3;
                    }
                }
            }
        }
        this.selectedDimension = this.dimensions.get(0);
        this.selectedDimensionIndex = 0;
        this.originalDimensions = new ArrayList();
        for (DimensionConfig dimensionConfig : this.dimensions) {
            this.originalDimensions.add(dimensionConfig.clone());
        }
    }

    public OTGGuiDimensionList(int previouslySelectedIndex, boolean isMainMenu, boolean isGameRulesMenu, boolean isAdvancedSettingsMenu, float lastScrollPos) {
        this.previousMenu = null;
        this.dimensions = new ArrayList();
        this.restoreSelection = true;
        this.previouslySelectedMainMenu = isMainMenu;
        this.previouslySelectedGameRulesMenu = isGameRulesMenu;
        this.previouslySelectedAdvancedSettingsMenu = isAdvancedSettingsMenu;
        this.lastScrollPos = lastScrollPos;
        this.modPackConfigName = OTG.getDimensionsConfig().ModPackConfigName;
        this.modPackConfigVersion = OTG.getDimensionsConfig().ModPackConfigVersion;
        this.dimensions.add(OTG.getDimensionsConfig().Overworld.clone());
        for (DimensionConfig dimConfig : OTG.getDimensionsConfig().Dimensions) {
            this.dimensions.add(dimConfig.clone());
        }
        if (previouslySelectedIndex >= this.dimensions.size()) {
            previouslySelectedIndex = this.dimensions.size() - 1;
        }
        this.selectedDimension = this.dimensions.get(previouslySelectedIndex);
        this.selectedDimensionIndex = previouslySelectedIndex;
        this.originalDimensions = new ArrayList();
        for (DimensionConfig dimConfig : this.dimensions) {
            this.originalDimensions.add(dimConfig.clone());
        }
    }

    public Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        if (this.selectingPresetForDimension) {
            this.selectingPresetForDimension = false;
            if (this.creatingNewDimension) {
                this.creatingNewDimension = false;
                if (this.selectPresetForDimensionMenu.selectedPreset != null) {
                    boolean bFoundDefaultSettigForDim = false;
                    DimensionsConfig defaultConfig = OTG.getEngine().getModPackConfigManager().getModPackConfig(this.field_146297_k.field_71441_e != null ? OTG.getDimensionsConfig().Overworld.PresetName : (String)this.previousMenu.selectedPreset.func_76341_a());
                    if (defaultConfig != null) {
                        DimensionConfig newConfig = null;
                        this.modPackConfigName = defaultConfig.ModPackConfigName;
                        this.modPackConfigVersion = defaultConfig.ModPackConfigVersion;
                        for (DimensionConfig dimConfig : defaultConfig.Dimensions) {
                            if (!dimConfig.PresetName.equals(this.selectPresetForDimensionMenu.selectedPreset.func_76341_a())) continue;
                            newConfig = dimConfig.clone();
                            newConfig.isNewConfig = this.field_146297_k.field_71441_e != null;
                            PortalColors.correctPortalColor(newConfig, this.dimensions);
                            this.dimensions.add(newConfig);
                            bFoundDefaultSettigForDim = true;
                            break;
                        }
                    }
                    if (!bFoundDefaultSettigForDim) {
                        DimensionConfig newConfig = new DimensionConfig((DimensionConfigGui)this.selectPresetForDimensionMenu.selectedPreset.func_76340_b());
                        newConfig.isNewConfig = this.field_146297_k.field_71441_e != null;
                        PortalColors.correctPortalColor(newConfig, this.dimensions);
                        this.dimensions.add(newConfig);
                    }
                    this.selectedDimension = this.dimensions.get(this.dimensions.size() - 1);
                    this.dimensionsList.selectedIndex = this.dimensions.size() - 1;
                    this.dimensionsList.lastClickTime = System.currentTimeMillis();
                    this.selectDimensionIndex(this.dimensionsList.selectedIndex);
                    this.compareSettingsToOriginal();
                }
            } else if (this.selectPresetForDimensionMenu.selectedPreset != null) {
                this.selectedDimension.PresetName = (String)this.selectPresetForDimensionMenu.selectedPreset.func_76341_a();
            }
        }
        this.field_146292_n.add(new GuiButton(2, this.leftMargin, this.field_146295_m - this.btnBottomMargin, this.listWidth, 20, "Add"));
        this.btnDelete = new GuiButton(3, this.leftMargin, this.field_146295_m - (this.btnBottomMargin - 24), this.listWidth, 20, "Delete");
        this.field_146292_n.add(this.btnDelete);
        boolean isNewDim = this.selectedDimension.isNewConfig;
        boolean isLoaded = false;
        if (!isNewDim) {
            ForgeWorld forgeWorld;
            if (this.field_146297_k.func_71356_B()) {
                forgeWorld = !GuiHandler.IsInMainMenu && this.selectedDimensionIndex != 0 ? (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(this.selectedDimension.PresetName) : null;
                isLoaded = this.selectedDimensionIndex == 0 || forgeWorld != null;
            } else {
                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(this.selectedDimension.PresetName);
                isLoaded = this.selectedDimensionIndex == 0 || forgeWorld != null && forgeWorld.isLoadedOnServer;
            }
        }
        this.btnDelete.field_146124_l = this.selectedDimensionIndex != 0 && (isNewDim || !isLoaded);
        int maxBtnWidth = 330;
        int btnWidth = this.field_146294_l - this.listWidth - this.margin - this.rightMargin;
        btnWidth = btnWidth > maxBtnWidth ? maxBtnWidth : btnWidth;
        this.btnContinue = new GuiButton(0, this.listWidth + this.margin, this.field_146295_m - this.btnBottomMargin, btnWidth, 20, "Continue");
        this.field_146292_n.add(this.btnContinue);
        this.btnCancel = new GuiButton(1, this.listWidth + this.margin, this.field_146295_m - (this.btnBottomMargin - 24), btnWidth, 20, "Cancel");
        this.field_146292_n.add(this.btnCancel);
        if (!GuiHandler.IsInMainMenu) {
            boolean bFound = false;
            for (DimensionConfig dimConfig : this.dimensions) {
                if (!dimConfig.isNewConfig) continue;
                bFound = true;
            }
            if (bFound || !this.field_146297_k.func_71356_B()) {
                this.btnContinue.field_146126_j = "Apply";
                this.btnCancel.field_146126_j = "Cancel";
                this.btnContinue.field_146124_l = this.field_146297_k.func_71356_B() ? true : this.settingsChanged;
            } else {
                this.btnContinue.field_146126_j = "";
                this.btnCancel.field_146126_j = "Back";
                this.btnContinue.field_146124_l = false;
            }
        }
        if (this.dimensionSettingsList == null) {
            this.dimensionSettingsList = new OTGGuiDimensionSettingsList(this, this.topMargin, this.field_146295_m - this.bottomMargin, this.listWidth + this.margin, this.field_146294_l - this.listWidth - this.margin - this.rightMargin, this.field_146297_k);
            this.dimensionsList = new OTGGuiSlotDimensionList(this, this, this.dimensions);
        } else {
            this.dimensionSettingsList.resize(this.topMargin, this.field_146295_m - this.bottomMargin, this.listWidth + this.margin, this.field_146294_l - this.listWidth - this.margin - this.rightMargin);
            this.dimensionsList.resize();
        }
        this.updateCache();
    }

    public int drawLine(String line, int offset, int shifty) {
        this.field_146289_q.func_78276_b(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.dimensionsList == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastPregeneratorCheckTime > 1000L) {
            this.lastPregeneratorCheckTime = System.currentTimeMillis();
            for (LocalWorld forgeWorld : OTG.getEngine().getAllWorlds()) {
                if ((this.selectedDimensionIndex != 0 || !((ForgeWorld)forgeWorld).getName().equals("overworld")) && !((ForgeWorld)forgeWorld).getName().equals(this.selectedDimension.PresetName) || forgeWorld.getWorldSession() == null) continue;
                Pregenerator pregenerator = ((ForgeWorldSession)forgeWorld.getWorldSession()).getPregenerator();
                if (pregenerator.isRunning() && pregenerator.preGeneratorProgressStatus != "Done") {
                    if (this.dimensionSettingsList.showingPregeneratorStatus) continue;
                    this.dimensionSettingsList.refreshData();
                    continue;
                }
                if (!this.dimensionSettingsList.showingPregeneratorStatus) continue;
                this.dimensionSettingsList.refreshData();
            }
        }
        this.dimensionsList.drawScreen(mouseX, mouseY, partialTicks, this.field_73735_i);
        this.dimensionSettingsList.drawScreen(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, GuiHandler.IsInMainMenu ? "Create dimensions" : "Manage dimensions", this.field_146294_l / 2, 16, 0xFFFFFF);
        this.wikiBtnWidth = this.field_146289_q.func_78256_a("Wiki");
        this.wikiBtnHeight = 6;
        this.wikiBtnLeft = this.field_146294_l - (this.rightMargin + this.field_146289_q.func_78256_a("Wiki")) - 2;
        this.wikiBtnRight = this.wikiBtnLeft + this.wikiBtnWidth;
        this.wikiBtnTop = 16;
        this.wikiBtnBottom = this.wikiBtnTop + this.wikiBtnHeight;
        this.func_73731_b(this.field_146289_q, TextFormatting.UNDERLINE + "Wiki", this.wikiBtnLeft, this.wikiBtnTop, 0x5555FF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!GuiHandler.IsInMainMenu && !this.field_146297_k.func_71356_B() && this.btnContinue.field_146124_l != this.settingsChanged) {
            this.btnContinue.field_146124_l = this.settingsChanged;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            this.func_73864_a(0, 0, 0);
            switch (button.field_146127_k) {
                case 0: {
                    if (GuiHandler.IsInMainMenu) {
                        ArrayList<String> presetNames = new ArrayList<String>();
                        boolean bPortalColorsUnique = true;
                        for (DimensionConfig dimConfig : this.dimensions) {
                            presetNames.add(dimConfig.PresetName);
                            for (DimensionConfig dimConfig2 : this.dimensions) {
                                if (dimConfig2 == dimConfig || !dimConfig.Settings.PortalColor.toLowerCase().equals(dimConfig2.Settings.PortalColor.toLowerCase())) continue;
                                bPortalColorsUnique = false;
                            }
                        }
                        if (!bPortalColorsUnique) {
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Multiple dimensions are using the same portal color, each dimension's portal color must be unique."));
                        } else if (!OTG.getEngine().areEnoughBiomeIdsAvailableForPresets(presetNames)) {
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Not enough biome id's available to add all dimensions."));
                        } else {
                            this.field_146297_k.func_147108_a((GuiScreen)new OTGGuiEnterWorldName(this, this.dimensions.get((int)0).PresetName));
                        }
                    } else {
                        if (this.field_146297_k.func_71356_B()) {
                            this.applyGameRules();
                            boolean bPortalColorsUnique = true;
                            for (DimensionConfig dimConfig : this.dimensions) {
                                for (DimensionConfig dimConfig2 : this.dimensions) {
                                    if (dimConfig2 == dimConfig || !dimConfig.Settings.PortalColor.toLowerCase().equals(dimConfig2.Settings.PortalColor.toLowerCase())) continue;
                                    bPortalColorsUnique = false;
                                }
                            }
                            if (!bPortalColorsUnique) {
                                this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Multiple dimensions are using the same portal color, each dimension's portal color must be unique."));
                            } else {
                                for (DimensionConfig dimConfig : this.dimensions) {
                                    if (!dimConfig.isNewConfig) continue;
                                    ArrayList<String> presetNames = new ArrayList<String>();
                                    presetNames.add(dimConfig.PresetName);
                                    if (OTG.getEngine().areEnoughBiomeIdsAvailableForPresets(presetNames)) {
                                        dimConfig.isNewConfig = false;
                                        OTG.IsNewWorldBeingCreated = true;
                                        if (!OTGDimensionManager.createNewDimensionSP(dimConfig, (MinecraftServer)this.field_146297_k.func_71401_C())) {
                                            this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Dimension id " + dimConfig.DimensionId + " was taken."));
                                        }
                                        OTG.IsNewWorldBeingCreated = false;
                                        continue;
                                    }
                                    this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Not enough biome id's available to add all dimensions."));
                                    break;
                                }
                            }
                            this.dimensionSettingsList.refreshData();
                            this.btnContinue.field_146124_l = false;
                        } else {
                            ArrayList applyDimSettings = (ArrayList)this.dimensions.clone();
                            ArrayList<DimensionConfig> dimensionConfigsToUpdate = new ArrayList<DimensionConfig>();
                            boolean isOverWorldIncluded = false;
                            block11: for (int i = 0; i < applyDimSettings.size(); ++i) {
                                DimensionConfig dimConfig = (DimensionConfig)applyDimSettings.get(i);
                                if (dimConfig.isNewConfig) {
                                    dimConfig.isNewConfig = false;
                                    ClientPacketManager.sendCreateDimensionPacket(dimConfig);
                                    this.dimensionSettingsList.refreshData(true, false, false);
                                    continue;
                                }
                                for (DimensionConfig originalDimConfig : this.originalDimensions) {
                                    if (originalDimConfig.PresetName != null && !originalDimConfig.PresetName.equals(dimConfig.PresetName)) continue;
                                    if (originalDimConfig.toYamlString().equals(dimConfig.toYamlString())) continue block11;
                                    if (i == 0) {
                                        isOverWorldIncluded = true;
                                    }
                                    dimensionConfigsToUpdate.add(dimConfig);
                                    continue block11;
                                }
                            }
                            if (dimensionConfigsToUpdate.size() > 0) {
                                ClientPacketManager.sendUpdateDimensionSettingsPacket(dimensionConfigsToUpdate, isOverWorldIncluded);
                            }
                            this.settingsChanged = false;
                        }
                        this.btnContinue.field_146126_j = "";
                    }
                    return;
                }
                case 1: {
                    if (this.dimensionSettingsList.advancedSettingsMenu || this.dimensionSettingsList.gameRulesMenu) {
                        this.dimensionSettingsList.refreshData(true, false, false);
                        this.dimensionSettingsList.scrollBy(Int.MinValue());
                    } else {
                        if (this.field_146297_k.func_71356_B() && this.field_146297_k.field_71441_e != null) {
                            this.applyGameRules();
                            DimensionsConfig dimsConfig = OTG.getDimensionsConfig();
                            ArrayList<DimensionConfig> dims = new ArrayList<DimensionConfig>();
                            for (DimensionConfig dimConfig : dimsConfig.Dimensions) {
                                if (dimConfig.isNewConfig) continue;
                                dims.add(dimConfig);
                            }
                            dimsConfig.Dimensions = dims;
                            OTG.getDimensionsConfig().save();
                        }
                        this.field_146297_k.func_147108_a((GuiScreen)this.previousMenu);
                    }
                    return;
                }
                case 2: {
                    this.creatingNewDimension = true;
                    this.selectingPresetForDimension = true;
                    this.selectPresetForDimensionMenu = new OTGGuiPresetList(this, true);
                    this.field_146297_k.func_147108_a((GuiScreen)this.selectPresetForDimensionMenu);
                    return;
                }
                case 3: {
                    if (this.dimensionsList.selectedIndex == 0 || this.dimensionsList.selectedIndex == -1) {
                        return;
                    }
                    if (GuiHandler.IsInMainMenu || this.field_146297_k.func_71356_B()) {
                        boolean bSuccess = true;
                        if (!this.selectedDimension.isNewConfig && !GuiHandler.IsInMainMenu) {
                            bSuccess = OTGDimensionManager.DeleteDimensionServer(this.selectedDimension.PresetName, (MinecraftServer)this.field_146297_k.func_71401_C());
                        }
                        if (bSuccess) {
                            this.dimensions.remove(this.selectedDimension);
                            if (this.dimensionsList.selectedIndex >= this.dimensionsList.getSize()) {
                                this.dimensionsList.selectedIndex = this.dimensionsList.getSize() - 1;
                            }
                            this.dimensionsList.lastClickTime = System.currentTimeMillis();
                            this.selectDimensionIndex(this.dimensionsList.selectedIndex);
                        }
                    } else if (this.selectedDimension.isNewConfig) {
                        this.dimensions.remove(this.selectedDimension);
                        if (this.dimensionsList.selectedIndex >= this.dimensionsList.getSize()) {
                            this.dimensionsList.selectedIndex = this.dimensionsList.getSize() - 1;
                        }
                        this.dimensionsList.lastClickTime = System.currentTimeMillis();
                        this.selectDimensionIndex(this.dimensionsList.selectedIndex);
                    } else {
                        ClientPacketManager.sendDeleteDimensionPacket(this.selectedDimension.PresetName);
                    }
                    return;
                }
            }
            return;
        }
        super.func_146284_a(button);
    }

    public void func_73878_a(boolean ok, int worldId) {
        if (!ShowingOpenLinkDialogue && ok) {
            long i = new Random().nextLong();
            String s = this.dimensions.get((int)0).Seed;
            if (s != null && s.length() > 0) {
                try {
                    long j = Long.parseLong(s);
                    if (j != 0L) {
                        i = j;
                    }
                }
                catch (NumberFormatException numberformatexception) {
                    i = s.hashCode();
                }
            }
            WorldType.func_77130_a((String)"OTG").onGUICreateWorldPress();
            GameType gametype = this.dimensions.get((int)0).GameType.equals("Hardcore") ? GameType.SURVIVAL : GameType.func_77142_a((String)this.dimensions.get((int)0).GameType.toLowerCase());
            WorldSettings worldsettings = new WorldSettings(i, gametype, true, this.dimensions.get((int)0).GameType.equals("Hardcore"), WorldType.func_77130_a((String)"OTG"));
            worldsettings.func_82750_a("OpenTerrainGenerator");
            if (this.dimensions.get((int)0).BonusChest) {
                worldsettings.func_77159_a();
            }
            if (this.dimensions.get((int)0).AllowCheats) {
                worldsettings.func_77166_b();
            }
            if (this.field_146297_k.func_71359_d().func_75803_c(this.worldName) == null) {
                DimensionsConfig forgeWorldConfig = new DimensionsConfig(new File(this.field_146297_k.field_71412_D.getAbsolutePath() + File.separator + "saves" + File.separator), this.worldName);
                forgeWorldConfig.ModPackConfigName = this.modPackConfigName;
                forgeWorldConfig.ModPackConfigVersion = this.modPackConfigVersion;
                forgeWorldConfig.WorldName = this.worldName;
                forgeWorldConfig.Overworld = this.dimensions.get(0).clone();
                forgeWorldConfig.Dimensions = new ArrayList();
                for (int j = 1; j < this.dimensions.size(); ++j) {
                    forgeWorldConfig.Dimensions.add(this.dimensions.get(j).clone());
                }
                OTG.setDimensionsConfig(forgeWorldConfig);
                ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
                isaveformat.func_75800_d();
                isaveformat.func_75802_e(this.worldName);
                OTG.getDimensionsConfig().save();
                OTG.IsNewWorldBeingCreated = true;
                this.field_146297_k.func_71371_a(this.worldName, this.worldName, worldsettings);
                OTG.IsNewWorldBeingCreated = false;
            }
        }
        if (ShowingOpenLinkDialogue && ok) {
            try {
                this.openWebLink(new URI("http://openterraingen.wikia.com/wiki/In-game_tools_and_console_commands"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
            return;
        }
        if (ShowingOpenLinkDialogue && !ok) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
        }
        ShowingOpenLinkDialogue = false;
        super.func_73878_a(ok, worldId);
    }

    public void func_146274_d() throws IOException {
        if (this.field_146297_k != null) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            super.func_146274_d();
            this.dimensionsList.handleMouseInput(mouseX, mouseY);
            this.dimensionSettingsList.handleMouseInput();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.wikiLinkClicked(mouseX, mouseY)) {
            ShowingOpenLinkDialogue = true;
            GuiConfirmOpenLink gui = new GuiConfirmOpenLink((GuiYesNoCallback)this, "http://openterraingen.wikia.com/wiki/In-game_tools_and_console_commands", 0, true);
            gui.func_146358_g();
            this.field_146297_k.func_147108_a((GuiScreen)gui);
            return;
        }
        if (this.buttonId != null) {
            this.buttonId = null;
        }
        if (mouseButton != 0 || !this.dimensionSettingsList.mouseClicked(mouseX, mouseY, mouseButton)) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    private boolean wikiLinkClicked(int mouseX, int mouseY) {
        return mouseX >= this.wikiBtnLeft && mouseX <= this.wikiBtnRight && mouseY >= this.wikiBtnTop && mouseY <= this.wikiBtnBottom;
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (state != 0 || !this.dimensionSettingsList.mouseReleased(mouseX, mouseY, state)) {
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.btnCancel);
        }
        this.dimensionSettingsList.keyTyped(typedChar, keyCode);
        if (keyCode == 28 || keyCode == 83) {
            this.dimensionSettingsList.refreshData();
        }
    }

    public void compareSettingsToOriginal() {
        if (!GuiHandler.IsInMainMenu && !this.field_146297_k.func_71356_B()) {
            this.settingsChanged = false;
            for (DimensionConfig dimConfig : this.dimensions) {
                if (dimConfig.PresetName == null || !dimConfig.isNewConfig) continue;
                this.settingsChanged = true;
                return;
            }
            for (int i = 0; i < this.originalDimensions.size(); ++i) {
                DimensionConfig originalDimConfig = this.originalDimensions.get(i);
                DimensionConfig dimConfig = this.dimensions.get(i);
                boolean bl = this.settingsChanged = !dimConfig.toYamlString().equals(originalDimConfig.toYamlString());
                if (!this.settingsChanged) continue;
                return;
            }
        }
    }

    private void applyGameRules() {
        if (this.field_146297_k.field_71441_e != null) {
            DimensionsConfig dimsConfig = OTG.getDimensionsConfig();
            ArrayList<LocalWorld> worlds = ((ForgeEngine)OTG.getEngine()).getAllWorlds();
            for (LocalWorld world : worlds) {
                if (((ForgeWorld)world).getWorld() == null) continue;
                OTGDimensionManager.ApplyGameRulesToWorld(((ForgeWorld)world).getWorld(), dimsConfig.getDimensionConfig(((ForgeWorld)world).getName()));
            }
        }
    }

    private void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            OTG.log(LogMarker.ERROR, "Couldn't open link: {}", throwable == null ? "<UNKNOWN>" : throwable.getMessage());
        }
    }

    public void selectDimensionIndex(int index) {
        if (index >= this.dimensions.size()) {
            return;
        }
        this.selectedDimensionIndex = index;
        this.selectedDimension = index >= 0 ? this.dimensions.get(this.selectedDimensionIndex) : null;
        this.updateCache();
        this.dimensionSettingsList.scrollBy(Int.MinValue());
        boolean isNewDim = this.selectedDimension.isNewConfig;
        boolean isLoaded = false;
        if (!isNewDim) {
            if (this.field_146297_k.func_71356_B()) {
                ForgeWorld forgeWorld = !GuiHandler.IsInMainMenu && this.selectedDimensionIndex != 0 ? (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(this.selectedDimension.PresetName) : null;
                isLoaded = this.selectedDimensionIndex == 0 || forgeWorld != null;
            } else {
                ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(this.selectedDimension.PresetName);
                isLoaded = this.selectedDimensionIndex == 0 || forgeWorld != null && forgeWorld.isLoadedOnServer;
            }
        }
        this.btnDelete.field_146124_l = this.selectedDimensionIndex != 0 && (isNewDim || !isLoaded);
    }

    public boolean isDimensionIndexSelected(int index) {
        return index == this.selectedDimensionIndex;
    }

    private void updateCache() {
        if (this.restoreSelection) {
            this.restoreSelection = false;
            this.dimensionsList.selectedIndex = this.selectedDimensionIndex;
            this.dimensionSettingsList.refreshData(this.previouslySelectedMainMenu, this.previouslySelectedGameRulesMenu, this.previouslySelectedAdvancedSettingsMenu);
            this.dimensionSettingsList.amountScrolled = this.lastScrollPos;
        } else {
            this.dimensionSettingsList.refreshData(true, false, false);
        }
    }

    static {
        DimensionType.register((String)"overworld", (String)"OTG", (int)0, OTGWorldProvider.class, (boolean)false);
        ShowingOpenLinkDialogue = false;
    }
}

