/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events.server;

import com.google.common.collect.ImmutableList;
import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.customobjects.bo3.bo3function.BO3EntityFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4EntityFunction;
import com.pg85.otg.customobjects.bofunctions.EntityFunction;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.SpawnerFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ServerTickHandler {
    private int currentTimeInSeconds = 0;
    private int lastSpawnedTimeInSeconds = 0;
    private HashMap<ChunkCoordinate, Boolean> eligibleChunksForSpawning = new HashMap();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ((ForgeEngine)OTG.getEngine()).processPregeneratorTick();
            this.teleportPlayers();
        }
        if (event.phase == TickEvent.Phase.END) {
            ImmutableList messages;
            this.currentTimeInSeconds = (int)Math.ceil(System.currentTimeMillis() / 1000L);
            if (this.currentTimeInSeconds != this.lastSpawnedTimeInSeconds) {
                this.lastSpawnedTimeInSeconds = this.currentTimeInSeconds;
                for (LocalWorld localWorld : ((ForgeEngine)OTG.getEngine()).getWorldLoader().getAllLoadedWorlds()) {
                    this.findChunksForSpawning((ForgeWorld)localWorld, true, true);
                }
            }
            if ((messages = FMLInterModComms.fetchRuntimeMessages((Object)OTGPlugin.Instance)).size() > 0) {
                for (FMLInterModComms.IMCMessage imcMessage : messages) {
                    String[] paramString;
                    if (imcMessage.key.equalsIgnoreCase("GetModData") && imcMessage.isStringMessage()) {
                        paramString = imcMessage.getStringValue().split(",");
                        if (paramString.length == 3) {
                            int chunkZ;
                            int chunkX;
                            String worldName = paramString[0];
                            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldName);
                            if (forgeWorld == null) {
                                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldName);
                            }
                            try {
                                chunkX = Integer.parseInt(paramString[1]);
                                chunkZ = Integer.parseInt(paramString[2]);
                            }
                            catch (NumberFormatException ex) {
                                OTG.log(LogMarker.WARN, "The mod " + imcMessage.getSender() + " has sent the following message: " + imcMessage.key + ", however the parameters were invalid: " + imcMessage.getStringValue() + ". Should be: MyWorldName,MyChunkX,MyChunkZ", new Object[0]);
                                return;
                            }
                            String messageString = "";
                            HashMap<String, ArrayList<ModDataFunction<?>>> modDataInChunk = forgeWorld.getWorldSession().getModDataForChunk(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
                            if (modDataInChunk != null && modDataInChunk.entrySet().size() > 0) {
                                for (Map.Entry<String, ArrayList<ModDataFunction<?>>> modNameAndData : modDataInChunk.entrySet()) {
                                    if (!modNameAndData.getKey().equalsIgnoreCase(imcMessage.getSender())) continue;
                                    for (ModDataFunction<?> modData : modNameAndData.getValue()) {
                                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                                    }
                                }
                                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)imcMessage.getSender(), (String)"ModData", (String)("[[" + worldName + "," + chunkX + "," + chunkZ + "]" + (messageString.length() > 0 ? messageString : "[]") + "]"));
                            } else {
                                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)imcMessage.getSender(), (String)"ModData", (String)("[[" + worldName + "," + chunkX + "," + chunkZ + "]]"));
                            }
                        } else {
                            OTG.log(LogMarker.WARN, "The mod " + imcMessage.getSender() + " has sent the following message: " + imcMessage.key + ", however the parameters were invalid: " + imcMessage.getStringValue() + ". Should be: MyWorldName,MyChunkX,MyChunkZ", new Object[0]);
                        }
                    }
                    if (!imcMessage.key.equalsIgnoreCase("ModData")) continue;
                    paramString = imcMessage.getStringValue().replace("[[", "").replace("]]", "").split("\\]\\[");
                    String[] chunkCoordString = paramString[0].split(",");
                    String worldName = chunkCoordString[0];
                    if (paramString.length < 2) continue;
                    for (int i = 1; i < paramString.length; ++i) {
                        if (paramString[i].length() <= 0) continue;
                        String[] modDataString = paramString[i].split(",");
                        int modDataBlockX = Integer.parseInt(modDataString[0]);
                        int modDataBlockY = Integer.parseInt(modDataString[1]);
                        int modDataBlockZ = Integer.parseInt(modDataString[2]);
                        String modDataText = modDataString[3];
                        ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldName);
                        if (world == null) {
                            world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldName);
                        }
                        if (world == null) {
                            OTG.log(LogMarker.FATAL, "Error: Failed to load LocalWorld for world \"" + worldName + "\"", new Object[0]);
                            throw new RuntimeException("Error: Failed to load LocalWorld for world \"" + worldName + "\"");
                        }
                        if (world.getConfigs() == null) {
                            OTG.log(LogMarker.FATAL, "Error: Failed to load world settings for world \"" + worldName + "\"", new Object[0]);
                            throw new RuntimeException("Error: Failed to load world settings for world \"" + worldName + "\"");
                        }
                        if (world.getConfigs().getWorldConfig() == null) {
                            OTG.log(LogMarker.FATAL, "Error: Failed to load worldConfig for world \"" + worldName + "\"", new Object[0]);
                            throw new RuntimeException("Error: Failed to load worldConfig for world \"" + worldName + "\"");
                        }
                        String[] paramString2 = modDataText.split("\\/");
                        if (paramString2.length <= 1) continue;
                        if (paramString2[0].equals("mob")) {
                            try {
                                EntityFunction entityFunc = world.isBo4Enabled() ? new BO4EntityFunction() : new BO3EntityFunction();
                                entityFunc.x = modDataBlockX;
                                entityFunc.y = modDataBlockY;
                                entityFunc.z = modDataBlockZ;
                                entityFunc.processEntityName(paramString2[1]);
                                int n = entityFunc.groupSize = paramString2.length > 2 ? Integer.parseInt(paramString2[2]) : 1;
                                if (paramString2.length > 5) {
                                    entityFunc.processNameTagOrFileName(paramString2[5]);
                                } else {
                                    entityFunc.nameTagOrNBTFileName = null;
                                    entityFunc.originalNameTagOrNBTFileName = null;
                                }
                                entityFunc.rotation = 0;
                                world.spawnEntity(entityFunc, null);
                            }
                            catch (NumberFormatException ex) {
                                if (!OTG.getPluginConfig().spawnLog) continue;
                                OTG.log(LogMarker.WARN, "Error in ModData: " + modDataText + " parameter count was not a number", new Object[0]);
                            }
                            continue;
                        }
                        if (!paramString2[0].equals("block")) continue;
                        try {
                            LocalMaterialData material = MaterialHelper.readMaterial(paramString2[1]);
                            world.setBlock(modDataBlockX, modDataBlockY, modDataBlockZ, material, null, null, false);
                            continue;
                        }
                        catch (InvalidConfigException e) {
                            if (!OTG.getPluginConfig().spawnLog) continue;
                            OTG.log(LogMarker.WARN, "Error in ModData: " + modDataText + " parameter material was not a valid material", new Object[0]);
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private void findChunksForSpawning(ForgeWorld world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        WorldServer worldServer = (WorldServer)world.getWorld();
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return;
        }
        this.eligibleChunksForSpawning.clear();
        for (int i = 0; i < worldServer.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)worldServer.field_73010_i.get(i);
            int playerPosChunkX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int playerPosChunkZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int radius = 8;
            for (int l = -radius; l <= radius; ++l) {
                for (int i1 = -radius; i1 <= radius; ++i1) {
                    boolean flag3 = l == -radius || l == radius || i1 == -radius || i1 == radius;
                    ChunkCoordinate chunkcoordintpair = ChunkCoordinate.fromChunkCoords(l + playerPosChunkX, i1 + playerPosChunkZ);
                    if (flag3) continue;
                    this.eligibleChunksForSpawning.put(chunkcoordintpair, false);
                }
            }
        }
        Stack<Object[]> playerCoords = new Stack<Object[]>();
        for (int a = 0; a < worldServer.field_73010_i.size(); ++a) {
            EntityPlayer player = (EntityPlayer)worldServer.field_73010_i.get(a);
            playerCoords.add(new Object[]{player.field_70165_t, player.field_70163_u, player.field_70161_v, player});
        }
        double maxDistToClosestPlayer = 33.0;
        double maxDistToClosestPlayerSq = maxDistToClosestPlayer * maxDistToClosestPlayer;
        for (int x = 0; x < worldServer.field_72996_f.size(); ++x) {
            Entity entity = (Entity)worldServer.field_72996_f.get(x);
            NBTTagCompound entityData = entity.getEntityData();
            if (!entityData.func_74764_b("OTG")) continue;
            boolean playerInRange = false;
            for (int a = 0; a < playerCoords.size(); ++a) {
                float f2;
                float f1;
                float f = (float)((Double)((Object[])playerCoords.get(a))[0] - entity.field_70165_t);
                double distance = f * f + (f1 = (float)((Double)((Object[])playerCoords.get(a))[1] - entity.field_70163_u)) * f1 + (f2 = (float)((Double)((Object[])playerCoords.get(a))[2] - entity.field_70161_v)) * f2;
                if (!(distance < maxDistToClosestPlayerSq)) continue;
                playerInRange = true;
                break;
            }
            if (playerInRange) continue;
            int despawnTimer = entityData.func_74762_e("OTGDT");
            if (despawnTimer <= 1) {
                entity.func_70106_y();
                continue;
            }
            entityData.func_74768_a("OTGDT", despawnTimer - 1);
        }
        Random random = new Random();
        Stack<SpawnerFunction> spawnerDataSortedByDistance = new Stack<SpawnerFunction>();
        Stack<Object[]> spawnerDatasWithDistance = new Stack<Object[]>();
        for (ChunkCoordinate chunkcoordintpair1 : this.eligibleChunksForSpawning.keySet()) {
            ArrayList<SpawnerFunction<?>> spawnerDataForOTG;
            if (this.eligibleChunksForSpawning.get(chunkcoordintpair1).booleanValue() || (spawnerDataForOTG = world.getWorldSession().getSpawnersForChunk(ChunkCoordinate.fromChunkCoords(chunkcoordintpair1.getChunkX(), chunkcoordintpair1.getChunkZ()))) == null || spawnerDataForOTG.size() <= 0) continue;
            block15: for (SpawnerFunction<?> spawnerData : spawnerDataForOTG) {
                double distToClosestPlayer = maxDistToClosestPlayerSq;
                for (int a = 0; a < playerCoords.size(); ++a) {
                    float f2;
                    float f1;
                    float f = (float)((Double)((Object[])playerCoords.get(a))[0] - (double)spawnerData.x);
                    double distance = f * f + (f1 = (float)((Double)((Object[])playerCoords.get(a))[1] - (double)spawnerData.y)) * f1 + (f2 = (float)((Double)((Object[])playerCoords.get(a))[2] - (double)spawnerData.z)) * f2;
                    if (!(distance < distToClosestPlayer)) continue;
                    distToClosestPlayer = distance;
                }
                if (!(distToClosestPlayer > 0.0) || !(distToClosestPlayer < maxDistToClosestPlayerSq)) continue;
                if (spawnerDatasWithDistance.size() == 0) {
                    spawnerDatasWithDistance.add(new Object[]{distToClosestPlayer, spawnerData});
                    continue;
                }
                for (int r = 0; r < spawnerDatasWithDistance.size(); ++r) {
                    if (distToClosestPlayer < (Double)((Object[])spawnerDatasWithDistance.get(r))[0]) {
                        spawnerDatasWithDistance.add(r, new Object[]{distToClosestPlayer, spawnerData});
                        continue block15;
                    }
                    if (r != spawnerDatasWithDistance.size() - 1) continue;
                    spawnerDatasWithDistance.add(new Object[]{distToClosestPlayer, spawnerData});
                    continue block15;
                }
            }
        }
        for (Object[] spawnerDataWithDistance : spawnerDatasWithDistance) {
            spawnerDataSortedByDistance.add((SpawnerFunction)spawnerDataWithDistance[1]);
        }
        block19: for (SpawnerFunction spawnerData : spawnerDataSortedByDistance) {
            boolean b5;
            boolean b3;
            double velocityZ;
            double velocityX;
            double velocityY;
            NBTTagCompound nbttagcompound;
            Entity entity;
            Class<? extends Entity> entityClass;
            int rngRoll;
            int despawnTime;
            int max;
            int spawnChance;
            int groupSize;
            block48: {
                String mobTypeName = spawnerData.mobName;
                groupSize = spawnerData.groupSize;
                int interval = spawnerData.interval;
                spawnChance = spawnerData.spawnChance;
                max = spawnerData.maxCount;
                despawnTime = spawnerData.despawnTime;
                rngRoll = random.nextInt(100);
                if ((this.currentTimeInSeconds - spawnerData.intervalOffset) % interval != 0 && !spawnerData.firstSpawn.booleanValue()) continue;
                if (spawnerData.firstSpawn.booleanValue()) {
                    spawnerData.intervalOffset = this.currentTimeInSeconds;
                }
                spawnerData.firstSpawn = false;
                entityClass = MobSpawnGroupHelper.toMinecraftClass(mobTypeName);
                if (entityClass == null) {
                    if (!OTG.getPluginConfig().spawnLog) continue;
                    OTG.log(LogMarker.WARN, "Could not find entity: " + mobTypeName, new Object[0]);
                    continue;
                }
                ResourceLocation resourceLocation = MobSpawnGroupHelper.resourceLocationFromMinecraftClass(entityClass);
                entity = null;
                nbttagcompound = null;
                if (spawnerData.getMetaData() == null) {
                    try {
                        entity = entityClass.getConstructor(World.class).newInstance(worldServer);
                        break block48;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                }
                nbttagcompound = new NBTTagCompound();
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)spawnerData.getMetaData());
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        throw new RuntimeException();
                    }
                    nbttagcompound = nbtbase;
                }
                catch (NBTException nbtexception) {
                    if (!OTG.getPluginConfig().spawnLog) continue;
                    OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in SpawnerFunction: " + spawnerData.getMetaData() + ". Skipping mob.", new Object[0]);
                    continue;
                }
                nbttagcompound.func_74778_a("id", resourceLocation.toString());
                entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldServer);
            }
            if (entity == null) {
                throw new RuntimeException();
            }
            int worldMobCount = 0;
            int mobCountRadius = 32;
            for (int x = 0; x < worldServer.field_72996_f.size(); ++x) {
                Entity entity1 = (Entity)worldServer.field_72996_f.get(x);
                if (entity1.getClass() != entityClass || !entity1.getEntityData().func_74764_b("OTG") || !(entity1.field_70165_t >= (double)(spawnerData.x - mobCountRadius)) || !(entity1.field_70165_t <= (double)(spawnerData.x + mobCountRadius)) || !(entity1.field_70163_u >= (double)(spawnerData.y - mobCountRadius)) || !(entity1.field_70163_u <= (double)(spawnerData.y + mobCountRadius)) || !(entity1.field_70161_v >= (double)(spawnerData.z - mobCountRadius)) || !(entity1.field_70161_v <= (double)(spawnerData.z + mobCountRadius))) continue;
                ++worldMobCount;
            }
            if (worldMobCount >= max) continue;
            int j1 = spawnerData.x;
            int k1 = spawnerData.y;
            int l1 = spawnerData.z;
            float x = (float)j1 + 0.5f;
            float y = k1;
            float z = (float)l1 + 0.5f;
            float yaw = spawnerData.yaw;
            float pitch = spawnerData.pitch;
            entity.getEntityData().func_74757_a("OTG", true);
            if (despawnTime > 0) {
                entity.getEntityData().func_74768_a("OTGDT", despawnTime - 1);
            }
            if (entity instanceof EntityLiving) {
                velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.0;
                velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
                velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
                entity.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
                entity.func_70024_g(velocityX, velocityY, velocityZ);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)((EntityLiving)entity), (World)worldServer, (float)x, (float)y, (float)z);
                boolean entityCanSpawnHere = false;
                if (canSpawn == Event.Result.DEFAULT) {
                    boolean b32;
                    int ia = MathHelper.func_76128_c((double)entity.field_70165_t);
                    int ja = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
                    int ka = MathHelper.func_76128_c((double)entity.field_70161_v);
                    boolean b1 = entity.field_70170_p.func_72855_b(entity.func_174813_aQ());
                    boolean b2 = entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ()).isEmpty();
                    boolean bl = b32 = !entity.field_70170_p.func_72953_d(entity.func_174813_aQ());
                    boolean b52 = entity instanceof EntityCreature ? ((EntityCreature)entity).func_180484_a(new BlockPos(ia, ja, ka)) >= 0.0f : true;
                    boolean bl2 = entityCanSpawnHere = b1 && b2 && b32 && b52;
                }
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entityCanSpawnHere)) continue;
                for (int r = 0; r < groupSize && worldMobCount < max; ++r) {
                    rngRoll = random.nextInt(100);
                    if (spawnChance <= rngRoll) continue;
                    if (r != 0) {
                        block49: {
                            if (spawnerData.getMetaData() == null) {
                                try {
                                    entity = (EntityLiving)entityClass.getConstructor(World.class).newInstance(worldServer);
                                    break block49;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    continue block19;
                                }
                            }
                            entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldServer);
                        }
                        velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.0;
                        velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
                        velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
                        entity.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
                        entity.func_70024_g(velocityX, velocityY, velocityZ);
                        entity.getEntityData().func_74757_a("OTG", true);
                        entity.getEntityData().func_74768_a("OTGDT", despawnTime);
                    }
                    if (spawnerData.getMetaData() == null) {
                        ((EntityLiving)entity).func_180482_a(worldServer.func_175649_E(new BlockPos((double)x, (double)y, (double)z)), (IEntityLivingData)null);
                    }
                    worldServer.func_72838_d(entity);
                    if (nbttagcompound != null) {
                        Entity entity2 = entity;
                        NBTTagCompound nbttagcompound1 = nbttagcompound;
                        while (entity2 != null && nbttagcompound1.func_150297_b("Riding", 10)) {
                            Entity entity1 = EntityList.func_75615_a((NBTTagCompound)nbttagcompound1.func_74775_l("Riding"), (World)worldServer);
                            if (entity1 != null) {
                                entity1.func_70012_b((double)x, (double)y, (double)z, entity1.field_70177_z, entity1.field_70125_A);
                                worldServer.func_72838_d(entity1);
                                entity2.func_184220_m(entity1);
                            }
                            entity2 = entity1;
                            nbttagcompound1 = nbttagcompound1.func_74775_l("Riding");
                        }
                    }
                    ++worldMobCount;
                }
                continue;
            }
            velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.1;
            velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
            velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
            entity.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
            if (!(entity instanceof EntityHanging)) {
                entity.func_70024_g(velocityX, velocityY, velocityZ);
            }
            boolean entityCanSpawnHere = false;
            int ia = MathHelper.func_76128_c((double)entity.field_70165_t);
            int ja = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
            int ka = MathHelper.func_76128_c((double)entity.field_70161_v);
            boolean b1 = entity.field_70170_p.func_72855_b(entity.func_174813_aQ());
            boolean b2 = entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ()).isEmpty();
            boolean bl = b3 = !entity.field_70170_p.func_72953_d(entity.func_174813_aQ());
            boolean bl3 = entity instanceof EntityLiving ? ((EntityCreature)entity).func_180484_a(new BlockPos(ia, ja, ka)) >= 0.0f : (b5 = true);
            entityCanSpawnHere = b1 && b2 && b3 && b5;
            if (!entityCanSpawnHere) continue;
            for (int r = 0; r < groupSize && worldMobCount < max; ++r) {
                rngRoll = random.nextInt(100);
                if (spawnChance <= rngRoll) continue;
                if (r != 0) {
                    block50: {
                        if (spawnerData.getMetaData() == null) {
                            try {
                                entity = entityClass.getConstructor(World.class).newInstance(worldServer);
                                break block50;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue block19;
                            }
                        }
                        entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldServer);
                    }
                    velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
                    velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.1;
                    velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
                    entity.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
                    entity.func_70024_g(velocityX, velocityY, velocityZ);
                    entity.getEntityData().func_74757_a("OTG", true);
                    entity.getEntityData().func_74768_a("OTGDT", despawnTime);
                }
                worldServer.func_72838_d(entity);
                ++worldMobCount;
            }
        }
        for (int a = 0; a < playerCoords.size(); ++a) {
            EntityPlayer player = (EntityPlayer)((Object[])playerCoords.get(a))[3];
            ArrayList particleDataForOTGPerPlayer = new ArrayList();
            for (ChunkCoordinate chunkcoordintpair1 : this.eligibleChunksForSpawning.keySet()) {
                if (this.eligibleChunksForSpawning.get(chunkcoordintpair1).booleanValue()) continue;
                ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkcoordintpair1.getChunkX(), chunkcoordintpair1.getChunkZ());
                ArrayList<ParticleFunction<?>> particleDataForOTG = world.getWorldSession().getParticlesForChunk(chunkCoord);
                if (particleDataForOTG == null || particleDataForOTG.size() <= 0) continue;
                for (ParticleFunction<?> particleData : particleDataForOTG) {
                    float f2;
                    float f1;
                    float f = (float)((Double)((Object[])playerCoords.get(a))[0] - (double)particleData.x);
                    double distance = f * f + (f1 = (float)((Double)((Object[])playerCoords.get(a))[1] - (double)particleData.y)) * f1 + (f2 = (float)((Double)((Object[])playerCoords.get(a))[2] - (double)particleData.z)) * f2;
                    if (!(distance > 0.0) || !(distance < maxDistToClosestPlayerSq)) continue;
                    if (!worldServer.func_180495_p(new BlockPos(particleData.x, particleData.y, particleData.z)).func_185904_a().func_76220_a()) {
                        particleDataForOTGPerPlayer.add(particleData);
                        continue;
                    }
                    world.getWorldSession().removeParticles(chunkCoord, particleData);
                }
            }
            if (particleDataForOTGPerPlayer.size() <= 0) continue;
            ServerPacketManager.sendParticlesPacket(particleDataForOTGPerPlayer, (EntityPlayerMP)player);
        }
    }

    private void teleportPlayers() {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (WorldServer worldServer : mcServer.field_71305_c) {
            if ((!(worldServer.func_72912_H() instanceof DerivedWorldInfo) || !((DerivedWorldInfo)worldServer.func_72912_H()).field_76115_a.func_82571_y().equals("OpenTerrainGenerator")) && !worldServer.func_72912_H().func_82571_y().equals("OpenTerrainGenerator")) continue;
            ArrayList players = new ArrayList(worldServer.field_73010_i);
            for (EntityPlayer player : players) {
                this.tryTeleportPlayer(player);
            }
        }
    }

    private void tryTeleportPlayer(EntityPlayer player) {
        DimensionConfig dimConfig;
        ForgeWorld playerWorld = ((ForgeEngine)OTG.getEngine()).getWorld(player.field_70170_p);
        DimensionConfig dimensionConfig = dimConfig = playerWorld != null ? OTG.getDimensionsConfig().getDimensionConfig(playerWorld.getName()) : null;
        if (playerWorld != null && dimConfig.Settings.DimensionBelow != null && dimConfig.Settings.DimensionBelow.trim().length() > 0 && player.func_180425_c().func_177956_o() < dimConfig.Settings.DimensionBelowHeight) {
            WorldServer destinationWorld = null;
            if (OTG.getDimensionsConfig().Overworld.PresetName == null && dimConfig.Settings.DimensionBelow.toLowerCase().trim().equals("overworld") || OTG.getDimensionsConfig().Overworld.PresetName != null && OTG.getDimensionsConfig().Overworld.PresetName.equals(dimConfig.Settings.DimensionBelow)) {
                destinationWorld = DimensionManager.getWorld((int)0);
            } else {
                ForgeWorld destinationForgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(dimConfig.Settings.DimensionBelow);
                if (destinationForgeWorld == null) {
                    destinationForgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(dimConfig.Settings.DimensionBelow);
                }
                if (destinationForgeWorld != null) {
                    destinationWorld = destinationForgeWorld.getWorld();
                }
            }
            if (destinationWorld != null) {
                if (destinationWorld == playerWorld.getWorld()) {
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 254, player.func_180425_c().func_177952_p()));
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 255, player.func_180425_c().func_177952_p()));
                    player.func_70634_a((double)player.func_180425_c().func_177958_n(), 254.0, (double)player.func_180425_c().func_177952_p());
                } else {
                    this.teleportPlayerToDimension(destinationWorld.field_73011_w.getDimension(), destinationWorld.field_73011_w.getDimension(), player);
                    return;
                }
            }
        }
        if (playerWorld != null && dimConfig.Settings.DimensionAbove != null && dimConfig.Settings.DimensionAbove.trim().length() > 0 && player.func_180425_c().func_177956_o() > dimConfig.Settings.DimensionAboveHeight) {
            WorldServer destinationWorld = null;
            if (OTG.getDimensionsConfig().Overworld.PresetName == null && dimConfig.Settings.DimensionAbove.toLowerCase().trim().equals("overworld") || OTG.getDimensionsConfig().Overworld.PresetName != null && OTG.getDimensionsConfig().Overworld.PresetName.equals(dimConfig.Settings.DimensionAbove)) {
                destinationWorld = DimensionManager.getWorld((int)0);
            } else {
                ForgeWorld destinationForgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(dimConfig.Settings.DimensionAbove);
                if (destinationForgeWorld == null) {
                    destinationForgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(dimConfig.Settings.DimensionAbove);
                }
                if (destinationForgeWorld != null) {
                    destinationWorld = destinationForgeWorld.getWorld();
                }
            }
            if (destinationWorld != null) {
                if (destinationWorld == playerWorld.getWorld()) {
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 1, player.func_180425_c().func_177952_p()));
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 2, player.func_180425_c().func_177952_p()));
                    player.func_70634_a((double)player.func_180425_c().func_177958_n(), 1.0, (double)player.func_180425_c().func_177952_p());
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n() + 1, 1, player.func_180425_c().func_177952_p()));
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n() + 1, 2, player.func_180425_c().func_177952_p()));
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n() + 1, 0, player.func_180425_c().func_177952_p()));
                } else {
                    this.teleportPlayerToDimension(destinationWorld.field_73011_w.getDimension(), destinationWorld.field_73011_w.getDimension(), player);
                }
            }
        }
    }

    private void teleportPlayerToDimension(int originDimension, int newDimension, EntityPlayer e) {
        if (e instanceof EntityPlayerMP) {
            OTGTeleporter.changeDimension(newDimension, (EntityPlayerMP)e, false, false);
        }
    }
}

