/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.generator.resource.SaplingGen;
import com.pg85.otg.generator.resource.SaplingType;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SaplingListener {
    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        BiomeConfig parent;
        SaplingGen sapling;
        boolean wideTrunk;
        SaplingType bigSaplingType;
        World world = event.getWorld();
        ForgeWorld localWorld = ((ForgeEngine)OTG.getEngine()).getWorld(world);
        BlockPos blockPos = event.getPos();
        if (localWorld == null) {
            return;
        }
        LocalBiome biome = localWorld.getBiome(blockPos.func_177958_n(), blockPos.func_177952_p());
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        LocalMaterialData material = localWorld.getMaterial(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), null);
        if (material == null) {
            return;
        }
        SaplingType saplingType = null;
        if (!material.isMaterial(DefaultMaterial.SAPLING)) {
            saplingType = SaplingType.Custom;
        }
        if ((bigSaplingType = this.getBigSaplingType(material.getBlockData())) != null || saplingType == SaplingType.Custom) {
            BlockPos result = this.findFourSaplings(blockPos, material, localWorld);
            if (result != null) {
                if (saplingType != SaplingType.Custom) {
                    saplingType = bigSaplingType;
                }
                blockPos = result;
                wideTrunk = true;
            } else {
                wideTrunk = false;
            }
        } else {
            wideTrunk = false;
        }
        if (saplingType == null) {
            saplingType = this.getSmallSaplingType(material.getBlockData());
        }
        if (saplingType == null) {
            saplingType = SaplingType.Custom;
        }
        if ((sapling = saplingType == SaplingType.Custom ? biomeConfig.getCustomSaplingGen(material, wideTrunk) : biomeConfig.getSaplingGen(saplingType)) == null && (parent = this.getParent(biome, localWorld)) != null) {
            sapling = saplingType == SaplingType.Custom ? parent.getCustomSaplingGen(material, wideTrunk) : parent.getSaplingGen(saplingType);
        }
        if (sapling == null) {
            return;
        }
        event.setResult(Event.Result.DENY);
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        if (wideTrunk) {
            world.func_175656_a(blockPos, air);
            world.func_175656_a(blockPos.func_177982_a(1, 0, 0), air);
            world.func_175656_a(blockPos.func_177982_a(0, 0, 1), air);
            world.func_175656_a(blockPos.func_177982_a(1, 0, 1), air);
        } else {
            world.func_175656_a(blockPos, air);
        }
        boolean saplingGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!sapling.growSapling(localWorld, random, wideTrunk, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())) continue;
            saplingGrown = true;
            break;
        }
        if (!saplingGrown) {
            int saplingX = blockPos.func_177958_n();
            int saplingY = blockPos.func_177956_o();
            int saplingZ = blockPos.func_177952_p();
            if (wideTrunk) {
                localWorld.setBlock(saplingX, saplingY, saplingZ, material, null, null, false);
                localWorld.setBlock(saplingX + 1, saplingY, saplingZ, material, null, null, false);
                localWorld.setBlock(saplingX, saplingY, saplingZ + 1, material, null, null, false);
                localWorld.setBlock(saplingX + 1, saplingY, saplingZ + 1, material, null, null, false);
            } else {
                localWorld.setBlock(saplingX, saplingY, saplingZ, material, null, null, false);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onBonemealUse(BonemealEvent event) {
        BiomeConfig parent;
        ForgeWorld localWorld = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (localWorld == null) {
            return;
        }
        LocalBiome biome = localWorld.getBiome(event.getPos().func_177958_n(), event.getPos().func_177952_p());
        if (biome == null) {
            return;
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        SaplingGen gen = null;
        SaplingType type = null;
        if (event.getBlock() == Blocks.field_150419_aX) {
            type = SaplingType.RedMushroom;
        } else if (event.getBlock() == Blocks.field_150420_aW) {
            type = SaplingType.BrownMushroom;
        } else {
            return;
        }
        gen = biomeConfig.getSaplingGen(type);
        if (gen == null && (parent = this.getParent(biome, localWorld)) != null) {
            gen = parent.getSaplingGen(type);
        }
        if (gen == null) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
        event.getWorld().func_175656_a(event.getPos(), Blocks.field_150350_a.func_176223_P());
        boolean mushroomGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!gen.growSapling(localWorld, random, false, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) continue;
            mushroomGrown = true;
            break;
        }
        if (!mushroomGrown) {
            event.getWorld().func_175656_a(event.getPos(), event.getBlock());
        }
    }

    private BiomeConfig getParent(LocalBiome biome, LocalWorld world) {
        LocalBiome localBiome;
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        if (biomeConfig.inheritSaplingResource && biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0 && (localBiome = world.getBiomeByNameOrNull(biomeConfig.replaceToBiomeName)) != null) {
            return localBiome.getBiomeConfig();
        }
        return null;
    }

    private SaplingType getSmallSaplingType(int data) {
        switch (data % 8) {
            case 0: {
                return SaplingType.Oak;
            }
            case 1: {
                return SaplingType.Redwood;
            }
            case 2: {
                return SaplingType.Birch;
            }
            case 3: {
                return SaplingType.SmallJungle;
            }
            case 4: {
                return SaplingType.Acacia;
            }
        }
        return null;
    }

    private SaplingType getBigSaplingType(int data) {
        switch (data % 8) {
            case 1: {
                return SaplingType.HugeRedwood;
            }
            case 3: {
                return SaplingType.BigJungle;
            }
            case 5: {
                return SaplingType.DarkOak;
            }
        }
        return null;
    }

    private boolean isSameSapling(LocalMaterialData sapling1, LocalMaterialData sapling2) {
        if (sapling1 == null || sapling2 == null) {
            return false;
        }
        return sapling1.getBlockData() % 8 == sapling2.getBlockData() % 8 && sapling1.getBlockId() == sapling2.getBlockId();
    }

    private BlockPos findFourSaplings(BlockPos blockPos, LocalMaterialData material, LocalWorld world) {
        int x = blockPos.func_177958_n();
        int y = blockPos.func_177956_o();
        int z = blockPos.func_177952_p();
        for (int treeOffsetX = 0; treeOffsetX >= -1; --treeOffsetX) {
            for (int treeOffsetZ = 0; treeOffsetZ >= -1; --treeOffsetZ) {
                if (!this.isSameSapling(material, world.getMaterial(x + treeOffsetX, y, z + treeOffsetZ, null)) || !this.isSameSapling(material, world.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ, null)) || !this.isSameSapling(material, world.getMaterial(x + treeOffsetX, y, z + treeOffsetZ + 1, null)) || !this.isSameSapling(material, world.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ + 1, null))) continue;
                return blockPos.func_177982_a(treeOffsetX, 0, treeOffsetZ);
            }
        }
        return null;
    }
}

